/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import io.reactivex.Observable;
import io.streamlayer.common.session.Session;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.utils.GsonUtil;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0001\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u000bH\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020!H\u0016J\u0015\u0010(\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020%2\b\u0010,\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010/\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0018\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0006H\u0016J\u0018\u00103\u001a\u00020%2\u0006\u0010#\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0006H\u0016J\u0010\u00105\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00066"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/common/session/Session;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isLoggedIn", "", "()Z", "mSharedPreferences", "Landroid/content/SharedPreferences;", "value", "", "sdkKey", "getSdkKey", "()Ljava/lang/String;", "setSdkKey", "(Ljava/lang/String;)V", "token", "getToken", "setToken", "userId", "", "getUserId", "()J", "setUserId", "(J)V", "apiBasePort", "", "apiBaseUrl", "checkPermissionAsked", "permission", "getOrganizationSettings", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "isTipsShown", "tipSet", "logout", "", "saveOrganizationSettings", "settings", "setApiBasePort", "basePort", "(Ljava/lang/Integer;)V", "setApiBaseUrl", "baseUrl", "setLoggedIn", "loggedIn", "setPermissionAsked", "setSkipOnboardingStep", "stepName", "skip", "setTipsShown", "shown", "shouldSkipOnboardingStep", "sdk_release"})
public final class SessionPrefImpl
implements Session {
    private final SharedPreferences mSharedPreferences;

    @Inject
    public SessionPrefImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences("io.streamlayer.sdk_session", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        this.mSharedPreferences = sharedPreferences;
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this.mSharedPreferences.getString("sdk_key", null);
    }

    @Override
    public void setSdkKey(@Nullable String string2) {
        this.mSharedPreferences.edit().putString("sdk_key", string2).apply();
    }

    @Override
    public boolean isLoggedIn() {
        return this.mSharedPreferences.getBoolean("logged_in", false);
    }

    @Override
    public long getUserId() {
        return this.mSharedPreferences.getLong("user_id", 0L);
    }

    @Override
    public void setUserId(long l) {
        this.mSharedPreferences.edit().putLong("user_id", l).apply();
    }

    @Override
    @NotNull
    public String getToken() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getString("session_token", "");
        if (object == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void setToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"token");
        this.mSharedPreferences.edit().putString("session_token", "Bearer " + string2).apply();
    }

    @Override
    public void setLoggedIn(boolean bl, long l) {
        this.mSharedPreferences.edit().putBoolean("logged_in", bl).putLong("user_id", l).apply();
    }

    @Override
    public void logout() {
        SessionPrefImpl sessionPrefImpl = this;
        sessionPrefImpl.setLoggedIn(false, 0L);
        sessionPrefImpl.setToken("");
    }

    @Override
    public boolean checkPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        return this.mSharedPreferences.contains("PERMISSION_ASKED_" + string2);
    }

    @Override
    public void setPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        this.mSharedPreferences.edit().putBoolean("PERMISSION_ASKED_" + string2, true).apply();
    }

    @Override
    public boolean shouldSkipOnboardingStep(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        return this.mSharedPreferences.getBoolean("onboarding_step_skip_" + string2, false);
    }

    @Override
    public void setSkipOnboardingStep(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        this.mSharedPreferences.edit().putBoolean("onboarding_step_skip_" + string2, bl).apply();
    }

    @Override
    public boolean isTipsShown(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        return this.mSharedPreferences.getBoolean(string2 + "_tips_shown", false);
    }

    @Override
    public void setTipsShown(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        this.mSharedPreferences.edit().putBoolean(string2 + "_tips_shown", bl).apply();
    }

    @Nullable
    public final String apiBaseUrl() {
        return this.mSharedPreferences.getString("abu", null);
    }

    public final void setApiBaseUrl(@Nullable String string2) {
        if (string2 != null) {
            this.mSharedPreferences.edit().putString("abu", string2).apply();
        } else {
            this.mSharedPreferences.edit().remove("abu").apply();
        }
    }

    public final int apiBasePort() {
        return this.mSharedPreferences.getInt("abp", 0);
    }

    public final void setApiBasePort(@Nullable Integer n) {
        if (n != null) {
            this.mSharedPreferences.edit().putInt("abp", n.intValue()).apply();
        } else {
            this.mSharedPreferences.edit().remove("abp").apply();
        }
    }

    @Override
    @NotNull
    public Observable<OrganizationSettings> getOrganizationSettings() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("organization_settings")) {
            sessionPrefImpl = Observable.just((Object)GsonUtil.INSTANCE.getDefaultGson().fromJson(sessionPrefImpl.mSharedPreferences.getString("organization_settings", "[]"), OrganizationSettings.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.just(\n       \u2026          )\n            )");
        } else {
            sessionPrefImpl = Observable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.empty()");
        }
        return sessionPrefImpl;
    }

    @Override
    public void saveOrganizationSettings(@NotNull OrganizationSettings organizationSettings) {
        Intrinsics.checkParameterIsNotNull((Object)organizationSettings, (String)"settings");
        this.mSharedPreferences.edit().putString("organization_settings", GsonUtil.INSTANCE.getDefaultGson().toJson((Object)organizationSettings)).apply();
    }
}

