/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.basketball.playbyplay;

import android.content.Context;
import android.graphics.Typeface;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlayStatistics;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fH\u0014J\u0016\u0010\u0012\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/sports/basketball/BasketballPlayByPlayStatistics;", "()V", "homeTeamId", "", "Ljava/lang/Long;", "findHomeTeamId", "", "listItems", "", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setItems", "BasketballPlayByPlayViewHolder", "sdk_release"})
public final class BasketballPlayByPlayAdapter
extends GenericAdapter<BasketballPlayByPlayStatistics> {
    private Long homeTeamId;

    private final void findHomeTeamId(List<BasketballPlayByPlayStatistics> object) {
        for (BasketballPlayByPlayStatistics basketballPlayByPlayStatistics : CollectionsKt.reversed(object)) {
            if (!basketballPlayByPlayStatistics.getScoring() || this.homeTeamId != null || basketballPlayByPlayStatistics.getHomeScore() <= 0) continue;
            this.homeTeamId = basketballPlayByPlayStatistics.getTeam().getId();
        }
    }

    public static final /* synthetic */ void access$setHomeTeamId$p(BasketballPlayByPlayAdapter basketballPlayByPlayAdapter, Long l) {
        basketballPlayByPlayAdapter.homeTeamId = l;
    }

    public void setItems(@NotNull List<BasketballPlayByPlayStatistics> list) {
        List<BasketballPlayByPlayStatistics> list2 = list;
        Intrinsics.checkParameterIsNotNull(list2, (String)"listItems");
        this.findHomeTeamId(list2);
        super.setItems(list);
    }

    protected int getLayoutId(int n) {
        return R.layout.sl_item_basketball_play_by_play;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<BasketballPlayByPlayStatistics> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new BasketballPlayByPlayViewHolder(view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter$BasketballPlayByPlayViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/sports/basketball/BasketballPlayByPlayStatistics;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/basketball/playbyplay/BasketballPlayByPlayAdapter;Landroid/view/View;)V", "bind", "", "data", "formatCurrentScore", "Landroid/text/Spannable;", "context", "Landroid/content/Context;", "formatPlayText", "playTV", "Landroid/widget/TextView;", "scoring", "", "spanText", "text", "", "highlight", "sdk_release"})
    public final class BasketballPlayByPlayViewHolder
    extends GenericAdapter.GenericViewHolder<BasketballPlayByPlayStatistics> {
        private final void formatPlayText(TextView textView, boolean bl) {
            if (bl) {
                TextView textView2 = textView;
                textView2.setTypeface(Typeface.DEFAULT_BOLD);
                textView2.setTextColor(ContextCompat.getColor((Context)textView2.getContext(), (int)R.color.sl_yellow500));
            } else {
                TextView textView3 = textView;
                textView3.setTypeface(Typeface.DEFAULT);
                textView3.setTextColor(ContextCompat.getColor((Context)textView3.getContext(), (int)R.color.white_alpha_80));
            }
        }

        private final Spannable formatCurrentScore(BasketballPlayByPlayStatistics object, Context context) {
            Object[] objectArray = new Object[]{((BasketballPlayByPlayStatistics)object).getHomeScore(), ((BasketballPlayByPlayStatistics)object).getAwayScore()};
            String string2 = String.format("%d - %d", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            if (((BasketballPlayByPlayStatistics)object).getScoring()) {
                Long l = BasketballPlayByPlayAdapter.this.homeTeamId;
                long l2 = ((BasketballPlayByPlayStatistics)object).getTeam().getId();
                if (l != null && l == l2) {
                    Object[] objectArray2 = new Object[]{((BasketballPlayByPlayStatistics)object).getHomeScore()};
                    object = String.format("%d -", Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"java.lang.String.format(format, *args)");
                } else {
                    Object[] objectArray3 = new Object[]{((BasketballPlayByPlayStatistics)object).getAwayScore()};
                    object = String.format("- %d", Arrays.copyOf(objectArray3, objectArray3.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"java.lang.String.format(format, *args)");
                }
                return this.spanText(string2, (String)object, context);
            }
            return new SpannableString((CharSequence)string2);
        }

        private final Spannable spanText(String string2, String string3, Context context) {
            TypefaceSpan typefaceSpan;
            ForegroundColorSpan foregroundColorSpan;
            SpannableString spannableString;
            BasketballPlayByPlayViewHolder basketballPlayByPlayViewHolder = spannableString;
            spannableString = new SpannableString((CharSequence)string2);
            ForegroundColorSpan foregroundColorSpan2 = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)context, (int)R.color.white));
            context = typefaceSpan;
            context("sans-serif-black");
            int n = StringsKt.indexOf$default((CharSequence)string2, (String)string3, (int)0, (boolean)false, (int)6, null);
            int n2 = StringsKt.indexOf$default((CharSequence)string2, (String)string3, (int)0, (boolean)false, (int)6, null) + string3.length();
            basketballPlayByPlayViewHolder.setSpan(foregroundColorSpan2, n, n2, 18);
            spannableString.setSpan((Object)typefaceSpan, n, n2, 18);
            return spannableString;
        }

        public BasketballPlayByPlayViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        public void bind(@NotNull BasketballPlayByPlayStatistics basketballPlayByPlayStatistics) {
            View view;
            Intrinsics.checkParameterIsNotNull((Object)basketballPlayByPlayStatistics, (String)"data");
            View view2 = view = this.itemView;
            ImageView imageView = (ImageView)view2.findViewById(R.id.slBasketballPlayByPlayTeamLogoIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slBasketballPlayByPlayTeamLogoIV");
            ExtensionsKt.loadUrl$default(imageView, basketballPlayByPlayStatistics.getTeam().getLogo(), false, null, 6, null);
            TextView textView = (TextView)view2.findViewById(R.id.slBasketballPlayByPlayTimeTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slBasketballPlayByPlayTimeTV");
            textView.setText((CharSequence)basketballPlayByPlayStatistics.getEventTime().getClock());
            TextView textView2 = (TextView)view2.findViewById(R.id.slBasketballPlayByPlayInfoTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"slBasketballPlayByPlayInfoTV");
            textView2.setText((CharSequence)basketballPlayByPlayStatistics.getPlayText());
            TextView textView3 = (TextView)view2.findViewById(R.id.slBasketballPlayByPlayInfoTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"slBasketballPlayByPlayInfoTV");
            this.formatPlayText(textView3, basketballPlayByPlayStatistics.getScoring());
            TextView textView4 = (TextView)view.findViewById(R.id.slBasketballPlayByPlayScoreTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"slBasketballPlayByPlayScoreTV");
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            textView4.setText((CharSequence)this.formatCurrentScore(basketballPlayByPlayStatistics, context));
        }
    }
}

