/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.sports.events;

import android.database.Cursor;
import androidx.collection.LongSparseArray;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventSummaryAwayEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryHomeEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryRelation;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseDataRelation;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballPerformers;
import io.streamlayer.sdk.model.sports.basketball.BasketballSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamSummary;
import io.streamlayer.sdk.model.sports.basketball.PlayerScores;
import io.streamlayer.sdk.repository.sports.events.SportEventsDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class SportEventsDao_Impl
implements SportEventsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BasketballEventSummary> __insertionAdapterOfBasketballEventSummary;
    private final Converters __converters;
    private final EntityInsertionAdapter<BasketballBoxScore> __insertionAdapterOfBasketballBoxScore;
    private final EntityInsertionAdapter<EventSummaryResponseData> __insertionAdapterOfEventSummaryResponseData;
    private final EntityInsertionAdapter<EventTeam> __insertionAdapterOfEventTeam;
    private final EntityInsertionAdapter<EventSummary> __insertionAdapterOfEventSummary;
    private final EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef> __insertionAdapterOfEventSummaryHomeEventTeamCrossRef;
    private final EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef> __insertionAdapterOfEventSummaryAwayEventTeamCrossRef;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __deletionAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __deletionAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __deletionAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __deletionAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __deletionAdapterOfEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __updateAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __updateAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __updateAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __updateAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __updateAdapterOfEventSummary;

    public SportEventsDao_Impl(RoomDatabase roomDatabase) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__converters = new Converters();
        sportEventsDao_Impl.__db = roomDatabase;
        sportEventsDao_Impl.__insertionAdapterOfBasketballEventSummary = new EntityInsertionAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballEventSummary` (`basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary object) {
                long l = ((BasketballEventSummary)object).getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = object2.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(((BasketballEventSummary)object).getPerformers());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object2);
                }
                object2 = ((BasketballEventSummary)object).getSummary();
                if (object2 != null) {
                    object = ((BasketballSummary)object2).getHomeTeamStatistics();
                    if (object != null) {
                        l = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindLong(3, l);
                        l = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindLong(4, l);
                        l = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindLong(5, l);
                        l = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(6, l);
                        l = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(7, l);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object2 = ((BasketballSummary)object2).getAwayTeamStatistics();
                    if (object2 != null) {
                        long l2 = ((BasketballTeamSummary)object2).getFieldGoalPercentage();
                        supportSQLiteStatement.bindLong(8, l2);
                        l2 = ((BasketballTeamSummary)object2).getThreePtsPercentage();
                        supportSQLiteStatement.bindLong(9, l2);
                        l2 = ((BasketballTeamSummary)object2).getFreeThrowPercentage();
                        supportSQLiteStatement.bindLong(10, l2);
                        l2 = ((BasketballTeamSummary)object2).getAssists();
                        supportSQLiteStatement.bindLong(11, l2);
                        l2 = ((BasketballTeamSummary)object2).getRebounds();
                        supportSQLiteStatement.bindLong(12, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfBasketballBoxScore = new EntityInsertionAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballBoxScore` (`basketballBoxScoreId`,`homePlayerScores`,`awayPlayerScore`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryResponseData = new EntityInsertionAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryResponseData` (`eventSummaryResponseDataId`,`type`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventTeam = new EntityInsertionAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventTeam` (`eventTeamId`,`name`,`alias`,`logo`,`colors`,`isWinner`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummary = new EntityInsertionAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummary` (`eventSummaryId`,`scheduled`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventSummary.getScheduled());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(3, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(4, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(5, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(6, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, (String)object);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(9, l2);
                object = eventSummary.getEventTime();
                if (object != null) {
                    if (((EventTime)object).getClock() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, ((EventTime)object).getClock());
                    }
                    long l3 = ((EventTime)object).getPeriod();
                    supportSQLiteStatement.bindLong(11, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(10);
                    supportSQLiteStatement2.bindNull(11);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef = new EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryHomeEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
                long l = eventSummaryHomeEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryHomeEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef = new EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryAwayEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
                long l = eventSummaryAwayEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryAwayEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfBasketballEventSummary = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfBasketballBoxScore = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballBoxScore` WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventSummaryResponseData = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummaryResponseData` WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventTeam = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventTeam` WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventSummary = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummary` WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballEventSummary = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballEventSummary` SET `basketballEventSummaryId` = ?,`performers` = ?,`homeTeamfieldGoalPercentage` = ?,`homeTeamthreePtsPercentage` = ?,`homeTeamfreeThrowPercentage` = ?,`homeTeamassists` = ?,`homeTeamrebounds` = ?,`awayTeamfieldGoalPercentage` = ?,`awayTeamthreePtsPercentage` = ?,`awayTeamfreeThrowPercentage` = ?,`awayTeamassists` = ?,`awayTeamrebounds` = ? WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(basketballEventSummary.getPerformers());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                object = basketballEventSummary.getSummary();
                if (object != null) {
                    BasketballTeamSummary basketballTeamSummary = ((BasketballSummary)object).getHomeTeamStatistics();
                    if (basketballTeamSummary != null) {
                        long l2 = basketballTeamSummary.getFieldGoalPercentage();
                        supportSQLiteStatement.bindLong(3, l2);
                        l2 = basketballTeamSummary.getThreePtsPercentage();
                        supportSQLiteStatement.bindLong(4, l2);
                        l2 = basketballTeamSummary.getFreeThrowPercentage();
                        supportSQLiteStatement.bindLong(5, l2);
                        l2 = basketballTeamSummary.getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = basketballTeamSummary.getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object = ((BasketballSummary)object).getAwayTeamStatistics();
                    if (object != null) {
                        long l3 = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindLong(8, l3);
                        l3 = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindLong(9, l3);
                        l3 = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindLong(10, l3);
                        l3 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
                long l4 = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(13, l4);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballBoxScore = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballBoxScore` SET `basketballBoxScoreId` = ?,`homePlayerScores` = ?,`awayPlayerScore` = ? WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                long l2 = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(4, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventSummaryResponseData = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummaryResponseData` SET `eventSummaryResponseDataId` = ?,`type` = ? WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventTeam = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventTeam` SET `eventTeamId` = ?,`name` = ?,`alias` = ?,`logo` = ?,`colors` = ?,`isWinner` = ? WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
                l2 = eventTeam.getId();
                supportSQLiteStatement.bindLong(7, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventSummary = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummary` SET `eventSummaryId` = ?,`scheduled` = ?,`homeScore` = ?,`awayScore` = ?,`homeTeamId` = ?,`awayTeamId` = ?,`status` = ?,`periods` = ?,`periodsCount` = ?,`clock` = ?,`period` = ? WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventSummary.getScheduled());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(3, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(4, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(5, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(6, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, (String)object);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(9, l2);
                object = eventSummary.getEventTime();
                if (object != null) {
                    if (((EventTime)object).getClock() == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, ((EventTime)object).getClock());
                    }
                    l2 = ((EventTime)object).getPeriod();
                    supportSQLiteStatement.bindLong(11, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(10);
                    supportSQLiteStatement2.bindNull(11);
                }
                long l3 = eventSummary.getId();
                supportSQLiteStatement.bindLong(12, l3);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n2 = 0;
            int n3 = longSparseArray.size();
            for (int j = 0; j < n3; ++j) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(j), null);
                if (++n2 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n2 = 0;
            }
            if (n2 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryHomeEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n4 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (n = 0; n < longSparseArray.size(); ++n5, ++n) {
            roomSQLiteQuery.bindLong(n5, longSparseArray.keyAt(n));
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"eventTeamId");
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"name");
            int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"alias");
            int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"logo");
            int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"colors");
            int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"isWinner");
            while (roomSQLiteQuery.moveToNext()) {
                Object object;
                long l = roomSQLiteQuery.getLong(6);
                if (!longSparseArray.containsKey(l)) continue;
                long l2 = n5 == -1 ? 0L : roomSQLiteQuery.getLong(n5);
                String string2 = n == -1 ? null : roomSQLiteQuery.getString(n);
                String string3 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
                String string4 = n7 == -1 ? null : roomSQLiteQuery.getString(n7);
                if (n8 == -1) {
                    object = null;
                } else {
                    object = roomSQLiteQuery.getString(n8);
                    object = this.__converters.stringToStringList((String)object);
                }
                boolean bl = n9 != -1 && roomSQLiteQuery.getInt(n9) != 0;
                longSparseArray.put(l, (Object)new EventTeam(l2, string2, string3, string4, (List<String>)object, bl));
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        roomSQLiteQuery.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n2 = 0;
            int n3 = longSparseArray.size();
            for (int j = 0; j < n3; ++j) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(j), null);
                if (++n2 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n2 = 0;
            }
            if (n2 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryAwayEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n4 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (n = 0; n < longSparseArray.size(); ++n5, ++n) {
            roomSQLiteQuery.bindLong(n5, longSparseArray.keyAt(n));
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"eventTeamId");
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"name");
            int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"alias");
            int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"logo");
            int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"colors");
            int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"isWinner");
            while (roomSQLiteQuery.moveToNext()) {
                Object object;
                long l = roomSQLiteQuery.getLong(6);
                if (!longSparseArray.containsKey(l)) continue;
                long l2 = n5 == -1 ? 0L : roomSQLiteQuery.getLong(n5);
                String string2 = n == -1 ? null : roomSQLiteQuery.getString(n);
                String string3 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
                String string4 = n7 == -1 ? null : roomSQLiteQuery.getString(n7);
                if (n8 == -1) {
                    object = null;
                } else {
                    object = roomSQLiteQuery.getString(n8);
                    object = this.__converters.stringToStringList((String)object);
                }
                boolean bl = n9 != -1 && roomSQLiteQuery.getInt(n9) != 0;
                longSparseArray.put(l, (Object)new EventTeam(l2, string2, string3, string4, (List<String>)object, bl));
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        roomSQLiteQuery.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation(LongSparseArray<EventSummaryRelation> var1_1) {
        block20: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `eventSummaryId`,`scheduled`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period` FROM `EventSummary` WHERE `eventSummaryId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var3_6, ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)true, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"eventSummaryId");
            if (var3_6 != -1) break block20;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        var4_8 = CursorUtil.getColumnIndex((Cursor)v3, (String)"eventSummaryId");
        var5_10 = CursorUtil.getColumnIndex((Cursor)v3, (String)"scheduled");
        var6_11 = CursorUtil.getColumnIndex((Cursor)v3, (String)"homeScore");
        var7_12 = CursorUtil.getColumnIndex((Cursor)v3, (String)"awayScore");
        var8_13 = CursorUtil.getColumnIndex((Cursor)v3, (String)"homeTeamId");
        var9_14 = CursorUtil.getColumnIndex((Cursor)v3, (String)"awayTeamId");
        var10_15 = CursorUtil.getColumnIndex((Cursor)v3, (String)"status");
        var11_16 = CursorUtil.getColumnIndex((Cursor)v3, (String)"periods");
        var12_17 = CursorUtil.getColumnIndex((Cursor)v3, (String)"periodsCount");
        var13_18 = CursorUtil.getColumnIndex((Cursor)v3, (String)"clock");
        var14_19 = CursorUtil.getColumnIndex((Cursor)v3, (String)"period");
        var15_20 = v4;
        v4 = new LongSparseArray();
        var16_21 = v5;
        v5 = new LongSparseArray();
        while (var2_4.moveToNext()) {
            var15_20.put(var2_4.getLong(var4_8), null);
            var16_21.put(var2_4.getLong(var4_8), null);
        }
        v6 = this;
        v7 = var16_21;
        v8 = this;
        v9 = var15_20;
        var2_4.moveToPosition(-1);
        try {
            v8.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)v9);
            v6.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)v7);
            while (var2_4.moveToNext()) {
                v10 = var1_1;
                var17_22 = var2_4.getLong(var3_6);
            }
        }
        catch (Throwable v11) {
            var2_4.close();
            throw v11;
        }
        {
            block22: {
                block21: {
                    if (!v10.containsKey(var17_22)) continue;
                    if (!(var4_8 != -1 && var2_4.isNull(var4_8) == false || var5_10 != -1 && var2_4.isNull(var5_10) == false || var6_11 != -1 && var2_4.isNull(var6_11) == false || var7_12 != -1 && var2_4.isNull(var7_12) == false || var8_13 != -1 && var2_4.isNull(var8_13) == false || var9_14 != -1 && var2_4.isNull(var9_14) == false || var10_15 != -1 && var2_4.isNull(var10_15) == false || var11_16 != -1 && var2_4.isNull(var11_16) == false || var12_17 != -1 && var2_4.isNull(var12_17) == false || var13_18 != -1 && var2_4.isNull(var13_18) == false) && (var14_19 == -1 || var2_4.isNull(var14_19))) ** GOTO lbl111
                    var19_25 = var4_8 == -1 ? 0L : var2_4.getLong(var4_8);
                    var21_26 = var5_10 == -1 ? null : var2_4.getString(var5_10);
                    var22_27 = var6_11 == -1 ? 0 : var2_4.getInt(var6_11);
                    var23_28 = var7_12 == -1 ? 0 : var2_4.getInt(var7_12);
                    var24_29 = var8_13 == -1 ? 0L : var2_4.getLong(var8_13);
                    var26_30 = var9_14 == -1 ? 0L : var2_4.getLong(var9_14);
                    if (var10_15 == -1) {
                        var28_31 /* !! */  = null;
                    } else {
                        var28_31 /* !! */  = var2_4.getString(var10_15);
                        var28_31 /* !! */  = this.__converters.stringToEventStatus(var28_31 /* !! */ );
                    }
                    if (var11_16 == -1) {
                        var29_32 = null;
                    } else {
                        var29_32 = var2_4.getString(var11_16);
                        var29_32 = this.__converters.stringToEventPeriods((String)var29_32);
                    }
                    var30_33 = var12_17 == -1 ? 0 : var2_4.getInt(var12_17);
                    if ((var13_18 == -1 || var2_4.isNull(var13_18)) && (var14_19 == -1 || var2_4.isNull(var14_19))) ** GOTO lbl105
                    var31_34 = var13_18 == -1 ? null : var2_4.getString(var13_18);
                    var32_35 = var14_19 == -1 ? 0 : var2_4.getInt(var14_19);
                    var33_36 = v12;
                    v12 = new EventTime((String)var31_34, var32_35);
                    break block21;
lbl105:
                    // 1 sources

                    var33_36 = null;
                }
                var31_34 = v13;
                v13 = new EventSummary(var19_25, var21_26, var22_27, var23_28, var33_36, var24_29, var26_30, (EventStatus)var28_31 /* !! */ , (List<EventPeriod>)var29_32, var30_33);
                break block22;
lbl111:
                // 1 sources

                var31_34 = null;
            }
            var17_23 = (EventTeam)var15_20.get(var2_4.getLong(var4_8));
            var18_24 = (EventTeam)var16_21.get(var2_4.getLong(var4_8));
            var1_1.put(var17_22, (Object)new EventSummaryRelation((EventSummary)var31_34, var17_23, var18_24));
            continue;
        }
        var2_4.close();
    }

    private void __fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary(LongSparseArray<BasketballEventSummary> longSparseArray) {
        int n;
        int n2;
        int n3;
        RoomSQLiteQuery roomSQLiteQuery;
        block102: {
            if (longSparseArray.isEmpty()) {
                return;
            }
            if (longSparseArray.size() > 999) {
                LongSparseArray longSparseArray2;
                LongSparseArray longSparseArray3 = longSparseArray2;
                longSparseArray2 = new LongSparseArray(999);
                int n4 = 0;
                int n5 = longSparseArray.size();
                for (int j = 0; j < n5; ++j) {
                    LongSparseArray longSparseArray4;
                    longSparseArray3.put(longSparseArray.keyAt(j), null);
                    if (++n4 != 999) continue;
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray3);
                    longSparseArray.putAll(longSparseArray3);
                    longSparseArray3 = longSparseArray4;
                    longSparseArray4 = new LongSparseArray(999);
                    n4 = 0;
                }
                if (n4 > 0) {
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray3);
                    longSparseArray.putAll(longSparseArray3);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds` FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` IN (");
            int n6 = longSparseArray.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n6);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n6 + 0));
            n3 = 1;
            for (n2 = 0; n2 < longSparseArray.size(); ++n2) {
                roomSQLiteQuery.bindLong(n3, longSparseArray.keyAt(n2));
                ++n3;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n3 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"basketballEventSummaryId");
            if (n3 != -1) break block102;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery2;
        n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"basketballEventSummaryId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery11, (String)"performers");
        int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery12, (String)"homeTeamfieldGoalPercentage");
        int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery13, (String)"homeTeamthreePtsPercentage");
        int n10 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery9, (String)"homeTeamfreeThrowPercentage");
        int n11 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery10, (String)"homeTeamassists");
        int n12 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery7, (String)"homeTeamrebounds");
        int n13 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery8, (String)"awayTeamfieldGoalPercentage");
        int n14 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery5, (String)"awayTeamthreePtsPercentage");
        int n15 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery6, (String)"awayTeamfreeThrowPercentage");
        int n16 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"awayTeamassists");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"awayTeamrebounds");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            BasketballSummary basketballSummary;
            Object object;
            long l;
            long l2;
            block113: {
                block106: {
                    BasketballSummary basketballSummary2;
                    BasketballTeamSummary basketballTeamSummary;
                    BasketballTeamSummary basketballTeamSummary2;
                    block112: {
                        block111: {
                            BasketballTeamSummary basketballTeamSummary3;
                            int n17;
                            int n18;
                            int n19;
                            int n20;
                            int n21;
                            block110: {
                                block109: {
                                    block108: {
                                        BasketballTeamSummary basketballTeamSummary4;
                                        block107: {
                                            block105: {
                                                block104: {
                                                    block103: {
                                                        if (!roomSQLiteQuery.moveToNext()) break;
                                                        LongSparseArray<BasketballEventSummary> longSparseArray5 = longSparseArray;
                                                        l2 = roomSQLiteQuery.getLong(n3);
                                                        if (!longSparseArray5.containsKey(l2)) continue;
                                                        if (n2 != -1) break block103;
                                                        l = 0L;
                                                        break block104;
                                                    }
                                                    l = roomSQLiteQuery.getLong(n2);
                                                }
                                                if (n7 == -1) {
                                                    object = null;
                                                } else {
                                                    SportEventsDao_Impl sportEventsDao_Impl = this;
                                                    object = roomSQLiteQuery.getString(n7);
                                                    object = sportEventsDao_Impl.__converters.stringToBasketballPerformers((String)object);
                                                }
                                                if (n8 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n8)) break block105;
                                                }
                                                if (n9 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n9)) break block105;
                                                }
                                                if (n10 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n10)) break block105;
                                                }
                                                if (n11 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n11)) break block105;
                                                }
                                                if (n12 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n12)) break block105;
                                                }
                                                if (n13 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n13)) break block105;
                                                }
                                                if (n14 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n14)) break block105;
                                                }
                                                if (n15 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n15)) break block105;
                                                }
                                                if (n16 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n16)) break block105;
                                                }
                                                if (n == -1) break block106;
                                                if (roomSQLiteQuery.isNull(n)) break block106;
                                            }
                                            if (n8 != -1) {
                                                if (!roomSQLiteQuery.isNull(n8)) break block107;
                                            }
                                            if (n9 != -1) {
                                                if (!roomSQLiteQuery.isNull(n9)) break block107;
                                            }
                                            if (n10 != -1) {
                                                if (!roomSQLiteQuery.isNull(n10)) break block107;
                                            }
                                            if (n11 != -1) {
                                                if (!roomSQLiteQuery.isNull(n11)) break block107;
                                            }
                                            if (n12 == -1) break block108;
                                            if (roomSQLiteQuery.isNull(n12)) break block108;
                                        }
                                        if (n8 == -1) {
                                            n21 = 0;
                                        } else {
                                            n21 = roomSQLiteQuery.getInt(n8);
                                        }
                                        if (n9 == -1) {
                                            n20 = 0;
                                        } else {
                                            n20 = roomSQLiteQuery.getInt(n9);
                                        }
                                        if (n10 == -1) {
                                            n19 = 0;
                                        } else {
                                            n19 = roomSQLiteQuery.getInt(n10);
                                        }
                                        if (n11 == -1) {
                                            n18 = 0;
                                        } else {
                                            n18 = roomSQLiteQuery.getInt(n11);
                                        }
                                        if (n12 == -1) {
                                            n17 = 0;
                                        } else {
                                            n17 = roomSQLiteQuery.getInt(n12);
                                        }
                                        basketballTeamSummary2 = basketballTeamSummary4;
                                        basketballTeamSummary4 = new BasketballTeamSummary(n21, n20, n19, n18, n17);
                                        break block109;
                                    }
                                    basketballTeamSummary2 = null;
                                }
                                if (n13 != -1) {
                                    if (!roomSQLiteQuery.isNull(n13)) break block110;
                                }
                                if (n14 != -1) {
                                    if (!roomSQLiteQuery.isNull(n14)) break block110;
                                }
                                if (n15 != -1) {
                                    if (!roomSQLiteQuery.isNull(n15)) break block110;
                                }
                                if (n16 != -1) {
                                    if (!roomSQLiteQuery.isNull(n16)) break block110;
                                }
                                if (n == -1) break block111;
                                if (roomSQLiteQuery.isNull(n)) break block111;
                            }
                            if (n13 == -1) {
                                n21 = 0;
                            } else {
                                n21 = roomSQLiteQuery.getInt(n13);
                            }
                            if (n14 == -1) {
                                n20 = 0;
                            } else {
                                n20 = roomSQLiteQuery.getInt(n14);
                            }
                            if (n15 == -1) {
                                n19 = 0;
                            } else {
                                n19 = roomSQLiteQuery.getInt(n15);
                            }
                            if (n16 == -1) {
                                n18 = 0;
                            } else {
                                n18 = roomSQLiteQuery.getInt(n16);
                            }
                            if (n == -1) {
                                n17 = 0;
                            } else {
                                n17 = roomSQLiteQuery.getInt(n);
                            }
                            basketballTeamSummary = basketballTeamSummary3;
                            basketballTeamSummary3 = new BasketballTeamSummary(n21, n20, n19, n18, n17);
                            break block112;
                        }
                        basketballTeamSummary = null;
                    }
                    basketballSummary = basketballSummary2;
                    basketballSummary2 = new BasketballSummary(basketballTeamSummary2, basketballTeamSummary);
                    break block113;
                }
                basketballSummary = null;
            }
            longSparseArray.put(l2, (Object)new BasketballEventSummary(l, basketballSummary, (List<BasketballPerformers>)object));
            continue;
            break;
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$200(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)longSparseArray);
    }

    static /* synthetic */ void access$300(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray);
    }

    static /* synthetic */ void access$400(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray);
    }

    static /* synthetic */ void access$500(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray);
    }

    @Override
    public void saveBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballEventSummary.insert((Object)basketballEventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballBoxScore.insert((Object)basketballBoxScore);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryResponseData.insert((Object)eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventTeam.insert((Object)eventTeam);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummary.insert((Object)eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryHomeEventTeamCrossRef(EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef.insert((Object)eventSummaryHomeEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryAwayEventTeamCrossRef(EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef.insert((Object)eventSummaryAwayEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummaryResponseData(sportEventsDao_Impl, eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummary(sportEventsDao_Impl, eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public Observable<BasketballEventSummary> getBasketballSummary(long l) {
        Callable<BasketballEventSummary> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballEventSummary WHERE BasketballEventSummary.basketballEventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballEventSummary";
        Callable<BasketballEventSummary> callable2 = callable;
        callable = new Callable<BasketballEventSummary>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public BasketballEventSummary call() throws Exception {
                block58: {
                    block52: {
                        block54: {
                            block57: {
                                block56: {
                                    block55: {
                                        block53: {
                                            var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                            try {
                                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"basketballEventSummaryId");
                                            }
                                            catch (Throwable v0) {
                                                var1_1.close();
                                                throw v0;
                                            }
                                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"performers");
                                            var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfieldGoalPercentage");
                                            var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamthreePtsPercentage");
                                            var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfreeThrowPercentage");
                                            var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamassists");
                                            var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamrebounds");
                                            var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfieldGoalPercentage");
                                            var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamthreePtsPercentage");
                                            var11_18 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfreeThrowPercentage");
                                            var12_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamassists");
                                            var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamrebounds");
                                            if (!var1_1.moveToFirst()) break block52;
                                            v1 = var1_1;
                                            v2 = var4_5;
                                            v3 = this;
                                            v4 = var1_1;
                                            v5 = var3_4;
                                            var2_3 = var1_1.getLong(var2_2);
                                            this = v4.getString(v5);
                                            this = SportEventsDao_Impl.access$000(v3.SportEventsDao_Impl.this).stringToBasketballPerformers((String)this);
                                            if (!v1.isNull(v2)) break block53;
                                            if (!var1_1.isNull(var5_10)) break block53;
                                            if (!var1_1.isNull(var6_12)) break block53;
                                            if (!var1_1.isNull(var7_13)) break block53;
                                            if (!var1_1.isNull(var8_14)) break block53;
                                            if (!var1_1.isNull(var9_15)) break block53;
                                            if (!var1_1.isNull(var10_17)) break block53;
                                            if (!var1_1.isNull(var11_18)) break block53;
                                            if (!var1_1.isNull(var12_19)) break block53;
                                            if (!var1_1.isNull(var13_20)) break block53;
                                            var4_6 = null;
                                            break block54;
                                        }
                                        if (!var1_1.isNull(var4_5)) break block55;
                                        if (!var1_1.isNull(var5_10)) break block55;
                                        if (!var1_1.isNull(var6_12)) break block55;
                                        if (!var1_1.isNull(var7_13)) break block55;
                                        if (!var1_1.isNull(var8_14)) break block55;
                                        var14_21 = var4_7 = null;
                                        ** GOTO lbl99
                                    }
                                    v6 = var1_1;
                                    v7 = var8_14;
                                    v8 = var1_1;
                                    v9 = var7_13;
                                    v10 = var1_1;
                                    v11 = var6_12;
                                    v12 = var1_1;
                                    v13 = var5_10;
                                    var4_5 = var1_1.getInt(var4_5);
                                    var5_10 = v12.getInt(v13);
                                    var6_12 = v10.getInt(v11);
                                    var7_13 = v8.getInt(v9);
                                    var8_14 = v6.getInt(v7);
                                    var14_21 = v14;
                                    v14 = new BasketballTeamSummary(var4_5, var5_10, var6_12, var7_13, var8_14);
lbl99:
                                    // 2 sources

                                    if (!var1_1.isNull(var9_15)) break block56;
                                    if (!var1_1.isNull(var10_17)) break block56;
                                    if (!var1_1.isNull(var11_18)) break block56;
                                    if (!var1_1.isNull(var12_19)) break block56;
                                    if (!var1_1.isNull(var13_20)) break block56;
                                    var9_16 = var4_8 = null;
                                    break block57;
                                }
                                v15 = var1_1;
                                v16 = var13_20;
                                v17 = var1_1;
                                v18 = var12_19;
                                v19 = var1_1;
                                v20 = var11_18;
                                v21 = var1_1;
                                v22 = var10_17;
                                var4_9 = var1_1.getInt(var9_15);
                                var5_10 = v21.getInt(v22);
                                var6_12 = v19.getInt(v20);
                                var7_13 = v17.getInt(v18);
                                var8_14 = v15.getInt(v16);
                                var9_16 = v23;
                                v23 = new BasketballTeamSummary(var4_9, var5_10, var6_12, var7_13, var8_14);
                            }
                            var4_6 = v24;
                            v24 = new BasketballSummary(var14_21, var9_16);
                        }
                        var5_11 = v25;
                        v25 = new BasketballEventSummary(var2_3, var4_6, this);
                        break block58;
                    }
                    var5_11 = null;
                }
                var1_1.close();
                return var5_11;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<BasketballBoxScore> getBasketballBoxScore(long l) {
        Callable<BasketballBoxScore> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballBoxScore WHERE BasketballBoxScore.basketballBoxScoreId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballBoxScore";
        Callable<BasketballBoxScore> callable2 = callable;
        callable = new Callable<BasketballBoxScore>(){

            @Override
            public BasketballBoxScore call() throws Exception {
                BasketballBoxScore basketballBoxScore;
                Cursor cursor;
                block13: {
                    block12: {
                        BasketballBoxScore basketballBoxScore2;
                        int n;
                        cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                        try {
                            n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballBoxScoreId");
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"homePlayerScores");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"awayPlayerScore");
                        if (!cursor.moveToFirst()) break block12;
                        19 v1 = list;
                        Cursor cursor2 = cursor;
                        int n4 = n3;
                        19 v4 = list;
                        Cursor cursor3 = cursor;
                        int n5 = n2;
                        long l = cursor.getLong(n);
                        List<PlayerScores> list = cursor3.getString(n5);
                        list = v4.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)((Object)list));
                        Object object = cursor2.getString(n4);
                        object = v1.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)object);
                        basketballBoxScore = basketballBoxScore2;
                        basketballBoxScore2 = new BasketballBoxScore(l, list, (List<PlayerScores>)object);
                        break block13;
                    }
                    basketballBoxScore = null;
                }
                cursor.close();
                return basketballBoxScore;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventSummaryResponseDataRelation> getEventSummaryResponseDataRelation(long l) {
        Callable<EventSummaryResponseDataRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData WHERE EventSummaryResponseData.eventSummaryResponseDataId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<EventSummaryResponseDataRelation> callable2 = callable;
        callable = new Callable<EventSummaryResponseDataRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryResponseDataRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block13: {
                        block12: {
                            catch (Throwable v1) {
                                SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                throw v1;
                            }
                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                            var4_6 /* !! */  = v2;
                            v2 = new LongSparseArray();
                            var5_7 = v3;
                            v3 = new LongSparseArray();
                            while (var1_1.moveToNext()) {
                                var4_6 /* !! */ .put(var1_1.getLong(var2_2), null);
                                var5_7.put(var1_1.getLong(var2_2), null);
                            }
                            v4 = var1_1;
                            v5 = this;
                            v6 = v5;
                            v7 = v5;
                            var1_1.moveToPosition(-1);
                            SportEventsDao_Impl.access$200(v6.SportEventsDao_Impl.this, var4_6 /* !! */ );
                            SportEventsDao_Impl.access$300(v7.SportEventsDao_Impl.this, var5_7);
                            if (!v4.moveToFirst()) ** GOTO lbl52
                            if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4)) break block12;
                            var3_5 /* !! */  = null;
                            var8_8 = var3_5 /* !! */ ;
                            ** GOTO lbl43
                        }
                        var6_9 = var1_1.getLong(var2_2);
                        var3_5 /* !! */  = var1_1.getString(var3_4);
                        var3_5 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var3_5 /* !! */ );
                        var8_8 = v8;
                        try {
                            v8 = new EventSummaryResponseData(var6_9, (EventType)var3_5 /* !! */ );
lbl43:
                            // 2 sources

                            var2_3 = (EventSummaryRelation)var4_6 /* !! */ .get(var1_1.getLong(var2_2));
                            var3_5 /* !! */  = (BasketballEventSummary)var5_7.get(var1_1.getLong(var2_2));
                        }
                        catch (Throwable v9) {}
                        {
                            var1_1.close();
                            throw v9;
                        }
                        var4_6 /* !! */  = v10;
                        v10 = new EventSummaryResponseDataRelation((EventSummaryResponseData)var8_8, var2_3, (BasketballEventSummary)var3_5 /* !! */ );
                        break block13;
lbl52:
                        // 1 sources

                        var4_6 /* !! */  = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_6 /* !! */ ;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<List<EventSummaryResponseDataRelation>> getEventSummaryResponseDataRelations() {
        Callable<List<EventSummaryResponseDataRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<List<EventSummaryResponseDataRelation>> callable2 = callable;
        callable = new Callable<List<EventSummaryResponseDataRelation>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<EventSummaryResponseDataRelation> call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    catch (Throwable v1) {
                        SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                        throw v1;
                    }
                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                    var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                    var4_4 = v2;
                    v2 = new LongSparseArray();
                    var5_5 = v3;
                    v3 = new LongSparseArray();
                    while (var1_1.moveToNext()) {
                        var4_4.put(var1_1.getLong(var2_2), null);
                        var5_5.put(var1_1.getLong(var2_2), null);
                    }
                    v4 = this;
                    v5 = v4;
                    v6 = v4;
                    var1_1.moveToPosition(-1);
                    SportEventsDao_Impl.access$200(v5.SportEventsDao_Impl.this, var4_4);
                    SportEventsDao_Impl.access$300(v6.SportEventsDao_Impl.this, var5_5);
                    var6_6 = v7;
                    try {
                        v7 = new ArrayList<EventSummaryResponseDataRelation>(var1_1.getCount());
                        while (var1_1.moveToNext()) {
                            block14: {
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_3)) break block14;
                                var7_7 = null;
                                var10_11 = var7_7;
                                ** GOTO lbl48
                            }
                            var7_8 = var1_1.getLong(var2_2);
                            var9_10 /* !! */  = var1_1.getString(var3_3);
                            var9_10 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var9_10 /* !! */ );
                        }
                    }
                    catch (Throwable v8) {}
                    {
                        var1_1.close();
                        throw v8;
                    }
                    {
                        var10_11 = v9;
                        v9 = new EventSummaryResponseData(var7_8, (EventType)var9_10 /* !! */ );
lbl48:
                        // 2 sources

                        var7_7 = (EventSummaryRelation)var4_4.get(var1_1.getLong(var2_2));
                        var8_9 = (BasketballEventSummary)var5_5.get(var1_1.getLong(var2_2));
                        var6_6.add(new EventSummaryResponseDataRelation(var10_11, (EventSummaryRelation)var7_7, var8_9));
                        continue;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var6_6;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventTeam> getEventTeam(long l) {
        Callable<EventTeam> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventTeam WHERE EventTeam.eventTeamId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventTeam";
        Callable<EventTeam> callable2 = callable;
        callable = new Callable<EventTeam>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public EventTeam call() throws Exception {
                EventTeam eventTeam;
                Cursor cursor;
                block20: {
                    block18: {
                        void var7_14;
                        EventTeam eventTeam2;
                        Object object;
                        String string4;
                        String string3;
                        long l;
                        String string2;
                        block19: {
                            int n;
                            cursor = DBUtil.query((RoomDatabase)string2.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)string2.roomSQLiteQuery, (boolean)false, null);
                            try {
                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"eventTeamId");
                            }
                            catch (Throwable throwable) {
                                cursor.close();
                                throw throwable;
                            }
                            int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                            int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"alias");
                            int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"logo");
                            int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"colors");
                            int bl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isWinner");
                            if (!cursor.moveToFirst()) break block18;
                            Cursor cursor2 = cursor;
                            int n6 = bl;
                            22 v3 = string2;
                            Cursor cursor3 = cursor;
                            int n7 = n5;
                            Cursor cursor4 = cursor;
                            int n8 = n4;
                            Cursor cursor5 = cursor;
                            int n9 = n3;
                            Cursor cursor6 = cursor;
                            int n10 = n2;
                            l = cursor.getLong(n);
                            string2 = cursor6.getString(n10);
                            string3 = cursor5.getString(n9);
                            string4 = cursor4.getString(n8);
                            object = cursor3.getString(n7);
                            object = v3.SportEventsDao_Impl.this.__converters.stringToStringList((String)object);
                            if (cursor2.getInt(n6) != 0) {
                                boolean bl2 = true;
                                break block19;
                            }
                            boolean bl3 = false;
                        }
                        eventTeam = eventTeam2;
                        eventTeam2 = new EventTeam(l, string2, string3, string4, (List<String>)object, (boolean)var7_14);
                        break block20;
                    }
                    eventTeam = null;
                }
                cursor.close();
                return eventTeam;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventSummaryRelation> getEventSummaryRelation(long l) {
        Callable<EventSummaryRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummary WHERE EventSummary.eventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        Callable<EventSummaryRelation> callable2 = callable;
        callable = new Callable<EventSummaryRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block16: {
                        block14: {
                            block15: {
                                catch (Throwable v1) {
                                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                    throw v1;
                                }
                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryId");
                                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduled");
                                var4_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeScore");
                                var5_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayScore");
                                var6_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamId");
                                var7_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamId");
                                var8_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                var9_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periods");
                                var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periodsCount");
                                var11_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"clock");
                                var12_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"period");
                                var13_22 = v2;
                                v2 = new LongSparseArray();
                                var14_23 = v3;
                                v3 = new LongSparseArray();
                                while (var1_1.moveToNext()) {
                                    var13_22.put(var1_1.getLong(var2_2), null);
                                    var14_23.put(var1_1.getLong(var2_2), null);
                                }
                                v4 = var1_1;
                                v5 = this;
                                v6 = v5;
                                v7 = v5;
                                var1_1.moveToPosition(-1);
                                SportEventsDao_Impl.access$400(v6.SportEventsDao_Impl.this, var13_22);
                                SportEventsDao_Impl.access$500(v7.SportEventsDao_Impl.this, var14_23);
                                if (!v4.moveToFirst()) ** GOTO lbl80
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4) || !var1_1.isNull(var4_8) || !var1_1.isNull(var5_10) || !var1_1.isNull(var6_12) || !var1_1.isNull(var7_13) || !var1_1.isNull(var8_14) || !var1_1.isNull(var9_16) || !var1_1.isNull(var10_17) || !var1_1.isNull(var11_19) || !var1_1.isNull(var12_21)) break block15;
                                var3_5 = null;
                                var11_20 = var3_5;
                                ** GOTO lbl71
                            }
                            v8 = var7_13;
                            v9 = var6_12;
                            var3_6 = var1_1.getLong(var2_2);
                            var5_11 = var1_1.getString(var3_4);
                            var6_12 = var1_1.getInt(var4_8);
                            var7_13 = var1_1.getInt(var5_10);
                            var8_15 = var1_1.getLong(v9);
                            var15_24 = var1_1.getLong(v8);
                            var10_18 /* !! */  = var1_1.getString(var8_14);
                            var10_18 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventStatus(var10_18 /* !! */ );
                            var17_25 = var1_1.getString(var9_16);
                            var17_25 = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventPeriods((String)var17_25);
                            var18_26 = var1_1.getInt(var10_17);
                            if (var1_1.isNull(var11_19) && var1_1.isNull(var12_21)) {
                                var19_27 = var11_20 = null;
                                break block14;
                            }
                            var11_20 = var1_1.getString(var11_19);
                            var12_21 = var1_1.getInt(var12_21);
                            var19_27 = v10;
                            v10 = new EventTime((String)var11_20, var12_21);
                        }
                        var11_20 = v11;
                        try {
                            v11 = new EventSummary(var3_6, var5_11, var6_12, var7_13, (EventTime)var19_27, var8_15, var15_24, (EventStatus)var10_18 /* !! */ , (List<EventPeriod>)var17_25, var18_26);
lbl71:
                            // 2 sources

                            var2_3 = (EventTeam)var13_22.get(var1_1.getLong(var2_2));
                            var3_7 = (EventTeam)var14_23.get(var1_1.getLong(var2_2));
                        }
                        catch (Throwable v12) {}
                        {
                            var1_1.close();
                            throw v12;
                        }
                        var4_9 = v13;
                        v13 = new EventSummaryRelation((EventSummary)var11_20, var2_3, var3_7);
                        break block16;
lbl80:
                        // 1 sources

                        var4_9 = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_9;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventSummaryResponseData> getEventSummaryResponseData(long l) {
        return SportEventsDao.DefaultImpls.getEventSummaryResponseData(this, l);
    }

    @Override
    public Observable<EventSummary> getEventSummary(long l) {
        return SportEventsDao.DefaultImpls.getEventSummary(this, l);
    }
}

