/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.baseball.BaseballEventScore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "()V", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "ViewHolder", "sdk_release"})
public final class BaseballScoresAdapter
extends GenericAdapter<EventScheduleData> {
    protected int getLayoutId(int n) {
        return R.layout.sl_item_statistics_schedule;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<EventScheduleData> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new ViewHolder(view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter$ViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballScoresAdapter;Landroid/view/View;)V", "bind", "", "data", "sdk_release"})
    private final class ViewHolder
    extends GenericAdapter.GenericViewHolder<EventScheduleData> {
        public ViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        public void bind(@NotNull EventScheduleData object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"data");
            ViewHolder viewHolder = viewHolder.itemView;
            EventTeam eventTeam = ((EventScheduleData)object).getAttributes().getSummary().getHomeTeam();
            ImageView imageView = (ImageView)viewHolder.findViewById(R.id.slScheduleTeamHomeLogo);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slScheduleTeamHomeLogo");
            ExtensionsKt.loadUrl$default(imageView, eventTeam.getLogo(), false, null, 4, null);
            TextView textView = (TextView)viewHolder.findViewById(R.id.slScheduleTeamHomeName);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slScheduleTeamHomeName");
            textView.setText((CharSequence)eventTeam.getName());
            ImageView imageView2 = (ImageView)viewHolder.findViewById(R.id.slScheduleTeamHomePointer);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"slScheduleTeamHomePointer");
            int n = eventTeam.isWinner() ? 0 : 4;
            ViewHolder viewHolder2 = viewHolder;
            imageView2.setVisibility(n);
            EventTeam eventTeam2 = ((EventScheduleData)object).getAttributes().getSummary().getAwayTeam();
            ImageView imageView3 = (ImageView)viewHolder2.findViewById(R.id.slScheduleTeamAwayLogo);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView3, (String)"slScheduleTeamAwayLogo");
            ExtensionsKt.loadUrl$default(imageView3, eventTeam2.getLogo(), false, null, 4, null);
            TextView textView2 = (TextView)viewHolder2.findViewById(R.id.slScheduleTeamAwayName);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"slScheduleTeamAwayName");
            textView2.setText((CharSequence)eventTeam2.getName());
            imageView2 = (ImageView)viewHolder2.findViewById(R.id.slScheduleTeamAwayPointer);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"slScheduleTeamAwayPointer");
            int n2 = eventTeam2.isWinner() ? 0 : 4;
            imageView2.setVisibility(n2);
            Object object2 = ((EventScheduleData)object).getAttributes().getSummary();
            if (((EventSummary)object2).getStatus() == EventStatus.Overtime) {
                ViewHolder viewHolder3 = viewHolder;
                TextView textView3 = (TextView)viewHolder3.findViewById(R.id.slScheduleExtraBottom);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"slScheduleExtraBottom");
                textView3.setVisibility(8);
                ((TextView)viewHolder3.findViewById(R.id.slScheduleExtraTop)).setText(R.string.sl_statistics_scores_final);
            } else {
                TextView textView4 = (TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"slScheduleExtraBottom");
                textView4.setVisibility(0);
            }
            imageView2 = (TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"slScheduleExtraBottom");
            boolean bl = ((EventSummary)object2).getStatus() != EventStatus.Overtime;
            ExtensionsKt.visibleIf((View)imageView2, bl);
            if (((EventSummary)object2).getStatus() == EventStatus.Postgame) {
                object2 = ((EventScheduleData)object).getAttributes().getBaseballEventScore();
                if (object2 != null) {
                    Object object3 = object2;
                    object2 = ((BaseballEventScore)object2).getHomeTeamRecord();
                    object2 = "" + ((TeamRecord)object2).getWins() + '-' + ((TeamRecord)object2).getLosses();
                    ((TextView)viewHolder.findViewById(R.id.slScheduleTeamHomePoints)).setText((CharSequence)object2);
                    object2 = ((BaseballEventScore)object3).getAwayTeamRecord();
                    object2 = "" + ((TeamRecord)object2).getWins() + '-' + ((TeamRecord)object2).getLosses();
                    ((TextView)viewHolder.findViewById(R.id.slScheduleTeamAwayPoints)).setText((CharSequence)object2);
                }
            } else {
                ViewHolder viewHolder4 = viewHolder;
                TextView textView5 = (TextView)viewHolder4.findViewById(R.id.slScheduleTeamHomePoints);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView5, (String)"slScheduleTeamHomePoints");
                textView5.setText((CharSequence)String.valueOf(((EventSummary)object2).getHomeScore()));
                TextView textView6 = (TextView)viewHolder4.findViewById(R.id.slScheduleTeamAwayPoints);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView6, (String)"slScheduleTeamAwayPoints");
                textView6.setText((CharSequence)String.valueOf(((EventSummary)object2).getAwayScore()));
            }
            if ((object2 = ((EventScheduleData)object).getAttributes().getBaseballEventScore()) != null) {
                if (((BaseballEventScore)object2).getDelayed()) {
                    ViewHolder viewHolder5 = viewHolder;
                    TextView textView7 = (TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView7, (String)"slScheduleExtraTop");
                    textView7.setText((CharSequence)((BaseballEventScore)object2).getReasonForDelay());
                    ((TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop)).setBackgroundResource(R.drawable.sl_shape_rect_rounded_2);
                    TextView textView8 = (TextView)viewHolder5.findViewById(R.id.slScheduleExtraTop);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView8, (String)"slScheduleExtraTop");
                    textView8.setBackgroundTintList(ContextCompat.getColorStateList((Context)viewHolder.getContext(), (int)R.color.sl_red700));
                } else {
                    ViewHolder viewHolder6 = viewHolder;
                    TextView textView9 = (TextView)viewHolder6.findViewById(R.id.slScheduleExtraTop);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView9, (String)"slScheduleExtraTop");
                    textView9.setBackground(null);
                    object = ((BaseballEventScore)object2).getInningDivision() + ' ' + ((EventScheduleData)object).getAttributes().getSummary().getEventTime().getPeriod();
                    ((TextView)viewHolder6.findViewById(R.id.slScheduleExtraTop)).setText((CharSequence)object);
                }
                TextView textView10 = (TextView)viewHolder.findViewById(R.id.slScheduleExtraBottom);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView10, (String)"slScheduleExtraBottom");
                textView10.setText((CharSequence)viewHolder.getContext().getString(R.string.sl_statistics_scores_outs, new Object[]{((BaseballEventScore)object2).getOuts()}));
                if (((BaseballEventScore)object2).getTakenBases() >= 3) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.ic_baseball_bases_3);
                } else if (((BaseballEventScore)object2).getTakenBases() == 2) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.ic_baseball_bases_2);
                } else if (((BaseballEventScore)object2).getTakenBases() == 1) {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageResource(R.drawable.ic_baseball_bases_1);
                } else {
                    ((ImageView)viewHolder.findViewById(R.id.slScheduleSportIcon)).setImageDrawable(null);
                }
            }
        }
    }
}

