/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.repository.notifications.NotificationDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class NotificationDao_Impl
implements NotificationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Notification> __insertionAdapterOfNotification;
    private final EntityDeletionOrUpdateAdapter<Notification> __deletionAdapterOfNotification;
    private final EntityDeletionOrUpdateAdapter<Notification> __updateAdapterOfNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllNotifications;

    public NotificationDao_Impl(RoomDatabase roomDatabase) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db = roomDatabase;
        notificationDao_Impl.__insertionAdapterOfNotification = new EntityInsertionAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Notification` (`id`,`title`,`description`,`_type`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                long l = notification.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getDescription());
                }
                if (notification.get_type() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notification.get_type());
                }
            }
        };
        notificationDao_Impl.__deletionAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `Notification` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                long l = notification.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        notificationDao_Impl.__updateAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `Notification` SET `id` = ?,`title` = ?,`description` = ?,`_type` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                long l = notification.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getDescription());
                }
                if (notification.get_type() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notification.get_type());
                }
                long l2 = notification.getId();
                supportSQLiteStatement.bindLong(5, l2);
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteNotification = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification WHERE id = ?";
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteAllNotifications = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification";
            }
        };
    }

    @Override
    public void saveNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__insertionAdapterOfNotification.insert(list);
            notificationDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public Completable deleteNotifications(final List<Notification> list) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                6 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handleMultiple((Iterable)list);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                return null;
            }
        });
    }

    @Override
    public void updateNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__updateAdapterOfNotification.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public Completable deleteNotification(final long l) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                7 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.acquire();
                long l2 = l;
                supportSQLiteStatement.bindLong(1, l2);
                NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    7 v2 = this;
                    v2.NotificationDao_Impl.this.__db.endTransaction();
                    v2.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                return null;
            }
        });
    }

    @Override
    public Completable deleteAllNotifications() {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                8 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.acquire();
                NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    8 v2 = this;
                    v2.NotificationDao_Impl.this.__db.endTransaction();
                    v2.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                v0.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.release(supportSQLiteStatement);
                return null;
            }
        });
    }

    @Override
    public Observable<List<Notification>> getNotifications() {
        Callable<List<Notification>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Notification", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Notification";
        Callable<List<Notification>> callable2 = callable;
        callable = new Callable<List<Notification>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<Notification> call() throws Exception {
                ArrayList<Notification> arrayList;
                int n;
                int n2;
                int n3;
                int n4;
                9 this_ = DBUtil.query((RoomDatabase)this_.NotificationDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                try {
                    n4 = CursorUtil.getColumnIndexOrThrow((Cursor)this_, (String)"id");
                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)this_, (String)"title");
                    n2 = CursorUtil.getColumnIndexOrThrow((Cursor)this_, (String)"description");
                    n = CursorUtil.getColumnIndexOrThrow((Cursor)this_, (String)"_type");
                }
                catch (Throwable throwable) {
                    this_.close();
                    throw throwable;
                }
                ArrayList<Notification> arrayList2 = arrayList;
                arrayList = new ArrayList<Notification>(this_.getCount());
                while (this_.moveToNext()) {
                    long l = this_.getLong(n4);
                    String string2 = this_.getString(n3);
                    String string3 = this_.getString(n2);
                    String string4 = this_.getString(n);
                    arrayList2.add(new Notification(l, string2, string3, string4));
                }
                this_.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }
}

