/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.basketball.scores;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventScore;
import io.streamlayer.utils.ExtensionsKt;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/statistics/basketball/scores/BasketballGameScoresAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "()V", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "BasketballGameScoreViewHolder", "Companion", "sdk_release"})
public final class BasketballGameScoresAdapter
extends GenericAdapter<EventScheduleData> {
    private static final SimpleDateFormat scheduleFormat;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        scheduleFormat = new SimpleDateFormat("E, M/d\nh:mm aa", Locale.ENGLISH);
    }

    protected int getLayoutId(int n) {
        return R.layout.sl_item_basketball_event_score;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<EventScheduleData> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new BasketballGameScoreViewHolder(view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/basketball/scores/BasketballGameScoresAdapter$BasketballGameScoreViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "bind", "", "data", "sdk_release"})
    private static final class BasketballGameScoreViewHolder
    extends GenericAdapter.GenericViewHolder<EventScheduleData> {
        public BasketballGameScoreViewHolder(@NotNull View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"itemView");
            super(view2);
        }

        public void bind(@NotNull EventScheduleData object) {
            EventScheduleData eventScheduleData = object;
            Intrinsics.checkParameterIsNotNull((Object)eventScheduleData, (String)"data");
            EventSummary eventSummary = eventScheduleData.getAttributes().getSummary();
            BasketballGameScoreViewHolder basketballGameScoreViewHolder = object2;
            BasketballGameScoreViewHolder basketballGameScoreViewHolder2 = object2;
            Object object2 = eventSummary.getHomeTeam();
            View view = basketballGameScoreViewHolder2.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            TextView textView = (TextView)view.findViewById(R.id.slBasketballScoreHomeNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"itemView.slBasketballScoreHomeNameTV");
            textView.setText((CharSequence)((EventTeam)object2).getName());
            View view2 = basketballGameScoreViewHolder2.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
            ImageView imageView = (ImageView)view2.findViewById(R.id.slBasketballScoreHomeLogoIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slBasketballScoreHomeLogoIV");
            io.streamlayer.common.kotlin.ExtensionsKt.loadUrl$default(imageView, ((EventTeam)object2).getLogo(), false, null, null, 14, null);
            object2 = eventSummary.getAwayTeam();
            View view3 = basketballGameScoreViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
            TextView textView2 = (TextView)view3.findViewById(R.id.slBasketballScoreAwayNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"itemView.slBasketballScoreAwayNameTV");
            textView2.setText((CharSequence)((EventTeam)object2).getName());
            View view4 = basketballGameScoreViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
            ImageView imageView2 = (ImageView)view4.findViewById(R.id.slBasketballScoreAwayLogoIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"itemView.slBasketballScoreAwayLogoIV");
            io.streamlayer.common.kotlin.ExtensionsKt.loadUrl$default(imageView2, ((EventTeam)object2).getLogo(), false, null, null, 14, null);
            Object object3 = object2 = basketballGameScoreViewHolder.itemView;
            TextView textView3 = (TextView)object3.findViewById(R.id.slBasketballScoreHomeNumTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"slBasketballScoreHomeNumTV");
            textView3.setText((CharSequence)String.valueOf(eventSummary.getHomeScore()));
            TextView textView4 = (TextView)object3.findViewById(R.id.slBasketballScoreAwayNumTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"slBasketballScoreAwayNumTV");
            textView4.setText((CharSequence)String.valueOf(eventSummary.getAwayScore()));
            Object object4 = eventSummary.getEventTime();
            TextView textView5 = (TextView)object2.findViewById(R.id.slBasketballScoreScheduleTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView5, (String)"slBasketballScoreScheduleTV");
            Object[] objectArray = new Object[]{((EventTime)object4).getClock(), ExtensionsKt.toOrdinalString(((EventTime)object4).getPeriod())};
            String string2 = String.format("%s - %s", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            textView5.setText((CharSequence)string2);
            TextView textView6 = (TextView)object2.findViewById(R.id.slBasketballScoreFinalTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView6, (String)"slBasketballScoreFinalTV");
            io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView6);
            TextView textView7 = (TextView)object2.findViewById(R.id.slBasketballScoreScheduleClientNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView7, (String)"slBasketballScoreScheduleClientNameTV");
            io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView7);
            if (eventSummary.getStatus() == EventStatus.Postgame) {
                Object object5 = object2;
                TextView textView8 = (TextView)object5.findViewById(R.id.slBasketballScoreScheduleTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView8, (String)"slBasketballScoreScheduleTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView8);
                object = (ImageView)object5.findViewById(R.id.slBasketballScoreHomeWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"slBasketballScoreHomeWonIV");
                boolean bl = eventSummary.getHomeScore() > eventSummary.getAwayScore();
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIfElse((View)object, bl, 4);
                object = (ImageView)object2.findViewById(R.id.slBasketballScoreAwayWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"slBasketballScoreAwayWonIV");
                boolean bl2 = eventSummary.getHomeScore() < eventSummary.getAwayScore();
                Object object6 = object2;
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIfElse((View)object, bl2, 4);
                TextView textView9 = (TextView)object6.findViewById(R.id.slBasketballScoreFinalTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView9, (String)"slBasketballScoreFinalTV");
                io.streamlayer.common.kotlin.ExtensionsKt.visible((View)textView9);
                TextView textView10 = (TextView)object6.findViewById(R.id.slBasketballScoreWatchBtnTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView10, (String)"slBasketballScoreWatchBtnTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView10);
                TextView textView11 = (TextView)object6.findViewById(R.id.slBasketballScoreLiveIndicatorTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView11, (String)"slBasketballScoreLiveIndicatorTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView11);
            } else if (eventSummary.getStatus() == EventStatus.Pregame) {
                object4 = ((EventScheduleData)object).getAttributes().getBasketballScore();
                if (object4 == null || (object4 = ((BasketballEventScore)object4).getHomeTeamRecord()) == null) {
                    TeamRecord teamRecord;
                    object4 = teamRecord;
                    teamRecord = new TeamRecord(0, 0);
                }
                object = ((EventScheduleData)object).getAttributes().getBasketballScore();
                if (object == null || (object = ((BasketballEventScore)object).getAwayTeamRecord()) == null) {
                    TeamRecord teamRecord;
                    object = teamRecord;
                    teamRecord = new TeamRecord(0, 0);
                }
                Object object7 = object2;
                TextView textView12 = (TextView)object7.findViewById(R.id.slBasketballScoreHomeNumTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView12, (String)"slBasketballScoreHomeNumTV");
                Object[] objectArray2 = new Object[]{((TeamRecord)object4).getWins(), ((TeamRecord)object4).getLosses()};
                String string3 = String.format("%d - %d", Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                textView12.setText((CharSequence)string3);
                TextView textView13 = (TextView)object7.findViewById(R.id.slBasketballScoreAwayNumTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView13, (String)"slBasketballScoreAwayNumTV");
                Object[] objectArray3 = new Object[]{((TeamRecord)object).getWins(), ((TeamRecord)object).getLosses()};
                String string4 = String.format("%d - %d", Arrays.copyOf(objectArray3, objectArray3.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(this, *args)");
                textView13.setText((CharSequence)string4);
                TextView textView14 = (TextView)object7.findViewById(R.id.slBasketballScoreScheduleTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView14, (String)"slBasketballScoreScheduleTV");
                textView14.setText((CharSequence)scheduleFormat.format(eventSummary.getScheduleDate()));
                ImageView imageView3 = (ImageView)object7.findViewById(R.id.slBasketballScoreHomeWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView3, (String)"slBasketballScoreHomeWonIV");
                io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)imageView3);
                ImageView imageView4 = (ImageView)object7.findViewById(R.id.slBasketballScoreAwayWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView4, (String)"slBasketballScoreAwayWonIV");
                io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)imageView4);
                TextView textView15 = (TextView)object7.findViewById(R.id.slBasketballScoreWatchBtnTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView15, (String)"slBasketballScoreWatchBtnTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView15);
                TextView textView16 = (TextView)object7.findViewById(R.id.slBasketballScoreLiveIndicatorTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView16, (String)"slBasketballScoreLiveIndicatorTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView16);
            } else {
                Object object8 = object2;
                ImageView imageView5 = (ImageView)object8.findViewById(R.id.slBasketballScoreHomeWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView5, (String)"slBasketballScoreHomeWonIV");
                io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)imageView5);
                ImageView imageView6 = (ImageView)object8.findViewById(R.id.slBasketballScoreAwayWonIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView6, (String)"slBasketballScoreAwayWonIV");
                io.streamlayer.common.kotlin.ExtensionsKt.invisible((View)imageView6);
                TextView textView17 = (TextView)object8.findViewById(R.id.slBasketballScoreScheduleClientNameTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView17, (String)"slBasketballScoreScheduleClientNameTV");
                textView17.setText((CharSequence)"ESPN");
                TextView textView18 = (TextView)object8.findViewById(R.id.slBasketballScoreScheduleClientNameTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView18, (String)"slBasketballScoreScheduleClientNameTV");
                io.streamlayer.common.kotlin.ExtensionsKt.visible((View)textView18);
                TextView textView19 = (TextView)object8.findViewById(R.id.slBasketballScoreWatchBtnTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView19, (String)"slBasketballScoreWatchBtnTV");
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)textView19, Random.Default.nextBoolean());
                TextView textView20 = (TextView)object8.findViewById(R.id.slBasketballScoreLiveIndicatorTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView20, (String)"slBasketballScoreLiveIndicatorTV");
                io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)textView20, Random.Default.nextBoolean());
                TextView textView21 = (TextView)object8.findViewById(R.id.slBasketballScoreScheduleClientFavouritePointSpreadTV);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView21, (String)"slBasketballScoreSchedul\u2026entFavouritePointSpreadTV");
                io.streamlayer.common.kotlin.ExtensionsKt.gone((View)textView21);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/statistics/basketball/scores/BasketballGameScoresAdapter$Companion;", "", "()V", "scheduleFormat", "Ljava/text/SimpleDateFormat;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

