/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.RecyclerView;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.CardStackListener;
import com.yuyakaido.android.cardstackview.CardStackView;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.Duration;
import com.yuyakaido.android.cardstackview.StackFrom;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.views.NotificationsView;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.notifications.NotificationsAdapter;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0010\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/streamlayer/common/views/NotificationsView;", "Lcom/yuyakaido/android/cardstackview/CardStackView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "listener", "Lio/streamlayer/common/views/NotificationsView$NotificationsInteractionListener;", "getListener", "()Lio/streamlayer/common/views/NotificationsView$NotificationsInteractionListener;", "setListener", "(Lio/streamlayer/common/views/NotificationsView$NotificationsInteractionListener;)V", "notificationStackListener", "io/streamlayer/common/views/NotificationsView$notificationStackListener$1", "Lio/streamlayer/common/views/NotificationsView$notificationStackListener$1;", "notificationsAdapter", "Lio/streamlayer/sdk/notifications/NotificationsAdapter;", "touchDragging", "", "onTouchEvent", "motionEvent", "Landroid/view/MotionEvent;", "setNotifications", "", "notifications", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "NotificationsInteractionListener", "sdk_release"})
public final class NotificationsView
extends CardStackView {
    @Nullable
    private NotificationsInteractionListener listener;
    private boolean touchDragging;
    private final NotificationsAdapter notificationsAdapter;
    private final notificationStackListener.1 notificationStackListener;
    private HashMap _$_findViewCache;

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        NotificationsView notificationsView = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributeSet, n);
        notificationsView.notificationsAdapter = new NotificationsAdapter();
        notificationsView.notificationStackListener = new CardStackListener(this){
            final /* synthetic */ NotificationsView this$0;
            {
                this.this$0 = notificationsView;
            }

            public void onCardDisappeared(@Nullable View view, int n) {
            }

            public void onCardDragging(@Nullable Direction direction, float f) {
                if (direction == Direction.Bottom) {
                    this.this$0.animate().translationY((float)this.this$0.getHeight() * f).start();
                }
            }

            public void onCardSwiped(@Nullable Direction object) {
                if (object == Direction.Bottom) {
                    object = this.this$0.getListener();
                    if (object != null) {
                        object.onAllNotificationsDismissed();
                    }
                } else if (object == Direction.Top && (object = this.this$0.getListener()) != null) {
                    object.onNotificationDismissed((Notification)NotificationsView.access$getNotificationsAdapter$p(this.this$0).getItem(0));
                }
                this.this$0.animate().translationY(0.0f).start();
            }

            public void onCardCanceled() {
                this.this$0.animate().translationY(0.0f).start();
            }

            public void onCardAppeared(@Nullable View view, int n) {
            }

            public void onCardRewound() {
            }
        };
        notificationsView.setPadding(notificationsView.getResources().getDimensionPixelSize(R.dimen.activity_horizontal_margin_small), this.getResources().getDimensionPixelSize(R.dimen.activity_vertical_margin), this.getResources().getDimensionPixelSize(R.dimen.activity_horizontal_margin_small), this.getResources().getDimensionPixelSize(R.dimen.activity_vertical_margin));
        notificationsView.setAdapter((RecyclerView.Adapter)notificationsView.notificationsAdapter);
        attributeSet = new SwipeAnimationSetting.Builder().setDirection(Direction.Right).setDuration(Duration.Normal.duration).setInterpolator((Interpolator)new AccelerateInterpolator()).build();
        CardStackLayoutManager cardStackLayoutManager = new CardStackLayoutManager(context, (CardStackListener)this.notificationStackListener);
        cardStackLayoutManager.setCanScrollHorizontal(false);
        cardStackLayoutManager.setStackFrom(StackFrom.Bottom);
        cardStackLayoutManager.setDirections(Direction.VERTICAL);
        cardStackLayoutManager.setTranslationInterval(4.0f);
        cardStackLayoutManager.setScaleInterval(0.98f);
        cardStackLayoutManager.setSwipeThreshold(0.05f);
        cardStackLayoutManager.setSwipeAnimationSetting((SwipeAnimationSetting)attributeSet);
        notificationsView.setLayoutManager((RecyclerView.LayoutManager)cardStackLayoutManager);
    }

    public /* synthetic */ NotificationsView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public NotificationsView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ NotificationsAdapter access$getNotificationsAdapter$p(NotificationsView notificationsView) {
        return notificationsView.notificationsAdapter;
    }

    @Nullable
    public final NotificationsInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable NotificationsInteractionListener notificationsInteractionListener) {
        this.listener = notificationsInteractionListener;
    }

    public boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        if (!(motionEvent.getY() > (float)(this.getHeight() - ExtensionsKt.getDp(80.0f))) && !this.touchDragging) {
            return false;
        }
        super.onTouchEvent(motionEvent);
        if (motionEvent.getActionMasked() != 0 && motionEvent.getActionMasked() != 2) {
            if (motionEvent.getActionMasked() == 1) {
                this.touchDragging = false;
            }
        } else {
            this.touchDragging = true;
        }
        return true;
    }

    public final void setNotifications(@NotNull List<Notification> list) {
        NotificationsView notificationsView = this;
        Intrinsics.checkParameterIsNotNull(list, (String)"notifications");
        notificationsView.notificationsAdapter.setItems(list);
        notificationsView.animate().translationY((float)(3 - RangesKt.coerceAtMost((int)list.size(), (int)3)) * (float)ExtensionsKt.getDp(4.0f)).start();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            NotificationsView notificationsView = this;
            view = notificationsView.findViewById(n);
            notificationsView._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((NotificationsView)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/views/NotificationsView$NotificationsInteractionListener;", "", "onAllNotificationsDismissed", "", "onNotificationActionClick", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "onNotificationClick", "onNotificationDismissed", "sdk_release"})
    public static interface NotificationsInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationActionClick(@NotNull Notification var1);

        public void onNotificationDismissed(@NotNull Notification var1);

        public void onAllNotificationsDismissed();
    }
}

