/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.demo.weather.repository.weather;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.demo.weather.model.Forecast;
import io.streamlayer.demo.weather.model.Main;
import io.streamlayer.demo.weather.model.Weather;
import io.streamlayer.demo.weather.model.WeatherConverter;
import io.streamlayer.demo.weather.model.WeatherResponse;
import io.streamlayer.demo.weather.repository.weather.WeatherDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class WeatherDao_Impl
implements WeatherDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WeatherResponse> __insertionAdapterOfWeatherResponse;
    private final WeatherConverter __weatherConverter;
    private final EntityInsertionAdapter<Forecast> __insertionAdapterOfForecast;
    private final SharedSQLiteStatement __preparedStmtOfClearForecastTable;

    public WeatherDao_Impl(RoomDatabase roomDatabase) {
        WeatherDao_Impl weatherDao_Impl = this;
        this.__weatherConverter = new WeatherConverter();
        weatherDao_Impl.__db = roomDatabase;
        weatherDao_Impl.__insertionAdapterOfWeatherResponse = new EntityInsertionAdapter<WeatherResponse>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WeatherResponse` (`id`,`weather`,`name`,`date`,`temp`,`minTemp`,`maxTemp`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, WeatherResponse weatherResponse) {
                long l = weatherResponse.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.WeatherDao_Impl.this.__weatherConverter.fromWeatherList(weatherResponse.getWeather());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                if (weatherResponse.getName() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, weatherResponse.getName());
                }
                l = weatherResponse.getDate();
                supportSQLiteStatement.bindLong(4, l);
                object = weatherResponse.getMain();
                if (object != null) {
                    double d = ((Main)object).getTemp();
                    supportSQLiteStatement.bindDouble(5, d);
                    d = ((Main)object).getMinTemp();
                    supportSQLiteStatement.bindDouble(6, d);
                    d = ((Main)object).getMaxTemp();
                    supportSQLiteStatement.bindDouble(7, d);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(5);
                    supportSQLiteStatement2.bindNull(6);
                    supportSQLiteStatement2.bindNull(7);
                }
            }
        };
        weatherDao_Impl.__insertionAdapterOfForecast = new EntityInsertionAdapter<Forecast>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Forecast` (`weather`,`date`,`name`,`temp`,`minTemp`,`maxTemp`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Forecast forecast) {
                Object object = object.WeatherDao_Impl.this.__weatherConverter.fromWeatherList(forecast.getWeather());
                if (object == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, (String)object);
                }
                if (forecast.getDate() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, forecast.getDate());
                }
                if (forecast.getName() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, forecast.getName());
                }
                object = forecast.getMain();
                if (object != null) {
                    double d = ((Main)object).getTemp();
                    supportSQLiteStatement.bindDouble(4, d);
                    d = ((Main)object).getMinTemp();
                    supportSQLiteStatement.bindDouble(5, d);
                    d = ((Main)object).getMaxTemp();
                    supportSQLiteStatement.bindDouble(6, d);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(4);
                    supportSQLiteStatement2.bindNull(5);
                    supportSQLiteStatement2.bindNull(6);
                }
            }
        };
        weatherDao_Impl.__preparedStmtOfClearForecastTable = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Forecast";
            }
        };
    }

    @Override
    public void saveWeatherData(WeatherResponse weatherResponse) {
        WeatherDao_Impl weatherDao_Impl = this;
        weatherDao_Impl.__db.assertNotSuspendingTransaction();
        weatherDao_Impl.__db.beginTransaction();
        try {
            weatherDao_Impl.__insertionAdapterOfWeatherResponse.insert((Object)weatherResponse);
            weatherDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        weatherDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveForecastData(List<Forecast> list) {
        WeatherDao_Impl weatherDao_Impl = this;
        weatherDao_Impl.__db.assertNotSuspendingTransaction();
        weatherDao_Impl.__db.beginTransaction();
        try {
            weatherDao_Impl.__insertionAdapterOfForecast.insert(list);
            weatherDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        weatherDao_Impl.__db.endTransaction();
    }

    @Override
    public void clearForecastTable() {
        WeatherDao_Impl weatherDao_Impl = this;
        weatherDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = weatherDao_Impl.__preparedStmtOfClearForecastTable.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            WeatherDao_Impl weatherDao_Impl2 = this;
            weatherDao_Impl2.__db.endTransaction();
            weatherDao_Impl2.__preparedStmtOfClearForecastTable.release(supportSQLiteStatement);
            throw throwable;
        }
        weatherDao_Impl.__db.setTransactionSuccessful();
        weatherDao_Impl.__db.endTransaction();
        weatherDao_Impl.__preparedStmtOfClearForecastTable.release(supportSQLiteStatement);
    }

    @Override
    public Observable<WeatherResponse> getWeatherData(String stringArray) {
        Callable<WeatherResponse> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM WeatherResponse WHERE name = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "WeatherResponse";
        Callable<WeatherResponse> callable2 = callable;
        callable = new Callable<WeatherResponse>(){

            @Override
            public WeatherResponse call() throws Exception {
                WeatherResponse weatherResponse;
                Cursor cursor;
                block26: {
                    block23: {
                        WeatherResponse weatherResponse2;
                        Main main;
                        long l;
                        String string2;
                        Object object;
                        int n;
                        block25: {
                            Main main2;
                            int n2;
                            int n3;
                            int n4;
                            block24: {
                                Main main3;
                                int n5;
                                cursor = DBUtil.query((RoomDatabase)WeatherDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                try {
                                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    throw throwable;
                                }
                                int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"weather");
                                int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                                int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"date");
                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"temp");
                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"minTemp");
                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"maxTemp");
                                if (!cursor.moveToFirst()) break block23;
                                Cursor cursor2 = cursor;
                                int n9 = n4;
                                Cursor cursor3 = cursor;
                                int n10 = n8;
                                Cursor cursor4 = cursor;
                                int n11 = n7;
                                4 v7 = this;
                                Cursor cursor5 = cursor;
                                int n12 = n6;
                                n = cursor.getInt(n5);
                                object = cursor5.getString(n12);
                                object = v7.WeatherDao_Impl.this.__weatherConverter.toWeatherList((String)object);
                                string2 = cursor4.getString(n11);
                                l = cursor3.getLong(n10);
                                if (!cursor2.isNull(n9)) break block24;
                                if (!cursor.isNull(n3)) break block24;
                                if (!cursor.isNull(n2)) break block24;
                                main = main3 = null;
                                break block25;
                            }
                            Cursor cursor6 = cursor;
                            int n13 = n2;
                            Cursor cursor7 = cursor;
                            int n14 = n3;
                            double d = cursor.getDouble(n4);
                            double d2 = cursor7.getDouble(n14);
                            double d3 = cursor6.getDouble(n13);
                            main = main2;
                            main2 = new Main(d, d2, d3);
                        }
                        weatherResponse = weatherResponse2;
                        weatherResponse2 = new WeatherResponse(n, (List<Weather>)object, main, string2, l);
                        break block26;
                    }
                    weatherResponse = null;
                }
                cursor.close();
                return weatherResponse;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Observable<List<Forecast>> getForecastData(String stringArray) {
        Callable<List<Forecast>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Forecast WHERE name = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "Forecast";
        Callable<List<Forecast>> callable2 = callable;
        callable = new Callable<List<Forecast>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<Forecast> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)WeatherDao_Impl.access$100(WeatherDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"weather");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"temp");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"minTemp");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"maxTemp");
                var8_8 = v0;
                try {
                    v0 = new ArrayList<Forecast>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block22: {
                        v2 = var1_1;
                        v3 = var5_5;
                        v4 = var1_1;
                        v5 = var4_4;
                        v6 = var1_1;
                        v7 = var3_3;
                        v8 = this;
                        var9_9 = var1_1.getString(var2_2);
                        var9_9 = WeatherDao_Impl.access$000(v8.WeatherDao_Impl.this).toWeatherList((String)var9_9);
                        var10_10 = v6.getString(v7);
                        var11_11 = v4.getString(v5);
                        if (!v2.isNull(v3)) break block22;
                        if (!var1_1.isNull(var6_6)) break block22;
                        if (!var1_1.isNull(var7_7)) break block22;
                        var18_16 = var12_12 = null;
                        ** GOTO lbl58
                    }
                    v9 = var1_1;
                    v10 = var7_7;
                    v11 = var1_1;
                    v12 = var6_6;
                    var12_13 = var1_1.getDouble(var5_5);
                    var14_14 = v11.getDouble(v12);
                    var16_15 = v9.getDouble(v10);
                    var18_16 = v13;
                    v13 = new Main(var12_13, var14_14, var16_15);
lbl58:
                    // 2 sources

                    var8_8.add(new Forecast(var18_16, (List<Weather>)var9_9, var10_10, var11_11));
                    continue;
                }
lbl61:
                // 1 sources

                var1_1.close();
                return var8_8;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }
}

