/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.Standings;
import io.streamlayer.sdk.model.sports.baseball.BaseballPlayByPlay;
import io.streamlayer.sdk.model.sports.baseball.BaseballSummary;
import io.streamlayer.sdk.repository.sports.baseball.BaseballRepo;
import io.streamlayer.sdk.repository.sports.events.SportEventsRepo;
import io.streamlayer.sdk.statistics.baseball.BaseballStatisticsViewModel;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u00020\u001bJ\u0018\u00107\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u00020\u001bH\u0002J\u000e\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u0015J\u0010\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020!H\u0002J\u0010\u0010=\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010>\u001a\u0002042\u0006\u0010?\u001a\u000206H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00120\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010 \u001a\u0004\u0018\u00010!@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b#\u0010$R\u001d\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R#\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010(R#\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00120\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\r0&\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010(\u00a8\u0006@"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballStatisticsViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "baseballRepo", "Lio/streamlayer/sdk/repository/sports/baseball/BaseballRepo;", "eventsRepo", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "(Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/sports/baseball/BaseballRepo;Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;)V", "_eventSummary", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "_playByPlay", "Lio/streamlayer/sdk/model/sports/baseball/BaseballPlayByPlay;", "_schedule", "", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "_scheduleDays", "Ljava/util/Date;", "_scoringSummary", "Lio/streamlayer/sdk/model/sports/baseball/BaseballSummary;", "_standings", "Lio/streamlayer/sdk/model/sports/Standings;", "baseballBoxScoreHomeSelected", "", "getBaseballBoxScoreHomeSelected", "()Z", "setBaseballBoxScoreHomeSelected", "(Z)V", "value", "", "eventLeague", "setEventLeague", "(Ljava/lang/String;)V", "eventSummary", "Landroidx/lifecycle/LiveData;", "getEventSummary", "()Landroidx/lifecycle/LiveData;", "playByPlay", "getPlayByPlay", "schedule", "getSchedule", "scheduleDays", "getScheduleDays", "scoringSummary", "getScoringSummary", "standings", "getStandings", "fetchEventSummary", "", "eventId", "", "fetchPlayByPlay", "scoringOnly", "fetchSchedule", "date", "fetchScheduleDays", "league", "fetchScoringSummary", "fetchStandings", "id", "sdk_release"})
public final class BaseballStatisticsViewModel
extends BaseViewModel {
    private String eventLeague;
    private final MutableLiveData<ResourceState<EventSummaryResponseData>> _eventSummary;
    @NotNull
    private final LiveData<ResourceState<EventSummaryResponseData>> eventSummary;
    private final MutableLiveData<ResourceState<Standings>> _standings;
    @NotNull
    private final LiveData<ResourceState<Standings>> standings;
    private final MutableLiveData<ResourceState<List<EventScheduleData>>> _schedule;
    @NotNull
    private final LiveData<ResourceState<List<EventScheduleData>>> schedule;
    private final MutableLiveData<ResourceState<List<Date>>> _scheduleDays;
    @NotNull
    private final LiveData<ResourceState<List<Date>>> scheduleDays;
    private final MutableLiveData<ResourceState<BaseballPlayByPlay>> _playByPlay;
    @NotNull
    private final LiveData<ResourceState<BaseballPlayByPlay>> playByPlay;
    private final MutableLiveData<ResourceState<BaseballSummary>> _scoringSummary;
    @NotNull
    private final LiveData<ResourceState<BaseballSummary>> scoringSummary;
    private boolean baseballBoxScoreHomeSelected;
    private final SchedulerProvider schedulers;
    private final SessionPrefImpl session;
    private final BaseballRepo baseballRepo;
    private final SportEventsRepo eventsRepo;

    private final void setEventLeague(String string2) {
        if (Intrinsics.areEqual((Object)this.eventLeague, (Object)string2) ^ true) {
            this.eventLeague = string2;
            if (string2 != null) {
                this.fetchScheduleDays(string2);
            }
        }
    }

    private final void fetchStandings(long l) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._standings, (Function0)new Function0<Observable<ResourceState<? extends Standings>>>(this, l){
            final /* synthetic */ BaseballStatisticsViewModel this$0;
            final /* synthetic */ long $id;
            {
                this.this$0 = baseballStatisticsViewModel;
                this.$id = l;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<Standings>> invoke() {
                return BaseballStatisticsViewModel.access$getBaseballRepo$p(this.this$0).getBaseballStandings(this.$id);
            }
        }, null, null, null, 28, null);
    }

    private final void fetchScheduleDays(String string2) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._scheduleDays, (Function0)new Function0<Observable<ResourceState<? extends List<? extends Date>>>>(this, string2){
            final /* synthetic */ BaseballStatisticsViewModel this$0;
            final /* synthetic */ String $league;
            {
                this.this$0 = baseballStatisticsViewModel;
                this.$league = string2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<List<Date>>> invoke() {
                return BaseballStatisticsViewModel.access$getEventsRepo$p(this.this$0).getScheduleDates(this.$league);
            }
        }, null, null, null, 28, null);
    }

    private final void fetchPlayByPlay(long l, boolean bl) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._playByPlay, (Function0)new Function0<Observable<ResourceState<? extends BaseballPlayByPlay>>>(this, l, bl){
            final /* synthetic */ BaseballStatisticsViewModel this$0;
            final /* synthetic */ long $eventId;
            final /* synthetic */ boolean $scoringOnly;
            {
                this.this$0 = baseballStatisticsViewModel;
                this.$eventId = l;
                this.$scoringOnly = bl;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<BaseballPlayByPlay>> invoke() {
                return BaseballStatisticsViewModel.access$getBaseballRepo$p(this.this$0).getBaseballPlayByPlay(this.$eventId, this.$scoringOnly);
            }
        }, null, null, null, 28, null);
    }

    private final void fetchEventSummary(long l) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._eventSummary, (Function0)new Function0<Observable<ResourceState<? extends EventSummaryResponseData>>>(this, l){
            final /* synthetic */ BaseballStatisticsViewModel this$0;
            final /* synthetic */ long $eventId;
            {
                this.this$0 = baseballStatisticsViewModel;
                this.$eventId = l;
                super(0);
            }

            public final Observable<ResourceState<EventSummaryResponseData>> invoke() {
                Observable observable = BaseballStatisticsViewModel.access$getEventsRepo$p(this.this$0).getEventSummaryResponseData(this.$eventId).observeOn(BaseballStatisticsViewModel.access$getSchedulers$p(this.this$0).ui()).doOnNext(new Consumer<ResourceState<? extends EventSummaryResponseData>>(this){
                    final /* synthetic */ fetchEventSummary.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<EventSummaryResponseData> resourceState) {
                        if (resourceState.getStatus() == Status.SUCCESS && resourceState.getData() != null) {
                            BaseballStatisticsViewModel.access$setEventLeague$p(this.this$0.this$0, resourceState.getData().getEventSummary().getLeague());
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"eventsRepo.getEventSumma\u2026      }\n                }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    private final void fetchScoringSummary(long l) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._scoringSummary, (Function0)new Function0<Observable<ResourceState<? extends BaseballSummary>>>(this, l){
            final /* synthetic */ BaseballStatisticsViewModel this$0;
            final /* synthetic */ long $eventId;
            {
                this.this$0 = baseballStatisticsViewModel;
                this.$eventId = l;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<BaseballSummary>> invoke() {
                return BaseballStatisticsViewModel.access$getBaseballRepo$p(this.this$0).getBaseballSummary(this.$eventId);
            }
        }, null, null, null, 28, null);
    }

    @Inject
    public BaseballStatisticsViewModel(@NotNull SchedulerProvider schedulerProvider, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull BaseballRepo baseballRepo, @NotNull SportEventsRepo sportEventsRepo) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)baseballRepo, (String)"baseballRepo");
        Intrinsics.checkParameterIsNotNull((Object)sportEventsRepo, (String)"eventsRepo");
        super(schedulerProvider);
        this.schedulers = schedulerProvider;
        this.session = sessionPrefImpl;
        this.baseballRepo = baseballRepo;
        baseballStatisticsViewModel.eventsRepo = sportEventsRepo;
        baseballStatisticsViewModel._eventSummary = new MutableLiveData();
        LiveData liveData = Transformations.distinctUntilChanged(baseballStatisticsViewModel._eventSummary);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        baseballStatisticsViewModel.eventSummary = liveData;
        baseballStatisticsViewModel._standings = new MutableLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged(baseballStatisticsViewModel._standings);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        baseballStatisticsViewModel.standings = liveData2;
        baseballStatisticsViewModel._schedule = new MutableLiveData();
        LiveData liveData3 = Transformations.distinctUntilChanged(baseballStatisticsViewModel._schedule);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData3, (String)"Transformations.distinctUntilChanged(this)");
        baseballStatisticsViewModel.schedule = liveData3;
        baseballStatisticsViewModel._scheduleDays = new MutableLiveData();
        LiveData liveData4 = Transformations.distinctUntilChanged(baseballStatisticsViewModel._scheduleDays);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData4, (String)"Transformations.distinctUntilChanged(this)");
        baseballStatisticsViewModel.scheduleDays = liveData4;
        baseballStatisticsViewModel._playByPlay = new MutableLiveData();
        LiveData liveData5 = Transformations.distinctUntilChanged(baseballStatisticsViewModel._playByPlay);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData5, (String)"Transformations.distinctUntilChanged(this)");
        baseballStatisticsViewModel.playByPlay = liveData5;
        baseballStatisticsViewModel._scoringSummary = new MutableLiveData();
        baseballStatisticsViewModel.scoringSummary = baseballStatisticsViewModel._scoringSummary;
        baseballStatisticsViewModel.baseballBoxScoreHomeSelected = true;
        long l = Long.parseLong(baseballStatisticsViewModel.session.getCurrentEventId());
        this.fetchEventSummary(l);
        this.fetchStandings(l);
        this.fetchPlayByPlay(l, false);
        baseballStatisticsViewModel.fetchScoringSummary(l);
    }

    public static final /* synthetic */ BaseballRepo access$getBaseballRepo$p(BaseballStatisticsViewModel baseballStatisticsViewModel) {
        return baseballStatisticsViewModel.baseballRepo;
    }

    public static final /* synthetic */ SportEventsRepo access$getEventsRepo$p(BaseballStatisticsViewModel baseballStatisticsViewModel) {
        return baseballStatisticsViewModel.eventsRepo;
    }

    public static final /* synthetic */ SchedulerProvider access$getSchedulers$p(BaseballStatisticsViewModel baseballStatisticsViewModel) {
        return baseballStatisticsViewModel.schedulers;
    }

    public static final /* synthetic */ String access$getEventLeague$p(BaseballStatisticsViewModel baseballStatisticsViewModel) {
        return baseballStatisticsViewModel.eventLeague;
    }

    public static final /* synthetic */ void access$setEventLeague$p(BaseballStatisticsViewModel baseballStatisticsViewModel, String string2) {
        baseballStatisticsViewModel.setEventLeague(string2);
    }

    @NotNull
    public final LiveData<ResourceState<EventSummaryResponseData>> getEventSummary() {
        return this.eventSummary;
    }

    @NotNull
    public final LiveData<ResourceState<Standings>> getStandings() {
        return this.standings;
    }

    @NotNull
    public final LiveData<ResourceState<List<EventScheduleData>>> getSchedule() {
        return this.schedule;
    }

    @NotNull
    public final LiveData<ResourceState<List<Date>>> getScheduleDays() {
        return this.scheduleDays;
    }

    @NotNull
    public final LiveData<ResourceState<BaseballPlayByPlay>> getPlayByPlay() {
        return this.playByPlay;
    }

    @NotNull
    public final LiveData<ResourceState<BaseballSummary>> getScoringSummary() {
        return this.scoringSummary;
    }

    public final boolean getBaseballBoxScoreHomeSelected() {
        return this.baseballBoxScoreHomeSelected;
    }

    public final void setBaseballBoxScoreHomeSelected(boolean bl) {
        this.baseballBoxScoreHomeSelected = bl;
    }

    public final void fetchSchedule(@NotNull Date date2) {
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date");
        String string2 = this.eventLeague;
        if (string2 != null) {
            BaseballStatisticsViewModel baseballStatisticsViewModel = this;
            BaseViewModel.observableCall$default(baseballStatisticsViewModel, baseballStatisticsViewModel._schedule, (Function0)new Function0<Observable<ResourceState<? extends List<? extends EventScheduleData>>>>(string2, this, date2){
                final /* synthetic */ String $league;
                final /* synthetic */ BaseballStatisticsViewModel this$0;
                final /* synthetic */ Date $date$inlined;
                {
                    this.$league = string2;
                    this.this$0 = baseballStatisticsViewModel;
                    this.$date$inlined = date2;
                    super(0);
                }

                @NotNull
                public final Observable<ResourceState<List<EventScheduleData>>> invoke() {
                    return BaseballStatisticsViewModel.access$getEventsRepo$p(this.this$0).getEventSchedules(this.$date$inlined, this.$league, EventType.Baseball);
                }
            }, null, null, null, 28, null);
        }
    }

    public final void fetchPlayByPlay(boolean bl) {
        BaseballStatisticsViewModel baseballStatisticsViewModel = this;
        baseballStatisticsViewModel.fetchPlayByPlay(Long.parseLong(baseballStatisticsViewModel.session.getCurrentEventId()), bl);
    }
}

