/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import io.streamlayer.common.dagger.components.ActivityComponent;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.BaseView;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.DialogUtil;
import java.util.HashMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u00020\u00112\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001aH\u0016J&\u0010\u001f\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/streamlayer/common/mvvm/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lio/streamlayer/common/mvvm/BaseView;", "()V", "progressDialog", "Landroid/app/Dialog;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "getSession", "()Lio/streamlayer/common/session/SessionPrefImpl;", "setSession", "(Lio/streamlayer/common/session/SessionPrefImpl;)V", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "toolbarProgressCircle", "Landroid/widget/ProgressBar;", "hideKeyboard", "", "view", "Landroid/view/View;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLogout", "setContentView", "layoutResID", "", "showError", "stringResourceId", "errorMessage", "", "showInfoDialog", "titleResourceId", "descriptionResourceId", "buttonText", "title", "description", "showLoader", "show", "", "cancelable", "showProgressCircle", "showShortInfo", "info", "sdk_release"})
public abstract class BaseActivity
extends AppCompatActivity
implements BaseView {
    @Inject
    @NotNull
    public SessionPrefImpl session;
    private Dialog progressDialog;
    private Toolbar toolbar;
    private ProgressBar toolbarProgressCircle;
    private HashMap _$_findViewCache;

    @NotNull
    public final SessionPrefImpl getSession() {
        SessionPrefImpl sessionPrefImpl = ((BaseActivity)((Object)sessionPrefImpl)).session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        return sessionPrefImpl;
    }

    public final void setSession(@NotNull SessionPrefImpl sessionPrefImpl) {
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl;
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl2, (String)"<set-?>");
        this.session = sessionPrefImpl2;
    }

    protected void onCreate(@Nullable Bundle bundle) {
        ActivityComponent.Companion.inject$sdk_release(this);
        super.onCreate(bundle);
        BaseActivity baseActivity = this;
        this.progressDialog = DialogUtil.INSTANCE.buildLoaderDialog((Activity)baseActivity, baseActivity.getString(R.string.please_wait));
    }

    public void setContentView(@LayoutRes int n) {
        BaseActivity baseActivity = this;
        super.setContentView(n);
        baseActivity.toolbar = (Toolbar)baseActivity.findViewById(R.id.toolbar);
        baseActivity.toolbarProgressCircle = (ProgressBar)baseActivity.findViewById(R.id.toolbarProgressCircle);
    }

    @Override
    public void showError(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"errorMessage");
        this.showShortInfo(string3);
    }

    @Override
    public void showError(int n) {
        BaseActivity baseActivity = this;
        String string2 = baseActivity.getString(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        baseActivity.showError(string2);
    }

    @Override
    public void showShortInfo(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"info");
        Toast.makeText((Context)this, (CharSequence)string3, (int)0).show();
    }

    @Override
    public void showShortInfo(int n) {
        BaseActivity baseActivity = this;
        String string2 = baseActivity.getString(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        baseActivity.showShortInfo(string2);
    }

    @Override
    public void showProgressCircle(boolean bl) {
        ProgressBar progressBar = this.toolbarProgressCircle;
        if (progressBar != null) {
            ExtensionsKt.visibleIf((View)progressBar, bl);
        } else {
            this.showLoader(bl);
        }
    }

    @Override
    public void showLoader(boolean bl) {
        if (bl) {
            Dialog dialog = baseActivity.progressDialog;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressDialog");
            }
            dialog.show();
        } else {
            Dialog dialog = baseActivity.progressDialog;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressDialog");
            }
            dialog.dismiss();
        }
        if (!bl) {
            BaseActivity baseActivity = baseActivity.progressDialog;
            if (baseActivity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressDialog");
            }
            baseActivity.setCancelable(true);
        }
    }

    @Override
    public void showLoader(boolean bl, boolean bl2) {
        Dialog dialog = this.progressDialog;
        if (dialog == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressDialog");
        }
        dialog.setCancelable(bl2);
        this.showLoader(bl);
    }

    @Override
    public void hideKeyboard(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = object.getSystemService("input_method");
        if (object != null) {
            ((InputMethodManager)object).hideSoftInputFromWindow(view.getWindowToken(), 0);
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    @Override
    public void showInfoDialog(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        DialogUtil.buildInfoDialog$default(DialogUtil.INSTANCE, (Activity)this, string2, string3, string4, null, 16, null).show();
    }

    @Override
    public void showInfoDialog(@StringRes int n, @StringRes int n2, @StringRes int n3) {
        String string2 = n != 0 ? this.getString(n) : null;
        String string3 = n2 != 0 ? this.getString(n2) : null;
        String string4 = n3 != 0 ? this.getString(n3) : null;
        this.showInfoDialog(string2, string3, string4);
    }

    @Override
    public void onLogout() {
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            BaseActivity baseActivity = this;
            view = baseActivity.findViewById(n);
            baseActivity._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((BaseActivity)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }
}

