/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.notifications;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.notifications.NotificationsAdapter$NotificationViewHolder$WhenMappings;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/notifications/Notification;", "()V", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setItems", "", "listItems", "", "DiffCallback", "NotificationViewHolder", "sdk_release"})
public final class NotificationsAdapter
extends GenericAdapter<Notification> {
    public void setItems(@NotNull List<Notification> list) {
        List<Notification> list2 = list;
        Intrinsics.checkParameterIsNotNull(list2, (String)"listItems");
        super.setItems(list2);
    }

    protected int getLayoutId(int n) {
        return R.layout.sl_item_notification;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<Notification> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new NotificationViewHolder(this, view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter$NotificationViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "getColor", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getIcon", "sdk_release"})
    public final class NotificationViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        final /* synthetic */ NotificationsAdapter this$0;

        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: {
                    n = R.drawable.ic_chat;
                    break;
                }
                case 8: {
                    n = R.drawable.ic_twitter;
                    break;
                }
                case 7: {
                    n = R.drawable.ic_chat;
                    break;
                }
                case 6: {
                    n = R.drawable.ic_betting;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n = R.drawable.ic_call;
                    break;
                }
                case 1: {
                    n = R.drawable.ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 9: {
                    n = R.color.primaryBlue;
                    break;
                }
                case 8: {
                    n = R.color.slTwitter;
                    break;
                }
                case 7: {
                    n = R.color.primaryBlue;
                    break;
                }
                case 6: {
                    n = R.color.slOrange;
                    break;
                }
                case 4: 
                case 5: {
                    n = R.color.slRed;
                    break;
                }
                case 2: 
                case 3: {
                    n = R.color.slGreen;
                    break;
                }
                case 1: {
                    n = R.color.primaryBlue;
                }
            }
            return n;
        }

        public NotificationViewHolder(@NotNull NotificationsAdapter notificationsAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = notificationsAdapter;
            super(view);
            ((FrameLayout)view2.findViewById(R.id.slNotificationHolder)).setOnTouchListener((View.OnTouchListener)1.INSTANCE);
            view2.setOnTouchListener((View.OnTouchListener)2.INSTANCE);
        }

        public void bind(@NotNull Notification notification) {
            NotificationViewHolder notificationViewHolder = this;
            Intrinsics.checkParameterIsNotNull((Object)notification, (String)"data");
            View view = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            TextView textView = (TextView)view.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"itemView.slNotifTitleTV");
            textView.setText((CharSequence)notification.getTitle());
            View view2 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
            TextView textView2 = (TextView)view2.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"itemView.slNotifDescriptionTV");
            textView2.setText((CharSequence)notification.getDescription());
            View view3 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
            ((ImageView)view3.findViewById(R.id.slNotifIconIV)).setImageResource(this.getIcon(notification.getType()));
            View view4 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
            ImageView imageView = (ImageView)view4.findViewById(R.id.slNotifIconIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slNotifIconIV");
            View view5 = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView");
            imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)view5.getContext(), (int)this.getColor(notification.getType()))));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter$DiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "newList", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_release"})
    public static final class DiffCallback
    extends DiffUtil.Callback {
        private final List<Notification> oldList;
        private final List<Notification> newList;

        public DiffCallback(@NotNull List<Notification> list, @NotNull List<Notification> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldList");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newList");
            this.oldList = list;
            this.newList = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return this.oldList.get(n).getId() == this.newList.get(n2).getId();
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            Notification notification = ((DiffCallback)((Object)notification2)).oldList.get(n);
            Notification notification2 = ((DiffCallback)((Object)notification2)).newList.get(n2);
            return Intrinsics.areEqual((Object)notification.getTitle(), (Object)notification2.getTitle()) && Intrinsics.areEqual((Object)notification.getDescription(), (Object)notification2.getDescription()) && Intrinsics.areEqual((Object)notification.get_type(), (Object)notification2.get_type());
        }
    }
}

