/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<Chat> __insertionAdapterOfChat;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__converters = new Converters();
        messagingDao_Impl.__db = roomDatabase;
        messagingDao_Impl.__insertionAdapterOfChatMessage = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                String string2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, string2);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChatMessage_1 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                String string2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, string2);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChat = new EntityInsertionAdapter<Chat>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Chat` (`chatId`,`name`,`ownerId`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`descUpdatedAt`,`subUpdatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Chat chat) {
                if (chat.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chat.getChatId());
                }
                if (chat.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chat.getName());
                }
                if (chat.getOwnerId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chat.getOwnerId());
                }
                long l = chat.getSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = chat.getReadSeq();
                supportSQLiteStatement.bindLong(5, l);
                l = chat.getRecvSeq();
                supportSQLiteStatement.bindLong(6, l);
                String string2 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getUpdatedAt());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, string2);
                }
                string2 = object.MessagingDao_Impl.this.__converters.dateToString(chat.getDescUpdatedAt());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, string2);
                }
                Object object = object.MessagingDao_Impl.this.__converters.dateToString(chat.getSubUpdatedAt());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        messagingDao_Impl.__deletionAdapterOfChatMessage = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`chatMessageSeq` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                long l = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                long l2 = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(5, l2);
            }
        };
        messagingDao_Impl.__preparedStmtOfDeleteMessages = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        messagingDao_Impl.__preparedStmtOfDeleteChats = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Chat";
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> arrayMap) {
        String string2;
        ArrayMap<String, TinodeContact> arrayMap2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        RoomSQLiteQuery roomSQLiteQuery;
        block16: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap3;
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                int n9 = 0;
                int n10 = arrayMap.size();
                for (int j = 0; j < n10; ++j) {
                    ArrayMap arrayMap4;
                    set.put(arrayMap.keyAt(j), null);
                    if (++n9 != 999) continue;
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                    set = arrayMap4;
                    arrayMap4 = new ArrayMap(999);
                    n9 = 0;
                }
                if (n9 > 0) {
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)set);
                    arrayMap.putAll((Map)((Object)set));
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatUserId`,`chatToken`,`chatExpiration`,`chatName`,`online`,`lastFullSync`,`photoBase64` FROM `TinodeContact` WHERE `chatUserId` IN (");
            int n11 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n11);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n11 + 0));
            n8 = 1;
            for (String string3 : set) {
                if (string3 == null) {
                    roomSQLiteQuery.bindNull(n8);
                } else {
                    roomSQLiteQuery.bindString(n8, string3);
                }
                ++n8;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatUserId");
            if (n8 != -1) break block16;
            roomSQLiteQuery.close();
            return;
        }
        try {
            RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
            n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatUserId");
            n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatToken");
            n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatExpiration");
            n4 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatName");
            n3 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"online");
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"lastFullSync");
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"photoBase64");
            while (roomSQLiteQuery.moveToNext()) {
                arrayMap2 = arrayMap;
                string2 = roomSQLiteQuery.getString(n8);
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        {
            Object object;
            Object object2;
            if (!arrayMap2.containsKey((Object)string2)) continue;
            String string4 = n7 == -1 ? null : roomSQLiteQuery.getString(n7);
            String string5 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
            if (n5 == -1) {
                object2 = null;
            } else {
                object2 = roomSQLiteQuery.getString(n5);
                object2 = this.__converters.stringToDate((String)object2);
            }
            String string6 = n4 == -1 ? null : roomSQLiteQuery.getString(n4);
            boolean bl = n3 != -1 && roomSQLiteQuery.getInt(n3) != 0;
            if (n2 == -1) {
                object = null;
            } else {
                object = roomSQLiteQuery.getString(n2);
                object = this.__converters.stringToDate((String)object);
            }
            String string7 = n == -1 ? null : roomSQLiteQuery.getString(n);
            arrayMap.put((Object)string2, (Object)new TinodeContact(string4, string5, (Date)object2, string6, bl, (Date)object, string7));
            continue;
        }
        roomSQLiteQuery.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> arrayMap) {
        Set set = arrayMap.keySet();
        if (set.isEmpty()) {
            return;
        }
        if (arrayMap.size() > 999) {
            ArrayMap arrayMap2;
            set = arrayMap2;
            arrayMap2 = new ArrayMap(999);
            int n = 0;
            int n2 = arrayMap.size();
            for (int j = 0; j < n2; ++j) {
                ArrayMap arrayMap3;
                set.put(arrayMap.keyAt(j), arrayMap.valueAt(j));
                if (++n != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
                set = arrayMap3;
                arrayMap3 = new ArrayMap(999);
                n = 0;
            }
            if (n > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)set);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoBase64` AS `photoBase64`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        int n = set.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n + 0));
        int n3 = 1;
        for (String string2 : set) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n3);
            } else {
                roomSQLiteQuery.bindString(n3, string2);
            }
            ++n3;
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n3 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatUserId");
            int n4 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatToken");
            int n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatExpiration");
            int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatName");
            int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"online");
            int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"lastFullSync");
            int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"photoBase64");
            while (roomSQLiteQuery.moveToNext()) {
                Object object;
                Object object2;
                ArrayList arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(7));
                if (arrayList == null) continue;
                String string3 = n3 == -1 ? null : roomSQLiteQuery.getString(n3);
                String string4 = n4 == -1 ? null : roomSQLiteQuery.getString(n4);
                if (n5 == -1) {
                    object2 = null;
                } else {
                    object2 = roomSQLiteQuery.getString(n5);
                    object2 = this.__converters.stringToDate((String)object2);
                }
                String string5 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
                boolean bl = n7 != -1 && roomSQLiteQuery.getInt(n7) != 0;
                if (n8 == -1) {
                    object = null;
                } else {
                    object = roomSQLiteQuery.getString(n8);
                    object = this.__converters.stringToDate((String)object);
                }
                String string6 = n9 == -1 ? null : roomSQLiteQuery.getString(n9);
                arrayList.add(new TinodeContact(string3, string4, (Date)object2, string5, bl, (Date)object, string6));
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        {
            continue;
        }
        roomSQLiteQuery.close();
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block49: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(j), arrayMap.valueAt(j));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block49;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery8, (String)"chatMessageSeq");
        int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery10, (String)"date");
        int n10 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery6, (String)"text");
        int n11 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery7, (String)"type");
        int n12 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"subtype");
        int n13 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery5, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            String string4;
            String string5;
            String string6;
            Object object2;
            String string7;
            int n14;
            String string8;
            ArrayList arrayList;
            block51: {
                block50: {
                    if (!roomSQLiteQuery.moveToNext()) break;
                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                    if (arrayList == null) continue;
                    if (n6 != -1) break block50;
                    string8 = null;
                    break block51;
                }
                string8 = roomSQLiteQuery.getString(n6);
            }
            if (n7 == -1) {
                n14 = 0;
            } else {
                n14 = roomSQLiteQuery.getInt(n7);
            }
            if (n8 == -1) {
                string7 = null;
            } else {
                string7 = roomSQLiteQuery.getString(n8);
            }
            if (n9 == -1) {
                object2 = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object2 = roomSQLiteQuery.getString(n9);
                object2 = messagingDao_Impl.__converters.stringToDate((String)object2);
            }
            if (n10 == -1) {
                string6 = null;
            } else {
                string6 = roomSQLiteQuery.getString(n10);
            }
            if (n11 == -1) {
                string5 = null;
            } else {
                string5 = roomSQLiteQuery.getString(n11);
            }
            if (n12 == -1) {
                string4 = null;
            } else {
                string4 = roomSQLiteQuery.getString(n12);
            }
            if (n13 == -1) {
                string3 = null;
            } else {
                string3 = roomSQLiteQuery.getString(n13);
            }
            if (n == -1) {
                object = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object = roomSQLiteQuery.getString(n);
                object = messagingDao_Impl.__converters.stringToChatStatus((String)object);
            }
            arrayList.add(new ChatMessage(string8, n14, string7, (Date)object2, string6, string5, string4, string3, (ChatMessageStatus)((Object)object)));
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$300(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$400(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChat.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public Maybe<Integer> getLastSeqId(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return Maybe.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer n;
                block5: {
                    block4: {
                        9 this_ = DBUtil.query((RoomDatabase)this_.MessagingDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!this_.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            this_.close();
                            throw throwable;
                        }
                        if (this_.isNull(0)) break block4;
                        n = this_.getInt(0);
                        break block5;
                    }
                    n = null;
                }
                this_.close();
                return n;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public Observable<ChatMessageRelation> getChatMessageRelation(String string2, int n) {
        Callable<ChatMessageRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND ChatMessage.chatMessageSeq = ?", (int)2);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        long l = n;
        roomSQLiteQuery.bindLong(2, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        Callable<ChatMessageRelation> callable2 = callable;
        callable = new Callable<ChatMessageRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatMessageRelation call() throws Exception {
                block47: {
                    block45: {
                        block46: {
                            v0 = this;
                            MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                            var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                            var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                            var5_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                            var6_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                            var7_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                            var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                            var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                            var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                            var11_19 = v1;
                            v1 = new ArrayMap();
                            ** while (var1_1.moveToNext())
lbl-1000:
                            // 1 sources

                            {
                                var11_19.put((Object)var1_1.getString(var4_6), null);
                                continue;
                            }
lbl32:
                            // 2 sources

                            v2 = var1_1;
                            v3 = this;
                            var1_1.moveToPosition(-1);
                            MessagingDao_Impl.access$200(v3.MessagingDao_Impl.this, var11_19);
                            if (!v2.moveToFirst()) break block45;
                            if (!var1_1.isNull(var2_2)) break block46;
                            if (!var1_1.isNull(var3_4)) break block46;
                            if (!var1_1.isNull(var4_6)) break block46;
                            if (!var1_1.isNull(var5_7)) break block46;
                            if (!var1_1.isNull(var6_9)) break block46;
                            if (!var1_1.isNull(var7_11)) break block46;
                            if (!var1_1.isNull(var8_13)) break block46;
                            if (!var1_1.isNull(var9_15)) break block46;
                            if (!var1_1.isNull(var10_17)) break block46;
                            var13_20 = var2_3 = null;
                            ** GOTO lbl103
                        }
                        v4 = this;
                        v5 = var1_1;
                        v6 = var10_17;
                        v7 = var1_1;
                        v8 = var9_15;
                        v9 = var1_1;
                        v10 = var8_13;
                        v11 = var1_1;
                        v12 = var7_11;
                        v13 = var1_1;
                        v14 = var6_9;
                        v15 = this;
                        v16 = var1_1;
                        v17 = var5_7;
                        v18 = var1_1;
                        v19 = var4_6;
                        v20 = var1_1;
                        v21 = var3_4;
                        var2_3 = var1_1.getString(var2_2);
                        var3_4 = v20.getInt(v21);
                        var5_8 = v18.getString(v19);
                        var6_10 = v16.getString(v17);
                        var6_10 = MessagingDao_Impl.access$000(v15.MessagingDao_Impl.this).stringToDate((String)var6_10);
                        var7_12 = v13.getString(v14);
                        var8_14 = v11.getString(v12);
                        var9_16 = v9.getString(v10);
                        var10_18 = v7.getString(v8);
                        var12_21 /* !! */  = v5.getString(v6);
                        var12_21 /* !! */  = MessagingDao_Impl.access$000(v4.MessagingDao_Impl.this).stringToChatStatus(var12_21 /* !! */ );
                        var13_20 = v22;
                        v22 = new ChatMessage((String)var2_3, var3_4, var5_8, (Date)var6_10, var7_12, var8_14, var9_16, var10_18, (ChatMessageStatus)var12_21 /* !! */ );
lbl103:
                        // 2 sources

                        var2_3 = (TinodeContact)var11_19.get((Object)var1_1.getString(var4_6));
                        var3_5 = v23;
                        v23 = new ChatMessageRelation((ChatMessage)var13_20, (TinodeContact)var2_3);
                        break block47;
                    }
                    var3_5 = null;
                }
                v24 = var3_5;
                v25 = this;
                v26 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v26.close();
                {
                    catch (Throwable v27) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v27;
                    }
                }
                MessagingDao_Impl.access$100(v25.MessagingDao_Impl.this).endTransaction();
                return v24;
                catch (Throwable v28) {
                    var1_1.close();
                    throw v28;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>(stringArray2.MessagingDao_Impl.this.__db, stringArray2.roomSQLiteQuery, true, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageSeq");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n3), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9)) {
                                object = object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.getString(n);
                                int n10 = cursor.getInt(n2);
                                String string2 = cursor.getString(n3);
                                Object object3 = cursor.getString(n4);
                                object3 = MessagingDao_Impl.this.__converters.stringToDate((String)object3);
                                String string3 = cursor.getString(n5);
                                String string4 = cursor.getString(n6);
                                String string5 = cursor.getString(n7);
                                String string6 = cursor.getString(n8);
                                Object object4 = cursor.getString(n9);
                                object4 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object4);
                                object = chatMessage;
                                chatMessage = new ChatMessage((String)object2, n10, string2, (Date)object3, string3, string4, string5, string6, (ChatMessageStatus)((Object)object4));
                            }
                            object2 = (TinodeContact)arrayMap2.get((Object)cursor.getString(n3));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object, (TinodeContact)object2));
                        }
                        return arrayList2;
                    }
                };
            }
        };
    }

    @Override
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(String string2, Integer object, int n) {
        Callable<List<ChatMessageRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)4);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        int n3 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindLong(n3, (long)((Integer)object).intValue());
        }
        n3 = 3;
        if (object == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindLong(n3, (long)((Integer)object).intValue());
        }
        long l = n;
        roomSQLiteQuery.bindLong(4, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        object = callable;
        callable = new Callable<List<ChatMessageRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatMessageRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                var11_11 = v1;
                v1 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    var11_11.put((Object)var1_1.getString(var4_4), null);
                    continue;
                }
lbl32:
                // 2 sources

                v2 = this;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$200(v2.MessagingDao_Impl.this, var11_11);
                var12_12 = v3;
                v3 = new ArrayList<ChatMessageRelation>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block46: {
                        if (!var1_1.isNull(var2_2)) break block46;
                        if (!var1_1.isNull(var3_3)) break block46;
                        if (!var1_1.isNull(var4_4)) break block46;
                        if (!var1_1.isNull(var5_5)) break block46;
                        if (!var1_1.isNull(var6_6)) break block46;
                        if (!var1_1.isNull(var7_7)) break block46;
                        if (!var1_1.isNull(var8_8)) break block46;
                        if (!var1_1.isNull(var9_9)) break block46;
                        if (!var1_1.isNull(var10_10)) break block46;
                        var22_22 = var13_13 = null;
                        ** GOTO lbl105
                    }
                    v4 = this;
                    v5 = var1_1;
                    v6 = var10_10;
                    v7 = var1_1;
                    v8 = var9_9;
                    v9 = var1_1;
                    v10 = var8_8;
                    v11 = var1_1;
                    v12 = var7_7;
                    v13 = var1_1;
                    v14 = var6_6;
                    v15 = this;
                    v16 = var1_1;
                    v17 = var5_5;
                    v18 = var1_1;
                    v19 = var4_4;
                    v20 = var1_1;
                    v21 = var3_3;
                    var13_13 = var1_1.getString(var2_2);
                    var14_14 = v20.getInt(v21);
                    var15_15 = v18.getString(v19);
                    var16_16 = v16.getString(v17);
                    var16_16 = MessagingDao_Impl.access$000(v15.MessagingDao_Impl.this).stringToDate((String)var16_16);
                    var17_17 = v13.getString(v14);
                    var18_18 = v11.getString(v12);
                    var19_19 = v9.getString(v10);
                    var20_20 = v7.getString(v8);
                    var21_21 /* !! */  = v5.getString(v6);
                    var21_21 /* !! */  = MessagingDao_Impl.access$000(v4.MessagingDao_Impl.this).stringToChatStatus(var21_21 /* !! */ );
                    var22_22 = v22;
                    v22 = new ChatMessage((String)var13_13, var14_14, var15_15, (Date)var16_16, var17_17, var18_18, var19_19, var20_20, (ChatMessageStatus)var21_21 /* !! */ );
lbl105:
                    // 2 sources

                    v23 = var12_12;
                    var13_13 = (TinodeContact)var11_11.get((Object)var1_1.getString(var4_4));
                    v23.add(new ChatMessageRelation((ChatMessage)var22_22, (TinodeContact)var13_13));
                    continue;
                }
lbl112:
                // 2 sources

                v24 = var12_12;
                v25 = this;
                v26 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v26.close();
                {
                    catch (Throwable v27) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v27;
                    }
                }
                MessagingDao_Impl.access$100(v25.MessagingDao_Impl.this).endTransaction();
                return v24;
                catch (Throwable v28) {
                    var1_1.close();
                    throw v28;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Observable<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Chat";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"ownerId");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"descUpdatedAt");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subUpdatedAt");
                var11_11 = v1;
                v1 = new ArrayMap();
                var12_12 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block56: {
                        v3 = var11_11;
                        var13_13 = var1_1.getString(var2_2);
                        if ((ArrayList)v3.get(var13_13) != null) break block56;
                        var11_11.put(var13_13, new ArrayList<E>());
                    }
                    v4 = var12_12;
                    var13_13 = var1_1.getString(var2_2);
                    if ((ArrayList)v4.get(var13_13) != null) continue;
                    var12_12.put(var13_13, new ArrayList<E>());
                    continue;
                }
lbl49:
                // 2 sources

                v5 = this;
                v6 = v5;
                v7 = v5;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$300(v6.MessagingDao_Impl.this, var11_11);
                MessagingDao_Impl.access$400(v7.MessagingDao_Impl.this, var12_12);
                var13_13 = v8;
                v8 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block57: {
                        if (!var1_1.isNull(var2_2)) break block57;
                        if (!var1_1.isNull(var3_3)) break block57;
                        if (!var1_1.isNull(var4_4)) break block57;
                        if (!var1_1.isNull(var5_5)) break block57;
                        if (!var1_1.isNull(var6_6)) break block57;
                        if (!var1_1.isNull(var7_7)) break block57;
                        if (!var1_1.isNull(var8_8)) break block57;
                        if (!var1_1.isNull(var9_9)) break block57;
                        if (!var1_1.isNull(var10_10)) break block57;
                        var23_23 = var14_14 = null;
                        ** GOTO lbl128
                    }
                    v9 = this;
                    v10 = var1_1;
                    v11 = var10_10;
                    v12 = this;
                    v13 = var1_1;
                    v14 = var9_9;
                    v15 = this;
                    v16 = var1_1;
                    v17 = var8_8;
                    v18 = var1_1;
                    v19 = var7_7;
                    v20 = var1_1;
                    v21 = var6_6;
                    v22 = var1_1;
                    v23 = var5_5;
                    v24 = var1_1;
                    v25 = var4_4;
                    v26 = var1_1;
                    v27 = var3_3;
                    var14_14 = var1_1.getString(var2_2);
                    var15_15 = v26.getString(v27);
                    var16_16 = v24.getString(v25);
                    var17_17 = v22.getInt(v23);
                    var18_18 = v20.getInt(v21);
                    var19_19 = v18.getInt(v19);
                    var20_20 = v16.getString(v17);
                    var20_20 = MessagingDao_Impl.access$000(v15.MessagingDao_Impl.this).stringToDate((String)var20_20);
                    var21_21 = v13.getString(v14);
                    var21_21 = MessagingDao_Impl.access$000(v12.MessagingDao_Impl.this).stringToDate((String)var21_21);
                    var22_22 = v10.getString(v11);
                    var22_22 = MessagingDao_Impl.access$000(v9.MessagingDao_Impl.this).stringToDate((String)var22_22);
                    var23_23 = v28;
                    v28 = new Chat((String)var14_14, (String)var15_15, var16_16, var17_17, var18_18, var19_19, (Date)var20_20, (Date)var21_21, (Date)var22_22);
lbl128:
                    // 2 sources

                    var14_14 = (ArrayList)var11_11.get((Object)var1_1.getString(var2_2));
                    if (var14_14 != null) ** GOTO lbl133
                    var14_14 = v29;
                    v29 = new ArrayList<E>();
lbl133:
                    // 2 sources

                    if ((var15_15 = (ArrayList)var12_12.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl137
                    var15_15 = v30;
                    v30 = new ArrayList<E>();
lbl137:
                    // 2 sources

                    var13_13.add(new ChatRelation((Chat)var23_23, (List<TinodeContact>)var14_14, (List<ChatMessage>)var15_15));
                    continue;
                }
lbl141:
                // 2 sources

                v31 = var13_13;
                v32 = this;
                v33 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v33.close();
                {
                    catch (Throwable v34) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v34;
                    }
                }
                MessagingDao_Impl.access$100(v32.MessagingDao_Impl.this).endTransaction();
                return v31;
                catch (Throwable v35) {
                    var1_1.close();
                    throw v35;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat WHERE Chat.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Chat";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public ChatRelation call() throws Exception {
                block59: {
                    block56: {
                        block58: {
                            block57: {
                                v0 = this;
                                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"ownerId");
                                var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"descUpdatedAt");
                                var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subUpdatedAt");
                                var11_18 = v1;
                                v1 = new ArrayMap();
                                var12_19 = v2;
                                v2 = new ArrayMap();
                                ** while (var1_1.moveToNext())
lbl-1000:
                                // 1 sources

                                {
                                    block55: {
                                        v3 = var11_18;
                                        var13_20 = var1_1.getString(var2_2);
                                        if ((ArrayList)v3.get(var13_20) != null) break block55;
                                        var11_18.put(var13_20, new ArrayList<E>());
                                    }
                                    v4 = var12_19;
                                    var13_20 = var1_1.getString(var2_2);
                                    if ((ArrayList)v4.get(var13_20) != null) continue;
                                    var12_19.put(var13_20, new ArrayList<E>());
                                    continue;
                                }
lbl49:
                                // 2 sources

                                v5 = var1_1;
                                v6 = this;
                                v7 = v6;
                                v8 = v6;
                                var1_1.moveToPosition(-1);
                                MessagingDao_Impl.access$300(v7.MessagingDao_Impl.this, var11_18);
                                MessagingDao_Impl.access$400(v8.MessagingDao_Impl.this, var12_19);
                                if (!v5.moveToFirst()) break block56;
                                if (!var1_1.isNull(var2_2)) break block57;
                                if (!var1_1.isNull(var3_4)) break block57;
                                if (!var1_1.isNull(var4_6)) break block57;
                                if (!var1_1.isNull(var5_9)) break block57;
                                if (!var1_1.isNull(var6_11)) break block57;
                                if (!var1_1.isNull(var7_12)) break block57;
                                if (!var1_1.isNull(var8_13)) break block57;
                                if (!var1_1.isNull(var9_14)) break block57;
                                if (!var1_1.isNull(var10_16)) break block57;
                                var14_21 = var3_5 = null;
                                ** GOTO lbl126
                            }
                            v9 = this;
                            v10 = var1_1;
                            v11 = var10_16;
                            v12 = this;
                            v13 = var1_1;
                            v14 = var9_14;
                            v15 = this;
                            v16 = var1_1;
                            v17 = var8_13;
                            v18 = var1_1;
                            v19 = var7_12;
                            v20 = var1_1;
                            v21 = var6_11;
                            v22 = var1_1;
                            v23 = var5_9;
                            v24 = var1_1;
                            v25 = var4_6;
                            v26 = var1_1;
                            v27 = var3_4;
                            var3_5 = var1_1.getString(var2_2);
                            var4_7 = v26.getString(v27);
                            var5_10 = v24.getString(v25);
                            var6_11 = v22.getInt(v23);
                            var7_12 = v20.getInt(v21);
                            var8_13 = v18.getInt(v19);
                            var9_15 = v16.getString(v17);
                            var9_15 = MessagingDao_Impl.access$000(v15.MessagingDao_Impl.this).stringToDate((String)var9_15);
                            var10_17 = v13.getString(v14);
                            var10_17 = MessagingDao_Impl.access$000(v12.MessagingDao_Impl.this).stringToDate((String)var10_17);
                            var13_20 = v10.getString(v11);
                            var13_20 = MessagingDao_Impl.access$000(v9.MessagingDao_Impl.this).stringToDate((String)var13_20);
                            var14_21 = v28;
                            v28 = new Chat((String)var3_5, var4_7, var5_10, var6_11, var7_12, var8_13, (Date)var9_15, (Date)var10_17, (Date)var13_20);
lbl126:
                            // 2 sources

                            var3_5 = (ArrayList)var11_18.get((Object)var1_1.getString(var2_2));
                            if (var3_5 != null) ** GOTO lbl131
                            var3_5 = v29;
                            v29 = new ArrayList<E>();
lbl131:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var12_19.get((Object)var1_1.getString(var2_2))) != null) break block58;
                            var2_3 = v30;
                            v30 = new ArrayList<E>();
                        }
                        var4_8 = v31;
                        v31 = new ChatRelation((Chat)var14_21, (List<TinodeContact>)var3_5, var2_3);
                        break block59;
                    }
                    var4_8 = null;
                }
                v32 = var4_8;
                v33 = this;
                v34 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v34.close();
                {
                    catch (Throwable v35) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v35;
                    }
                }
                MessagingDao_Impl.access$100(v33.MessagingDao_Impl.this).endTransaction();
                return v32;
                catch (Throwable v36) {
                    var1_1.close();
                    throw v36;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public Observable<ChatMessage> getChatMessage(String string2, int n) {
        return MessagingDao.DefaultImpls.getChatMessage(this, string2, n);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(String string2) {
        return MessagingDao.DefaultImpls.getChatMessagesLiveData(this, string2);
    }

    @Override
    public Observable<List<ChatMessage>> getChatMessages(String string2, Integer n, int n2) {
        return MessagingDao.DefaultImpls.getChatMessages(this, string2, n, n2);
    }

    @Override
    public Observable<List<Chat>> getChats() {
        return MessagingDao.DefaultImpls.getChats(this);
    }

    @Override
    public Observable<Chat> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }
}

