/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.DiffUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.google.android.material.imageview.ShapeableImageView;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.MessagingAdapter;
import io.streamlayer.sdk.messaging.MessagingAdapter$MessageViewHolder$WhenMappings;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.AvatarUtil;
import io.streamlayer.utils.DateUtil;
import io.streamlayer.utils.EmojiUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00132\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0004\u0013\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001c\u0010\u000f\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/messaging/MessagingAdapter;", "Landroidx/paging/PagedListAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageViewHolder;", "mode", "Lio/streamlayer/sdk/model/messaging/ChatType;", "userId", "", "(Lio/streamlayer/sdk/model/messaging/ChatType;Ljava/lang/String;)V", "getItemViewType", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "MessageReceiverViewHolder", "MessageSenderViewHolder", "MessageViewHolder", "sdk_release"})
public final class MessagingAdapter
extends PagedListAdapter<ChatMessage, MessageViewHolder> {
    private static final Lazy messageDiffCallback$delegate;
    public static final Companion Companion;
    private final ChatType mode;
    private final String userId;

    public MessagingAdapter(@NotNull ChatType chatType, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)chatType), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
        super(MessagingAdapter.Companion.getMessageDiffCallback());
        this.mode = chatType;
        this.userId = string2;
    }

    static {
        Companion = new Companion(null);
        messageDiffCallback$delegate = LazyKt.lazy((Function0)Companion.messageDiffCallback.2.INSTANCE);
    }

    @NotNull
    public MessageViewHolder onCreateViewHolder(@NotNull ViewGroup object, int n) {
        MessageSenderViewHolder messageSenderViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"parent");
        switch (n) {
            default: {
                throw new RuntimeException("Unsupported item view type: " + n);
            }
            case 3: {
                ViewGroup viewGroup = object;
                messageSenderViewHolder = ExtensionsKt.inflate(viewGroup, R.layout.sl_item_chat_receiver);
                boolean bl = true;
                boolean bl2 = this.mode == ChatType.Group;
                object = new MessageReceiverViewHolder((View)messageSenderViewHolder, bl, bl2);
                messageSenderViewHolder = object;
                break;
            }
            case 2: {
                ViewGroup viewGroup = object;
                messageSenderViewHolder = ExtensionsKt.inflate(viewGroup, R.layout.sl_item_chat_receiver);
                boolean bl = false;
                boolean bl3 = this.mode == ChatType.Group;
                object = new MessageReceiverViewHolder((View)messageSenderViewHolder, bl, bl3);
                messageSenderViewHolder = object;
                break;
            }
            case 1: {
                MessageSenderViewHolder messageSenderViewHolder2;
                messageSenderViewHolder = messageSenderViewHolder2;
                messageSenderViewHolder2 = new MessageSenderViewHolder(ExtensionsKt.inflate(object, R.layout.sl_item_chat_sender), true);
                break;
            }
            case 0: {
                MessageSenderViewHolder messageSenderViewHolder3;
                messageSenderViewHolder = messageSenderViewHolder3;
                messageSenderViewHolder3 = new MessageSenderViewHolder(ExtensionsKt.inflate(object, R.layout.sl_item_chat_sender), false);
            }
        }
        return messageSenderViewHolder;
    }

    public void onBindViewHolder(@NotNull MessageViewHolder messageViewHolder, int n) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)messageViewHolder), (String)"holder");
        Object object = (ChatMessage)object.getItem(n);
        if (object != null) {
            messageViewHolder.bind((ChatMessage)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getItemViewType(int n) {
        Object object;
        ChatMessage chatMessage;
        block7: {
            chatMessage = (ChatMessage)this.getItem(n);
            if (chatMessage == null) return super.getItemViewType(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)chatMessage, (String)"getItem(position) ?: ret\u2026getItemViewType(position)");
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block7;
            }
            {
                object = Result.constructor-impl((Object)((ChatMessage)this.getItem(n - 1)));
            }
        }
        if (Result.isFailure-impl((Object)object)) {
            object = null;
        }
        ChatMessage chatMessage2 = chatMessage;
        object = (ChatMessage)object;
        boolean bl = Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)this.userId);
        boolean bl2 = chatMessage2.getDate() != null && ((object != null ? ((ChatMessage)object).getDate() : null) == null || !DateUtil.INSTANCE.isSameDay(((ChatMessage)object).getDate(), chatMessage.getDate()));
        if (bl && bl2) {
            return 1;
        }
        if (bl) {
            return 0;
        }
        if (!bl && bl2) {
            return 3;
        }
        if (bl) throw new RuntimeException("Unsupported state. isCurrentUser: " + bl + "; shouldShowTimestamp: " + bl2);
        return 2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u001b\u0010\b\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "itemView", "Landroid/view/View;", "withTimestamp", "", "(Lio/streamlayer/sdk/messaging/MessagingAdapter;Landroid/view/View;Z)V", "chatMessageContainer", "getChatMessageContainer", "()Landroid/view/View;", "chatMessageContainer$delegate", "Lkotlin/Lazy;", "chatMessageContent", "Landroid/widget/TextView;", "getChatMessageContent", "()Landroid/widget/TextView;", "chatMessageContent$delegate", "chatTimestamp", "getChatTimestamp", "chatTimestamp$delegate", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "bind", "", "message", "sdk_release"})
    public abstract class MessageViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<ChatMessage> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Lazy chatTimestamp$delegate;
        private final Lazy chatMessageContent$delegate;
        private final Lazy chatMessageContainer$delegate;
        private Drawable defaultBackground;
        private final boolean withTimestamp;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatTimestamp", "getChatTimestamp()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContent", "getChatMessageContent()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContainer", "getChatMessageContainer()Landroid/view/View;"))};
        }

        private final TextView getChatTimestamp() {
            KProperty cfr_ignored_0 = $$delegatedProperties[0];
            return (TextView)this.chatTimestamp$delegate.getValue();
        }

        private final TextView getChatMessageContent() {
            KProperty cfr_ignored_0 = $$delegatedProperties[1];
            return (TextView)this.chatMessageContent$delegate.getValue();
        }

        private final View getChatMessageContainer() {
            KProperty cfr_ignored_0 = $$delegatedProperties[2];
            return (View)this.chatMessageContainer$delegate.getValue();
        }

        public MessageViewHolder(View view, boolean bl) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            this.withTimestamp = bl;
            this.chatTimestamp$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatTimestamp);
                }
            });
            this.chatMessageContent$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatMessageContent);
                }
            });
            this.chatMessageContainer$delegate = LazyKt.lazy((Function0)new Function0<View>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageContainer);
                }
            });
            Drawable drawable2 = this.getChatMessageContainer().getBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"chatMessageContainer.background");
            this.defaultBackground = drawable2;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
            if (this.withTimestamp && chatMessage.getDate() != null) {
                MessageViewHolder messageViewHolder = this;
                TextView textView = messageViewHolder.getChatTimestamp();
                View view = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                textView.setText(DateUtils.getRelativeDateTimeString((Context)view.getContext(), (long)chatMessage.getDate().getTime(), (long)86400000L, (long)86400000L, (int)0));
                ExtensionsKt.visible((View)messageViewHolder.getChatTimestamp());
            } else {
                ExtensionsKt.gone((View)this.getChatTimestamp());
            }
            View view = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            float f = MessagingAdapter$MessageViewHolder$WhenMappings.$EnumSwitchMapping$0[chatMessage.getStatus().ordinal()] != 1 ? 1.0f : 0.7f;
            view.setAlpha(f);
            if (EmojiUtil.INSTANCE.isEmojiOnly(chatMessage.getText())) {
                MessageViewHolder messageViewHolder = this;
                messageViewHolder.getChatMessageContainer().setBackground(null);
                messageViewHolder.getChatMessageContent().setTextSize(1, 32.0f);
                TextView textView = messageViewHolder.getChatMessageContent();
                View view2 = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
                Context context = view2.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"itemView.context");
                textView.setTextSize(context.getResources().getDimension(R.dimen.slChatMessageBig));
            } else {
                MessageViewHolder messageViewHolder = this;
                messageViewHolder.getChatMessageContainer().setBackground(this.defaultBackground);
                messageViewHolder.getChatMessageContent().setTextSize(2, 14.0f);
            }
            this.getChatMessageContent().setText((CharSequence)chatMessage.getText());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageSenderViewHolder;", "Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/MessagingAdapter;", "itemView", "Landroid/view/View;", "showTimestamp", "", "(Lio/streamlayer/sdk/messaging/MessagingAdapter;Landroid/view/View;Z)V", "sdk_release"})
    public final class MessageSenderViewHolder
    extends MessageViewHolder {
        public MessageSenderViewHolder(View view, boolean bl) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view, bl);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageReceiverViewHolder;", "Lio/streamlayer/sdk/messaging/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/MessagingAdapter;", "itemView", "Landroid/view/View;", "showTimestamp", "", "isGroup", "(Lio/streamlayer/sdk/messaging/MessagingAdapter;Landroid/view/View;ZZ)V", "bind", "", "message", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "sdk_release"})
    public final class MessageReceiverViewHolder
    extends MessageViewHolder {
        private final boolean isGroup;

        public MessageReceiverViewHolder(View view, boolean bl, boolean bl2) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view, bl);
            this.isGroup = bl2;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            MessageReceiverViewHolder messageReceiverViewHolder = object;
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"message");
            super.bind(chatMessage2);
            Object object = chatMessage.getSender();
            chatMessage = messageReceiverViewHolder.itemView;
            if (messageReceiverViewHolder.isGroup && object != null) {
                Object object2;
                block9: {
                    Object object3 = object;
                    object2 = ((TinodeContact)object3).getPhotoBase64();
                    if (object2 != null) break block9;
                    object2 = "";
                }
                try {
                    object2 = Result.constructor-impl((Object)Base64.decode((String)object2, (int)0));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if (Result.isFailure-impl((Object)object2)) {
                    object2 = null;
                }
                object2 = (byte[])object2;
                object2 = Glide.with((View)((ShapeableImageView)chatMessage.findViewById(R.id.chatMessageAuthorAvatar))).load((byte[])object2);
                String string2 = ((TinodeContact)object).getChatName();
                if (string2 == null) {
                    string2 = "";
                }
                ((RequestBuilder)object2.error((Drawable)new AcronymDrawable(string2, 0.0f, 2, null))).into((ImageView)((ShapeableImageView)chatMessage.findViewById(R.id.chatMessageAuthorAvatar)));
                object2 = (ShapeableImageView)chatMessage.findViewById(R.id.chatMessageAuthorAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"chatMessageAuthorAvatar");
                string2 = ((TinodeContact)object).getPhotoBase64();
                if (string2 == null) {
                    string2 = "";
                }
                Object object4 = object;
                ChatMessage chatMessage3 = chatMessage;
                ExtensionsKt.loadUrl$default((ImageView)object2, string2, false, null, null, 14, null);
                ShapeableImageView shapeableImageView = (ShapeableImageView)chatMessage3.findViewById(R.id.chatMessageAuthorAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)shapeableImageView, (String)"chatMessageAuthorAvatar");
                ExtensionsKt.visible((View)shapeableImageView);
                TextView textView = (TextView)chatMessage3.findViewById(R.id.chatMessageAuthorName);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                textView.setText((CharSequence)((TinodeContact)object).getChatName());
                object = (TextView)chatMessage3.findViewById(R.id.chatMessageAuthorName);
                object2 = ((TinodeContact)object4).getChatName();
                int n = object2 != null ? AvatarUtil.INSTANCE.getColor((String)object2) : -1;
                object.setTextColor(n);
                TextView textView2 = (TextView)chatMessage.findViewById(R.id.chatMessageAuthorName);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"chatMessageAuthorName");
                ExtensionsKt.visible((View)textView2);
            } else {
                ChatMessage chatMessage4 = chatMessage;
                ShapeableImageView shapeableImageView = (ShapeableImageView)chatMessage4.findViewById(R.id.chatMessageAuthorAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)shapeableImageView, (String)"chatMessageAuthorAvatar");
                ExtensionsKt.gone((View)shapeableImageView);
                TextView textView = (TextView)chatMessage4.findViewById(R.id.chatMessageAuthorName);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                ExtensionsKt.gone((View)textView);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/messaging/MessagingAdapter$Companion;", "", "()V", "messageDiffCallback", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "getMessageDiffCallback", "()Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "messageDiffCallback$delegate", "Lkotlin/Lazy;", "sdk_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "messageDiffCallback", "getMessageDiffCallback()Landroidx/recyclerview/widget/DiffUtil$ItemCallback;"))};
        }

        private final DiffUtil.ItemCallback<ChatMessage> getMessageDiffCallback() {
            KProperty cfr_ignored_0 = $$delegatedProperties[0];
            return (DiffUtil.ItemCallback)messageDiffCallback$delegate.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

