/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.os.ParcelableCompat;
import androidx.core.os.ParcelableCompatCreatorCallbacks;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.R;
import java.lang.ref.WeakReference;

public class TopSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_HIDDEN = 5;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final float HIDE_FRICTION = 0.1f;
    private float mMaximumVelocity;
    private int mPeekHeight;
    private int mMinOffset;
    private int mMaxOffset;
    private boolean mHideable;
    private boolean mSkipCollapsed;
    private int mState;
    private ViewDragHelper mViewDragHelper;
    private boolean mIgnoreEvents;
    private int mLastNestedScrollDy;
    private boolean mNestedScrolled;
    private int mParentHeight;
    private WeakReference<V> mViewRef;
    private WeakReference<View> mNestedScrollingChildRef;
    private TopSheetCallback mCallback;
    private VelocityTracker mVelocityTracker;
    private int mActivePointerId;
    private int mInitialY;
    private boolean mTouchingScrollingChild;
    int oldState;
    private final ViewDragHelper.Callback mDragCallback;

    public TopSheetBehavior() {
        this.oldState = this.mState = 4;
        this.mDragCallback = new ViewDragHelper.Callback(){

            public boolean tryCaptureView(View view, int n) {
                View view2;
                if (TopSheetBehavior.this.mState == 1) {
                    return false;
                }
                if (TopSheetBehavior.this.mTouchingScrollingChild) {
                    return false;
                }
                if (TopSheetBehavior.this.mState == 3 && TopSheetBehavior.this.mActivePointerId == n && (view2 = (View)TopSheetBehavior.this.mNestedScrollingChildRef.get()) != null && ViewCompat.canScrollVertically((View)view2, (int)-1)) {
                    return false;
                }
                return TopSheetBehavior.this.mViewRef != null && TopSheetBehavior.this.mViewRef.get() == view;
            }

            public void onViewPositionChanged(View view, int n, int n2, int n3, int n4) {
                TopSheetBehavior.this.dispatchOnSlide(n2);
            }

            public void onViewDragStateChanged(int n) {
                if (n == 1) {
                    TopSheetBehavior.this.setStateInternal(1);
                }
            }

            public void onViewReleased(View view, float f, float f2) {
                int n;
                float f3 = f2 - 0.0f;
                float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                if (f4 > 0) {
                    f4 = TopSheetBehavior.this.mMaxOffset;
                    n = 3;
                } else if (TopSheetBehavior.this.mHideable && TopSheetBehavior.this.shouldHide(view, f2)) {
                    f4 = -((View)TopSheetBehavior.this.mViewRef.get()).getHeight();
                    n = 5;
                } else if (f4 == false) {
                    int n2 = view.getTop();
                    f4 = n2;
                    if (Math.abs(n2 - TopSheetBehavior.this.mMinOffset) > Math.abs((int)(f4 - TopSheetBehavior.this.mMaxOffset))) {
                        f4 = TopSheetBehavior.this.mMaxOffset;
                        n = 3;
                    } else {
                        f4 = TopSheetBehavior.this.mMinOffset;
                        n = 4;
                    }
                } else {
                    f4 = TopSheetBehavior.this.mMinOffset;
                    n = 4;
                }
                if (TopSheetBehavior.this.mViewDragHelper.settleCapturedViewAt(view.getLeft(), (int)f4)) {
                    TopSheetBehavior.this.setStateInternal(2);
                    ViewCompat.postOnAnimation((View)view, (Runnable)new SettleRunnable(view, n));
                } else {
                    TopSheetBehavior.this.setStateInternal(n);
                }
            }

            public int clampViewPositionVertical(View view, int n, int n2) {
                int n3 = TopSheetBehavior.this.mHideable ? -view.getHeight() : TopSheetBehavior.this.mMinOffset;
                return TopSheetBehavior.constrain(n, n3, TopSheetBehavior.this.mMaxOffset);
            }

            public int clampViewPositionHorizontal(View view, int n, int n2) {
                return view.getLeft();
            }

            public int getViewVerticalDragRange(View view) {
                if (TopSheetBehavior.this.mHideable) {
                    return view.getHeight();
                }
                return TopSheetBehavior.this.mMaxOffset - TopSheetBehavior.this.mMinOffset;
            }
        };
    }

    public TopSheetBehavior(Context context, AttributeSet attributeSet) {
        Context context2 = context;
        super(context, attributeSet);
        this.oldState = this.mState = 4;
        this.mDragCallback = new /* invalid duplicate definition of identical inner class */;
        context = context2.obtainStyledAttributes(attributeSet, R.styleable.BottomSheetBehavior_Layout);
        this.setPeekHeight(context.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, 0));
        this.setHideable(context.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setSkipCollapsed(context.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        context.recycle();
        this.mMaximumVelocity = ViewConfiguration.get((Context)context2).getScaledMaximumFlingVelocity();
    }

    private void setStateInternal(int n) {
        if (n == 4 || n == 3) {
            ((TopSheetBehavior)((Object)this)).oldState = n;
        }
        if (((TopSheetBehavior)((Object)this)).mState == n) {
            return;
        }
        ((TopSheetBehavior)((Object)this)).mState = n;
        View view = (View)((TopSheetBehavior)((Object)this)).mViewRef.get();
        if (view != null && (this = ((TopSheetBehavior)((Object)this)).mCallback) != null) {
            ((TopSheetCallback)this).onStateChanged(view, n);
        }
    }

    private void reset() {
        this.mActivePointerId = -1;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean shouldHide(View view, float f) {
        if (view.getTop() > this.mMinOffset) {
            return false;
        }
        return Math.abs((float)view.getTop() + f * 0.1f - (float)this.mMinOffset) / (float)this.mPeekHeight > 0.5f;
    }

    private View findScrollingChild(View view) {
        if (view instanceof NestedScrollingChild) {
            return view;
        }
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            int n = view.getChildCount();
            for (int j = 0; j < n; ++j) {
                View view2 = this.findScrollingChild(view.getChildAt(j));
                if (view2 == null) continue;
                return view2;
            }
        }
        return null;
    }

    private float getYVelocity() {
        TopSheetBehavior topSheetBehavior = this;
        topSheetBehavior.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
        return VelocityTrackerCompat.getYVelocity((VelocityTracker)topSheetBehavior.mVelocityTracker, (int)this.mActivePointerId);
    }

    private void dispatchOnSlide(int n) {
        View view = (View)this.mViewRef.get();
        if (view != null && this.mCallback != null) {
            Boolean bl = this.oldState == 4;
            int n2 = this.mMinOffset;
            if (n < n2) {
                this.mCallback.onSlide(view, (float)(n - n2) / (float)this.mPeekHeight, bl);
            } else {
                this.mCallback.onSlide(view, (float)(n - n2) / (float)(this.mMaxOffset - n2), bl);
            }
        }
    }

    public static <V extends View> TopSheetBehavior<V> from(V object) {
        if ((object = object.getLayoutParams()) instanceof CoordinatorLayout.LayoutParams) {
            if ((object = ((CoordinatorLayout.LayoutParams)object).getBehavior()) instanceof TopSheetBehavior) {
                return (TopSheetBehavior)((Object)object);
            }
            throw new IllegalArgumentException("The view is not associated with TopSheetBehavior");
        }
        throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
    }

    static int constrain(int n, int n2, int n3) {
        if (n < n2) {
            n3 = n2;
        } else if (n <= n3) {
            n3 = n;
        }
        return n3;
    }

    static float constrain(float f, float f2, float f3) {
        if (f < f2) {
            f3 = f2;
        } else if (!(f > f3)) {
            f3 = f;
        }
        return f3;
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v) {
        return new SavedState(super.onSaveInstanceState(coordinatorLayout, v), this.mState);
    }

    public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v, Parcelable object) {
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(coordinatorLayout, v, object.getSuperState());
        int n = object.state;
        this.mState = n != 1 && n != 2 ? n : 4;
    }

    public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int n) {
        if (ViewCompat.getFitsSystemWindows((View)coordinatorLayout) && !ViewCompat.getFitsSystemWindows(v)) {
            ViewCompat.setFitsSystemWindows(v, (boolean)true);
        }
        CoordinatorLayout coordinatorLayout2 = coordinatorLayout;
        int n2 = n;
        n = v.getTop();
        coordinatorLayout2.onLayoutChild(v, n2);
        this.mParentHeight = coordinatorLayout2.getHeight();
        this.mMinOffset = Math.max(-v.getHeight(), -(v.getHeight() - this.mPeekHeight));
        this.mMaxOffset = 0;
        int n3 = this.mState;
        if (n3 == 3) {
            ViewCompat.offsetTopAndBottom(v, (int)this.mMaxOffset);
        } else if (this.mHideable && n3 == 5) {
            V v2 = v;
            ViewCompat.offsetTopAndBottom(v2, (int)(-v2.getHeight()));
        } else {
            n3 = this.mState;
            if (n3 == 4) {
                ViewCompat.offsetTopAndBottom(v, (int)this.mMinOffset);
            } else if (n3 == 1 || n3 == 2) {
                ViewCompat.offsetTopAndBottom(v, (int)(n - v.getTop()));
            }
        }
        if (this.mViewDragHelper == null) {
            this.mViewDragHelper = ViewDragHelper.create((ViewGroup)coordinatorLayout, (ViewDragHelper.Callback)this.mDragCallback);
        }
        TopSheetBehavior topSheetBehavior = this;
        topSheetBehavior.mViewRef = new WeakReference<V>(v);
        topSheetBehavior.mNestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)v));
        return true;
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V object, MotionEvent motionEvent) {
        if (!object.isShown()) {
            return false;
        }
        int n = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (n == 0) {
            this.reset();
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        if (n != 0) {
            if (n == 1 || n == 3) {
                this.mTouchingScrollingChild = false;
                this.mActivePointerId = -1;
                if (this.mIgnoreEvents) {
                    this.mIgnoreEvents = false;
                    return false;
                }
            }
        } else {
            MotionEvent motionEvent2 = motionEvent;
            int n2 = (int)motionEvent2.getX();
            this.mInitialY = (int)motionEvent2.getY();
            View view = (View)this.mNestedScrollingChildRef.get();
            if (view != null && coordinatorLayout.isPointInChildBounds(view, n2, this.mInitialY)) {
                TopSheetBehavior topSheetBehavior = this;
                MotionEvent motionEvent3 = motionEvent;
                topSheetBehavior.mActivePointerId = motionEvent3.getPointerId(motionEvent3.getActionIndex());
                topSheetBehavior.mTouchingScrollingChild = true;
            }
            boolean bl = this.mActivePointerId == -1 && !coordinatorLayout.isPointInChildBounds(object, n2, this.mInitialY);
            this.mIgnoreEvents = bl;
        }
        if (!this.mIgnoreEvents && this.mViewDragHelper.shouldInterceptTouchEvent(motionEvent)) {
            return true;
        }
        object = (View)this.mNestedScrollingChildRef.get();
        return n == 2 && object != null && !this.mIgnoreEvents && this.mState != 1 && !coordinatorLayout.isPointInChildBounds(object, (int)motionEvent.getX(), (int)motionEvent.getY()) && Math.abs((float)this.mInitialY - motionEvent.getY()) > (float)this.mViewDragHelper.getTouchSlop();
    }

    public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
        if (!v.isShown()) {
            return false;
        }
        int n = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (this.mState == 1 && n == 0) {
            return true;
        }
        ViewDragHelper viewDragHelper = this.mViewDragHelper;
        if (viewDragHelper != null) {
            viewDragHelper.processTouchEvent(motionEvent);
            if (n == 0) {
                this.reset();
            }
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(motionEvent);
            if (n == 2 && !this.mIgnoreEvents && Math.abs((float)this.mInitialY - motionEvent.getY()) > (float)this.mViewDragHelper.getTouchSlop()) {
                MotionEvent motionEvent2 = motionEvent;
                this.mViewDragHelper.captureChildView(v, motionEvent2.getPointerId(motionEvent2.getActionIndex()));
            }
        }
        return this.mIgnoreEvents ^ true;
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n) {
        TopSheetBehavior topSheetBehavior = this;
        topSheetBehavior.mLastNestedScrollDy = 0;
        topSheetBehavior.mNestedScrolled = false;
        return (n & 2) != 0;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int[] nArray) {
        if (view != (View)this.mNestedScrollingChildRef.get()) {
            return;
        }
        int n3 = v.getTop();
        n = n3 - n2;
        if (n2 > 0) {
            if (!ViewCompat.canScrollVertically((View)view, (int)1)) {
                int n4 = this.mMinOffset;
                if (n < n4 && !this.mHideable) {
                    nArray[1] = n3 - n4;
                    ViewCompat.offsetTopAndBottom(v, (int)(-nArray[1]));
                    this.setStateInternal(4);
                } else {
                    nArray[1] = n2;
                    ViewCompat.offsetTopAndBottom(v, (int)(-n2));
                    this.setStateInternal(1);
                }
            }
        } else if (n2 < 0) {
            int n5 = this.mMaxOffset;
            if (n < n5) {
                nArray[1] = n2;
                ViewCompat.offsetTopAndBottom(v, (int)(-n2));
                this.setStateInternal(1);
            } else {
                nArray[1] = n3 - n5;
                ViewCompat.offsetTopAndBottom(v, (int)(-nArray[1]));
                this.setStateInternal(3);
            }
        }
        TopSheetBehavior topSheetBehavior = this;
        this.dispatchOnSlide(v.getTop());
        topSheetBehavior.mLastNestedScrollDy = n2;
        topSheetBehavior.mNestedScrolled = true;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view) {
        if (v.getTop() == this.mMaxOffset) {
            this.setStateInternal(3);
            return;
        }
        if (view == this.mNestedScrollingChildRef.get() && this.mNestedScrolled) {
            int n;
            int n2;
            if (this.mLastNestedScrollDy < 0) {
                n2 = this.mMaxOffset;
                n = 3;
            } else if (this.mHideable && this.shouldHide((View)v, this.getYVelocity())) {
                n2 = -v.getHeight();
                n = 5;
            } else if (this.mLastNestedScrollDy == 0) {
                n2 = v.getTop();
                if (Math.abs(n2 - this.mMinOffset) > Math.abs(n2 - this.mMaxOffset)) {
                    n2 = this.mMaxOffset;
                    n = 3;
                } else {
                    n2 = this.mMinOffset;
                    n = 4;
                }
            } else {
                n2 = this.mMinOffset;
                n = 4;
            }
            V v2 = v;
            if (this.mViewDragHelper.smoothSlideViewTo(v2, v2.getLeft(), n2)) {
                this.setStateInternal(2);
                ViewCompat.postOnAnimation(v, (Runnable)new SettleRunnable((View)v, n));
            } else {
                this.setStateInternal(n);
            }
            this.mNestedScrolled = false;
            return;
        }
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2) {
        return view == this.mNestedScrollingChildRef.get() && (this.mState != 3 || super.onNestedPreFling(coordinatorLayout, v, view, f, f2));
    }

    public final void setPeekHeight(int n) {
        this.mPeekHeight = Math.max(0, n);
        WeakReference<V> weakReference = this.mViewRef;
        if (weakReference != null && weakReference.get() != null) {
            this.mMinOffset = Math.max(-((View)this.mViewRef.get()).getHeight(), -(((View)this.mViewRef.get()).getHeight() - this.mPeekHeight));
        }
    }

    public final int getPeekHeight() {
        return this.mPeekHeight;
    }

    public void setHideable(boolean bl) {
        this.mHideable = bl;
    }

    public boolean isHideable() {
        return this.mHideable;
    }

    public void setSkipCollapsed(boolean bl) {
        this.mSkipCollapsed = bl;
    }

    public boolean getSkipCollapsed() {
        return this.mSkipCollapsed;
    }

    public void setTopSheetCallback(TopSheetCallback topSheetCallback) {
        this.mCallback = topSheetCallback;
    }

    public final void setState(int n) {
        block11: {
            int n2;
            View view;
            block9: {
                block10: {
                    block8: {
                        if (n == this.mState) {
                            return;
                        }
                        view = this.mViewRef;
                        if (view == null) {
                            if (n == 4 || n == 3 || this.mHideable && n == 5) {
                                this.mState = n;
                            }
                            return;
                        }
                        if ((view = (View)view.get()) == null) {
                            return;
                        }
                        if (n != 4) break block8;
                        n2 = this.mMinOffset;
                        break block9;
                    }
                    if (n != 3) break block10;
                    n2 = this.mMaxOffset;
                    break block9;
                }
                if (!this.mHideable || n != 5) break block11;
                n2 = -view.getHeight();
            }
            TopSheetBehavior topSheetBehavior = this;
            topSheetBehavior.setStateInternal(2);
            View view2 = view;
            if (topSheetBehavior.mViewDragHelper.smoothSlideViewTo(view2, view2.getLeft(), n2)) {
                ViewCompat.postOnAnimation((View)view, (Runnable)new SettleRunnable(view, n));
            }
            return;
        }
        throw new IllegalArgumentException("Illegal state argument: " + n);
    }

    public final int getState() {
        return this.mState;
    }

    protected static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            @RequiresApi(api=24)
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        });
        final int state;

        @RequiresApi(api=24)
        public SavedState(Parcel parcel) {
            this(parcel, null);
        }

        @RequiresApi(api=24)
        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.state = parcel.readInt();
        }

        public SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.state = n;
        }

        public void writeToParcel(Parcel parcel, int n) {
            SavedState savedState = this;
            super.writeToParcel(parcel, n);
            parcel.writeInt(savedState.state);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private final View mView;
        private final int mTargetState;

        SettleRunnable(View view, int n) {
            this.mView = view;
            this.mTargetState = n;
        }

        @Override
        public void run() {
            if (TopSheetBehavior.this.mViewDragHelper != null && TopSheetBehavior.this.mViewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.mView, (Runnable)this);
            } else {
                TopSheetBehavior.this.setStateInternal(this.mTargetState);
            }
        }
    }

    public static abstract class TopSheetCallback {
        public abstract void onStateChanged(@NonNull View var1, int var2);

        public abstract void onSlide(@NonNull View var1, float var2, @Nullable Boolean var3);
    }
}

