/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodePhoto;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class MessagingDao_Impl
implements MessagingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage;
    private final Converters __converters;
    private final EntityInsertionAdapter<ChatMessage> __insertionAdapterOfChatMessage_1;
    private final EntityInsertionAdapter<Chat> __insertionAdapterOfChat;
    private final EntityInsertionAdapter<ChatParticipantCrossRef> __insertionAdapterOfChatParticipantCrossRef;
    private final EntityDeletionOrUpdateAdapter<ChatMessage> __deletionAdapterOfChatMessage;
    private final EntityDeletionOrUpdateAdapter<ChatMessageUpdate> __updateAdapterOfChatMessageUpdateAsChatMessage;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMessages;
    private final SharedSQLiteStatement __preparedStmtOfDeleteChats;

    public MessagingDao_Impl(RoomDatabase roomDatabase) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__converters = new Converters();
        messagingDao_Impl.__db = roomDatabase;
        messagingDao_Impl.__insertionAdapterOfChatMessage = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChatMessage_1 = new EntityInsertionAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatMessage` (`chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                if (chatMessage.getSenderUserId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chatMessage.getSenderUserId());
                }
                Long l2 = object.MessagingDao_Impl.this.__converters.dateToString(chatMessage.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(4, l3);
                }
                if (chatMessage.getText() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, chatMessage.getText());
                }
                if (chatMessage.getType() == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, chatMessage.getType());
                }
                if (chatMessage.getSubtype() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, chatMessage.getSubtype());
                }
                if (chatMessage.getReplyTo() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, chatMessage.getReplyTo());
                }
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessage.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, (String)object);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChat = new EntityInsertionAdapter<Chat>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Chat` (`chatId`,`name`,`ownerId`,`seq`,`readSeq`,`recvSeq`,`updatedAt`,`descUpdatedAt`,`subUpdatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Chat chat) {
                if (chat.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chat.getChatId());
                }
                if (chat.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chat.getName());
                }
                if (chat.getOwnerId() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, chat.getOwnerId());
                }
                long l = chat.getSeq();
                supportSQLiteStatement.bindLong(4, l);
                l = chat.getReadSeq();
                supportSQLiteStatement.bindLong(5, l);
                l = chat.getRecvSeq();
                supportSQLiteStatement.bindLong(6, l);
                Long l2 = l6.MessagingDao_Impl.this.__converters.dateToString(chat.getUpdatedAt());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    long l3 = l2;
                    supportSQLiteStatement.bindLong(7, l3);
                }
                Long l4 = l6.MessagingDao_Impl.this.__converters.dateToString(chat.getDescUpdatedAt());
                if (l4 == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    long l5 = l4;
                    supportSQLiteStatement.bindLong(8, l5);
                }
                Long l6 = l6.MessagingDao_Impl.this.__converters.dateToString(chat.getSubUpdatedAt());
                if (l6 == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    long l7 = l6;
                    supportSQLiteStatement.bindLong(9, l7);
                }
            }
        };
        messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef = new EntityInsertionAdapter<ChatParticipantCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChatParticipantCrossRef` (`chatId`,`chatUserId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatParticipantCrossRef chatParticipantCrossRef) {
                if (chatParticipantCrossRef.getChatId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatParticipantCrossRef.getChatId());
                }
                if (chatParticipantCrossRef.getChatUserId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, chatParticipantCrossRef.getChatUserId());
                }
            }
        };
        messagingDao_Impl.__deletionAdapterOfChatMessage = new EntityDeletionOrUpdateAdapter<ChatMessage>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `ChatMessage` WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessage chatMessage) {
                if (chatMessage.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessage.getTopicId());
                }
                long l = chatMessage.getSeq();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage = new EntityDeletionOrUpdateAdapter<ChatMessageUpdate>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `ChatMessage` SET `chatMessageTopicId` = ?,`chatMessageSeq` = ?,`status` = ? WHERE `chatMessageTopicId` = ? AND `chatMessageSeq` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, ChatMessageUpdate chatMessageUpdate) {
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, chatMessageUpdate.getTopicId());
                }
                long l = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(2, l);
                Object object = object.MessagingDao_Impl.this.__converters.chatStatusToString(chatMessageUpdate.getStatus());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                if (chatMessageUpdate.getTopicId() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, chatMessageUpdate.getTopicId());
                }
                long l2 = chatMessageUpdate.getSeq();
                supportSQLiteStatement.bindLong(5, l2);
            }
        };
        messagingDao_Impl.__preparedStmtOfDeleteMessages = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM ChatMessage WHERE chatMessageTopicId = ? AND status = ?";
            }
        };
        messagingDao_Impl.__preparedStmtOfDeleteChats = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Chat";
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact(ArrayMap<String, TinodeContact> var1_1) {
        block85: {
            var2_2 = var1_1.keySet();
            if (var2_2.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new ArrayMap(999);
                var3_5 = 0;
                var5_10 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                    var2_2 = v1;
                    v1 = new ArrayMap(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)var2_2);
                    var1_1.putAll((Map)var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `chatUserId`,`chatToken`,`chatExpiration`,`chatName`,`online`,`lastFullSync`,`photoBase64`,`privateData`,`externalId`,`fn`,`title`,`data`,`format` FROM `TinodeContact` WHERE `chatUserId` IN (");
            var2_3 = var2_2.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (String var5_11 : var2_2) {
                if (var5_11 == null) {
                    var2_4.bindNull(var3_6);
                } else {
                    var2_4.bindString(var3_6, var5_11);
                }
                ++var3_6;
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
            if (var3_6 != -1) break block85;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        v4 = v3;
        v5 = v3;
        v6 = v3;
        v7 = v3;
        v8 = v3;
        v9 = v3;
        v10 = v3;
        v11 = v3;
        v12 = v3;
        v13 = v3;
        v14 = v3;
        v15 = v3;
        var4_9 = CursorUtil.getColumnIndex((Cursor)v3, (String)"chatUserId");
        var5_12 = CursorUtil.getColumnIndex((Cursor)v13, (String)"chatToken");
        var6_13 = CursorUtil.getColumnIndex((Cursor)v14, (String)"chatExpiration");
        var7_14 = CursorUtil.getColumnIndex((Cursor)v15, (String)"chatName");
        var8_15 = CursorUtil.getColumnIndex((Cursor)v11, (String)"online");
        var9_16 = CursorUtil.getColumnIndex((Cursor)v12, (String)"lastFullSync");
        var10_17 = CursorUtil.getColumnIndex((Cursor)v9, (String)"photoBase64");
        var11_18 = CursorUtil.getColumnIndex((Cursor)v10, (String)"privateData");
        var12_19 = CursorUtil.getColumnIndex((Cursor)v7, (String)"externalId");
        var13_20 = CursorUtil.getColumnIndex((Cursor)v8, (String)"fn");
        var14_21 = CursorUtil.getColumnIndex((Cursor)v5, (String)"title");
        var15_22 = CursorUtil.getColumnIndex((Cursor)v6, (String)"data");
        try {
            var16_23 = CursorUtil.getColumnIndex((Cursor)v4, (String)"format");
        }
        catch (Throwable v19) {
            var2_4.close();
            throw v19;
        }
        while (true) {
            block97: {
                block93: {
                    block96: {
                        block95: {
                            block94: {
                                block92: {
                                    block87: {
                                        block86: {
                                            if (!var2_4.moveToNext()) break;
                                            v16 = var1_1;
                                            var17_24 = var2_4.getString(var3_6);
                                            if (!v16.containsKey((Object)var17_24)) continue;
                                            if (var4_9 != -1) break block86;
                                            var18_25 = null;
                                            break block87;
                                        }
                                        var18_25 = var2_4.getString(var4_9);
                                    }
                                    if (var5_12 == -1) {
                                        var19_26 = null;
                                    } else {
                                        var19_26 = var2_4.getString(var5_12);
                                    }
                                    if (var6_13 == -1) {
                                        var20_27 /* !! */  = null;
                                    } else {
                                        block89: {
                                            block88: {
                                                if (!var2_4.isNull(var6_13)) break block88;
                                                var20_27 /* !! */  = null;
                                                break block89;
                                            }
                                            var20_27 /* !! */  = var2_4.getLong(var6_13);
                                        }
                                        var20_27 /* !! */  = this.__converters.timestampToDate(var20_27 /* !! */ );
                                    }
                                    if (var7_14 == -1) {
                                        var21_28 = null;
                                    } else {
                                        var21_28 = var2_4.getString(var7_14);
                                    }
                                    if (var8_15 == -1) {
                                        while (true) {
                                            var22_29 = false;
                                            break;
                                        }
                                    } else {
                                        if (var2_4.getInt(var8_15) == 0) ** continue;
                                        var22_29 = true;
                                    }
                                    if (var9_16 == -1) {
                                        var23_30 /* !! */  = null;
                                    } else {
                                        block91: {
                                            block90: {
                                                if (!var2_4.isNull(var9_16)) break block90;
                                                var23_30 /* !! */  = null;
                                                break block91;
                                            }
                                            var23_30 /* !! */  = var2_4.getLong(var9_16);
                                        }
                                        var23_30 /* !! */  = this.__converters.timestampToDate(var23_30 /* !! */ );
                                    }
                                    if (var10_17 == -1) {
                                        var24_31 = null;
                                    } else {
                                        var24_31 = var2_4.getString(var10_17);
                                    }
                                    if (var11_18 == -1) {
                                        var25_32 = null;
                                    } else {
                                        var25_32 = var2_4.getString(var11_18);
                                    }
                                    if (var12_19 != -1) {
                                        if (!var2_4.isNull(var12_19)) break block92;
                                    }
                                    if (var13_20 != -1) {
                                        if (!var2_4.isNull(var13_20)) break block92;
                                    }
                                    if (var14_21 != -1) {
                                        if (!var2_4.isNull(var14_21)) break block92;
                                    }
                                    if (var15_22 != -1) {
                                        if (!var2_4.isNull(var15_22)) break block92;
                                    }
                                    if (var16_23 == -1) break block93;
                                    if (var2_4.isNull(var16_23)) break block93;
                                }
                                if (var12_19 == -1) {
                                    var26_33 = null;
                                } else {
                                    var26_33 = var2_4.getString(var12_19);
                                }
                                if (var13_20 == -1) {
                                    var27_34 = null;
                                } else {
                                    var27_34 = var2_4.getString(var13_20);
                                }
                                if (var14_21 == -1) {
                                    var28_35 = null;
                                } else {
                                    var28_35 = var2_4.getString(var14_21);
                                }
                                if (var15_22 != -1) {
                                    if (!var2_4.isNull(var15_22)) break block94;
                                }
                                if (var16_23 == -1) break block95;
                                if (var2_4.isNull(var16_23)) break block95;
                            }
                            if (var15_22 == -1) {
                                var29_36 = null;
                            } else {
                                var29_36 = var2_4.getString(var15_22);
                            }
                            if (var16_23 == -1) {
                                var30_37 = null;
                            } else {
                                var30_37 = var2_4.getString(var16_23);
                            }
                            var31_38 = v17;
                            v17 = new TinodePhoto((String)var29_36, var30_37);
                            break block96;
                        }
                        var31_38 = null;
                    }
                    var29_36 = v18;
                    v18 = new TinodeUserPublic(var26_33, var27_34, var28_35, var31_38);
                    break block97;
                }
                var29_36 = null;
            }
            var1_1.put((Object)var17_24, (Object)new TinodeContact(var18_25, var19_26, (Date)var20_27 /* !! */ , var21_28, var22_29, (Date)var23_30 /* !! */ , var24_31, var25_32, (TinodeUserPublic)var29_36));
        }
        var2_4.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void __fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1(ArrayMap<String, ArrayList<TinodeContact>> var1_1) {
        var2_2 = var1_1.keySet();
        if (var2_2.isEmpty()) {
            return;
        }
        if (var1_1.size() > 999) {
            var2_2 = v0;
            v0 = new ArrayMap(999);
            var3_5 = 0;
            var5_10 = var1_1.size();
            for (var4_7 = 0; var4_7 < var5_10; ++var4_7) {
                var2_2.put(var1_1.keyAt(var4_7), var1_1.valueAt(var4_7));
                if (++var3_5 != 999) continue;
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
                var2_2 = v1;
                v1 = new ArrayMap(999);
                var3_5 = 0;
            }
            if (var3_5 > 0) {
                this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)var2_2);
            }
            return;
        }
        v2 = StringUtil.newStringBuilder();
        v2.append("SELECT `TinodeContact`.`chatUserId` AS `chatUserId`,`TinodeContact`.`chatToken` AS `chatToken`,`TinodeContact`.`chatExpiration` AS `chatExpiration`,`TinodeContact`.`chatName` AS `chatName`,`TinodeContact`.`online` AS `online`,`TinodeContact`.`lastFullSync` AS `lastFullSync`,`TinodeContact`.`photoBase64` AS `photoBase64`,`TinodeContact`.`privateData` AS `privateData`,`TinodeContact`.`externalId` AS `externalId`,`TinodeContact`.`fn` AS `fn`,`TinodeContact`.`title` AS `title`,`TinodeContact`.`data` AS `data`,`TinodeContact`.`format` AS `format`,_junction.`chatId` FROM `ChatParticipantCrossRef` AS _junction INNER JOIN `TinodeContact` ON (_junction.`chatUserId` = `TinodeContact`.`chatUserId`) WHERE _junction.`chatId` IN (");
        var2_3 = var2_2.size();
        StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
        v2.append(")");
        var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
        var3_6 = 1;
        for (String var5_11 : var2_2) {
            if (var5_11 == null) {
                var2_4.bindNull(var3_6);
            } else {
                var2_4.bindString(var3_6, var5_11);
            }
            ++var3_6;
        }
        var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)false, null);
        var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatUserId");
        var4_9 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatToken");
        var5_12 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatExpiration");
        var6_13 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"chatName");
        var7_14 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"online");
        var8_15 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"lastFullSync");
        var9_16 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"photoBase64");
        var10_17 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"privateData");
        var11_18 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"externalId");
        var12_19 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"fn");
        var13_20 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"title");
        var14_21 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"data");
        try {
            var15_22 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"format");
        }
        catch (Throwable v5) {
            var2_4.close();
            throw v5;
        }
        while (true) {
            block94: {
                block90: {
                    block93: {
                        block92: {
                            block91: {
                                block89: {
                                    block84: {
                                        block83: {
                                            if (!var2_4.moveToNext()) break;
                                            var16_23 = (ArrayList)var1_1.get((Object)var2_4.getString(13));
                                            if (var16_23 == null) continue;
                                            if (var3_6 != -1) break block83;
                                            var17_24 = null;
                                            break block84;
                                        }
                                        var17_24 = var2_4.getString(var3_6);
                                    }
                                    if (var4_9 == -1) {
                                        var18_25 = null;
                                    } else {
                                        var18_25 = var2_4.getString(var4_9);
                                    }
                                    if (var5_12 == -1) {
                                        var19_26 /* !! */  = null;
                                    } else {
                                        block86: {
                                            block85: {
                                                if (!var2_4.isNull(var5_12)) break block85;
                                                var19_26 /* !! */  = null;
                                                break block86;
                                            }
                                            var19_26 /* !! */  = var2_4.getLong(var5_12);
                                        }
                                        var19_26 /* !! */  = this.__converters.timestampToDate(var19_26 /* !! */ );
                                    }
                                    if (var6_13 == -1) {
                                        var20_27 = null;
                                    } else {
                                        var20_27 = var2_4.getString(var6_13);
                                    }
                                    if (var7_14 == -1) {
                                        while (true) {
                                            var21_28 = false;
                                            break;
                                        }
                                    } else {
                                        if (var2_4.getInt(var7_14) == 0) ** continue;
                                        var21_28 = true;
                                    }
                                    if (var8_15 == -1) {
                                        var22_29 /* !! */  = null;
                                    } else {
                                        block88: {
                                            block87: {
                                                if (!var2_4.isNull(var8_15)) break block87;
                                                var22_29 /* !! */  = null;
                                                break block88;
                                            }
                                            var22_29 /* !! */  = var2_4.getLong(var8_15);
                                        }
                                        var22_29 /* !! */  = this.__converters.timestampToDate(var22_29 /* !! */ );
                                    }
                                    if (var9_16 == -1) {
                                        var23_30 = null;
                                    } else {
                                        var23_30 = var2_4.getString(var9_16);
                                    }
                                    if (var10_17 == -1) {
                                        var24_31 = null;
                                    } else {
                                        var24_31 = var2_4.getString(var10_17);
                                    }
                                    if (var11_18 != -1) {
                                        if (!var2_4.isNull(var11_18)) break block89;
                                    }
                                    if (var12_19 != -1) {
                                        if (!var2_4.isNull(var12_19)) break block89;
                                    }
                                    if (var13_20 != -1) {
                                        if (!var2_4.isNull(var13_20)) break block89;
                                    }
                                    if (var14_21 != -1) {
                                        if (!var2_4.isNull(var14_21)) break block89;
                                    }
                                    if (var15_22 == -1) break block90;
                                    if (var2_4.isNull(var15_22)) break block90;
                                }
                                if (var11_18 == -1) {
                                    var25_32 = null;
                                } else {
                                    var25_32 = var2_4.getString(var11_18);
                                }
                                if (var12_19 == -1) {
                                    var26_33 = null;
                                } else {
                                    var26_33 = var2_4.getString(var12_19);
                                }
                                if (var13_20 == -1) {
                                    var27_34 = null;
                                } else {
                                    var27_34 = var2_4.getString(var13_20);
                                }
                                if (var14_21 != -1) {
                                    if (!var2_4.isNull(var14_21)) break block91;
                                }
                                if (var15_22 == -1) break block92;
                                if (var2_4.isNull(var15_22)) break block92;
                            }
                            if (var14_21 == -1) {
                                var28_35 = null;
                            } else {
                                var28_35 = var2_4.getString(var14_21);
                            }
                            if (var15_22 == -1) {
                                var29_36 = null;
                            } else {
                                var29_36 = var2_4.getString(var15_22);
                            }
                            var30_37 = v3;
                            v3 = new TinodePhoto((String)var28_35, var29_36);
                            break block93;
                        }
                        var30_37 = null;
                    }
                    var28_35 = v4;
                    v4 = new TinodeUserPublic(var25_32, var26_33, var27_34, var30_37);
                    break block94;
                }
                var28_35 = null;
            }
            var16_23.add(new TinodeContact(var17_24, var18_25, (Date)var19_26 /* !! */ , var20_27, var21_28, (Date)var22_29 /* !! */ , var23_30, var24_31, (TinodeUserPublic)var28_35));
        }
        var2_4.close();
        return;
    }

    private void __fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage(ArrayMap<String, ArrayList<ChatMessage>> arrayMap) {
        int n;
        int n2;
        RoomSQLiteQuery roomSQLiteQuery;
        block50: {
            Set set = arrayMap.keySet();
            if (set.isEmpty()) {
                return;
            }
            if (arrayMap.size() > 999) {
                ArrayMap arrayMap2;
                set = arrayMap2;
                arrayMap2 = new ArrayMap(999);
                int n3 = 0;
                int n4 = arrayMap.size();
                for (int j = 0; j < n4; ++j) {
                    ArrayMap arrayMap3;
                    set.put(arrayMap.keyAt(j), arrayMap.valueAt(j));
                    if (++n3 != 999) continue;
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                    set = arrayMap3;
                    arrayMap3 = new ArrayMap(999);
                    n3 = 0;
                }
                if (n3 > 0) {
                    this.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)set);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `chatMessageTopicId`,`chatMessageSeq`,`senderUserId`,`date`,`text`,`type`,`subtype`,`replyTo`,`status` FROM `ChatMessage` WHERE `chatMessageTopicId` IN (");
            int n5 = set.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n5);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n5 + 0));
            n2 = 1;
            for (String string2 : set) {
                if (string2 == null) {
                    roomSQLiteQuery.bindNull(n2);
                } else {
                    roomSQLiteQuery.bindString(n2, string2);
                }
                ++n2;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"chatMessageTopicId");
            if (n2 != -1) break block50;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"chatMessageTopicId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery8, (String)"chatMessageSeq");
        int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery9, (String)"senderUserId");
        int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery10, (String)"date");
        int n10 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery6, (String)"text");
        int n11 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery7, (String)"type");
        int n12 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"subtype");
        int n13 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery5, (String)"replyTo");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"status");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            Object object;
            String string3;
            String string4;
            String string5;
            String string6;
            Comparable<Long> comparable;
            String string7;
            int n14;
            String string8;
            ArrayList arrayList;
            block52: {
                block51: {
                    if (!roomSQLiteQuery.moveToNext()) break;
                    arrayList = (ArrayList)arrayMap.get((Object)roomSQLiteQuery.getString(n2));
                    if (arrayList == null) continue;
                    if (n6 != -1) break block51;
                    string8 = null;
                    break block52;
                }
                string8 = roomSQLiteQuery.getString(n6);
            }
            if (n7 == -1) {
                n14 = 0;
            } else {
                n14 = roomSQLiteQuery.getInt(n7);
            }
            if (n8 == -1) {
                string7 = null;
            } else {
                string7 = roomSQLiteQuery.getString(n8);
            }
            if (n9 == -1) {
                comparable = null;
            } else {
                block54: {
                    block53: {
                        if (!roomSQLiteQuery.isNull(n9)) break block53;
                        comparable = null;
                        break block54;
                    }
                    comparable = roomSQLiteQuery.getLong(n9);
                }
                comparable = this.__converters.timestampToDate((Long)comparable);
            }
            if (n10 == -1) {
                string6 = null;
            } else {
                string6 = roomSQLiteQuery.getString(n10);
            }
            if (n11 == -1) {
                string5 = null;
            } else {
                string5 = roomSQLiteQuery.getString(n11);
            }
            if (n12 == -1) {
                string4 = null;
            } else {
                string4 = roomSQLiteQuery.getString(n12);
            }
            if (n13 == -1) {
                string3 = null;
            } else {
                string3 = roomSQLiteQuery.getString(n13);
            }
            if (n == -1) {
                object = null;
            } else {
                MessagingDao_Impl messagingDao_Impl = this;
                object = roomSQLiteQuery.getString(n);
                object = messagingDao_Impl.__converters.stringToChatStatus((String)object);
            }
            arrayList.add(new ChatMessage(string8, n14, string7, (Date)comparable, string6, string5, string4, string3, (ChatMessageStatus)((Object)object)));
        }
        roomSQLiteQuery.close();
        return;
    }

    static /* synthetic */ void access$300(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact_1((ArrayMap<String, ArrayList<TinodeContact>>)arrayMap);
    }

    static /* synthetic */ void access$400(MessagingDao_Impl messagingDao_Impl, ArrayMap arrayMap) {
        messagingDao_Impl.__fetchRelationshipChatMessageAsioStreamlayerSdkModelMessagingChatMessage((ArrayMap<String, ArrayList<ChatMessage>>)arrayMap);
    }

    @Override
    public long saveChatMessage(ChatMessage chatMessage) {
        long l;
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            l = messagingDao_Impl.__insertionAdapterOfChatMessage.insertAndReturnId((Object)chatMessage);
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.setTransactionSuccessful();
            messagingDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public void saveChatMessages(List<ChatMessage> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatMessage_1.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChat.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipantCrossRefs(List<ChatParticipantCrossRef> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__insertionAdapterOfChatParticipantCrossRef.insert(list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteChatMessage(ChatMessage chatMessage) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__deletionAdapterOfChatMessage.handle((Object)chatMessage);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateChatMessage(ChatMessageUpdate chatMessageUpdate) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        messagingDao_Impl.__db.beginTransaction();
        try {
            messagingDao_Impl.__updateAdapterOfChatMessageUpdateAsChatMessage.handle((Object)chatMessageUpdate);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChats(List<Chat> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChats(messagingDao_Impl, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveChatParticipants(String string2, List<TinodeContact> list) {
        MessagingDao_Impl messagingDao_Impl = this;
        this.__db.beginTransaction();
        try {
            MessagingDao.DefaultImpls.saveChatParticipants(messagingDao_Impl, string2, list);
            messagingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        messagingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteMessages(String string2, ChatMessageStatus object) {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteMessages.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        int n2 = 2;
        object = this.__converters.chatStatusToString((ChatMessageStatus)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n2);
        } else {
            supportSQLiteStatement.bindString(n2, (String)object);
        }
        MessagingDao_Impl messagingDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl3 = this;
            messagingDao_Impl3.__db.endTransaction();
            messagingDao_Impl3.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl2.__db.setTransactionSuccessful();
        messagingDao_Impl2.__db.endTransaction();
        messagingDao_Impl2.__preparedStmtOfDeleteMessages.release(supportSQLiteStatement);
    }

    @Override
    public void deleteChats() {
        MessagingDao_Impl messagingDao_Impl = this;
        messagingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = messagingDao_Impl.__preparedStmtOfDeleteChats.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            MessagingDao_Impl messagingDao_Impl2 = this;
            messagingDao_Impl2.__db.endTransaction();
            messagingDao_Impl2.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
            throw throwable;
        }
        messagingDao_Impl.__db.setTransactionSuccessful();
        messagingDao_Impl.__db.endTransaction();
        messagingDao_Impl.__preparedStmtOfDeleteChats.release(supportSQLiteStatement);
    }

    @Override
    public Maybe<Integer> getLastSeqId(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return Maybe.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer n;
                block5: {
                    block4: {
                        9 this_ = DBUtil.query((RoomDatabase)this_.MessagingDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                        try {
                            if (!this_.moveToFirst()) break block4;
                        }
                        catch (Throwable throwable) {
                            this_.close();
                            throw throwable;
                        }
                        if (this_.isNull(0)) break block4;
                        n = this_.getInt(0);
                        break block5;
                    }
                    n = null;
                }
                this_.close();
                return n;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        });
    }

    @Override
    public Observable<ChatMessageRelation> getChatMessageRelation(String string2, int n) {
        Callable<ChatMessageRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND ChatMessage.chatMessageSeq = ?", (int)2);
        int n2 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, string2);
        }
        long l = n;
        roomSQLiteQuery.bindLong(2, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        Callable<ChatMessageRelation> callable2 = callable;
        callable = new Callable<ChatMessageRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatMessageRelation call() throws Exception {
                block50: {
                    block46: {
                        block49: {
                            block48: {
                                block47: {
                                    v0 = this;
                                    MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                    var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                                    var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                                    var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                                    var5_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                                    var6_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                                    var7_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                                    var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                                    var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                                    var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                    var11_19 = v1;
                                    v1 = new ArrayMap();
                                    ** while (var1_1.moveToNext())
lbl-1000:
                                    // 1 sources

                                    {
                                        var11_19.put((Object)var1_1.getString(var4_6), null);
                                        continue;
                                    }
lbl32:
                                    // 2 sources

                                    v2 = var1_1;
                                    v3 = this;
                                    var1_1.moveToPosition(-1);
                                    MessagingDao_Impl.access$200(v3.MessagingDao_Impl.this, var11_19);
                                    if (!v2.moveToFirst()) break block46;
                                    if (!var1_1.isNull(var2_2)) break block47;
                                    if (!var1_1.isNull(var3_4)) break block47;
                                    if (!var1_1.isNull(var4_6)) break block47;
                                    if (!var1_1.isNull(var5_7)) break block47;
                                    if (!var1_1.isNull(var6_9)) break block47;
                                    if (!var1_1.isNull(var7_11)) break block47;
                                    if (!var1_1.isNull(var8_13)) break block47;
                                    if (!var1_1.isNull(var9_15)) break block47;
                                    if (!var1_1.isNull(var10_17)) break block47;
                                    var13_20 = var2_3 = null;
                                    ** GOTO lbl108
                                }
                                v4 = var1_1;
                                v5 = var5_7;
                                v6 = var1_1;
                                v7 = var4_6;
                                v8 = var1_1;
                                v9 = var3_4;
                                var2_3 = var1_1.getString(var2_2);
                                var3_4 = v8.getInt(v9);
                                var12_21 = v6.getString(v7);
                                if (!v4.isNull(v5)) break block48;
                                var5_8 /* !! */  = null;
                                break block49;
                            }
                            var5_8 /* !! */  = var1_1.getLong(var5_7);
                        }
                        v10 = this;
                        v11 = var1_1;
                        v12 = var10_17;
                        v13 = var1_1;
                        v14 = var9_15;
                        v15 = var1_1;
                        v16 = var8_13;
                        v17 = var1_1;
                        v18 = var7_11;
                        v19 = var1_1;
                        v20 = var6_9;
                        var5_8 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var5_8 /* !! */ );
                        var6_10 = v19.getString(v20);
                        var7_12 = v17.getString(v18);
                        var8_14 = v15.getString(v16);
                        var9_16 = v13.getString(v14);
                        var10_18 /* !! */  = v11.getString(v12);
                        var10_18 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var10_18 /* !! */ );
                        var13_20 = v21;
                        v21 = new ChatMessage((String)var2_3, var3_4, var12_21, (Date)var5_8 /* !! */ , var6_10, var7_12, var8_14, var9_16, (ChatMessageStatus)var10_18 /* !! */ );
lbl108:
                        // 2 sources

                        var2_3 = (TinodeContact)var11_19.get((Object)var1_1.getString(var4_6));
                        var3_5 = v22;
                        v22 = new ChatMessageRelation((ChatMessage)var13_20, (TinodeContact)var2_3);
                        break block50;
                    }
                    var3_5 = null;
                }
                v23 = var3_5;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable v27) {
                    var1_1.close();
                    throw v27;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(String string2) {
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? ORDER BY ChatMessage.chatMessageSeq DESC", (int)1);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        return new DataSource.Factory<Integer, ChatMessageRelation>(){

            public LimitOffsetDataSource<ChatMessageRelation> create() {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "TinodeContact";
                stringArray[1] = "ChatMessage";
                return new LimitOffsetDataSource<ChatMessageRelation>(stringArray2.MessagingDao_Impl.this.__db, stringArray2.roomSQLiteQuery, true, stringArray2){

                    protected List<ChatMessageRelation> convertRows(Cursor cursor) {
                        ArrayList<ChatMessageRelation> arrayList;
                        ArrayMap arrayMap;
                        Cursor cursor2 = cursor;
                        int n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageTopicId");
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"chatMessageSeq");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"senderUserId");
                        int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                        int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"text");
                        int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"type");
                        int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"subtype");
                        int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"replyTo");
                        int n9 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"status");
                        ArrayMap arrayMap2 = arrayMap;
                        arrayMap = new ArrayMap();
                        while (cursor.moveToNext()) {
                            arrayMap2.put((Object)cursor.getString(n3), null);
                        }
                        cursor.moveToPosition(-1);
                        MessagingDao_Impl.this.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)arrayMap2);
                        ArrayList<ChatMessageRelation> arrayList2 = arrayList;
                        arrayList = new ArrayList<ChatMessageRelation>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            Object object;
                            Object object2;
                            if (cursor.isNull(n) && cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9)) {
                                object = object2 = null;
                            } else {
                                ChatMessage chatMessage;
                                object2 = cursor.getString(n);
                                int n10 = cursor.getInt(n2);
                                String string2 = cursor.getString(n3);
                                Comparable<Long> comparable = cursor.isNull(n4) ? null : Long.valueOf(cursor.getLong(n4));
                                comparable = MessagingDao_Impl.this.__converters.timestampToDate((Long)comparable);
                                String string3 = cursor.getString(n5);
                                String string4 = cursor.getString(n6);
                                String string5 = cursor.getString(n7);
                                String string6 = cursor.getString(n8);
                                Object object3 = cursor.getString(n9);
                                object3 = MessagingDao_Impl.this.__converters.stringToChatStatus((String)object3);
                                object = chatMessage;
                                chatMessage = new ChatMessage((String)object2, n10, string2, (Date)comparable, string3, string4, string5, string6, (ChatMessageStatus)((Object)object3));
                            }
                            object2 = (TinodeContact)arrayMap2.get((Object)cursor.getString(n3));
                            arrayList2.add(new ChatMessageRelation((ChatMessage)object, (TinodeContact)object2));
                        }
                        return arrayList2;
                    }
                };
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public List<ChatMessageRelation> getChatMessagesRelationList(String var1_1, Integer var2_5, Integer var3_7, int var4_9) {
        var5_10 = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        var6_11 = 1;
        if (var1_1 == null) {
            var5_10.bindNull(var6_11);
        } else {
            var5_10.bindString(var6_11, var1_1);
        }
        var1_2 = 2;
        if (var2_5 == null) {
            var5_10.bindNull(var1_2);
        } else {
            var5_10.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 3;
        if (var2_5 == null) {
            var5_10.bindNull(var1_2);
        } else {
            var5_10.bindLong(var1_2, (long)var2_5.intValue());
        }
        var1_2 = 4;
        if (var3_7 == null) {
            var5_10.bindNull(var1_2);
        } else {
            var5_10.bindLong(var1_2, (long)var3_7.intValue());
        }
        var1_2 = 5;
        if (var3_7 == null) {
            var5_10.bindNull(var1_2);
        } else {
            var5_10.bindLong(var1_2, (long)var3_7.intValue());
        }
        v0 = this;
        var1_3 = var4_9;
        var5_10.bindLong(6, var1_3);
        v0.__db.assertNotSuspendingTransaction();
        v0.__db.beginTransaction();
        var1_4 = DBUtil.query((RoomDatabase)v0.__db, (SupportSQLiteQuery)var5_10, (boolean)true, null);
        var2_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageTopicId");
        var3_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"chatMessageSeq");
        var4_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"senderUserId");
        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"date");
        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"text");
        var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"type");
        var9_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"subtype");
        var10_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"replyTo");
        var11_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_4, (String)"status");
        var12_17 = v1;
        v1 = new ArrayMap();
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            var12_17.put((Object)var1_4.getString(var4_9), null);
            continue;
        }
lbl61:
        // 2 sources

        v2 = this;
        v3 = var12_17;
        var1_4.moveToPosition(-1);
        v2.__fetchRelationshipTinodeContactAsioStreamlayerSdkModelTinodecontactTinodeContact((ArrayMap<String, TinodeContact>)v3);
        var13_18 = v4;
        v4 = new ArrayList<ChatMessageRelation>(var1_4.getCount());
        ** while (var1_4.moveToNext())
lbl-1000:
        // 1 sources

        {
            block59: {
                block58: {
                    block57: {
                        if (!var1_4.isNull(var2_6)) break block57;
                        if (!var1_4.isNull(var3_8)) break block57;
                        if (!var1_4.isNull(var4_9)) break block57;
                        if (!var1_4.isNull(var6_11)) break block57;
                        if (!var1_4.isNull(var7_12)) break block57;
                        if (!var1_4.isNull(var8_13)) break block57;
                        if (!var1_4.isNull(var9_14)) break block57;
                        if (!var1_4.isNull(var10_15)) break block57;
                        if (!var1_4.isNull(var11_16)) break block57;
                        var23_28 = var14_19 = null;
                        ** GOTO lbl140
                    }
                    v5 = var1_4;
                    v6 = var6_11;
                    v7 = var1_4;
                    v8 = var4_9;
                    v9 = var1_4;
                    v10 = var3_8;
                    var14_19 = var1_4.getString(var2_6);
                    var15_20 = v9.getInt(v10);
                    var16_21 = v7.getString(v8);
                    if (!v5.isNull(v6)) break block58;
                    var17_22 /* !! */  = null;
                    break block59;
                }
                var17_22 /* !! */  = var1_4.getLong(var6_11);
            }
            v11 = this;
            v12 = var1_4;
            v13 = var11_16;
            v14 = var1_4;
            v15 = var10_15;
            v16 = var1_4;
            v17 = var9_14;
            v18 = var1_4;
            v19 = var8_13;
            v20 = var1_4;
            v21 = var7_12;
            var17_22 /* !! */  = this.__converters.timestampToDate(var17_22 /* !! */ );
            var18_23 = v20.getString(v21);
            var19_24 = v18.getString(v19);
            var20_25 = v16.getString(v17);
            var21_26 = v14.getString(v15);
            var22_27 /* !! */  = v12.getString(v13);
            var22_27 /* !! */  = v11.__converters.stringToChatStatus(var22_27 /* !! */ );
            var23_28 = v22;
            v22 = new ChatMessage((String)var14_19, var15_20, var16_21, (Date)var17_22 /* !! */ , var18_23, var19_24, var20_25, var21_26, (ChatMessageStatus)var22_27 /* !! */ );
lbl140:
            // 2 sources

            v23 = var13_18;
            var14_19 = (TinodeContact)var12_17.get((Object)var1_4.getString(var4_9));
            v23.add(new ChatMessageRelation((ChatMessage)var23_28, (TinodeContact)var14_19));
            continue;
        }
lbl147:
        // 2 sources

        v24 = var13_18;
        v25 = this;
        v26 = var5_10;
        v27 = var1_4;
        this.__db.setTransactionSuccessful();
        v27.close();
        v26.release();
        {
            catch (Throwable v28) {
                this.__db.endTransaction();
                throw v28;
            }
        }
        v25.__db.endTransaction();
        return v24;
        catch (Throwable v29) {
            var1_4.close();
            var5_10.release();
            throw v29;
        }
    }

    @Override
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(String string2, Integer object, Integer n, int n2) {
        Callable<List<ChatMessageRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = ? AND (chatMessageSeq < ? OR ? IS NULL) AND (chatMessageSeq >= ? OR ? IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT ?", (int)6);
        int n3 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindString(n3, string2);
        }
        int n4 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 3;
        if (object == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)((Integer)object).intValue());
        }
        n4 = 4;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        n4 = 5;
        if (n == null) {
            roomSQLiteQuery.bindNull(n4);
        } else {
            roomSQLiteQuery.bindLong(n4, (long)n.intValue());
        }
        long l = n2;
        roomSQLiteQuery.bindLong(6, l);
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "TinodeContact";
        stringArray[1] = "ChatMessage";
        object = callable;
        callable = new Callable<List<ChatMessageRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatMessageRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageTopicId");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatMessageSeq");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"senderUserId");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subtype");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"replyTo");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                var11_11 = v1;
                v1 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    var11_11.put((Object)var1_1.getString(var4_4), null);
                    continue;
                }
lbl32:
                // 2 sources

                v2 = this;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$200(v2.MessagingDao_Impl.this, var11_11);
                var12_12 = v3;
                v3 = new ArrayList<ChatMessageRelation>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block49: {
                        block48: {
                            block47: {
                                if (!var1_1.isNull(var2_2)) break block47;
                                if (!var1_1.isNull(var3_3)) break block47;
                                if (!var1_1.isNull(var4_4)) break block47;
                                if (!var1_1.isNull(var5_5)) break block47;
                                if (!var1_1.isNull(var6_6)) break block47;
                                if (!var1_1.isNull(var7_7)) break block47;
                                if (!var1_1.isNull(var8_8)) break block47;
                                if (!var1_1.isNull(var9_9)) break block47;
                                if (!var1_1.isNull(var10_10)) break block47;
                                var22_22 = var13_13 = null;
                                ** GOTO lbl110
                            }
                            v4 = var1_1;
                            v5 = var5_5;
                            v6 = var1_1;
                            v7 = var4_4;
                            v8 = var1_1;
                            v9 = var3_3;
                            var13_13 = var1_1.getString(var2_2);
                            var14_14 = v8.getInt(v9);
                            var15_15 = v6.getString(v7);
                            if (!v4.isNull(v5)) break block48;
                            var16_16 /* !! */  = null;
                            break block49;
                        }
                        var16_16 /* !! */  = var1_1.getLong(var5_5);
                    }
                    v10 = this;
                    v11 = var1_1;
                    v12 = var10_10;
                    v13 = var1_1;
                    v14 = var9_9;
                    v15 = var1_1;
                    v16 = var8_8;
                    v17 = var1_1;
                    v18 = var7_7;
                    v19 = var1_1;
                    v20 = var6_6;
                    var16_16 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var16_16 /* !! */ );
                    var17_17 = v19.getString(v20);
                    var18_18 = v17.getString(v18);
                    var19_19 = v15.getString(v16);
                    var20_20 = v13.getString(v14);
                    var21_21 /* !! */  = v11.getString(v12);
                    var21_21 /* !! */  = MessagingDao_Impl.access$000(v10.MessagingDao_Impl.this).stringToChatStatus(var21_21 /* !! */ );
                    var22_22 = v21;
                    v21 = new ChatMessage((String)var13_13, var14_14, var15_15, (Date)var16_16 /* !! */ , var17_17, var18_18, var19_19, var20_20, (ChatMessageStatus)var21_21 /* !! */ );
lbl110:
                    // 2 sources

                    v22 = var12_12;
                    var13_13 = (TinodeContact)var11_11.get((Object)var1_1.getString(var4_4));
                    v22.add(new ChatMessageRelation((ChatMessage)var22_22, (TinodeContact)var13_13));
                    continue;
                }
lbl117:
                // 2 sources

                v23 = var12_12;
                v24 = this;
                v25 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v25.close();
                {
                    catch (Throwable v26) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v26;
                    }
                }
                MessagingDao_Impl.access$100(v24.MessagingDao_Impl.this).endTransaction();
                return v23;
                catch (Throwable v27) {
                    var1_1.close();
                    throw v27;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Observable<List<ChatRelation>> getChatsRelation() {
        Callable<List<ChatRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat ORDER BY Chat.updatedAt DESC", (int)0);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "ChatParticipantCrossRef";
        stringArray[1] = "TinodeContact";
        stringArray[2] = "ChatMessage";
        stringArray[3] = "Chat";
        Callable<List<ChatRelation>> callable2 = callable;
        callable = new Callable<List<ChatRelation>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<ChatRelation> call() throws Exception {
                v0 = this;
                MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"ownerId");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"descUpdatedAt");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subUpdatedAt");
                var11_11 = v1;
                v1 = new ArrayMap();
                var12_12 = v2;
                v2 = new ArrayMap();
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block59: {
                        v3 = var11_11;
                        var13_13 = var1_1.getString(var2_2);
                        if ((ArrayList)v3.get(var13_13) != null) break block59;
                        var11_11.put(var13_13, new ArrayList<E>());
                    }
                    v4 = var12_12;
                    var13_13 = var1_1.getString(var2_2);
                    if ((ArrayList)v4.get(var13_13) != null) continue;
                    var12_12.put(var13_13, new ArrayList<E>());
                    continue;
                }
lbl49:
                // 2 sources

                v5 = this;
                v6 = v5;
                v7 = v5;
                var1_1.moveToPosition(-1);
                MessagingDao_Impl.access$300(v6.MessagingDao_Impl.this, var11_11);
                MessagingDao_Impl.access$400(v7.MessagingDao_Impl.this, var12_12);
                var13_13 = v8;
                v8 = new ArrayList<E>(var1_1.getCount());
                ** while (var1_1.moveToNext())
lbl-1000:
                // 1 sources

                {
                    block66: {
                        block65: {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            block60: {
                                                if (!var1_1.isNull(var2_2)) break block60;
                                                if (!var1_1.isNull(var3_3)) break block60;
                                                if (!var1_1.isNull(var4_4)) break block60;
                                                if (!var1_1.isNull(var5_5)) break block60;
                                                if (!var1_1.isNull(var6_6)) break block60;
                                                if (!var1_1.isNull(var7_7)) break block60;
                                                if (!var1_1.isNull(var8_8)) break block60;
                                                if (!var1_1.isNull(var9_9)) break block60;
                                                if (!var1_1.isNull(var10_10)) break block60;
                                                var23_23 = var14_14 = null;
                                                ** GOTO lbl143
                                            }
                                            v9 = var1_1;
                                            v10 = var8_8;
                                            v11 = var1_1;
                                            v12 = var7_7;
                                            v13 = var1_1;
                                            v14 = var6_6;
                                            v15 = var1_1;
                                            v16 = var5_5;
                                            v17 = var1_1;
                                            v18 = var4_4;
                                            v19 = var1_1;
                                            v20 = var3_3;
                                            var14_14 = var1_1.getString(var2_2);
                                            var15_15 = v19.getString(v20);
                                            var16_16 = v17.getString(v18);
                                            var17_17 = v15.getInt(v16);
                                            var18_18 = v13.getInt(v14);
                                            var19_19 = v11.getInt(v12);
                                            if (!v9.isNull(v10)) break block61;
                                            var20_20 /* !! */  = null;
                                            break block62;
                                        }
                                        var20_20 /* !! */  = var1_1.getLong(var8_8);
                                    }
                                    v21 = var1_1;
                                    v22 = var9_9;
                                    var20_20 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var20_20 /* !! */ );
                                    if (!v21.isNull(v22)) break block63;
                                    var21_21 /* !! */  = null;
                                    break block64;
                                }
                                var21_21 /* !! */  = var1_1.getLong(var9_9);
                            }
                            v23 = var1_1;
                            v24 = var10_10;
                            var21_21 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var21_21 /* !! */ );
                            if (!v23.isNull(v24)) break block65;
                            var22_22 /* !! */  = null;
                            break block66;
                        }
                        var22_22 /* !! */  = var1_1.getLong(var10_10);
                    }
                    var22_22 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var22_22 /* !! */ );
                    var23_23 = v25;
                    v25 = new Chat((String)var14_14, (String)var15_15, var16_16, var17_17, var18_18, var19_19, (Date)var20_20 /* !! */ , (Date)var21_21 /* !! */ , (Date)var22_22 /* !! */ );
lbl143:
                    // 2 sources

                    var14_14 = (ArrayList)var11_11.get((Object)var1_1.getString(var2_2));
                    if (var14_14 != null) ** GOTO lbl148
                    var14_14 = v26;
                    v26 = new ArrayList<E>();
lbl148:
                    // 2 sources

                    if ((var15_15 = (ArrayList)var12_12.get((Object)var1_1.getString(var2_2))) != null) ** GOTO lbl152
                    var15_15 = v27;
                    v27 = new ArrayList<E>();
lbl152:
                    // 2 sources

                    var13_13.add(new ChatRelation((Chat)var23_23, (List<TinodeContact>)var14_14, (List<ChatMessage>)var15_15));
                    continue;
                }
lbl156:
                // 2 sources

                v28 = var13_13;
                v29 = this;
                v30 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v30.close();
                {
                    catch (Throwable v31) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v31;
                    }
                }
                MessagingDao_Impl.access$100(v29.MessagingDao_Impl.this).endTransaction();
                return v28;
                catch (Throwable v32) {
                    var1_1.close();
                    throw v32;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<ChatRelation> getChatRelation(String stringArray) {
        Callable<ChatRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Chat WHERE Chat.chatId = ?", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[4];
        stringArray = stringArray2;
        stringArray2[0] = "ChatParticipantCrossRef";
        stringArray2[1] = "TinodeContact";
        stringArray2[2] = "ChatMessage";
        stringArray2[3] = "Chat";
        Callable<ChatRelation> callable2 = callable;
        callable = new Callable<ChatRelation>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public ChatRelation call() throws Exception {
                block68: {
                    block59: {
                        block67: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        v0 = this;
                                                        MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this).beginTransaction();
                                                        var1_1 = DBUtil.query((RoomDatabase)MessagingDao_Impl.access$100(v0.MessagingDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                                                        var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"chatId");
                                                        var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"name");
                                                        var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"ownerId");
                                                        var5_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"seq");
                                                        var6_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"readSeq");
                                                        var7_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"recvSeq");
                                                        var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"updatedAt");
                                                        var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"descUpdatedAt");
                                                        var10_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"subUpdatedAt");
                                                        var11_19 = v1;
                                                        v1 = new ArrayMap();
                                                        var12_20 = v2;
                                                        v2 = new ArrayMap();
                                                        ** while (var1_1.moveToNext())
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            block58: {
                                                                v3 = var11_19;
                                                                var13_21 = var1_1.getString(var2_2);
                                                                if ((ArrayList)v3.get((Object)var13_21) != null) break block58;
                                                                var11_19.put((Object)var13_21, new ArrayList<E>());
                                                            }
                                                            v4 = var12_20;
                                                            var13_21 = var1_1.getString(var2_2);
                                                            if ((ArrayList)v4.get((Object)var13_21) != null) continue;
                                                            var12_20.put((Object)var13_21, new ArrayList<E>());
                                                            continue;
                                                        }
lbl49:
                                                        // 2 sources

                                                        v5 = var1_1;
                                                        v6 = this;
                                                        v7 = v6;
                                                        v8 = v6;
                                                        var1_1.moveToPosition(-1);
                                                        MessagingDao_Impl.access$300(v7.MessagingDao_Impl.this, var11_19);
                                                        MessagingDao_Impl.access$400(v8.MessagingDao_Impl.this, var12_20);
                                                        if (!v5.moveToFirst()) break block59;
                                                        if (!var1_1.isNull(var2_2)) break block60;
                                                        if (!var1_1.isNull(var3_4)) break block60;
                                                        if (!var1_1.isNull(var4_6)) break block60;
                                                        if (!var1_1.isNull(var5_9)) break block60;
                                                        if (!var1_1.isNull(var6_11)) break block60;
                                                        if (!var1_1.isNull(var7_12)) break block60;
                                                        if (!var1_1.isNull(var8_13)) break block60;
                                                        if (!var1_1.isNull(var9_15)) break block60;
                                                        if (!var1_1.isNull(var10_17)) break block60;
                                                        var14_23 = var3_5 = null;
                                                        ** GOTO lbl141
                                                    }
                                                    v9 = var1_1;
                                                    v10 = var8_13;
                                                    v11 = var1_1;
                                                    v12 = var7_12;
                                                    v13 = var1_1;
                                                    v14 = var6_11;
                                                    v15 = var1_1;
                                                    v16 = var5_9;
                                                    v17 = var1_1;
                                                    v18 = var4_6;
                                                    v19 = var1_1;
                                                    v20 = var3_4;
                                                    var3_5 = var1_1.getString(var2_2);
                                                    var4_7 = v19.getString(v20);
                                                    var5_10 = v17.getString(v18);
                                                    var6_11 = v15.getInt(v16);
                                                    var7_12 = v13.getInt(v14);
                                                    var13_22 = v11.getInt(v12);
                                                    if (!v9.isNull(v10)) break block61;
                                                    var8_14 /* !! */  = null;
                                                    break block62;
                                                }
                                                var8_14 /* !! */  = var1_1.getLong(var8_13);
                                            }
                                            v21 = var1_1;
                                            v22 = var9_15;
                                            var8_14 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var8_14 /* !! */ );
                                            if (!v21.isNull(v22)) break block63;
                                            var9_16 /* !! */  = null;
                                            break block64;
                                        }
                                        var9_16 /* !! */  = var1_1.getLong(var9_15);
                                    }
                                    v23 = var1_1;
                                    v24 = var10_17;
                                    var9_16 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var9_16 /* !! */ );
                                    if (!v23.isNull(v24)) break block65;
                                    var10_18 /* !! */  = null;
                                    break block66;
                                }
                                var10_18 /* !! */  = var1_1.getLong(var10_17);
                            }
                            var10_18 /* !! */  = MessagingDao_Impl.access$000(MessagingDao_Impl.this).timestampToDate(var10_18 /* !! */ );
                            var14_23 = v25;
                            v25 = new Chat((String)var3_5, var4_7, var5_10, var6_11, var7_12, var13_22, (Date)var8_14 /* !! */ , (Date)var9_16 /* !! */ , (Date)var10_18 /* !! */ );
lbl141:
                            // 2 sources

                            var3_5 = (ArrayList)var11_19.get((Object)var1_1.getString(var2_2));
                            if (var3_5 != null) ** GOTO lbl146
                            var3_5 = v26;
                            v26 = new ArrayList<E>();
lbl146:
                            // 2 sources

                            if ((var2_3 = (ArrayList)var12_20.get((Object)var1_1.getString(var2_2))) != null) break block67;
                            var2_3 = v27;
                            v27 = new ArrayList<E>();
                        }
                        var4_8 = v28;
                        v28 = new ChatRelation((Chat)var14_23, (List<TinodeContact>)var3_5, var2_3);
                        break block68;
                    }
                    var4_8 = null;
                }
                v29 = var4_8;
                v30 = this;
                v31 = var1_1;
                MessagingDao_Impl.access$100(MessagingDao_Impl.this).setTransactionSuccessful();
                v31.close();
                {
                    catch (Throwable v32) {
                        MessagingDao_Impl.access$100(MessagingDao_Impl.this).endTransaction();
                        throw v32;
                    }
                }
                MessagingDao_Impl.access$100(v30.MessagingDao_Impl.this).endTransaction();
                return v29;
                catch (Throwable v33) {
                    var1_1.close();
                    throw v33;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        MessagingDao.DefaultImpls.saveOrUpdateChatMessage(this, chatMessage);
    }

    @Override
    public Observable<ChatMessage> getChatMessage(String string2, int n) {
        return MessagingDao.DefaultImpls.getChatMessage(this, string2, n);
    }

    @Override
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(String string2) {
        return MessagingDao.DefaultImpls.getChatMessagesLiveData(this, string2);
    }

    @Override
    public List<ChatMessage> getChatMessagesList(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessagesList(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<ChatMessage>> getChatMessages(String string2, Integer n, Integer n2, int n3) {
        return MessagingDao.DefaultImpls.getChatMessages(this, string2, n, n2, n3);
    }

    @Override
    public Observable<List<Chat>> getChats() {
        return MessagingDao.DefaultImpls.getChats(this);
    }

    @Override
    public Observable<Chat> getChat(String string2) {
        return MessagingDao.DefaultImpls.getChat(this, string2);
    }
}

