/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.repository.notifications.NotificationDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class NotificationDao_Impl
implements NotificationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Notification> __insertionAdapterOfNotification;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<Notification> __deletionAdapterOfNotification;
    private final EntityDeletionOrUpdateAdapter<Notification> __updateAdapterOfNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllNotifications;

    public NotificationDao_Impl(RoomDatabase roomDatabase) {
        NotificationDao_Impl notificationDao_Impl = this;
        this.__converters = new Converters();
        notificationDao_Impl.__db = roomDatabase;
        notificationDao_Impl.__insertionAdapterOfNotification = new EntityInsertionAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `Notification` (`dataJson`,`id`,`title`,`description`,`_type`,`date`,`sourceUniqueId`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                long l;
                if (notification.getDataJson() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, notification.getDataJson());
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    l = notification.getId();
                    supportSQLiteStatement.bindLong(2, l);
                }
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notification.getDescription());
                }
                if (notification.get_type() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, notification.get_type());
                }
                Long l2 = l2.NotificationDao_Impl.this.__converters.dateToString(notification.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    l = l2;
                    supportSQLiteStatement.bindLong(6, l);
                }
                if (notification.getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, notification.getSourceUniqueId());
                }
            }
        };
        notificationDao_Impl.__deletionAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `Notification` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
            }
        };
        notificationDao_Impl.__updateAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `Notification` SET `dataJson` = ?,`id` = ?,`title` = ?,`description` = ?,`_type` = ?,`date` = ?,`sourceUniqueId` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                long l;
                if (notification.getDataJson() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, notification.getDataJson());
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    l = notification.getId();
                    supportSQLiteStatement.bindLong(2, l);
                }
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notification.getDescription());
                }
                if (notification.get_type() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, notification.get_type());
                }
                Long l2 = l2.NotificationDao_Impl.this.__converters.dateToString(notification.getDate());
                if (l2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    l = l2;
                    supportSQLiteStatement.bindLong(6, l);
                }
                if (notification.getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, notification.getSourceUniqueId());
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    long l3 = notification.getId();
                    supportSQLiteStatement.bindLong(8, l3);
                }
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteNotification = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification WHERE id = ?";
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteAllNotifications = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification";
            }
        };
    }

    @Override
    public void saveNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__insertionAdapterOfNotification.insert(list);
            notificationDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public Completable deleteNotifications(final List<Notification> list) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                6 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handleMultiple((Iterable)list);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                return null;
            }
        });
    }

    @Override
    public Completable deleteNotification(final Notification notification) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                7 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handle((Object)notification);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                return null;
            }
        });
    }

    @Override
    public void updateNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__updateAdapterOfNotification.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public Completable deleteNotification(final long l) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                8 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.acquire();
                long l2 = l;
                supportSQLiteStatement.bindLong(1, l2);
                NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    8 v2 = this;
                    v2.NotificationDao_Impl.this.__db.endTransaction();
                    v2.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                return null;
            }
        });
    }

    @Override
    public Completable deleteAllNotifications() {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                9 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.acquire();
                NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    9 v2 = this;
                    v2.NotificationDao_Impl.this.__db.endTransaction();
                    v2.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                v0.NotificationDao_Impl.this.__preparedStmtOfDeleteAllNotifications.release(supportSQLiteStatement);
                return null;
            }
        });
    }

    @Override
    public Observable<List<Notification>> getNotifications() {
        Callable<List<Notification>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Notification";
        Callable<List<Notification>> callable2 = callable;
        callable = new Callable<List<Notification>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<Notification> call() throws Exception {
                int n;
                Cursor cursor;
                ArrayList<Notification> arrayList;
                Cursor cursor2 = DBUtil.query((RoomDatabase)NotificationDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"dataJson");
                int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"id");
                int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"title");
                int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"description");
                int n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"_type");
                int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"date");
                int n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor2, (String)"sourceUniqueId");
                ArrayList<Notification> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<Notification>(cursor2.getCount());
                    while (cursor2.moveToNext()) {
                        cursor = cursor2;
                        n = n3;
                    }
                }
                catch (Throwable throwable) {
                    cursor2.close();
                    throw throwable;
                }
                {
                    Notification notification;
                    Notification notification2 = notification;
                    notification2();
                    notification.setDataJson(cursor2.getString(n2));
                    Long l = cursor.isNull(n) ? null : Long.valueOf(cursor2.getLong(n3));
                    notification2.setId(l);
                    notification2.setTitle(cursor2.getString(n4));
                    notification2.setDescription(cursor2.getString(n5));
                    notification2.set_type(cursor2.getString(n6));
                    l = cursor2.isNull(n7) ? null : Long.valueOf(cursor2.getLong(n7));
                    Notification notification3 = notification2;
                    notification2.setDate(NotificationDao_Impl.this.__converters.timestampToDate(l));
                    notification3.setSourceUniqueId(cursor2.getString(n8));
                    arrayList2.add(notification3);
                    continue;
                }
                cursor2.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }
}

