/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.files;

import android.graphics.Bitmap;
import android.net.Uri;
import com.streamlayer.files.RxFilesGrpc;
import com.streamlayer.files.UploadRequest;
import com.streamlayer.files.UploadResponse;
import com.streamlayer.files.common.FileMeta;
import com.streamlayer.files.common.FileUpload;
import io.grpc.Channel;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Consumer;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.fs.FileSystem;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.retrofit.ApiInterface;
import io.streamlayer.common.data.retrofit.CDNService;
import io.streamlayer.common.mvvm.BaseRepo;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.repository.files.FilesRepo;
import io.streamlayer.utils.ExtensionsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0016H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/repository/files/FilesRepoImpl;", "Lio/streamlayer/common/mvvm/BaseRepo;", "Lio/streamlayer/sdk/repository/files/FilesRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "apiInterface", "Lio/streamlayer/common/data/retrofit/ApiInterface;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "fileSystem", "Lio/streamlayer/common/data/fs/FileSystem;", "cdnService", "Lio/streamlayer/common/data/retrofit/CDNService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/retrofit/ApiInterface;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/grpc/GrpcService;Lio/streamlayer/common/data/fs/FileSystem;Lio/streamlayer/common/data/retrofit/CDNService;)V", "createTempImage", "Lio/reactivex/Observable;", "Ljava/io/File;", "image", "Landroid/graphics/Bitmap;", "name", "", "extension", "deleteTempImage", "Lio/reactivex/Completable;", "sendFileToCDN", "file", "metaResponse", "Lcom/streamlayer/files/UploadResponse;", "sendMetaDataForFile", "type", "sdk_release"})
public final class FilesRepoImpl
extends BaseRepo
implements FilesRepo {
    private final GrpcService grpcService;
    private final FileSystem fileSystem;
    private final CDNService cdnService;

    @Inject
    public FilesRepoImpl(@NotNull AppDatabase appDatabase, @NotNull ApiInterface apiInterface, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull GrpcService grpcService2, @NotNull FileSystem fileSystem, @NotNull CDNService cDNService) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)apiInterface, (String)"apiInterface");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)grpcService2, (String)"grpcService");
        Intrinsics.checkParameterIsNotNull((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkParameterIsNotNull((Object)cDNService, (String)"cdnService");
        super(appDatabase, apiInterface, sessionPrefImpl);
        this.grpcService = grpcService2;
        this.fileSystem = fileSystem;
        this.cdnService = cDNService;
    }

    @Override
    @NotNull
    public Observable<UploadResponse> sendMetaDataForFile(@NotNull File object, @NotNull String string2) {
        FilesRepoImpl filesRepoImpl = filesRepoImpl2;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"type");
        FilesRepoImpl filesRepoImpl2 = FileMeta.newBuilder().setName("avatar").build();
        object = CollectionsKt.listOf((Object)com.streamlayer.files.common.File.newBuilder().setMd5Hash(ExtensionsKt.md5((File)object)).setType("original").setContentType(string2).setContentLength((int)((File)object).length()).build());
        Observable observable = RxFilesGrpc.newRxStub((Channel)filesRepoImpl.grpcService.getManagedChannel()).upload(UploadRequest.newBuilder().addAllFiles((Iterable)object).setMeta((FileMeta)filesRepoImpl2).build()).toObservable();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"stub.upload(request).toObservable()");
        return observable;
    }

    @Override
    @NotNull
    public Observable<String> sendFileToCDN(@NotNull File file, @NotNull UploadResponse uploadResponse) {
        UploadResponse uploadResponse2 = uploadResponse;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)uploadResponse2, (String)"metaResponse");
        List list = uploadResponse2.getFilesList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"metaResponse.filesList");
        uploadResponse = (FileUpload)CollectionsKt.first((List)list);
        MediaType.Companion companion = MediaType.Companion;
        Intrinsics.checkExpressionValueIsNotNull((Object)uploadResponse, (String)"uploading");
        String string2 = uploadResponse.getContentType();
        if (string2 == null) {
            string2 = "";
        }
        FilesRepoImpl filesRepoImpl = filesRepoImpl2;
        FilesRepoImpl filesRepoImpl2 = companion.get(string2);
        filesRepoImpl2 = RequestBody.Companion.create(file, (MediaType)filesRepoImpl2);
        CDNService cDNService = filesRepoImpl.cdnService;
        String string3 = uploadResponse.getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"uploading.location");
        String string4 = uploadResponse.getContentType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"uploading.contentType");
        long l = uploadResponse.getContentLength();
        String string5 = uploadResponse.getMd5Hash();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"uploading.md5Hash");
        Observable observable = CDNService.DefaultImpls.uploadFileToCDN$default(cDNService, string3, string4, l, string5, (RequestBody)filesRepoImpl2, null, null, 96, null).andThen((ObservableSource)Observable.fromCallable(new Callable<T>((FileUpload)uploadResponse){
            final /* synthetic */ FileUpload $uploading;
            {
                this.$uploading = fileUpload;
            }

            @NotNull
            public final String call() {
                FileUpload fileUpload = this.$uploading;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileUpload, (String)"uploading");
                return Uri.parse((String)fileUpload.getLocation()).buildUpon().clearQuery().toString();
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"cdnService.uploadFileToC\u2026toString()\n            })");
        return observable;
    }

    @Override
    @NotNull
    public Observable<File> createTempImage(@NotNull Bitmap bitmap2, @NotNull String string2, @NotNull String string3) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"extension");
        Observable observable = this.fileSystem.createTempFile(string2, string3).doOnNext(new Consumer<File>(bitmap2){
            final /* synthetic */ Bitmap $image;
            {
                this.$image = bitmap2;
            }

            public final void accept(File file) {
                FileOutputStream fileOutputStream;
                FileOutputStream fileOutputStream2 = fileOutputStream;
                fileOutputStream2(file);
                this.$image.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream2);
                fileOutputStream.close();
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"fileSystem.createTempFil\u2026)\n            }\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Completable deleteTempImage(@NotNull String string2, @NotNull String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"extension");
        return this.fileSystem.deleteTempFile(string2, string3);
    }
}

