/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chats;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.chats.MessagingChatsAdapter;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.DateUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/messaging/Chat;", "currentUserId", "", "(Ljava/lang/String;)V", "onChatSelectedListener", "Lkotlin/Function1;", "", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setItems", "listItems", "", "setOnChatSelectedListener", "listener", "ChatsDiffCallback", "ViewHolder", "sdk_release"})
public final class MessagingChatsAdapter
extends GenericAdapter<Chat> {
    private Function1<? super Chat, Unit> onChatSelectedListener;
    private final String currentUserId;

    public MessagingChatsAdapter(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"currentUserId");
        this.currentUserId = string2;
    }

    public static final /* synthetic */ void access$setOnChatSelectedListener$p(MessagingChatsAdapter messagingChatsAdapter, Function1 function1) {
        messagingChatsAdapter.onChatSelectedListener = function1;
    }

    public final void setOnChatSelectedListener(@NotNull Function1<? super Chat, Unit> function1) {
        Function1<? super Chat, Unit> function12 = function1;
        Intrinsics.checkParameterIsNotNull(function12, (String)"listener");
        this.onChatSelectedListener = function12;
    }

    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        MessagingChatsAdapter messagingChatsAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(C\u2026is.listItems, listItems))");
        messagingChatsAdapter.getListItems().clear();
        messagingChatsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)messagingChatsAdapter);
    }

    protected int getLayoutId(int n) {
        return R.layout.sl_item_messaging_chat;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new ViewHolder(view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/Chat;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter;Landroid/view/View;)V", "bind", "", "data", "getChatName", "", "loadImage", "sdk_release"})
    public final class ViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        private final String getChatName(Chat chat) {
            Object object;
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            for (Object t : chat.getParticipants()) {
                if (!(Intrinsics.areEqual((Object)((TinodeContact)t).getChatUserId(), (Object)((ViewHolder)((Object)object)).MessagingChatsAdapter.this.currentUserId) ^ true)) continue;
                arrayList2.add(t);
            }
            if (chat.getChatType() == ChatType.P2P) {
                return chat.getName();
            }
            if (arrayList2.size() <= 1) {
                object = (TinodeContact)CollectionsKt.firstOrNull(arrayList2);
                if (object == null || (object = ((TinodeContact)object).getChatName()) == null) {
                    object = chat.getName();
                }
                return object;
            }
            object = getChatName.1.INSTANCE;
            return CollectionsKt.joinToString$default(arrayList2, (CharSequence)", ", null, null, (int)0, null, (Function1)object, (int)30, null);
        }

        private final void loadImage(Chat chat) {
            ArrayList arrayList;
            Object object = arrayList;
            arrayList = new ArrayList();
            for (Object t : chat.getParticipants()) {
                if (!(Intrinsics.areEqual((Object)((TinodeContact)t).getChatUserId(), (Object)MessagingChatsAdapter.this.currentUserId) ^ true)) continue;
                object.add(t);
            }
            if (chat.getChatType() != ChatType.P2P && object.size() != 1) {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ((ImageView)view.findViewById(R.id.chatAvatar)).setBackgroundResource(R.drawable.slr_shape_circle);
                View view2 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
                ((ImageView)view2.findViewById(R.id.chatAvatar)).setImageResource(R.drawable.sl_ic_contact_group);
            } else if ((object = (TinodeContact)CollectionsKt.firstOrNull(object)) != null) {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ImageView imageView = (ImageView)view.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.chatAvatar");
                imageView.setBackground(null);
                View view3 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
                ImageView imageView2 = (ImageView)view3.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"itemView.chatAvatar");
                ExtensionsKt.loadBase64(imageView2, ((TinodeContact)object).getPhotoBase64(), (Function1<? super RequestBuilder<Drawable>, Unit>)new Function1<RequestBuilder<Drawable>, Unit>((TinodeContact)object){
                    final /* synthetic */ TinodeContact $receiver;
                    {
                        this.$receiver = tinodeContact;
                        super(1);
                    }

                    public final void invoke(@NotNull RequestBuilder<Drawable> requestBuilder) {
                        RequestBuilder<Drawable> requestBuilder2 = requestBuilder;
                        Intrinsics.checkParameterIsNotNull(requestBuilder2, (String)"$receiver");
                        requestBuilder2.apply((BaseRequestOptions)RequestOptions.circleCropTransform());
                        Object object = object.$receiver.getChatName();
                        if (object == null) {
                            object = "";
                        }
                        requestBuilder.error((Drawable)new AcronymDrawable((String)object, 0.0f, 2, null));
                    }
                });
            } else {
                ViewHolder viewHolder = this;
                View view = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ImageView imageView = (ImageView)view.findViewById(R.id.chatAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.chatAvatar");
                imageView.setBackground(null);
                View view4 = viewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                ((ImageView)view4.findViewById(R.id.chatAvatar)).setImageDrawable((Drawable)new AcronymDrawable(chat.getName(), 0.0f, 2, null));
            }
        }

        public ViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            view.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View view) {
                    view = object.MessagingChatsAdapter.this.onChatSelectedListener;
                    if (view != null) {
                        Object object = object.this;
                        Unit cfr_ignored_0 = (Unit)view.invoke(((ViewHolder)((Object)object)).MessagingChatsAdapter.this.getItem(object.getLayoutPosition()));
                    }
                }
            });
        }

        public void bind(@NotNull Chat chat) {
            ViewHolder viewHolder = object;
            Chat chat2 = chat;
            Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"data");
            viewHolder.loadImage(chat2);
            View view = viewHolder.itemView;
            TextView textView = (TextView)view.findViewById(R.id.chatName);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatName");
            textView.setText((CharSequence)((ViewHolder)((Object)object)).getChatName(chat));
            Object object = chat.getLastMessage();
            textView = (TextView)view.findViewById(R.id.chatMessage);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessage");
            String string2 = object != null ? ((ChatMessage)object).getText() : null;
            textView.setText((CharSequence)string2);
            view = (TextView)view.findViewById(R.id.chatTime);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"chatTime");
            object = (object != null ? ((ChatMessage)object).getDate() : null) != null ? DateUtil.INSTANCE.toRelativeTimeString(((ChatMessage)object).getDate()) : (chat.getUpdatedAt() != null ? DateUtil.INSTANCE.toRelativeTimeString(chat.getUpdatedAt()) : "");
            view.setText((CharSequence)object);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/messaging/chats/MessagingChatsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lio/streamlayer/sdk/model/messaging/Chat;", "newItems", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_release"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        private final List<Chat> oldItems;
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n), (Object)this.newItems.get(n2));
        }
    }
}

