/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.InAppNotificationsService$WhenMappings;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0015J\u000e\u0010,\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u0010\u0010-\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010/\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;)V", "generalSound", "", "isAppInForeground", "", "()Z", "setAppInForeground", "(Z)V", "lastTimestampSoundPlayed", "", "messageSound", "pausedTopicsNotifications", "", "", "settings", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "soundPool", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "tinodeUserId", "checkSettingsEnabled", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "checkSoundEnabled", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "disconnect", "", "notifyChatMessage", "chatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "pauseNotifications", "pause", "chatId", "playSound", "showInAppNotification", "showNotification", "showSystemNotification", "sdk_release"})
public final class InAppNotificationsService {
    private boolean isAppInForeground;
    private final String tinodeUserId;
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;
    private final SessionPrefImpl session;
    private final NotificationRepo notificationsRepo;

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        if (!this.checkSettingsEnabled(notification)) {
            return;
        }
        if (this.isAppInForeground) {
            this.showInAppNotification(notification);
        } else {
            this.showSystemNotification(notification);
        }
    }

    private final void showInAppNotification(Notification notification) {
        this.notificationsRepo.saveNotification(notification);
        this.playSound(notification.getType());
    }

    private final void showSystemNotification(Notification notification) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSettingsEnabled(Notification notification) {
        if (InAppNotificationsService$WhenMappings.$EnumSwitchMapping$0[notification.getType().ordinal()] != 1) {
            return true;
        }
        if ((this = ((InAppNotificationsService)this).getSettings()) == null) return false;
        if (!((ClientSettings)this).getMessagesNotify()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSoundEnabled(NotificationType notificationType) {
        int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return true;
                }
                if ((this = super.getSettings()) == null) return false;
                if (!((ClientSettings)this).getFriendsSound()) return false;
                return true;
            }
            if ((this = ((InAppNotificationsService)this).getSettings()) == null) return false;
            if (!((ClientSettings)this).getCallsSound()) return false;
            return true;
        }
        if ((this = ((InAppNotificationsService)this).getSettings()) == null) return false;
        if (!((ClientSettings)this).getMessagesSound()) return false;
        return true;
    }

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo) {
        InAppNotificationsService inAppNotificationsService = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        this.session = sessionPrefImpl;
        inAppNotificationsService.notificationsRepo = notificationRepo;
        inAppNotificationsService.isAppInForeground = true;
        inAppNotificationsService.tinodeUserId = inAppNotificationsService.session.getTinodeUserId();
        inAppNotificationsService.pausedTopicsNotifications = new ArrayList<String>();
        inAppNotificationsService.soundPool = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        inAppNotificationsService.generalSound = inAppNotificationsService.soundPool.load(context, R.raw.general_notification, 1);
        inAppNotificationsService.messageSound = inAppNotificationsService.soundPool.load(context, R.raw.message_notification, 1);
    }

    public final boolean isAppInForeground() {
        return this.isAppInForeground;
    }

    public final void setAppInForeground(boolean bl) {
        this.isAppInForeground = bl;
    }

    public final void notifyChatMessage(@NotNull ChatMessage chatMessage) {
        ChatMessage chatMessage2 = chatMessage;
        Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"chatMessage");
        if (!Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)this.tinodeUserId) && !StringsKt.isBlank((CharSequence)chatMessage.getText())) {
            ChatMessage chatMessage3 = chatMessage;
            String string = chatMessage3.getTopicId();
            Long l = null;
            Object object = chatMessage3.getSender();
            object = object != null ? ((TinodeContact)object).getChatName() : null;
            Notification notification = new Notification(l, (String)object, chatMessage.getText(), NotificationType.Chat.name(), new Date(), chatMessage.getTopicId() + "_" + chatMessage.getSeq(), chatMessage);
            if (!this.pausedTopicsNotifications.contains(string) && !this.session.isTopicMuted(string) && this.checkSettingsEnabled(notification)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void playSound(@NotNull NotificationType notificationType) {
        long l;
        NotificationType notificationType2 = notificationType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType2), (String)"type");
        if (this.checkSoundEnabled(notificationType2) && (l = System.currentTimeMillis()) > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$2[notificationType.ordinal()] != 1 ? this.generalSound : this.messageSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public final void disconnect() {
        this.isAppInForeground = false;
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string));
        }
    }
}

