/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.auth;

import android.graphics.Bitmap;
import com.streamlayer.files.UploadResponse;
import com.streamlayer.users.LoginRequest;
import com.streamlayer.users.MeRequest;
import com.streamlayer.users.RegisterRequest;
import com.streamlayer.users.RequestPasswordRequest;
import com.streamlayer.users.RxUsersGrpc;
import com.streamlayer.users.UpdateAvatarRequest;
import com.streamlayer.users.UpdateAvatarResponse;
import com.streamlayer.users.UpdateMetadataRequest;
import com.streamlayer.users.UpdateMetadataResponse;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.retrofit.ApiInterface;
import io.streamlayer.common.mvvm.BaseRepo;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import io.streamlayer.sdk.repository.auth.AuthRepoImpl;
import io.streamlayer.sdk.repository.files.FilesRepo;
import java.io.File;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0016H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J$\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0016H\u0016J0\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\u0016H\u0002J\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u000f0\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00162\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00162\u0006\u0010'\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lio/streamlayer/sdk/repository/auth/AuthRepoImpl;", "Lio/streamlayer/common/mvvm/BaseRepo;", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "apiInterface", "Lio/streamlayer/common/data/retrofit/ApiInterface;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "filesRepo", "Lio/streamlayer/sdk/repository/files/FilesRepo;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/retrofit/ApiInterface;Lio/streamlayer/common/data/grpc/GrpcService;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/files/FilesRepo;)V", "unauthorizedState", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/auth/User;", "getUnauthorizedState", "()Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "unauthorizedState$delegate", "Lkotlin/Lazy;", "deleteUserImage", "Lio/reactivex/Observable;", "getCurrentUser", "getCurrentUserFromApi", "getCurrentUserFromSession", "login", "id", "", "otp", "logout", "register", "", "ifRegistered", "requestOtp", "updateUserImage", "image", "Landroid/graphics/Bitmap;", "updateUserName", "name", "sdk_release"})
public final class AuthRepoImpl
extends BaseRepo
implements AuthRepo {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy unauthorizedState$delegate;
    private final AppDatabase database;
    private final GrpcService grpcService;
    private final SessionPrefImpl session;
    private final FilesRepo filesRepo;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthRepoImpl.class), "unauthorizedState", "getUnauthorizedState()Lio/streamlayer/common/mvvm/basemodels/ResourceState;"))};
    }

    private final ResourceState<User> getUnauthorizedState() {
        KProperty cfr_ignored_0 = $$delegatedProperties[0];
        return (ResourceState)this.unauthorizedState$delegate.getValue();
    }

    private final Observable<ResourceState<Boolean>> register(String string2, Observable<ResourceState<Boolean>> observable) {
        AuthRepoImpl authRepoImpl = authRepoImpl2;
        AuthRepoImpl authRepoImpl2 = RxUsersGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        string2 = RegisterRequest.newBuilder().setId(string2).build();
        return BaseRepo.oneSideCall$default(authRepoImpl, (Function0)new Function0<Observable<Boolean>>((RxUsersGrpc.RxUsersStub)authRepoImpl2, (RegisterRequest)string2, observable){
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ RegisterRequest $request;
            final /* synthetic */ Observable $ifRegistered;
            {
                this.$stub = rxUsersStub;
                this.$request = registerRequest;
                this.$ifRegistered = observable;
                super(0);
            }

            public final Observable<Boolean> invoke() {
                return this.$stub.register(this.$request).toObservable().map((Function)register.1.INSTANCE).onErrorResumeNext(new Function<Throwable, ObservableSource<? extends Boolean>>(this){
                    final /* synthetic */ register.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Boolean> apply(@NotNull Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Intrinsics.checkParameterIsNotNull((Object)throwable2, (String)"error");
                        if (throwable2 instanceof StatusRuntimeException && Intrinsics.areEqual((Object)((StatusRuntimeException)throwable).getStatus(), (Object)Status.ALREADY_EXISTS)) {
                            return this.this$0.$ifRegistered.map((Function)register.1.INSTANCE);
                        }
                        throw throwable;
                    }
                });
            }
        }, null, null, 6, null);
    }

    private final Observable<User> getCurrentUserFromSession() {
        return this.session.getUser();
    }

    private final Observable<User> getCurrentUserFromApi() {
        Observable observable = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel()).me(MeRequest.newBuilder().build()).toObservable().map((Function)getCurrentUserFromApi.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"stub.me(request).toObser\u2026ap { it.data.toDomain() }");
        return observable;
    }

    @Inject
    public AuthRepoImpl(@NotNull AppDatabase appDatabase, @NotNull ApiInterface apiInterface, @NotNull GrpcService grpcService2, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull FilesRepo filesRepo) {
        AuthRepoImpl authRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)apiInterface, (String)"apiInterface");
        Intrinsics.checkParameterIsNotNull((Object)grpcService2, (String)"grpcService");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)filesRepo, (String)"filesRepo");
        super(appDatabase, apiInterface, sessionPrefImpl);
        this.database = appDatabase;
        this.grpcService = grpcService2;
        this.session = sessionPrefImpl;
        authRepoImpl.filesRepo = filesRepo;
        authRepoImpl.unauthorizedState$delegate = LazyKt.lazy((Function0)unauthorizedState.2.INSTANCE);
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.session;
    }

    public static final /* synthetic */ FilesRepo access$getFilesRepo$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.filesRepo;
    }

    public static final /* synthetic */ Observable access$getCurrentUserFromApi(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.getCurrentUserFromApi();
    }

    public static final /* synthetic */ Observable access$getCurrentUserFromSession(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.getCurrentUserFromSession();
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.database;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> requestOtp(@NotNull String string2) {
        AuthRepoImpl authRepoImpl = authRepoImpl3;
        String string3 = string2;
        AuthRepoImpl authRepoImpl2 = authRepoImpl3;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
        AuthRepoImpl authRepoImpl3 = RxUsersGrpc.newRxStub((Channel)authRepoImpl2.grpcService.getManagedChannel());
        string2 = RequestPasswordRequest.newBuilder().setId(string2).build();
        authRepoImpl3 = BaseRepo.oneSideCall$default(authRepoImpl2, (Function0)new Function0<Observable<Boolean>>((RxUsersGrpc.RxUsersStub)authRepoImpl3, (RequestPasswordRequest)string2){
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ RequestPasswordRequest $request;
            {
                this.$stub = rxUsersStub;
                this.$request = requestPasswordRequest;
                super(0);
            }

            public final Observable<Boolean> invoke() {
                return this.$stub.requestPassword(this.$request).toObservable().map((Function)requestOtp.requestOtpObservable.1.INSTANCE);
            }
        }, null, null, 6, null);
        Observable observable = authRepoImpl.register(string3, (Observable<ResourceState<Boolean>>)authRepoImpl3).flatMap(new Function<T, ObservableSource<? extends R>>((Observable)authRepoImpl3){
            final /* synthetic */ Observable $requestOtpObservable;
            {
                this.$requestOtpObservable = observable;
            }

            @NotNull
            public final Observable<ResourceState<Boolean>> apply(@NotNull ResourceState<Boolean> resourceState) {
                Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                return this.$requestOtpObservable;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"register(id, requestOtpO\u2026 { requestOtpObservable }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> login(@NotNull String string2, @NotNull String string3) {
        AuthRepoImpl authRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"otp");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        string2 = LoginRequest.newBuilder().setId(string2).setPassword(string3).build();
        return BaseRepo.oneSideCall$default(authRepoImpl, (Function0)new Function0<Observable<User>>(this, rxUsersStub, (LoginRequest)string2){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ LoginRequest $request;
            {
                this.this$0 = authRepoImpl;
                this.$stub = rxUsersStub;
                this.$request = loginRequest;
                super(0);
            }

            public final Observable<User> invoke() {
                return this.$stub.login(this.$request).toObservable().map((Function)login.1.INSTANCE).doOnNext(new Consumer<Pair<? extends String, ? extends User>>(this){
                    final /* synthetic */ login.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(Pair<String, User> object) {
                        login.2 v0 = string2;
                        Pair<String, User> pair = object;
                        String string2 = (String)pair.component1();
                        object = (User)pair.component2();
                        AuthRepoImpl.access$getSession$p(v0.this$0.this$0).setLoggedIn(string2, (User)object);
                    }
                }).map((Function)login.3.INSTANCE);
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> updateUserName(@NotNull String string2) {
        AuthRepoImpl authRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        UpdateMetadataRequest updateMetadataRequest = UpdateMetadataRequest.newBuilder().setSetName(string2).build();
        return BaseRepo.oneSideCall$default(authRepoImpl, (Function0)new Function0<Observable<User>>(this, rxUsersStub, updateMetadataRequest, string2){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ UpdateMetadataRequest $request;
            final /* synthetic */ String $name;
            {
                this.this$0 = authRepoImpl;
                this.$stub = rxUsersStub;
                this.$request = updateMetadataRequest;
                this.$name = string2;
                super(0);
            }

            public final Observable<User> invoke() {
                return this.$stub.updateMetadata(this.$request).toObservable().map(new Function<T, R>(this){
                    final /* synthetic */ updateUserName.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final User apply(@NotNull UpdateMetadataResponse object) {
                        Intrinsics.checkParameterIsNotNull((Object)object, (String)"it");
                        object = AuthRepoImpl.access$getSession$p(this.this$0.this$0).getUser();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Object object2 = object;
                        object = this.this$0.$name;
                        User user = User.copy$default((User)object2, null, null, (String)object, null, 11, null);
                        AuthRepoImpl.access$getSession$p(this.this$0.this$0).setUser(user);
                        return user;
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> updateUserImage(@NotNull Bitmap bitmap2) {
        AuthRepoImpl authRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"image");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        return BaseRepo.oneSideCall$default(authRepoImpl, (Function0)new Function0<Observable<User>>(this, bitmap2, rxUsersStub){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ Bitmap $image;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $usersStub;
            {
                this.this$0 = authRepoImpl;
                this.$image = bitmap2;
                this.$usersStub = rxUsersStub;
                super(0);
            }

            public final Observable<User> invoke() {
                return FilesRepo.DefaultImpls.createTempImage$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0), this.$image, "avatar", null, 4, null).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<String> apply(@NotNull File file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        return FilesRepo.DefaultImpls.sendMetaDataForFile$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0.this$0), file, null, 2, null).flatMap(new Function<T, ObservableSource<? extends R>>(this, file){
                            final /* synthetic */ updateUserImage.1 this$0;
                            final /* synthetic */ File $file;
                            {
                                this.this$0 = var1_1;
                                this.$file = file;
                            }

                            @NotNull
                            public final Observable<String> apply(@NotNull UploadResponse uploadResponse) {
                                Intrinsics.checkParameterIsNotNull((Object)uploadResponse, (String)"response");
                                FilesRepo filesRepo = AuthRepoImpl.access$getFilesRepo$p(this.this$0.this$0.this$0);
                                File file = this.$file;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                                return filesRepo.sendFileToCDN(file, uploadResponse);
                            }
                        });
                    }
                }).map(new Function<T, R>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final UpdateAvatarRequest apply(@NotNull String string2) {
                        updateUserImage.2 v0 = this_;
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"it");
                        updateUserImage.2 this_ = UpdateAvatarRequest.newBuilder();
                        Object object = AuthRepoImpl.access$getSession$p(v0.this$0.this$0).getUser();
                        object = object != null ? ((User)object).getPhoneNumber() : null;
                        return this_.setUsername((String)object).setSetAvatar(string2).build();
                    }
                }).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<User> apply(@NotNull UpdateAvatarRequest updateAvatarRequest) {
                        Intrinsics.checkParameterIsNotNull((Object)updateAvatarRequest, (String)"it");
                        return this.this$0.$usersStub.updateAvatar(updateAvatarRequest).toObservable().flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                            final /* synthetic */ updateUserImage.3 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final Single<User> apply(@NotNull UpdateAvatarResponse updateAvatarResponse) {
                                Intrinsics.checkParameterIsNotNull((Object)updateAvatarResponse, (String)"it");
                                return AuthRepoImpl.access$getCurrentUserFromApi(this.this$0.this$0.this$0).singleOrError();
                            }
                        });
                    }
                });
            }
        }, (Function1)new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(User user) {
                AuthRepoImpl.access$getSession$p(this.this$0).setUser(user);
            }
        }, null, 4, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> deleteUserImage() {
        AuthRepoImpl authRepoImpl = this;
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        return BaseRepo.oneSideCall$default(authRepoImpl, (Function0)new Function0<Observable<User>>(this, rxUsersStub){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $usersStub;
            {
                this.this$0 = authRepoImpl;
                this.$usersStub = rxUsersStub;
                super(0);
            }

            public final Observable<User> invoke() {
                return FilesRepo.DefaultImpls.deleteTempImage$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0), "avatar", null, 2, null).andThen((ObservableSource)AuthRepoImpl.access$getSession$p(this.this$0).getUser().flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                    final /* synthetic */ deleteUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Single<UpdateAvatarResponse> apply(@NotNull User user) {
                        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
                        return this.this$0.$usersStub.updateAvatar(UpdateAvatarRequest.newBuilder().setDelAvatar(user.getAvatar()).setUsername(user.getPhoneNumber()).build());
                    }
                })).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ deleteUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<User> apply(@NotNull UpdateAvatarResponse updateAvatarResponse) {
                        Intrinsics.checkParameterIsNotNull((Object)updateAvatarResponse, (String)"it");
                        return AuthRepoImpl.access$getCurrentUserFromApi(this.this$0.this$0);
                    }
                });
            }
        }, (Function1)new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(User user) {
                AuthRepoImpl.access$getSession$p(this.this$0).setUser(user);
            }
        }, null, 4, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> getCurrentUser() {
        return this.twoSideCall(new Function0<Observable<User>>(this){

            @NotNull
            public final Observable<User> invoke() {
                return AuthRepoImpl.access$getCurrentUserFromSession((AuthRepoImpl)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AuthRepoImpl.class);
            }

            public final String getName() {
                return "getCurrentUserFromSession";
            }

            public final String getSignature() {
                return "getCurrentUserFromSession()Lio/reactivex/Observable;";
            }
        }, new Function0<Observable<User>>(this){

            @NotNull
            public final Observable<User> invoke() {
                return AuthRepoImpl.access$getCurrentUserFromApi((AuthRepoImpl)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AuthRepoImpl.class);
            }

            public final String getName() {
                return "getCurrentUserFromApi";
            }

            public final String getSignature() {
                return "getCurrentUserFromApi()Lio/reactivex/Observable;";
            }
        }, new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(@NotNull User user) {
                Intrinsics.checkParameterIsNotNull((Object)user, (String)"it");
                AuthRepoImpl.access$getSession$p(this.this$0).setLoggedIn(AuthRepoImpl.access$getSession$p(this.this$0).getToken(), user);
            }
        });
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> logout() {
        Observable observable = Completable.fromAction((Action)new Action(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
            }

            public final void run() {
                logout.1 v0 = this;
                AuthRepoImpl.access$getDatabase$p(v0.this$0).clearAllTables();
                AuthRepoImpl.access$getSession$p(v0.this$0).logout();
            }
        }).andThen((ObservableSource)Observable.just(this.getUnauthorizedState()));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Completable.fromAction {\u2026.just(unauthorizedState))");
        return observable;
    }
}

