/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.calls;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.bornfight.utils.adapters.GenericAdapter;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.calls.VoiceChatsAdapter;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.AcronymDrawable;
import io.streamlayer.utils.DateUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/sdk/calls/VoiceChatsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/messaging/Chat;", "currentUserId", "", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Ljava/lang/String;Lio/streamlayer/common/session/SessionPrefImpl;)V", "listener", "Lio/streamlayer/sdk/calls/VoiceChatsAdapter$VoiceChatsInteractionListener;", "getLayoutId", "", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setInteractionListener", "", "setItems", "listItems", "", "ChatsDiffCallback", "VoiceCallViewHolder", "VoiceChatsInteractionListener", "sdk_release"})
public final class VoiceChatsAdapter
extends GenericAdapter<Chat> {
    private VoiceChatsInteractionListener listener;
    private final String currentUserId;
    private final SessionPrefImpl session;

    public VoiceChatsAdapter(@NotNull String string2, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"currentUserId");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.currentUserId = string2;
        this.session = sessionPrefImpl;
    }

    public static final /* synthetic */ void access$setListener$p(VoiceChatsAdapter voiceChatsAdapter, VoiceChatsInteractionListener voiceChatsInteractionListener) {
        voiceChatsAdapter.listener = voiceChatsInteractionListener;
    }

    public final void setInteractionListener(@NotNull VoiceChatsInteractionListener voiceChatsInteractionListener) {
        VoiceChatsInteractionListener voiceChatsInteractionListener2 = voiceChatsInteractionListener;
        Intrinsics.checkParameterIsNotNull((Object)voiceChatsInteractionListener2, (String)"listener");
        this.listener = voiceChatsInteractionListener2;
    }

    public void setItems(@NotNull List<Chat> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new ChatsDiffCallback(this.getListItems(), list));
        VoiceChatsAdapter voiceChatsAdapter = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(C\u2026is.listItems, listItems))");
        voiceChatsAdapter.getListItems().clear();
        voiceChatsAdapter.getListItems().addAll(list);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)voiceChatsAdapter);
    }

    protected int getLayoutId(int n) {
        return R.layout.sl_item_voicecall_recent;
    }

    @NotNull
    protected GenericAdapter.GenericViewHolder<Chat> getViewHolder(@NotNull View view, int n) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return new VoiceCallViewHolder(this, view);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lio/streamlayer/sdk/calls/VoiceChatsAdapter$VoiceCallViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/Chat;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/calls/VoiceChatsAdapter;Landroid/view/View;)V", "bind", "", "data", "getChatName", "", "loadImage", "setCallStatus", "sdk_release"})
    public final class VoiceCallViewHolder
    extends GenericAdapter.GenericViewHolder<Chat> {
        final /* synthetic */ VoiceChatsAdapter this$0;

        private final String getChatName(Chat chat) {
            Object object = ((VoiceCallViewHolder)((Object)object)).this$0.session.getTinodeUserId();
            if (object == null) {
                object = "";
            }
            Chat chat2 = chat;
            object = MessagingExtensionsKt.participantsWithoutUser(chat2, (String)object);
            if (chat2.getChatType() == ChatType.P2P) {
                return chat.getName();
            }
            if (object.size() <= 1) {
                if ((object = (TinodeContact)CollectionsKt.firstOrNull((List)object)) == null || (object = ((TinodeContact)object).getChatName()) == null) {
                    object = chat.getName();
                }
                return object;
            }
            Object object2 = object;
            object = getChatName.1.INSTANCE;
            return CollectionsKt.joinToString$default((Iterable)object2, (CharSequence)", ", null, null, (int)0, null, (Function1)object, (int)30, null);
        }

        private final void loadImage(Chat chat) {
            Object object = this.this$0.session.getTinodeUserId();
            if (object == null) {
                object = "";
            }
            Chat chat2 = chat;
            object = MessagingExtensionsKt.participantsWithoutUser(chat2, (String)object);
            if (chat2.getChatType() != ChatType.P2P && object.size() != 1) {
                VoiceCallViewHolder voiceCallViewHolder = this;
                View view = voiceCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ((ImageView)view.findViewById(R.id.slVoiceCallIV)).setBackgroundResource(R.drawable.slr_shape_circle);
                View view2 = voiceCallViewHolder.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
                ((ImageView)view2.findViewById(R.id.slVoiceCallIV)).setImageResource(R.drawable.sl_ic_contact_group);
            } else {
                View view = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ImageView imageView = (ImageView)view.findViewById(R.id.slVoiceCallIV);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slVoiceCallIV");
                imageView.setBackground(null);
                object = (TinodeContact)CollectionsKt.firstOrNull((List)object);
                if (object != null) {
                    View view3 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
                    ImageView imageView2 = (ImageView)view3.findViewById(R.id.slVoiceCallIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"itemView.slVoiceCallIV");
                    ProfileExtensionsKt.loadContactAvatarWithStatus$default(imageView2, (TinodeContact)object, null, 2, null);
                } else {
                    View view4 = this.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
                    ((ImageView)view4.findViewById(R.id.slVoiceCallIV)).setImageDrawable((Drawable)new AcronymDrawable(chat.getName(), 0.0f, false, null, null, 30, null));
                }
            }
        }

        private final void setCallStatus(Chat chat) {
            boolean bl = chat.getChatId().hashCode() % 2 == 0;
            boolean bl2 = bl && chat.isOwner();
            boolean bl3 = bl && !chat.isOwner();
            View view = voiceCallViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            VoiceCallViewHolder voiceCallViewHolder = (ImageView)view.findViewById(R.id.slVoiceCallStatusIV);
            if (bl2) {
                VoiceCallViewHolder voiceCallViewHolder2 = voiceCallViewHolder;
                voiceCallViewHolder2.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)voiceCallViewHolder2.getContext(), (int)R.color.primaryBlue)));
                voiceCallViewHolder2.setBackgroundResource(R.drawable.sl_bg_oval_blue);
                voiceCallViewHolder2.setImageResource(R.drawable.sl_ic_missed_call_outbound);
                ExtensionsKt.visible((View)voiceCallViewHolder2);
            } else if (bl3) {
                VoiceCallViewHolder voiceCallViewHolder3 = voiceCallViewHolder;
                voiceCallViewHolder3.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)voiceCallViewHolder3.getContext(), (int)R.color.slRed)));
                voiceCallViewHolder3.setBackgroundResource(R.drawable.sl_bg_oval_blue);
                voiceCallViewHolder3.setImageResource(R.drawable.sl_ic_missed_call_inbound);
                ExtensionsKt.visible((View)voiceCallViewHolder3);
            } else {
                ExtensionsKt.gone((View)voiceCallViewHolder);
            }
        }

        public VoiceCallViewHolder(@NotNull VoiceChatsAdapter voiceChatsAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = voiceChatsAdapter;
            super(view);
            view2.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    object = this$0.listener;
                    if (object != null) {
                        Object object2 = object2.this;
                        object.onVoiceChatClick((Chat)((VoiceCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                    }
                }
            });
            ((ImageButton)view2.findViewById(R.id.slVoiceCallCallNudgeBtn)).setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    object = this$0.listener;
                    if (object != null) {
                        Object object2 = object2.this;
                        object.onNudgeSendClick((Chat)((VoiceCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()));
                    }
                }
            });
        }

        public void bind(@NotNull Chat chat) {
            VoiceCallViewHolder voiceCallViewHolder = this;
            Chat chat2 = chat;
            Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"data");
            voiceCallViewHolder.loadImage(chat2);
            View view = voiceCallViewHolder.itemView;
            Object object = (TextView)view.findViewById(R.id.slVoiceCallNameTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"slVoiceCallNameTV");
            object.setText((CharSequence)this.getChatName(chat));
            object = chat.getLastMessage();
            TextView textView = (TextView)view.findViewById(R.id.slVoiceCallTimeTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slVoiceCallTimeTV");
            object = (object != null ? ((ChatMessage)object).getDate() : null) != null ? DateUtil.INSTANCE.toRelativeTimeString(((ChatMessage)object).getDate()) : (chat.getUpdatedAt() != null ? DateUtil.INSTANCE.toRelativeTimeString(chat.getUpdatedAt()) : "");
            textView.setText((CharSequence)object);
            object = MessagingExtensionsKt.participantsWithoutUser(chat, this.this$0.session.getTinodeUserId());
            if (object.size() == 1 && (object = (TinodeContact)CollectionsKt.firstOrNull((List)object)) != null && !((TinodeContact)object).getOnline()) {
                ImageButton imageButton = (ImageButton)view.findViewById(R.id.slVoiceCallCallNudgeBtn);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageButton, (String)"slVoiceCallCallNudgeBtn");
                ExtensionsKt.visible((View)imageButton);
            } else {
                ImageButton imageButton = (ImageButton)view.findViewById(R.id.slVoiceCallCallNudgeBtn);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageButton, (String)"slVoiceCallCallNudgeBtn");
                ExtensionsKt.gone((View)imageButton);
            }
            this.setCallStatus(chat);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/sdk/calls/VoiceChatsAdapter$ChatsDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lio/streamlayer/sdk/model/messaging/Chat;", "newItems", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "sdk_release"})
    private static final class ChatsDiffCallback
    extends DiffUtil.Callback {
        private final List<Chat> oldItems;
        private final List<Chat> newItems;

        public ChatsDiffCallback(@NotNull List<Chat> list, @NotNull List<Chat> list2) {
            Intrinsics.checkParameterIsNotNull(list, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(list2, (String)"newItems");
            this.oldItems = list;
            this.newItems = list2;
        }

        public boolean areItemsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n).getChatId(), (Object)this.newItems.get(n2).getChatId());
        }

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areContentsTheSame(int n, int n2) {
            return Intrinsics.areEqual((Object)this.oldItems.get(n), (Object)this.newItems.get(n2));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lio/streamlayer/sdk/calls/VoiceChatsAdapter$VoiceChatsInteractionListener;", "", "onNudgeSendClick", "", "item", "Lio/streamlayer/sdk/model/messaging/Chat;", "onVoiceChatClick", "sdk_release"})
    public static interface VoiceChatsInteractionListener {
        public void onVoiceChatClick(@NotNull Chat var1);

        public void onNudgeSendClick(@NotNull Chat var1);
    }
}

