/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.hockey;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.ResourceStateKt;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlay;
import io.streamlayer.sdk.model.sports.hockey.GroupedHockeyStandings;
import io.streamlayer.sdk.model.sports.hockey.HockeyBoxScore;
import io.streamlayer.sdk.model.sports.hockey.HockeyConference;
import io.streamlayer.sdk.model.sports.hockey.HockeyStandings;
import io.streamlayer.sdk.model.sports.hockey.HockeyTeamStanding;
import io.streamlayer.sdk.repository.mock.MockRepoImpl;
import io.streamlayer.sdk.repository.sports.events.SportEventsRepo;
import io.streamlayer.sdk.repository.sports.hockey.HockeyRepo;
import io.streamlayer.sdk.statistics.hockey.HockeyStatisticsViewModel;
import io.streamlayer.utils.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010<\u001a\u00020=H\u0002J\u0010\u0010\u001c\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010,\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u000e\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020\u0015J\b\u0010.\u001a\u00020=H\u0002J\u0010\u00109\u001a\u00020=2\u0006\u0010B\u001a\u00020\u0015H\u0002J\u0010\u0010;\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020EH\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00120\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u0010\u0010'\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010!\"\u0004\b*\u0010#R\u001d\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001dR#\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001dR#\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00120\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001dR\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001dR\u001d\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\r0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001d\u00a8\u0006F"}, d2={"Lio/streamlayer/sdk/statistics/hockey/HockeyStatisticsViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "eventsRepo", "Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;", "hockeyRepo", "Lio/streamlayer/sdk/repository/sports/hockey/HockeyRepo;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "(Lio/streamlayer/sdk/repository/sports/events/SportEventsRepo;Lio/streamlayer/sdk/repository/sports/hockey/HockeyRepo;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/scheduler/SchedulerProvider;)V", "_boxScoreData", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/sports/hockey/HockeyBoxScore;", "_playByPlayData", "Lio/streamlayer/sdk/model/sports/basketball/BasketballPlayByPlay;", "_scheduleData", "", "Lio/streamlayer/sdk/model/sports/EventScheduleData;", "_scheduleDates", "", "_standings", "Lio/streamlayer/sdk/model/sports/hockey/GroupedHockeyStandings;", "_summaryData", "Lio/streamlayer/sdk/model/sports/EventSummaryResponseData;", "boxScoreData", "Landroidx/lifecycle/LiveData;", "getBoxScoreData", "()Landroidx/lifecycle/LiveData;", "boxScoreHomeSelected", "", "getBoxScoreHomeSelected", "()Z", "setBoxScoreHomeSelected", "(Z)V", "easternStandingsSelected", "getEasternStandingsSelected", "setEasternStandingsSelected", "eventLeague", "playByPlayAllPlaysFilter", "getPlayByPlayAllPlaysFilter", "setPlayByPlayAllPlaysFilter", "playByPlayData", "getPlayByPlayData", "scheduleData", "getScheduleData", "scheduleDates", "getScheduleDates", "scheduleDisposable", "Lio/reactivex/disposables/Disposable;", "selectedDate", "getSelectedDate", "()Ljava/lang/String;", "setSelectedDate", "(Ljava/lang/String;)V", "standings", "getStandings", "summaryData", "getSummaryData", "fillDates", "", "id", "", "getSchedule", "date", "league", "groupStandings", "data", "Lio/streamlayer/sdk/model/sports/hockey/HockeyStandings;", "sdk_release"})
public final class HockeyStatisticsViewModel
extends BaseViewModel {
    private String eventLeague;
    private final MutableLiveData<ResourceState<EventSummaryResponseData>> _summaryData;
    @NotNull
    private final LiveData<ResourceState<EventSummaryResponseData>> summaryData;
    private final MutableLiveData<ResourceState<BasketballPlayByPlay>> _playByPlayData;
    @NotNull
    private final LiveData<ResourceState<BasketballPlayByPlay>> playByPlayData;
    private boolean playByPlayAllPlaysFilter;
    private final MutableLiveData<ResourceState<HockeyBoxScore>> _boxScoreData;
    @NotNull
    private final LiveData<ResourceState<HockeyBoxScore>> boxScoreData;
    private boolean boxScoreHomeSelected;
    private final MutableLiveData<ResourceState<List<EventScheduleData>>> _scheduleData;
    @NotNull
    private final LiveData<ResourceState<List<EventScheduleData>>> scheduleData;
    private Disposable scheduleDisposable;
    private final MutableLiveData<ResourceState<List<String>>> _scheduleDates;
    @NotNull
    private final LiveData<ResourceState<List<String>>> scheduleDates;
    @NotNull
    private String selectedDate;
    private final MutableLiveData<ResourceState<GroupedHockeyStandings>> _standings;
    @NotNull
    private final LiveData<ResourceState<GroupedHockeyStandings>> standings;
    private boolean easternStandingsSelected;
    private final SportEventsRepo eventsRepo;
    private final HockeyRepo hockeyRepo;
    private final SessionPrefImpl session;
    private final SchedulerProvider schedulers;

    private final void getSummaryData(long l) {
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        BaseViewModel.observableCall$default(hockeyStatisticsViewModel, hockeyStatisticsViewModel._summaryData, (Function0)new Function0<Observable<ResourceState<? extends EventSummaryResponseData>>>(this, l){
            final /* synthetic */ HockeyStatisticsViewModel this$0;
            final /* synthetic */ long $id;
            {
                this.this$0 = hockeyStatisticsViewModel;
                this.$id = l;
                super(0);
            }

            public final Observable<ResourceState<EventSummaryResponseData>> invoke() {
                Observable observable = HockeyStatisticsViewModel.access$getEventsRepo$p(this.this$0).getEventSummaryResponseData(this.$id).observeOn(HockeyStatisticsViewModel.access$getSchedulers$p(this.this$0).ui()).doOnNext(new Consumer<ResourceState<? extends EventSummaryResponseData>>(this){
                    final /* synthetic */ getSummaryData.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<EventSummaryResponseData> object) {
                        if (((ResourceState)object).getStatus() == Status.SUCCESS && ((ResourceState)object).getData() != null) {
                            object = ((ResourceState)object).getData().getEventSummary().getLeague();
                            if (Intrinsics.areEqual((Object)HockeyStatisticsViewModel.access$getEventLeague$p(this.this$0.this$0), (Object)object) ^ true) {
                                getSummaryData.1 v0 = this;
                                HockeyStatisticsViewModel.access$setEventLeague$p(v0.this$0.this$0, (String)object);
                                HockeyStatisticsViewModel.access$getStandings(v0.this$0.this$0, (String)object);
                            }
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"eventsRepo.getEventSumma\u2026      }\n                }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    private final void getBoxScoreData(long l) {
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        BaseViewModel.observableCall$default(hockeyStatisticsViewModel, hockeyStatisticsViewModel._boxScoreData, (Function0)new Function0<Observable<ResourceState<? extends HockeyBoxScore>>>(l){
            final /* synthetic */ long $id;
            {
                this.$id = l;
                super(0);
            }

            public final Observable<ResourceState<HockeyBoxScore>> invoke() {
                Observable observable = new MockRepoImpl().getHockeyBoxScore(this.$id).map((Function)getBoxScoreData.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"MockRepoImpl().getHockey\u2026sourceState.success(it) }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    private final void getScheduleData() {
        Disposable disposable = this.scheduleDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        BaseViewModel.observableCall$default(hockeyStatisticsViewModel, hockeyStatisticsViewModel._scheduleData, getScheduleData.1.INSTANCE, (Function1)new Function1<Disposable, Unit>(this){
            final /* synthetic */ HockeyStatisticsViewModel this$0;
            {
                this.this$0 = hockeyStatisticsViewModel;
                super(1);
            }

            public final void invoke(@NotNull Disposable disposable) {
                Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"it");
                HockeyStatisticsViewModel.access$setScheduleDisposable$p(this.this$0, disposable);
            }
        }, null, null, 24, null);
    }

    private final void getPlayByPlayData(long l) {
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        BaseViewModel.observableCall$default(hockeyStatisticsViewModel, hockeyStatisticsViewModel._playByPlayData, getPlayByPlayData.1.INSTANCE, null, null, null, 28, null);
    }

    private final void fillDates() {
        ArrayList<String> arrayList;
        ArrayList<Date> arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList<Date>();
        Object object2 = Calendar.getInstance();
        ((Calendar)object2).set(2, 10);
        ((Calendar)object2).set(5, 20);
        ((Calendar)object2).set(1, 2019);
        int n = 256;
        for (int j = 0; j <= n; ++j) {
            Calendar calendar = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"calendar");
            Date date2 = calendar.getTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"calendar.time");
            object.add(date2);
            ((Calendar)object2).add(5, 1);
        }
        MutableLiveData<ResourceState<List<String>>> mutableLiveData = mutableLiveData._scheduleDates;
        object2 = ResourceState.Companion;
        ArrayList<String> arrayList3 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList3.add(DateUtil.INSTANCE.toDateString((Date)object.next()));
        }
        mutableLiveData.postValue(((ResourceState.Companion)object2).success(arrayList3));
    }

    private final void getStandings(String string2) {
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        BaseViewModel.observableCall$default(hockeyStatisticsViewModel, hockeyStatisticsViewModel._standings, (Function0)new Function0<Observable<ResourceState<? extends GroupedHockeyStandings>>>(this, string2){
            final /* synthetic */ HockeyStatisticsViewModel this$0;
            final /* synthetic */ String $league;
            {
                this.this$0 = hockeyStatisticsViewModel;
                this.$league = string2;
                super(0);
            }

            public final Observable<ResourceState<GroupedHockeyStandings>> invoke() {
                Observable observable = HockeyStatisticsViewModel.access$getHockeyRepo$p(this.this$0).getHockeyStandings(this.$league).map(new Function<T, R>(this){
                    final /* synthetic */ getStandings.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final ResourceState<GroupedHockeyStandings> apply(@NotNull ResourceState<HockeyStandings> resourceState) {
                        ResourceState<HockeyStandings> resourceState2 = resourceState;
                        Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                        return ResourceStateKt.mapValue(resourceState2, new Function1<HockeyStandings, GroupedHockeyStandings>(this){
                            final /* synthetic */ getStandings.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            @Nullable
                            public final GroupedHockeyStandings invoke(@Nullable HockeyStandings hockeyStandings) {
                                return hockeyStandings != null ? HockeyStatisticsViewModel.access$groupStandings(this.this$0.this$0.this$0, hockeyStandings) : null;
                            }
                        });
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"hockeyRepo.getHockeyStan\u2026 groupStandings(it) } } }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    private final GroupedHockeyStandings groupStandings(HockeyStandings object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        for (Object t : ((HockeyStandings)object).getStandings()) {
            if (!Intrinsics.areEqual((Object)((HockeyTeamStanding)t).getConference(), (Object)HockeyConference.Eastern.name())) continue;
            arrayList3.add(t);
        }
        List<HockeyTeamStanding> list = ((HockeyStandings)object).getStandings();
        object = arrayList;
        arrayList = new ArrayList();
        for (Object t : list) {
            if (!Intrinsics.areEqual((Object)((HockeyTeamStanding)t).getConference(), (Object)HockeyConference.Western.name())) continue;
            object.add(t);
        }
        return new GroupedHockeyStandings(arrayList3, (List<HockeyTeamStanding>)object);
    }

    @Inject
    public HockeyStatisticsViewModel(@NotNull SportEventsRepo object, @NotNull HockeyRepo hockeyRepo, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull SchedulerProvider schedulerProvider) {
        HockeyStatisticsViewModel hockeyStatisticsViewModel = this;
        SchedulerProvider schedulerProvider2 = schedulerProvider;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"eventsRepo");
        Intrinsics.checkParameterIsNotNull((Object)hockeyRepo, (String)"hockeyRepo");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider2, (String)"schedulers");
        super(schedulerProvider2);
        this.eventsRepo = object;
        this.hockeyRepo = hockeyRepo;
        this.session = sessionPrefImpl;
        hockeyStatisticsViewModel.schedulers = schedulerProvider;
        hockeyStatisticsViewModel._summaryData = new MutableLiveData();
        LiveData liveData = Transformations.distinctUntilChanged(hockeyStatisticsViewModel._summaryData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        hockeyStatisticsViewModel.summaryData = liveData;
        hockeyStatisticsViewModel._playByPlayData = new MutableLiveData();
        LiveData liveData2 = Transformations.distinctUntilChanged(hockeyStatisticsViewModel._playByPlayData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData2, (String)"Transformations.distinctUntilChanged(this)");
        hockeyStatisticsViewModel.playByPlayData = liveData2;
        hockeyStatisticsViewModel.playByPlayAllPlaysFilter = true;
        hockeyStatisticsViewModel._boxScoreData = new MutableLiveData();
        LiveData liveData3 = Transformations.distinctUntilChanged(hockeyStatisticsViewModel._boxScoreData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData3, (String)"Transformations.distinctUntilChanged(this)");
        hockeyStatisticsViewModel.boxScoreData = liveData3;
        hockeyStatisticsViewModel._scheduleData = new MutableLiveData();
        LiveData liveData4 = Transformations.distinctUntilChanged(hockeyStatisticsViewModel._scheduleData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData4, (String)"Transformations.distinctUntilChanged(this)");
        hockeyStatisticsViewModel.scheduleData = liveData4;
        hockeyStatisticsViewModel._scheduleDates = new MutableLiveData();
        hockeyStatisticsViewModel.scheduleDates = hockeyStatisticsViewModel._scheduleDates;
        hockeyStatisticsViewModel.selectedDate = DateUtil.INSTANCE.toDateString(new Date());
        hockeyStatisticsViewModel._standings = new MutableLiveData();
        LiveData liveData5 = Transformations.distinctUntilChanged(hockeyStatisticsViewModel._standings);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData5, (String)"Transformations.distinctUntilChanged(this)");
        hockeyStatisticsViewModel.standings = liveData5;
        hockeyStatisticsViewModel.easternStandingsSelected = true;
        object = hockeyStatisticsViewModel.session.getCurrentEventId();
        hockeyStatisticsViewModel.getSummaryData(Long.parseLong((String)object));
        hockeyStatisticsViewModel.getBoxScoreData(Long.parseLong((String)object));
        hockeyStatisticsViewModel.getPlayByPlayData(Long.parseLong((String)object));
        hockeyStatisticsViewModel.getScheduleData();
        hockeyStatisticsViewModel.fillDates();
        object = hockeyStatisticsViewModel.eventLeague;
        if (object != null) {
            this.getStandings((String)object);
        }
    }

    public static final /* synthetic */ SportEventsRepo access$getEventsRepo$p(HockeyStatisticsViewModel hockeyStatisticsViewModel) {
        return hockeyStatisticsViewModel.eventsRepo;
    }

    public static final /* synthetic */ SchedulerProvider access$getSchedulers$p(HockeyStatisticsViewModel hockeyStatisticsViewModel) {
        return hockeyStatisticsViewModel.schedulers;
    }

    public static final /* synthetic */ String access$getEventLeague$p(HockeyStatisticsViewModel hockeyStatisticsViewModel) {
        return hockeyStatisticsViewModel.eventLeague;
    }

    public static final /* synthetic */ void access$setEventLeague$p(HockeyStatisticsViewModel hockeyStatisticsViewModel, String string2) {
        hockeyStatisticsViewModel.eventLeague = string2;
    }

    public static final /* synthetic */ void access$getStandings(HockeyStatisticsViewModel hockeyStatisticsViewModel, String string2) {
        hockeyStatisticsViewModel.getStandings(string2);
    }

    public static final /* synthetic */ Disposable access$getScheduleDisposable$p(HockeyStatisticsViewModel hockeyStatisticsViewModel) {
        return hockeyStatisticsViewModel.scheduleDisposable;
    }

    public static final /* synthetic */ void access$setScheduleDisposable$p(HockeyStatisticsViewModel hockeyStatisticsViewModel, Disposable disposable) {
        hockeyStatisticsViewModel.scheduleDisposable = disposable;
    }

    public static final /* synthetic */ HockeyRepo access$getHockeyRepo$p(HockeyStatisticsViewModel hockeyStatisticsViewModel) {
        return hockeyStatisticsViewModel.hockeyRepo;
    }

    public static final /* synthetic */ GroupedHockeyStandings access$groupStandings(HockeyStatisticsViewModel hockeyStatisticsViewModel, HockeyStandings hockeyStandings) {
        return hockeyStatisticsViewModel.groupStandings(hockeyStandings);
    }

    @NotNull
    public final LiveData<ResourceState<EventSummaryResponseData>> getSummaryData() {
        return this.summaryData;
    }

    @NotNull
    public final LiveData<ResourceState<BasketballPlayByPlay>> getPlayByPlayData() {
        return this.playByPlayData;
    }

    public final boolean getPlayByPlayAllPlaysFilter() {
        return this.playByPlayAllPlaysFilter;
    }

    public final void setPlayByPlayAllPlaysFilter(boolean bl) {
        this.playByPlayAllPlaysFilter = bl;
    }

    @NotNull
    public final LiveData<ResourceState<HockeyBoxScore>> getBoxScoreData() {
        return this.boxScoreData;
    }

    public final boolean getBoxScoreHomeSelected() {
        return this.boxScoreHomeSelected;
    }

    public final void setBoxScoreHomeSelected(boolean bl) {
        this.boxScoreHomeSelected = bl;
    }

    @NotNull
    public final LiveData<ResourceState<List<EventScheduleData>>> getScheduleData() {
        return this.scheduleData;
    }

    @NotNull
    public final LiveData<ResourceState<List<String>>> getScheduleDates() {
        return this.scheduleDates;
    }

    @NotNull
    public final String getSelectedDate() {
        return this.selectedDate;
    }

    public final void setSelectedDate(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"<set-?>");
        this.selectedDate = string3;
    }

    @NotNull
    public final LiveData<ResourceState<GroupedHockeyStandings>> getStandings() {
        return this.standings;
    }

    public final boolean getEasternStandingsSelected() {
        return this.easternStandingsSelected;
    }

    public final void setEasternStandingsSelected(boolean bl) {
        this.easternStandingsSelected = bl;
    }

    public final void getSchedule(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"date");
        this.selectedDate = string3;
        this.getScheduleData();
    }
}

