/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.auth;

import android.graphics.Bitmap;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.auth.AuthViewModel;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u0010\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u000eR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\r0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006("}, d2={"Lio/streamlayer/sdk/auth/AuthViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "authRepo", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "tinodeService", "Lio/streamlayer/common/data/tinode/TinodeService;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/scheduler/SchedulerProvider;Lio/streamlayer/sdk/repository/auth/AuthRepo;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/session/SessionPrefImpl;)V", "_phoneNumber", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "_user", "io/streamlayer/sdk/auth/AuthViewModel$_user$1", "Lio/streamlayer/sdk/auth/AuthViewModel$_user$1;", "phoneNumber", "Landroidx/lifecycle/LiveData;", "getPhoneNumber", "()Landroidx/lifecycle/LiveData;", "user", "Lio/streamlayer/sdk/model/auth/User;", "getUser", "deleteUserAvatar", "", "fetchUser", "invalidatePhoneNumber", "logout", "resubmitPhoneNumber", "setUserAvatar", "avatar", "Landroid/graphics/Bitmap;", "setUserName", "name", "submitPhoneNumber", "submitUserName", "submitVerificationCode", "code", "sdk_release"})
public final class AuthViewModel
extends BaseViewModel {
    private final MutableLiveData<ResourceState<String>> _phoneNumber;
    @NotNull
    private final LiveData<ResourceState<String>> phoneNumber;
    private final _user.1 _user;
    @NotNull
    private final LiveData<ResourceState<User>> user;
    private final AuthRepo authRepo;
    private final TinodeService tinodeService;
    private final SessionPrefImpl session;

    private final void fetchUser() {
        AuthViewModel authViewModel = this;
        BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>(this){
            final /* synthetic */ AuthViewModel this$0;
            {
                this.this$0 = authViewModel;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<User>> invoke() {
                return AuthViewModel.access$getAuthRepo$p(this.this$0).getCurrentUser();
            }
        }, null, null, null, 28, null);
    }

    @Inject
    public AuthViewModel(@NotNull SchedulerProvider schedulerProvider, @NotNull AuthRepo authRepo, @NotNull TinodeService tinodeService, @NotNull SessionPrefImpl sessionPrefImpl) {
        AuthViewModel authViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider, (String)"schedulers");
        Intrinsics.checkParameterIsNotNull((Object)authRepo, (String)"authRepo");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinodeService");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        super(schedulerProvider);
        this.authRepo = authRepo;
        this.tinodeService = tinodeService;
        authViewModel.session = sessionPrefImpl;
        authViewModel._phoneNumber = new MutableLiveData();
        authViewModel.phoneNumber = authViewModel._phoneNumber;
        authViewModel._user = new MediatorLiveData<ResourceState<? extends User>>(this){
            final /* synthetic */ AuthViewModel this$0;
            {
                this.this$0 = authViewModel;
                this.addSource(AuthViewModel.access$getSession$p(authViewModel).getUserListener(), new Observer<User>(this){
                    final /* synthetic */ _user.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(@Nullable User user) {
                        if (user != null) {
                            this.this$0.postValue(ResourceState.Companion.success(user));
                        } else {
                            AuthViewModel.access$fetchUser(this.this$0.this$0);
                        }
                    }
                });
            }
        };
        LiveData liveData = Transformations.map((LiveData)authViewModel._user, new androidx.arch.core.util.Function<ResourceState<? extends User>, ResourceState<? extends User>>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object object) {
                return (ResourceState)object;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.map(this) { transform(it) }");
        authViewModel.user = liveData;
    }

    public static final /* synthetic */ AuthRepo access$getAuthRepo$p(AuthViewModel authViewModel) {
        return authViewModel.authRepo;
    }

    public static final /* synthetic */ TinodeService access$getTinodeService$p(AuthViewModel authViewModel) {
        return authViewModel.tinodeService;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(AuthViewModel authViewModel) {
        return authViewModel.session;
    }

    public static final /* synthetic */ void access$fetchUser(AuthViewModel authViewModel) {
        authViewModel.fetchUser();
    }

    @NotNull
    public final LiveData<ResourceState<String>> getPhoneNumber() {
        return this.phoneNumber;
    }

    @NotNull
    public final LiveData<ResourceState<User>> getUser() {
        return this.user;
    }

    public final void invalidatePhoneNumber() {
        this._phoneNumber.setValue(null);
    }

    public final void submitPhoneNumber(@NotNull String string2) {
        AuthViewModel authViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"phoneNumber");
        BaseViewModel.observableCall$default(authViewModel, authViewModel._phoneNumber, (Function0)new Function0<Observable<ResourceState<? extends String>>>(this, string2){
            final /* synthetic */ AuthViewModel this$0;
            final /* synthetic */ String $phoneNumber;
            {
                this.this$0 = authViewModel;
                this.$phoneNumber = string2;
                super(0);
            }

            public final Observable<ResourceState<String>> invoke() {
                Observable observable = AuthViewModel.access$getAuthRepo$p(this.this$0).requestOtp(this.$phoneNumber).map(new Function<T, R>(this){
                    final /* synthetic */ submitPhoneNumber.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final ResourceState<String> apply(@NotNull ResourceState<Boolean> resourceState) {
                        Intrinsics.checkParameterIsNotNull(resourceState, (String)"it");
                        return ResourceState.Companion.success(this.this$0.$phoneNumber);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"authRepo.requestOtp(phon\u2026te.success(phoneNumber) }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    public final void resubmitPhoneNumber() {
        Object object = (ResourceState)this._phoneNumber.getValue();
        if (object != null && (object = (String)((ResourceState)object).getData()) != null) {
            this.submitPhoneNumber((String)object);
        }
    }

    public final void submitVerificationCode(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"code");
        Object object = (ResourceState)this.phoneNumber.getValue();
        if (object != null && (object = (String)((ResourceState)object).getData()) != null) {
            AuthViewModel authViewModel = this;
            BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>((String)object, this, string2){
                final /* synthetic */ String $number;
                final /* synthetic */ AuthViewModel this$0;
                final /* synthetic */ String $code$inlined;
                {
                    this.$number = string2;
                    this.this$0 = authViewModel;
                    this.$code$inlined = string3;
                    super(0);
                }

                @NotNull
                public final Observable<ResourceState<User>> invoke() {
                    return AuthViewModel.access$getAuthRepo$p(this.this$0).login(this.$number, this.$code$inlined);
                }
            }, null, null, null, 28, null);
        }
    }

    public final void submitUserName(@NotNull String string2) {
        AuthViewModel authViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>(this, string2){
            final /* synthetic */ AuthViewModel this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = authViewModel;
                this.$name = string2;
                super(0);
            }

            public final Observable<ResourceState<User>> invoke() {
                Observable observable = AuthViewModel.access$getAuthRepo$p(this.this$0).updateUserName(this.$name).doOnNext(new Consumer<ResourceState<? extends User>>(this){
                    final /* synthetic */ submitUserName.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<User> resourceState) {
                        AuthViewModel.access$getTinodeService$p(this.this$0.this$0).updatePublicInfo(new TinodeUserPublic(null, this.this$0.$name, null, null, null, 29, null));
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"authRepo.updateUserName(\u2026eUserPublic(fn = name)) }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    public final void setUserName(@NotNull String string2) {
        AuthViewModel authViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>(this, string2){
            final /* synthetic */ AuthViewModel this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = authViewModel;
                this.$name = string2;
                super(0);
            }

            public final Observable<ResourceState<User>> invoke() {
                Observable observable = AuthViewModel.access$getAuthRepo$p(this.this$0).updateUserName(this.$name).doOnNext(new Consumer<ResourceState<? extends User>>(this){
                    final /* synthetic */ setUserName.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(ResourceState<User> resourceState) {
                        AuthViewModel.access$getTinodeService$p(this.this$0.this$0).updatePublicInfo(new TinodeUserPublic(null, this.this$0.$name, null, null, null, 29, null));
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"authRepo.updateUserName(\u2026eUserPublic(fn = name)) }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    public final void setUserAvatar(@NotNull Bitmap bitmap2) {
        AuthViewModel authViewModel = this;
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"avatar");
        BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>(this, bitmap2){
            final /* synthetic */ AuthViewModel this$0;
            final /* synthetic */ Bitmap $avatar;
            {
                this.this$0 = authViewModel;
                this.$avatar = bitmap2;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<User>> invoke() {
                return AuthViewModel.access$getAuthRepo$p(this.this$0).updateUserImage(this.$avatar);
            }
        }, null, null, null, 28, null);
    }

    public final void deleteUserAvatar() {
        AuthViewModel authViewModel = this;
        BaseViewModel.observableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Observable<ResourceState<? extends User>>>(this){
            final /* synthetic */ AuthViewModel this$0;
            {
                this.this$0 = authViewModel;
                super(0);
            }

            @NotNull
            public final Observable<ResourceState<User>> invoke() {
                return AuthViewModel.access$getAuthRepo$p(this.this$0).deleteUserImage();
            }
        }, null, null, null, 28, null);
    }

    public final void logout() {
        AuthViewModel authViewModel = this;
        authViewModel.tinodeService.disconnect();
        BaseViewModel.completableCall$default(authViewModel, (MutableLiveData)authViewModel._user, (Function0)new Function0<Completable>(this){
            final /* synthetic */ AuthViewModel this$0;
            {
                this.this$0 = authViewModel;
                super(0);
            }

            public final Completable invoke() {
                Completable completable = AuthViewModel.access$getAuthRepo$p(this.this$0).logout().ignoreElements();
                Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"authRepo.logout().ignoreElements()");
                return completable;
            }
        }, null, null, null, 28, null);
    }
}

