/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepo;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0014J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001bR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006#"}, d2={"Lio/streamlayer/sdk/main/StreamLayerViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "sdkSettingsRepo", "Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "authRepo", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "tinode", "Lio/streamlayer/common/data/tinode/TinodeService;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "(Lio/streamlayer/sdk/repository/sdksettings/SdkSettingsRepo;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/sdk/repository/auth/AuthRepo;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/scheduler/SchedulerProvider;)V", "_sdkOverlaysList", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "sdkOverlaysList", "Landroidx/lifecycle/LiveData;", "getSdkOverlaysList", "()Landroidx/lifecycle/LiveData;", "unreadMessagesCount", "", "getUnreadMessagesCount", "userLoggedIn", "", "getUserLoggedIn", "checkFirebaseTokenUpdated", "", "loadSdkOverlays", "onCleared", "setOnlineStatus", "online", "sdk_release"})
public final class StreamLayerViewModel
extends BaseViewModel {
    private final MutableLiveData<ResourceState<OrganizationSettings>> _sdkOverlaysList;
    @NotNull
    private final LiveData<ResourceState<OrganizationSettings>> sdkOverlaysList;
    @NotNull
    private final LiveData<Boolean> userLoggedIn;
    @NotNull
    private final LiveData<Integer> unreadMessagesCount;
    private final SdkSettingsRepo sdkSettingsRepo;
    private final NotificationRepo notificationsRepo;
    private final AuthRepo authRepo;
    private final SessionPrefImpl session;
    private final TinodeService tinode;

    private final void loadSdkOverlays() {
        StreamLayerViewModel streamLayerViewModel = this;
        BaseViewModel.observableCall$default(streamLayerViewModel, streamLayerViewModel._sdkOverlaysList, (Function0)new Function0<Observable<ResourceState<? extends OrganizationSettings>>>(this){
            final /* synthetic */ StreamLayerViewModel this$0;
            {
                this.this$0 = streamLayerViewModel;
                super(0);
            }

            public final Observable<ResourceState<OrganizationSettings>> invoke() {
                Observable observable = StreamLayerViewModel.access$getSdkSettingsRepo$p(this.this$0).getOrganizationSettings().map((Function)loadSdkOverlays.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"sdkSettingsRepo.getOrgan\u2026it?.withProfileItem() } }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    private final void checkFirebaseTokenUpdated() {
        if (this.session.isLoggedIn() && this.session.isFirebaseTokenChanged()) {
            BaseViewModel.observableCall$default(this, (Function0)new Function0<Observable<ResourceState<? extends Boolean>>>(this){
                final /* synthetic */ StreamLayerViewModel this$0;
                {
                    this.this$0 = streamLayerViewModel;
                    super(0);
                }

                public final Observable<ResourceState<Boolean>> invoke() {
                    return StreamLayerViewModel.access$getAuthRepo$p(this.this$0).uploadFirebaseToken(StreamLayerViewModel.access$getSession$p(this.this$0).getFirebaseToken()).map(new Function<T, R>(this){
                        final /* synthetic */ checkFirebaseTokenUpdated.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        @NotNull
                        public final ResourceState<Boolean> apply(@NotNull ResourceState<Boolean> resourceState) {
                            ResourceState<Boolean> resourceState2 = resourceState;
                            Intrinsics.checkParameterIsNotNull(resourceState2, (String)"it");
                            if (Intrinsics.areEqual((Object)resourceState2.getData(), (Object)true)) {
                                StreamLayerViewModel.access$getSession$p(this.this$0.this$0).setFirebaseTokenChanged(false);
                            }
                            return resourceState;
                        }
                    });
                }
            }, null, null, null, 14, null);
        }
    }

    @Inject
    public StreamLayerViewModel(@NotNull SdkSettingsRepo sdkSettingsRepo, @NotNull NotificationRepo notificationRepo, @NotNull AuthRepo authRepo, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull TinodeService tinodeService, @NotNull SchedulerProvider schedulerProvider) {
        StreamLayerViewModel streamLayerViewModel = this;
        SchedulerProvider schedulerProvider2 = schedulerProvider;
        Intrinsics.checkParameterIsNotNull((Object)sdkSettingsRepo, (String)"sdkSettingsRepo");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)authRepo, (String)"authRepo");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinode");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider2, (String)"schedulers");
        super(schedulerProvider2);
        this.sdkSettingsRepo = sdkSettingsRepo;
        this.notificationsRepo = notificationRepo;
        this.authRepo = authRepo;
        this.session = sessionPrefImpl;
        streamLayerViewModel.tinode = tinodeService;
        streamLayerViewModel._sdkOverlaysList = new MutableLiveData();
        LiveData liveData = Transformations.distinctUntilChanged(streamLayerViewModel._sdkOverlaysList);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        streamLayerViewModel.sdkOverlaysList = liveData;
        streamLayerViewModel.userLoggedIn = streamLayerViewModel.session.getUserLoggedInListener();
        streamLayerViewModel.unreadMessagesCount = streamLayerViewModel.session.getTotalUnreadMessagesCountListener();
        streamLayerViewModel.loadSdkOverlays();
        streamLayerViewModel.checkFirebaseTokenUpdated();
    }

    public static final /* synthetic */ SdkSettingsRepo access$getSdkSettingsRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.sdkSettingsRepo;
    }

    public static final /* synthetic */ AuthRepo access$getAuthRepo$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.authRepo;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.session;
    }

    public static final /* synthetic */ TinodeService access$getTinode$p(StreamLayerViewModel streamLayerViewModel) {
        return streamLayerViewModel.tinode;
    }

    @NotNull
    public final LiveData<ResourceState<OrganizationSettings>> getSdkOverlaysList() {
        return this.sdkOverlaysList;
    }

    @NotNull
    public final LiveData<Boolean> getUserLoggedIn() {
        return this.userLoggedIn;
    }

    @NotNull
    public final LiveData<Integer> getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public final void setOnlineStatus(boolean bl) {
        BaseViewModel.observableCall$default(this, (Function0)new Function0<Observable<ResourceState<? extends Boolean>>>(this, bl){
            final /* synthetic */ StreamLayerViewModel this$0;
            final /* synthetic */ boolean $online;
            {
                this.this$0 = streamLayerViewModel;
                this.$online = bl;
                super(0);
            }

            public final Observable<ResourceState<Boolean>> invoke() {
                return (this.$online ? StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOnlineStatus() : StreamLayerViewModel.access$getTinode$p(this.this$0).triggerOfflineStatus()).map((Function)setOnlineStatus.1.INSTANCE);
            }
        }, null, null, null, 14, null);
    }

    @Override
    protected void onCleared() {
        StreamLayerViewModel streamLayerViewModel = this;
        streamLayerViewModel.notificationsRepo.deleteAllNotifications();
        streamLayerViewModel.setOnlineStatus(false);
        streamLayerViewModel.tinode.disconnect();
        super.onCleared();
    }
}

