/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.content.Context;
import androidx.emoji.bundled.BundledEmojiCompatConfig;
import androidx.emoji.text.EmojiCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.streamlayer.sdkSettings.client.GetStreamResponse;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterConfig;
import io.streamlayer.common.dagger.components.DaggerStreamLayerComponent;
import io.streamlayer.common.dagger.components.StreamLayerComponent;
import io.streamlayer.common.dagger.modules.ContextModule;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.PushNotificationsService;
import io.streamlayer.common.session.SessionPrefImpl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J9\u0010\u000f\u001a\u00020\u000e\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u00102\u001a\u0010\u0013\u001a\u0016\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u000e0\u0014j\u0002`\u0017\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001cH\u0000\u00a2\u0006\u0002\b\u001eJ\u0016\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001dJ\u0015\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/streamlayer/sdk/StreamLayer;", "", "()V", "component", "Lio/streamlayer/common/dagger/components/StreamLayerComponent;", "getComponent$sdk_release", "()Lio/streamlayer/common/dagger/components/StreamLayerComponent;", "setComponent$sdk_release", "(Lio/streamlayer/common/dagger/components/StreamLayerComponent;)V", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "assertComponent", "", "changeStreamEvent", "T", "", "event", "onInitialized", "Lkotlin/Function1;", "Lcom/streamlayer/sdkSettings/client/GetStreamResponse;", "Lio/streamlayer/sdk/SLRResponse;", "Lio/streamlayer/sdk/OnStreamCallback;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function1;)V", "handleStreamLayerPush", "", "data", "", "", "handleStreamLayerPush$sdk_release", "initializeApp", "sdkKey", "uploadDeviceFCMToken", "token", "uploadDeviceFCMToken$sdk_release", "sdk_release"})
public final class StreamLayer {
    @NotNull
    public static StreamLayerComponent component;
    private static Context context;
    private static SessionPrefImpl session;
    public static final StreamLayer INSTANCE;

    private final void assertComponent() {
        if (component != null) {
            return;
        }
        throw new UninitializedPropertyAccessException("StreamLayer not initialized!");
    }

    private StreamLayer() {
    }

    static {
        INSTANCE = new StreamLayer();
    }

    @NotNull
    public final StreamLayerComponent getComponent$sdk_release() {
        StreamLayerComponent streamLayerComponent = component;
        if (streamLayerComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
        }
        return streamLayerComponent;
    }

    public final void setComponent$sdk_release(@NotNull StreamLayerComponent streamLayerComponent) {
        StreamLayerComponent streamLayerComponent2 = streamLayerComponent;
        Intrinsics.checkParameterIsNotNull((Object)streamLayerComponent2, (String)"<set-?>");
        component = streamLayerComponent2;
    }

    public final void initializeApp(@NotNull Context context, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"sdkKey");
        StreamLayerComponent streamLayerComponent = DaggerStreamLayerComponent.builder().contextModule(new ContextModule(context)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)streamLayerComponent, (String)"DaggerStreamLayerCompone\u2026xt))\n            .build()");
        component = streamLayerComponent;
        Glide.with((Context)context).setDefaultRequestOptions((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.AUTOMATIC));
        session = new SessionPrefImpl(context);
        SessionPrefImpl sessionPrefImpl = session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        sessionPrefImpl.setSdkKey(string2);
        StreamLayer.context = context;
        Twitter.initialize((TwitterConfig)new TwitterConfig.Builder(context).build());
        EmojiCompat.init((EmojiCompat.Config)new BundledEmojiCompatConfig(context));
        NotificationChannelsHelper.INSTANCE.initChannels(context);
    }

    public final <T extends CharSequence> void changeStreamEvent(@NotNull T t, @NotNull Function1<? super GetStreamResponse, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(t, (String)"event");
        Intrinsics.checkParameterIsNotNull(function1, (String)"onInitialized");
        ((StreamLayer)((Object)sessionPrefImpl)).assertComponent();
        SessionPrefImpl sessionPrefImpl = session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        sessionPrefImpl.setCurrentEventId(((Object)t).toString());
    }

    public final void uploadDeviceFCMToken$sdk_release(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"token");
        ((StreamLayer)object).assertComponent();
        Object object = session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        ((SessionPrefImpl)object).setFirebaseToken(string2);
        object = session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        ((SessionPrefImpl)object).setFirebaseTokenChanged(true);
        object = NotificationChannelsHelper.INSTANCE;
        string2 = context;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        ((NotificationChannelsHelper)object).initChannels((Context)string2);
    }

    public final boolean handleStreamLayerPush$sdk_release(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"data");
        ((StreamLayer)((Object)streamLayerComponent)).assertComponent();
        if (PushNotificationsService.Companion.isStreamLayerPush(map2)) {
            StreamLayerComponent streamLayerComponent = component;
            if (streamLayerComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            }
            streamLayerComponent.getPushNotificationsService().handlePushMessage(map2);
            return true;
        }
        return false;
    }
}

