/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.repository.notifications.NotificationDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class NotificationDao_Impl
implements NotificationDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Notification> __insertionAdapterOfNotification;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<Notification> __deletionAdapterOfNotification;
    private final EntityDeletionOrUpdateAdapter<Notification> __updateAdapterOfNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNotification;
    private final SharedSQLiteStatement __preparedStmtOfSafeDeleteAllNotifications;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNotification_1;

    public NotificationDao_Impl(RoomDatabase roomDatabase) {
        NotificationDao_Impl notificationDao_Impl = this;
        this.__converters = new Converters();
        notificationDao_Impl.__db = roomDatabase;
        notificationDao_Impl.__insertionAdapterOfNotification = new EntityInsertionAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `Notification` (`dataJson`,`id`,`title`,`description`,`_type`,`date`,`sourceUniqueId`,`meta`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification object) {
                if (((Notification)object).getDataJson() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, ((Notification)object).getDataJson());
                }
                if (((Notification)object).getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = ((Notification)object).getId();
                    supportSQLiteStatement.bindLong(2, l);
                }
                if (((Notification)object).getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, ((Notification)object).getTitle());
                }
                if (((Notification)object).getDescription() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, ((Notification)object).getDescription());
                }
                if (((Notification)object).get_type() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, ((Notification)object).get_type());
                }
                Long l = object2.NotificationDao_Impl.this.__converters.dateToString(((Notification)object).getDate());
                if (l == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(6, l2);
                }
                if (((Notification)object).getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, ((Notification)object).getSourceUniqueId());
                }
                object = ((Notification)object).getNotificationIcon();
                if (object != null) {
                    Object object2 = object2.NotificationDao_Impl.this.__converters.stringMapToString(((NotificationIcon)object).getMeta());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object2);
                    }
                } else {
                    supportSQLiteStatement.bindNull(8);
                }
            }
        };
        notificationDao_Impl.__deletionAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `Notification` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(1, l);
                }
            }
        };
        notificationDao_Impl.__updateAdapterOfNotification = new EntityDeletionOrUpdateAdapter<Notification>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `Notification` SET `dataJson` = ?,`id` = ?,`title` = ?,`description` = ?,`_type` = ?,`date` = ?,`sourceUniqueId` = ?,`meta` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Notification notification) {
                if (notification.getDataJson() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, notification.getDataJson());
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = notification.getId();
                    supportSQLiteStatement.bindLong(2, l);
                }
                if (notification.getTitle() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, notification.getTitle());
                }
                if (notification.getDescription() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, notification.getDescription());
                }
                if (notification.get_type() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, notification.get_type());
                }
                Long l = object.NotificationDao_Impl.this.__converters.dateToString(notification.getDate());
                if (l == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    long l2 = l;
                    supportSQLiteStatement.bindLong(6, l2);
                }
                if (notification.getSourceUniqueId() == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, notification.getSourceUniqueId());
                }
                NotificationIcon notificationIcon = notification.getNotificationIcon();
                if (notificationIcon != null) {
                    Object object = object.NotificationDao_Impl.this.__converters.stringMapToString(notificationIcon.getMeta());
                    if (object == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object);
                    }
                } else {
                    supportSQLiteStatement.bindNull(8);
                }
                if (notification.getId() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    long l3 = notification.getId();
                    supportSQLiteStatement.bindLong(9, l3);
                }
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteNotification = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification WHERE id = ?";
            }
        };
        notificationDao_Impl.__preparedStmtOfSafeDeleteAllNotifications = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification";
            }
        };
        notificationDao_Impl.__preparedStmtOfDeleteNotification_1 = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Notification WHERE sourceUniqueId = ?";
            }
        };
    }

    @Override
    public void saveNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__insertionAdapterOfNotification.insert(list);
            notificationDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public long saveNotification(Notification notification) {
        long l;
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            l = notificationDao_Impl.__insertionAdapterOfNotification.insertAndReturnId((Object)notification);
            NotificationDao_Impl notificationDao_Impl2 = this;
            notificationDao_Impl2.__db.setTransactionSuccessful();
            notificationDao_Impl2.__db.endTransaction();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        return l;
    }

    @Override
    public Completable deleteNotifications(final List<Notification> list) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                7 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handleMultiple((Iterable)list);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                return null;
            }
        });
    }

    @Override
    public Completable deleteNotification(final Notification notification) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                8 v0 = this;
                v0.NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    v0.NotificationDao_Impl.this.__deletionAdapterOfNotification.handle((Object)notification);
                }
                catch (Throwable throwable) {
                    NotificationDao_Impl.this.__db.endTransaction();
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                return null;
            }
        });
    }

    @Override
    public void updateNotifications(List<Notification> list) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        notificationDao_Impl.__db.beginTransaction();
        try {
            notificationDao_Impl.__updateAdapterOfNotification.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
    }

    @Override
    public Completable deleteNotification(final long l) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                9 v0 = this;
                SupportSQLiteStatement supportSQLiteStatement = v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.acquire();
                long l2 = l;
                supportSQLiteStatement.bindLong(1, l2);
                NotificationDao_Impl.this.__db.beginTransaction();
                try {
                    supportSQLiteStatement.executeUpdateDelete();
                }
                catch (Throwable throwable) {
                    9 v2 = this;
                    v2.NotificationDao_Impl.this.__db.endTransaction();
                    v2.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                    throw throwable;
                }
                v0.NotificationDao_Impl.this.__db.setTransactionSuccessful();
                v0.NotificationDao_Impl.this.__db.endTransaction();
                v0.NotificationDao_Impl.this.__preparedStmtOfDeleteNotification.release(supportSQLiteStatement);
                return null;
            }
        });
    }

    @Override
    public void safeDeleteAllNotifications() {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = notificationDao_Impl.__preparedStmtOfSafeDeleteAllNotifications.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            NotificationDao_Impl notificationDao_Impl2 = this;
            notificationDao_Impl2.__db.endTransaction();
            notificationDao_Impl2.__preparedStmtOfSafeDeleteAllNotifications.release(supportSQLiteStatement);
            throw throwable;
        }
        notificationDao_Impl.__db.setTransactionSuccessful();
        notificationDao_Impl.__db.endTransaction();
        notificationDao_Impl.__preparedStmtOfSafeDeleteAllNotifications.release(supportSQLiteStatement);
    }

    @Override
    public void deleteNotification(String string2) {
        NotificationDao_Impl notificationDao_Impl = this;
        notificationDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = notificationDao_Impl.__preparedStmtOfDeleteNotification_1.acquire();
        int n = 1;
        if (string2 == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, string2);
        }
        NotificationDao_Impl notificationDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            NotificationDao_Impl notificationDao_Impl3 = this;
            notificationDao_Impl3.__db.endTransaction();
            notificationDao_Impl3.__preparedStmtOfDeleteNotification_1.release(supportSQLiteStatement);
            throw throwable;
        }
        notificationDao_Impl2.__db.setTransactionSuccessful();
        notificationDao_Impl2.__db.endTransaction();
        notificationDao_Impl2.__preparedStmtOfDeleteNotification_1.release(supportSQLiteStatement);
    }

    @Override
    public Observable<List<Notification>> getNotifications() {
        Callable<List<Notification>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Notification";
        Callable<List<Notification>> callable2 = callable;
        callable = new Callable<List<Notification>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<Notification> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)NotificationDao_Impl.access$100(NotificationDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"dataJson");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"id");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"title");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"description");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"_type");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"sourceUniqueId");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"meta");
                var10_10 = v0;
                try {
                    v0 = new ArrayList<Notification>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            if (var1_1.isNull(var9_9)) break block23;
                                            v2 = this;
                                            var11_11 = var1_1.getString(var9_9);
                                            var11_11 = NotificationDao_Impl.access$000(v2.NotificationDao_Impl.this).stringToStringMap((String)var11_11);
                                            var12_12 = v3;
                                            v3 = new NotificationIcon(var11_11);
                                            break block24;
                                        }
                                        var12_12 = null;
                                    }
                                    v4 = var1_1;
                                    v5 = var3_3;
                                    var11_11 = v6;
                                    var11_11();
                                    v6.setDataJson(var1_1.getString(var2_2));
                                    if (!v4.isNull(v5)) break block25;
                                    var13_13 = null;
                                    break block26;
                                }
                                var13_13 = var1_1.getLong(var3_3);
                            }
                            var11_11.setId(var13_13);
                            var11_11.setTitle(var1_1.getString(var4_4));
                            var11_11.setDescription(var1_1.getString(var5_5));
                            var11_11.set_type(var1_1.getString(var6_6));
                            if (!var1_1.isNull(var7_7)) break block27;
                            var13_13 = null;
                            break block28;
                        }
                        var13_13 = var1_1.getLong(var7_7);
                    }
                    v7 = var11_11;
                    var11_11.setDate(NotificationDao_Impl.access$000(NotificationDao_Impl.this).timestampToDate(var13_13));
                    var11_11.setSourceUniqueId(var1_1.getString(var8_8));
                    v7.setNotificationIcon(var12_12);
                    var10_10.add((Notification)v7);
                    continue;
                }
lbl73:
                // 1 sources

                var1_1.close();
                return var10_10;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public void deleteAllNotifications() {
        NotificationDao.DefaultImpls.deleteAllNotifications(this);
    }

    @Override
    public void upsertNotificationBySourceId(Notification notification) {
        NotificationDao.DefaultImpls.upsertNotificationBySourceId(this, notification);
    }
}

