/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.notifications;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.bornfight.utils.adapters.GenericAdapter;
import com.google.android.material.button.MaterialButton;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationAction;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.notifications.NotificationsAdapter$NotificationCallViewHolder$WhenMappings;
import io.streamlayer.sdk.notifications.NotificationsAdapter$NotificationViewHolder$WhenMappings;
import io.streamlayer.sdk.notifications.NotificationsAdapter$WhenMappings;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.ExtensionsKt;
import io.streamlayer.utils.GsonUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter;", "Lcom/bornfight/utils/adapters/GenericAdapter;", "Lio/streamlayer/sdk/model/notifications/Notification;", "()V", "listener", "Lio/streamlayer/sdk/notifications/NotificationsAdapter$OnItemInteractionListener;", "getListener", "()Lio/streamlayer/sdk/notifications/NotificationsAdapter$OnItemInteractionListener;", "setListener", "(Lio/streamlayer/sdk/notifications/NotificationsAdapter$OnItemInteractionListener;)V", "getItemViewType", "", "position", "getLayoutId", "viewType", "getViewHolder", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "setItems", "", "listItems", "", "updateItems", "", "NotificationCallViewHolder", "NotificationViewHolder", "OnItemInteractionListener", "sdk_release"})
public final class NotificationsAdapter
extends GenericAdapter<Notification> {
    @Nullable
    private OnItemInteractionListener listener;

    @Nullable
    public final OnItemInteractionListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnItemInteractionListener onItemInteractionListener) {
        this.listener = onItemInteractionListener;
    }

    public void setItems(@NotNull List<Notification> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        if (!this.getListItems().containsAll(list)) {
            super.setItems(list);
        }
    }

    public final boolean updateItems(@NotNull List<Notification> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"listItems");
        if (!this.getListItems().containsAll(list)) {
            super.setItems(list);
            return true;
        }
        return false;
    }

    public int getItemViewType(int n) {
        int n2;
        switch (NotificationsAdapter$WhenMappings.$EnumSwitchMapping$0[((Notification)this.getItem(n)).getType().ordinal()]) {
            default: {
                n2 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
            }
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLayoutId(int n) {
        int n2;
        if (n != 1) {
            if (n != 2) throw new RuntimeException("Invalid ViewHolder type: " + n);
            n2 = R.layout.sl_item_notification_call;
            return n2;
        } else {
            n2 = R.layout.sl_item_notification;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected GenericAdapter.GenericViewHolder<Notification> getViewHolder(@NotNull View view, int n) {
        NotificationViewHolder notificationViewHolder;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (n != 1) {
            NotificationCallViewHolder notificationCallViewHolder;
            if (n != 2) throw new RuntimeException("Invalid ViewHolder type: " + n);
            notificationViewHolder = notificationCallViewHolder;
            notificationCallViewHolder = new NotificationCallViewHolder(this, view);
            return notificationViewHolder;
        } else {
            NotificationViewHolder notificationViewHolder2;
            notificationViewHolder = notificationViewHolder2;
            notificationViewHolder2 = new NotificationViewHolder(view);
        }
        return notificationViewHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter$OnItemInteractionListener;", "", "onNotificationActionClick", "", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "action", "Lio/streamlayer/sdk/model/notifications/NotificationAction;", "onNotificationClick", "sdk_release"})
    public static interface OnItemInteractionListener {
        public void onNotificationClick(@NotNull Notification var1);

        public void onNotificationActionClick(@NotNull Notification var1, @NotNull NotificationAction var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a8\u0006\u000e"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter$NotificationViewHolder;", "Lcom/bornfight/utils/adapters/GenericAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/notifications/Notification;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "getColor", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "getIcon", "sdk_release"})
    public class NotificationViewHolder
    extends GenericAdapter.GenericViewHolder<Notification> {
        @DrawableRes
        private final int getIcon(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: {
                    n = R.drawable.ic_profile;
                    break;
                }
                case 9: {
                    n = R.drawable.ic_chat;
                    break;
                }
                case 8: {
                    n = R.drawable.ic_twitter;
                    break;
                }
                case 7: {
                    n = R.drawable.ic_chat;
                    break;
                }
                case 6: {
                    n = R.drawable.ic_betting;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n = R.drawable.ic_call;
                    break;
                }
                case 1: {
                    n = R.drawable.ic_chat;
                }
            }
            return n;
        }

        @ColorRes
        private final int getColor(NotificationType notificationType) {
            int n;
            switch (NotificationsAdapter$NotificationViewHolder$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()]) {
                default: {
                    throw new NoWhenBranchMatchedException();
                }
                case 10: {
                    n = R.color.primaryBlue;
                    break;
                }
                case 9: {
                    n = R.color.primaryBlue;
                    break;
                }
                case 8: {
                    n = R.color.slTwitter;
                    break;
                }
                case 7: {
                    n = R.color.primaryBlue;
                    break;
                }
                case 6: {
                    n = R.color.slOrange;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n = 17170445;
                    break;
                }
                case 1: {
                    n = R.color.primaryBlue;
                }
            }
            return n;
        }

        public NotificationViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
            ((FrameLayout)view.findViewById(R.id.slNotificationHolder)).setOnTouchListener((View.OnTouchListener)1.INSTANCE);
        }

        public void bind(@NotNull Notification notification) {
            NotificationViewHolder notificationViewHolder = this;
            Intrinsics.checkParameterIsNotNull((Object)notification, (String)"data");
            View view = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            TextView textView = (TextView)view.findViewById(R.id.slNotifTitleTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"itemView.slNotifTitleTV");
            textView.setText((CharSequence)notification.getTitle());
            View view2 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
            TextView textView2 = (TextView)view2.findViewById(R.id.slNotifDescriptionTV);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"itemView.slNotifDescriptionTV");
            textView2.setText((CharSequence)notification.getDescription());
            View view3 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView");
            ((ImageView)view3.findViewById(R.id.slNotifIconIV)).setImageResource(this.getIcon(notification.getType()));
            View view4 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView");
            ImageView imageView = (ImageView)view4.findViewById(R.id.slNotifIconIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"itemView.slNotifIconIV");
            View view5 = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView");
            imageView.setBackgroundTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)view5.getContext(), (int)this.getColor(notification.getType()))));
            View view6 = notificationViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"itemView");
            ((ConstraintLayout)view6.findViewById(R.id.slNotification)).setOnClickListener(new View.OnClickListener(this, notification){
                final /* synthetic */ NotificationViewHolder this$0;
                final /* synthetic */ Notification $data;
                {
                    this.this$0 = notificationViewHolder;
                    this.$data = notification;
                }

                public final void onClick(View object) {
                    object = this.this$0.NotificationsAdapter.this.getListener();
                    if (object != null) {
                        object.onNotificationClick(this.$data);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsAdapter$NotificationCallViewHolder;", "Lio/streamlayer/sdk/notifications/NotificationsAdapter$NotificationViewHolder;", "Lio/streamlayer/sdk/notifications/NotificationsAdapter;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/notifications/NotificationsAdapter;Landroid/view/View;)V", "bind", "", "data", "Lio/streamlayer/sdk/model/notifications/Notification;", "sdk_release"})
    public final class NotificationCallViewHolder
    extends NotificationViewHolder {
        final /* synthetic */ NotificationsAdapter this$0;

        public NotificationCallViewHolder(@NotNull NotificationsAdapter notificationsAdapter, View view) {
            View view2 = view;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = notificationsAdapter;
            super(view);
            ((MaterialButton)view2.findViewById(R.id.slNotifCallAcceptBtn)).setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ NotificationCallViewHolder this$0;
                {
                    this.this$0 = notificationCallViewHolder;
                }

                public final void onClick(View object) {
                    object = object2.this$0.this$0.getListener();
                    if (object != null) {
                        Object object2 = object2.this$0;
                        object.onNotificationActionClick((Notification)((NotificationCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()), NotificationAction.AcceptCall);
                    }
                }
            });
            ((MaterialButton)view2.findViewById(R.id.slNotifCallDeclineBtn)).setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ NotificationCallViewHolder this$0;
                {
                    this.this$0 = notificationCallViewHolder;
                }

                public final void onClick(View object) {
                    object = object2.this$0.this$0.getListener();
                    if (object != null) {
                        Object object2 = object2.this$0;
                        object.onNotificationActionClick((Notification)((NotificationCallViewHolder)((Object)object2)).this$0.getItem(object2.getLayoutPosition()), NotificationAction.DeclineCall);
                    }
                }
            });
            ((MaterialButton)view2.findViewById(R.id.slNotifCallTextActionBtn)).setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ NotificationCallViewHolder this$0;
                {
                    this.this$0 = notificationCallViewHolder;
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void onClick(View object) {
                    void var1_7;
                    NotificationCallViewHolder notificationCallViewHolder = this.this$0;
                    int n = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$0[((Notification)notificationCallViewHolder.this$0.getItem(notificationCallViewHolder.getLayoutPosition())).getType().ordinal()];
                    if (n != 1) {
                        if (n != 2) throw new RuntimeException("Unsupported action for this button");
                        NotificationAction notificationAction = NotificationAction.CallBack;
                    } else {
                        NotificationAction notificationAction = NotificationAction.JoinGroupCall;
                    }
                    OnItemInteractionListener onItemInteractionListener = this.this$0.this$0.getListener();
                    if (onItemInteractionListener == null) return;
                    NotificationCallViewHolder notificationCallViewHolder2 = this.this$0;
                    onItemInteractionListener.onNotificationActionClick((Notification)notificationCallViewHolder2.this$0.getItem(notificationCallViewHolder2.getLayoutPosition()), (NotificationAction)var1_7);
                }
            });
        }

        @Override
        public void bind(@NotNull Notification object) {
            NotificationCallViewHolder notificationCallViewHolder = notificationCallViewHolder2;
            Notification notification = object;
            Intrinsics.checkParameterIsNotNull((Object)notification, (String)"data");
            super.bind(notification);
            NotificationCallViewHolder notificationCallViewHolder2 = notificationCallViewHolder.itemView;
            boolean bl = ArraysKt.contains((Object[])new NotificationType[]{NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)((Notification)object).getType()));
            MaterialButton materialButton = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallAcceptBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton, (String)"slNotifCallAcceptBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton, bl ^ true);
            MaterialButton materialButton2 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallDeclineBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton2, (String)"slNotifCallDeclineBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton2, bl ^ true);
            MaterialButton materialButton3 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallTextActionBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)materialButton3, (String)"slNotifCallTextActionBtn");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)materialButton3, bl);
            Object object2 = (MaterialButton)notificationCallViewHolder2.findViewById(R.id.slNotifCallTextActionBtn);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"slNotifCallTextActionBtn");
            int n = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$1[((Notification)object).getType().ordinal()];
            String string2 = n != 1 ? (n != 2 ? "" : notificationCallViewHolder2.getContext().getString(R.string.sl_call_back)) : notificationCallViewHolder2.getContext().getString(R.string.sl_call_back);
            object2.setText((CharSequence)string2);
            object2 = (Chat)GsonUtil.INSTANCE.getDefaultGson().fromJson(((Notification)object).getDataJson(), Chat.class);
            int n2 = NotificationsAdapter$NotificationCallViewHolder$WhenMappings.$EnumSwitchMapping$2[((Notification)object).getType().ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    ((ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV)).setImageResource(R.drawable.sl_ic_call_incoming_colored);
                } else {
                    ImageView imageView = (ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifIconIV");
                    Object object3 = ((Notification)object).getNotificationIcon();
                    object3 = object3 != null ? ((NotificationIcon)object3).getAvatarBase64() : null;
                    object = ((Notification)object).getNotificationIcon();
                    object = object != null ? ((NotificationIcon)object).getAvatarName() : null;
                    ProfileExtensionsKt.loadUserAvatar$default(imageView, (String)object3, (String)object, null, 4, null);
                }
            } else {
                ((ImageView)notificationCallViewHolder2.findViewById(R.id.slNotifIconIV)).setImageResource(R.drawable.sl_ic_contact_group);
            }
            NotificationCallViewHolder notificationCallViewHolder3 = notificationCallViewHolder2;
            ImageView imageView = (ImageView)notificationCallViewHolder3.findViewById(R.id.slNotifCallStatusIV);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slNotifCallStatusIV");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)imageView, false);
            Chronometer chronometer = (Chronometer)notificationCallViewHolder3.findViewById(R.id.slNotifCallChronometer);
            Intrinsics.checkExpressionValueIsNotNull((Object)chronometer, (String)"slNotifCallChronometer");
            io.streamlayer.common.kotlin.ExtensionsKt.visibleIf((View)chronometer, false);
            notificationCallViewHolder2 = (Chronometer)notificationCallViewHolder3.findViewById(R.id.slNotifCallChronometer);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)notificationCallViewHolder2), (String)"slNotifCallChronometer");
            object = ((Chat)object2).getUpdatedAt();
            object = object != null ? Long.valueOf(((Date)object).getTime()) : null;
            ExtensionsKt.startTimer((Chronometer)notificationCallViewHolder2, (Long)object);
        }
    }
}

