/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.contentprovider;

import android.content.Context;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.SparseArray;
import androidx.annotation.RequiresPermission;
import io.streamlayer.common.data.contentprovider.ContactsProvider;
import io.streamlayer.sdk.model.contact.PhoneContact;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "fetchContacts", "", "Lio/streamlayer/sdk/model/contact/PhoneContact;", "Companion", "sdk_release"})
public final class ContactsProvider {
    private static final String[] projection;
    private static final String selection = "mimetype in (?, ?) AND has_phone_number = '1'";
    private static final String[] selectionArgs;
    private static final String sortOrder = "sort_key_alt";
    public static final Companion Companion;
    private final Context context;

    @Inject
    public ContactsProvider(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        projection = new String[]{"mimetype", "contact_id", "display_name", "photo_uri", "starred", "account_type", "data1", "data2"};
        selectionArgs = new String[]{"vnd.android.cursor.item/email_v2", "vnd.android.cursor.item/phone_v2"};
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NotNull
    public final List<PhoneContact> fetchContacts() {
        SparseArray sparseArray;
        ArrayList arrayList;
        ContactsProvider contactsProvider = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Uri uri = ContactsContract.Data.CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"ContactsContract.Data.CONTENT_URI");
        uri = contactsProvider.context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (uri == null) {
            return CollectionsKt.emptyList();
        }
        Uri uri2 = uri;
        int n = uri2.getColumnIndex("mimetype");
        int n2 = uri2.getColumnIndex("contact_id");
        int n3 = uri2.getColumnIndex("display_name");
        int n4 = uri2.getColumnIndex("data1");
        int n5 = uri2.getColumnIndex("photo_uri");
        int n6 = uri2.getColumnIndex("data2");
        int n7 = uri2.getColumnIndex("account_type");
        SparseArray sparseArray2 = sparseArray;
        sparseArray = new SparseArray();
        while (uri.moveToNext()) {
            int n8 = uri.getInt(n2);
            String string = uri.getString(n5);
            String string2 = uri.getString(n3);
            String string3 = uri.getString(n7);
            uri.getInt(n6);
            String string4 = uri.getString(n4);
            PhoneContact phoneContact = (PhoneContact)sparseArray2.get(n8);
            if (phoneContact == null) {
                PhoneContact phoneContact2;
                PhoneContact phoneContact3 = phoneContact = phoneContact2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"contactName");
                phoneContact3(n8, string2, string, string3, null, null, 48, null);
                sparseArray2.put(n8, (Object)phoneContact3);
                arrayList2.add(phoneContact2);
            }
            if (Intrinsics.areEqual((Object)uri.getString(n), (Object)"vnd.android.cursor.item/email_v2")) {
                List<String> list = phoneContact.getEmails();
                String string5 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"contactData");
                list.add(string5);
                continue;
            }
            List<String> list = phoneContact.getPhoneNumbers();
            String string6 = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"contactData");
            list.add(string6);
        }
        uri.close();
        try {
            CollectionsKt.sortWith((List)arrayList2, (Comparator)fetchContacts.1.INSTANCE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider$Companion;", "", "()V", "projection", "", "", "[Ljava/lang/String;", "selection", "selectionArgs", "sortOrder", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

