/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.advertising;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.advertising.AdvertisingData;
import io.streamlayer.sdk.model.advertising.AdvertisingImage;
import io.streamlayer.sdk.model.advertising.AdvertisingTemplate;
import io.streamlayer.sdk.model.advertising.AdvertisingVideo;
import io.streamlayer.sdk.repository.advertising.AdvertisingDao;
import java.util.List;
import java.util.concurrent.Callable;

public final class AdvertisingDao_Impl
implements AdvertisingDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AdvertisingData> __insertionAdapterOfAdvertisingData;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<AdvertisingData> __deletionAdapterOfAdvertisingData;
    private final EntityDeletionOrUpdateAdapter<AdvertisingData> __updateAdapterOfAdvertisingData;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllAdvertisingData;

    public AdvertisingDao_Impl(RoomDatabase roomDatabase) {
        AdvertisingDao_Impl advertisingDao_Impl = this;
        this.__converters = new Converters();
        advertisingDao_Impl.__db = roomDatabase;
        advertisingDao_Impl.__insertionAdapterOfAdvertisingData = new EntityInsertionAdapter<AdvertisingData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `AdvertisingData` (`id`,`type`,`advertisingTemplateId`,`name`,`frequency`,`images`,`videos`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AdvertisingData object) {
                if (((AdvertisingData)object).getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, ((AdvertisingData)object).getId());
                }
                if (((AdvertisingData)object).getType() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, ((AdvertisingData)object).getType());
                }
                object = ((AdvertisingData)object).getAttributes();
                if (object != null) {
                    if (((AdvertisingTemplate)object).getId() == null) {
                        supportSQLiteStatement.bindNull(3);
                    } else {
                        supportSQLiteStatement.bindString(3, ((AdvertisingTemplate)object).getId());
                    }
                    if (((AdvertisingTemplate)object).getName() == null) {
                        supportSQLiteStatement.bindNull(4);
                    } else {
                        supportSQLiteStatement.bindString(4, ((AdvertisingTemplate)object).getName());
                    }
                    long l = ((AdvertisingTemplate)object).getFrequency();
                    supportSQLiteStatement.bindLong(5, l);
                    String string2 = object2.AdvertisingDao_Impl.this.__converters.advertisingImagesToString(((AdvertisingTemplate)object).getImages());
                    if (string2 == null) {
                        supportSQLiteStatement.bindNull(6);
                    } else {
                        supportSQLiteStatement.bindString(6, string2);
                    }
                    Object object2 = object2.AdvertisingDao_Impl.this.__converters.advertisingVideosToString(((AdvertisingTemplate)object).getVideos());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(7);
                    } else {
                        supportSQLiteStatement.bindString(7, (String)object2);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(3);
                    supportSQLiteStatement2.bindNull(4);
                    supportSQLiteStatement2.bindNull(5);
                    supportSQLiteStatement2.bindNull(6);
                    supportSQLiteStatement2.bindNull(7);
                }
            }
        };
        advertisingDao_Impl.__deletionAdapterOfAdvertisingData = new EntityDeletionOrUpdateAdapter<AdvertisingData>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `AdvertisingData` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AdvertisingData advertisingData) {
                if (advertisingData.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, advertisingData.getId());
                }
            }
        };
        advertisingDao_Impl.__updateAdapterOfAdvertisingData = new EntityDeletionOrUpdateAdapter<AdvertisingData>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `AdvertisingData` SET `id` = ?,`type` = ?,`advertisingTemplateId` = ?,`name` = ?,`frequency` = ?,`images` = ?,`videos` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, AdvertisingData advertisingData) {
                if (advertisingData.getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, advertisingData.getId());
                }
                if (advertisingData.getType() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, advertisingData.getType());
                }
                AdvertisingTemplate advertisingTemplate = advertisingData.getAttributes();
                if (advertisingTemplate != null) {
                    if (advertisingTemplate.getId() == null) {
                        supportSQLiteStatement.bindNull(3);
                    } else {
                        supportSQLiteStatement.bindString(3, advertisingTemplate.getId());
                    }
                    if (advertisingTemplate.getName() == null) {
                        supportSQLiteStatement.bindNull(4);
                    } else {
                        supportSQLiteStatement.bindString(4, advertisingTemplate.getName());
                    }
                    long l = advertisingTemplate.getFrequency();
                    supportSQLiteStatement.bindLong(5, l);
                    String string2 = object.AdvertisingDao_Impl.this.__converters.advertisingImagesToString(advertisingTemplate.getImages());
                    if (string2 == null) {
                        supportSQLiteStatement.bindNull(6);
                    } else {
                        supportSQLiteStatement.bindString(6, string2);
                    }
                    Object object = object.AdvertisingDao_Impl.this.__converters.advertisingVideosToString(advertisingTemplate.getVideos());
                    if (object == null) {
                        supportSQLiteStatement.bindNull(7);
                    } else {
                        supportSQLiteStatement.bindString(7, (String)object);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(3);
                    supportSQLiteStatement2.bindNull(4);
                    supportSQLiteStatement2.bindNull(5);
                    supportSQLiteStatement2.bindNull(6);
                    supportSQLiteStatement2.bindNull(7);
                }
                if (advertisingData.getId() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, advertisingData.getId());
                }
            }
        };
        advertisingDao_Impl.__preparedStmtOfDeleteAllAdvertisingData = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM AdvertisingData";
            }
        };
    }

    @Override
    public void saveAdvertisingData(AdvertisingData advertisingData) {
        AdvertisingDao_Impl advertisingDao_Impl = this;
        advertisingDao_Impl.__db.assertNotSuspendingTransaction();
        advertisingDao_Impl.__db.beginTransaction();
        try {
            advertisingDao_Impl.__insertionAdapterOfAdvertisingData.insert((Object)advertisingData);
            advertisingDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        advertisingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteAdvertisingData(AdvertisingData advertisingData) {
        AdvertisingDao_Impl advertisingDao_Impl = this;
        advertisingDao_Impl.__db.assertNotSuspendingTransaction();
        advertisingDao_Impl.__db.beginTransaction();
        try {
            advertisingDao_Impl.__deletionAdapterOfAdvertisingData.handle((Object)advertisingData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        advertisingDao_Impl.__db.setTransactionSuccessful();
        advertisingDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateAdvertisingData(AdvertisingData advertisingData) {
        AdvertisingDao_Impl advertisingDao_Impl = this;
        advertisingDao_Impl.__db.assertNotSuspendingTransaction();
        advertisingDao_Impl.__db.beginTransaction();
        try {
            advertisingDao_Impl.__updateAdapterOfAdvertisingData.handle((Object)advertisingData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        advertisingDao_Impl.__db.setTransactionSuccessful();
        advertisingDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteAllAdvertisingData() {
        AdvertisingDao_Impl advertisingDao_Impl = this;
        advertisingDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = advertisingDao_Impl.__preparedStmtOfDeleteAllAdvertisingData.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            AdvertisingDao_Impl advertisingDao_Impl2 = this;
            advertisingDao_Impl2.__db.endTransaction();
            advertisingDao_Impl2.__preparedStmtOfDeleteAllAdvertisingData.release(supportSQLiteStatement);
            throw throwable;
        }
        advertisingDao_Impl.__db.setTransactionSuccessful();
        advertisingDao_Impl.__db.endTransaction();
        advertisingDao_Impl.__preparedStmtOfDeleteAllAdvertisingData.release(supportSQLiteStatement);
    }

    @Override
    public Observable<AdvertisingData> getAdvertisingData() {
        Callable<AdvertisingData> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM AdvertisingData", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "AdvertisingData";
        Callable<AdvertisingData> callable2 = callable;
        callable = new Callable<AdvertisingData>(){

            @Override
            public AdvertisingData call() throws Exception {
                Cursor cursor;
                block29: {
                    Object object;
                    block26: {
                        AdvertisingData advertisingData;
                        Object object2;
                        String string2;
                        String string3;
                        block28: {
                            AdvertisingTemplate advertisingTemplate;
                            int n;
                            int n2;
                            int n3;
                            int n4;
                            int n5;
                            block27: {
                                int n6;
                                cursor = DBUtil.query((RoomDatabase)object.AdvertisingDao_Impl.this.__db, (SupportSQLiteQuery)object.roomSQLiteQuery, (boolean)false, null);
                                try {
                                    n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"id");
                                }
                                catch (Throwable throwable) {
                                    cursor.close();
                                    throw throwable;
                                }
                                int n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"type");
                                n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"advertisingTemplateId");
                                n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                                n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"frequency");
                                n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"images");
                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"videos");
                                if (!cursor.moveToFirst()) break block26;
                                Cursor cursor2 = cursor;
                                int n8 = n5;
                                Cursor cursor3 = cursor;
                                int n9 = n7;
                                string3 = cursor.getString(n6);
                                string2 = cursor3.getString(n9);
                                if (!cursor2.isNull(n8)) break block27;
                                if (!cursor.isNull(n4)) break block27;
                                if (!cursor.isNull(n3)) break block27;
                                if (!cursor.isNull(n2)) break block27;
                                if (!cursor.isNull(n)) break block27;
                                object2 = object = null;
                                break block28;
                            }
                            5 v5 = object;
                            Cursor cursor4 = cursor;
                            int n10 = n;
                            5 v8 = object;
                            Cursor cursor5 = cursor;
                            int n11 = n2;
                            Cursor cursor6 = cursor;
                            int n12 = n3;
                            Cursor cursor7 = cursor;
                            int n13 = n4;
                            object = cursor.getString(n5);
                            String string4 = cursor7.getString(n13);
                            n4 = cursor6.getInt(n12);
                            Object object3 = cursor5.getString(n11);
                            object3 = v8.AdvertisingDao_Impl.this.__converters.stringToAdvertisingImages((String)object3);
                            Object object4 = cursor4.getString(n10);
                            object4 = v5.AdvertisingDao_Impl.this.__converters.stringToAdvertisingVideos((String)object4);
                            object2 = advertisingTemplate;
                            advertisingTemplate = new AdvertisingTemplate((String)object, string4, n4, (List<AdvertisingImage>)object3, (List<AdvertisingVideo>)object4);
                        }
                        object = advertisingData;
                        advertisingData = new AdvertisingData(string3, string2, (AdvertisingTemplate)object2);
                        break block29;
                    }
                    object = null;
                }
                cursor.close();
                return object;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }
}

