/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.phonecontact;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.contact.PhoneContact;
import io.streamlayer.sdk.repository.phonecontact.PhoneContactDao;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class PhoneContactDao_Impl
implements PhoneContactDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PhoneContact> __insertionAdapterOfPhoneContact;
    private final Converters __converters;
    private final EntityDeletionOrUpdateAdapter<PhoneContact> __deletionAdapterOfPhoneContact;
    private final EntityDeletionOrUpdateAdapter<PhoneContact> __updateAdapterOfPhoneContact;
    private final SharedSQLiteStatement __preparedStmtOfDeletePhoneContacts;

    public PhoneContactDao_Impl(RoomDatabase roomDatabase) {
        PhoneContactDao_Impl phoneContactDao_Impl = this;
        this.__converters = new Converters();
        phoneContactDao_Impl.__db = roomDatabase;
        phoneContactDao_Impl.__insertionAdapterOfPhoneContact = new EntityInsertionAdapter<PhoneContact>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `PhoneContact` (`contactId`,`name`,`photoUri`,`contactAccountType`,`locallyUpdatedAt`,`phoneNumbers`,`emails`,`tinodeUserId`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, PhoneContact phoneContact) {
                long l = phoneContact.getContactId();
                supportSQLiteStatement.bindLong(1, l);
                if (phoneContact.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, phoneContact.getName());
                }
                if (phoneContact.getPhotoUri() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, phoneContact.getPhotoUri());
                }
                if (phoneContact.getContactAccountType() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, phoneContact.getContactAccountType());
                }
                l = phoneContact.getLocallyUpdatedAt();
                supportSQLiteStatement.bindLong(5, l);
                String string2 = object.PhoneContactDao_Impl.this.__converters.stringListToString(phoneContact.getPhoneNumbers());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, string2);
                }
                Object object = object.PhoneContactDao_Impl.this.__converters.stringListToString(phoneContact.getEmails());
                if (object == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, (String)object);
                }
                if (phoneContact.getTinodeUserId() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, phoneContact.getTinodeUserId());
                }
            }
        };
        phoneContactDao_Impl.__deletionAdapterOfPhoneContact = new EntityDeletionOrUpdateAdapter<PhoneContact>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `PhoneContact` WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, PhoneContact phoneContact) {
                long l = phoneContact.getContactId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        phoneContactDao_Impl.__updateAdapterOfPhoneContact = new EntityDeletionOrUpdateAdapter<PhoneContact>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `PhoneContact` SET `contactId` = ?,`name` = ?,`photoUri` = ?,`contactAccountType` = ?,`locallyUpdatedAt` = ?,`phoneNumbers` = ?,`emails` = ?,`tinodeUserId` = ? WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, PhoneContact phoneContact) {
                long l = phoneContact.getContactId();
                supportSQLiteStatement.bindLong(1, l);
                if (phoneContact.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, phoneContact.getName());
                }
                if (phoneContact.getPhotoUri() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, phoneContact.getPhotoUri());
                }
                if (phoneContact.getContactAccountType() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, phoneContact.getContactAccountType());
                }
                l = phoneContact.getLocallyUpdatedAt();
                supportSQLiteStatement.bindLong(5, l);
                String string2 = object.PhoneContactDao_Impl.this.__converters.stringListToString(phoneContact.getPhoneNumbers());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(6);
                } else {
                    supportSQLiteStatement.bindString(6, string2);
                }
                Object object = object.PhoneContactDao_Impl.this.__converters.stringListToString(phoneContact.getEmails());
                if (object == null) {
                    supportSQLiteStatement.bindNull(7);
                } else {
                    supportSQLiteStatement.bindString(7, (String)object);
                }
                if (phoneContact.getTinodeUserId() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindString(8, phoneContact.getTinodeUserId());
                }
                long l2 = phoneContact.getContactId();
                supportSQLiteStatement.bindLong(9, l2);
            }
        };
        phoneContactDao_Impl.__preparedStmtOfDeletePhoneContacts = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM PhoneContact";
            }
        };
    }

    @Override
    public void savePhoneContacts(List<PhoneContact> list) {
        PhoneContactDao_Impl phoneContactDao_Impl = this;
        phoneContactDao_Impl.__db.assertNotSuspendingTransaction();
        phoneContactDao_Impl.__db.beginTransaction();
        try {
            phoneContactDao_Impl.__insertionAdapterOfPhoneContact.insert(list);
            phoneContactDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        phoneContactDao_Impl.__db.endTransaction();
    }

    @Override
    public void deletePhoneContacts(List<PhoneContact> list) {
        PhoneContactDao_Impl phoneContactDao_Impl = this;
        phoneContactDao_Impl.__db.assertNotSuspendingTransaction();
        phoneContactDao_Impl.__db.beginTransaction();
        try {
            phoneContactDao_Impl.__deletionAdapterOfPhoneContact.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        phoneContactDao_Impl.__db.setTransactionSuccessful();
        phoneContactDao_Impl.__db.endTransaction();
    }

    @Override
    public void updatePhoneContacts(List<PhoneContact> list) {
        PhoneContactDao_Impl phoneContactDao_Impl = this;
        phoneContactDao_Impl.__db.assertNotSuspendingTransaction();
        phoneContactDao_Impl.__db.beginTransaction();
        try {
            phoneContactDao_Impl.__updateAdapterOfPhoneContact.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        phoneContactDao_Impl.__db.setTransactionSuccessful();
        phoneContactDao_Impl.__db.endTransaction();
    }

    @Override
    public void deletePhoneContacts() {
        PhoneContactDao_Impl phoneContactDao_Impl = this;
        phoneContactDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = phoneContactDao_Impl.__preparedStmtOfDeletePhoneContacts.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            PhoneContactDao_Impl phoneContactDao_Impl2 = this;
            phoneContactDao_Impl2.__db.endTransaction();
            phoneContactDao_Impl2.__preparedStmtOfDeletePhoneContacts.release(supportSQLiteStatement);
            throw throwable;
        }
        phoneContactDao_Impl.__db.setTransactionSuccessful();
        phoneContactDao_Impl.__db.endTransaction();
        phoneContactDao_Impl.__preparedStmtOfDeletePhoneContacts.release(supportSQLiteStatement);
    }

    @Override
    public Observable<List<PhoneContact>> getPhoneContacts(String string2, boolean bl, int n, int n2) {
        Callable<List<PhoneContact>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM PhoneContact WHERE name  LIKE '%' || ? || '%' AND (? = 1 AND tinodeUserId IS NULL OR ? = 0) ORDER BY name LIMIT ? OFFSET ?", (int)5);
        int n3 = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n3);
        } else {
            roomSQLiteQuery.bindString(n3, string2);
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        roomSQLiteQuery2.bindLong(2, (long)bl);
        roomSQLiteQuery2.bindLong(3, (long)bl);
        long l = n;
        roomSQLiteQuery.bindLong(4, l);
        l = n2;
        roomSQLiteQuery.bindLong(5, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "PhoneContact";
        Callable<List<PhoneContact>> callable2 = callable;
        callable = new Callable<List<PhoneContact>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<PhoneContact> call() throws Exception {
                ArrayList<PhoneContact> arrayList;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                Cursor cursor = DBUtil.query((RoomDatabase)PhoneContactDao_Impl.this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                try {
                    n8 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contactId");
                    n7 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                    n6 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"photoUri");
                    n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"contactAccountType");
                    n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"locallyUpdatedAt");
                    n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNumbers");
                    n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emails");
                    n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"tinodeUserId");
                }
                catch (Throwable throwable) {
                    cursor.close();
                    throw throwable;
                }
                ArrayList<PhoneContact> arrayList2 = arrayList;
                arrayList = new ArrayList<PhoneContact>(cursor.getCount());
                while (cursor.moveToNext()) {
                    int n9 = cursor.getInt(n8);
                    String string2 = cursor.getString(n7);
                    String string3 = cursor.getString(n6);
                    String string4 = cursor.getString(n5);
                    long l = cursor.getLong(n4);
                    Object object = cursor.getString(n3);
                    object = PhoneContactDao_Impl.this.__converters.stringToStringList((String)object);
                    Object object2 = cursor.getString(n2);
                    object2 = PhoneContactDao_Impl.this.__converters.stringToStringList((String)object2);
                    String string5 = cursor.getString(n);
                    arrayList2.add(new PhoneContact(n9, string2, string3, string4, l, (List<String>)object, (List<String>)object2, string5));
                }
                cursor.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }
}

