/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.view.View;
import android.widget.Chronometer;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.navigation.NavController;
import androidx.navigation.fragment.FragmentKt;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.ExtensionsKt;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a+\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001aO\u0010\f\u001a\u00020\r*\u00020\u000e2\b\b\u0003\u0010\u000f\u001a\u00020\u00102\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\b\u0003\u0010\u0013\u001a\u00020\u00102\b\b\u0003\u0010\u0014\u001a\u00020\u00102\b\b\u0003\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0016\u001aM\u0010\u0017\u001a\u00020\r*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\b\u0003\u0010\u0013\u001a\u00020\u00102\b\b\u0003\u0010\u0014\u001a\u00020\u00102\b\b\u0003\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001b\u001a\u0019\u0010\u001c\u001a\u00020\r*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 \u001a\n\u0010!\u001a\u00020\u0001*\u00020\"\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0010\u00a8\u0006$"}, d2={"getAppName", "", "Landroid/content/Context;", "kelvinToCelsiusString", "", "md5", "Ljava/io/File;", "random", "T", "", "probabilities", "(Ljava/util/List;Ljava/util/List;)Ljava/lang/Object;", "setupToolbarWithNavController", "", "Landroidx/fragment/app/Fragment;", "toolbarId", "", "navIconResource", "ad", "navButtonId", "titleId", "adSpaceId", "(Landroidx/fragment/app/Fragment;ILjava/lang/Integer;Ljava/lang/String;III)V", "setupWithNavController", "Landroidx/appcompat/widget/Toolbar;", "controller", "Landroidx/navigation/NavController;", "(Landroidx/appcompat/widget/Toolbar;Landroidx/navigation/NavController;Ljava/lang/Integer;Ljava/lang/String;III)V", "startTimer", "Landroid/widget/Chronometer;", "startedAt", "", "(Landroid/widget/Chronometer;Ljava/lang/Long;)V", "toHex", "", "toOrdinalString", "sdk_release"})
public final class ExtensionsKt {
    @NotNull
    public static final String kelvinToCelsiusString(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[]{d - 273.15};
        String string2 = String.format("%.2f", Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return stringBuilder.append(string2).append("\u00b0C").toString();
    }

    public static final void setupWithNavController(@NotNull Toolbar toolbar, @NotNull NavController navController, @DrawableRes @Nullable Integer n, @Nullable String string2, @IdRes int n2, @IdRes int n3, @IdRes int n4) {
        NavController navController2 = navController;
        Intrinsics.checkParameterIsNotNull((Object)toolbar, (String)"$this$setupWithNavController");
        Intrinsics.checkParameterIsNotNull((Object)navController2, (String)"controller");
        Object object = navController2.getCurrentDestination();
        toolbar.setTitle(null);
        View view = toolbar.findViewById(n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<TextView>(titleId)");
        TextView textView = (TextView)view;
        object = object != null ? object.getLabel() : null;
        textView.setText((CharSequence)object);
        ImageButton imageButton = (ImageButton)toolbar.findViewById(n2);
        int n5 = n != null ? n : R.drawable.ic_chevron_left;
        ImageButton imageButton2 = imageButton;
        imageButton2.setImageResource(n5);
        imageButton2.setOnClickListener(new View.OnClickListener(n, navController){
            final /* synthetic */ Integer $navIconResource$inlined;
            final /* synthetic */ NavController $controller$inlined;
            {
                this.$navIconResource$inlined = n;
                this.$controller$inlined = navController;
            }

            public final void onClick(View view) {
                this.$controller$inlined.navigateUp();
            }
        });
        if (string2 != null && (toolbar = (ImageView)toolbar.findViewById(n4)) != null) {
            io.streamlayer.common.kotlin.ExtensionsKt.loadUrl$default((ImageView)toolbar, string2, false, null, null, 14, null);
        }
    }

    public static /* synthetic */ void setupWithNavController$default(Toolbar toolbar, NavController navController, Integer n, String string2, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n = null;
        }
        if ((n5 & 4) != 0) {
            string2 = null;
        }
        if ((n5 & 8) != 0) {
            n2 = R.id.toolbarNavButton;
        }
        if ((n5 & 0x10) != 0) {
            n3 = R.id.toolbarTitle;
        }
        if ((n5 & 0x20) != 0) {
            n4 = R.id.toolbarAdSpace;
        }
        ExtensionsKt.setupWithNavController(toolbar, navController, n, string2, n2, n3, n4);
    }

    public static final void setupToolbarWithNavController(@NotNull Fragment fragment, @IdRes int n, @DrawableRes @Nullable Integer n2, @Nullable String string2, @IdRes int n3, @IdRes int n4, @IdRes int n5) {
        Toolbar toolbar;
        Fragment fragment2 = fragment;
        Intrinsics.checkParameterIsNotNull((Object)fragment2, (String)"$this$setupToolbarWithNavController");
        View view = fragment2.getView();
        if (view != null && (toolbar = (Toolbar)view.findViewById(n)) != null) {
            ExtensionsKt.setupWithNavController(toolbar, FragmentKt.findNavController((Fragment)fragment), n2, string2, n3, n4, n5);
        }
    }

    public static /* synthetic */ void setupToolbarWithNavController$default(Fragment fragment, int n, Integer n2, String string2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = R.id.toolbar;
        }
        if ((n6 & 2) != 0) {
            n2 = null;
        }
        if ((n6 & 4) != 0) {
            string2 = null;
        }
        if ((n6 & 8) != 0) {
            n3 = R.id.toolbarNavButton;
        }
        if ((n6 & 0x10) != 0) {
            n4 = R.id.toolbarTitle;
        }
        if ((n6 & 0x20) != 0) {
            n5 = R.id.toolbarAdSpace;
        }
        ExtensionsKt.setupToolbarWithNavController(fragment, n, n2, string2, n3, n4, n5);
    }

    @NotNull
    public static final String toHex(@NotNull byte[] object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"$this$toHex");
        object = (Object)toHex.1.INSTANCE;
        return ArraysKt.joinToString$default((byte[])object, (CharSequence)"", null, null, (int)0, null, (Function1)object, (int)30, null);
    }

    @NotNull
    public static final String md5(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"$this$md5");
        byte[] byArray = MessageDigest.getInstance("MD5").digest(FilesKt.readBytes((File)file));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bytes");
        return ExtensionsKt.toHex(byArray);
    }

    @NotNull
    public static final String toOrdinalString(int n) {
        String string2;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        stringArray[0] = "th";
        stringArray[1] = "st";
        stringArray[2] = "nd";
        stringArray[3] = "rd";
        stringArray[4] = "th";
        stringArray[5] = "th";
        stringArray[6] = "th";
        stringArray[7] = "th";
        stringArray[8] = "th";
        stringArray[9] = "th";
        switch (n % 100) {
            default: {
                string2 = String.valueOf(n) + stringArray2[n % 10];
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                Object[] objectArray = new Object[]{n};
                string2 = String.format("%dth", Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            }
        }
        return string2;
    }

    @NotNull
    public static final String getAppName(@NotNull Context object) {
        Context context = object;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"$this$getAppName");
        PackageManager packageManager = context.getPackageManager();
        try {
            Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"this.packageManager");
            object = ((Object)packageManager.getApplicationLabel(packageManager.getApplicationInfo(object.getPackageName(), 0))).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "";
        }
        return object;
    }

    public static final void startTimer(@NotNull Chronometer chronometer, @Nullable Long l) {
        long l2;
        Intrinsics.checkParameterIsNotNull((Object)chronometer, (String)"$this$startTimer");
        if (l != null) {
            l2 = l;
            l2 = System.currentTimeMillis() - l2;
        } else {
            l2 = 0L;
        }
        Chronometer chronometer2 = chronometer;
        chronometer2.setBase(SystemClock.elapsedRealtime() - l2);
        chronometer2.start();
    }

    public static final <T> T random(@NotNull List<? extends T> list, @NotNull List<Double> list2) {
        List<Double> list3 = list2;
        Intrinsics.checkParameterIsNotNull(list, (String)"$this$random");
        Intrinsics.checkParameterIsNotNull(list3, (String)"probabilities");
        Iterator iterator = list3.iterator();
        if (iterator.hasNext()) {
            Object object = iterator.next();
            while (iterator.hasNext()) {
                double d = ((Number)iterator.next()).doubleValue();
                object = ((Number)object).doubleValue() + d;
            }
            double d = ((Number)object).doubleValue();
            d = Random.Default.nextDouble(d);
            double d2 = 0.0;
            int n = 0;
            for (Object t : list2) {
                double d3;
                int n2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                d2 += ((Number)t).doubleValue();
                if (d < d3) {
                    return list.get(n);
                }
                n = n2;
            }
            List<T> list4 = list;
            return list4.get(list4.size() - 1);
        }
        throw new UnsupportedOperationException("Empty collection can't be reduced.");
    }
}

