/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.sports.events;

import android.database.Cursor;
import androidx.collection.LongSparseArray;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.sports.EventPeriod;
import io.streamlayer.sdk.model.sports.EventScheduleAttributes;
import io.streamlayer.sdk.model.sports.EventScheduleAttributesRelation;
import io.streamlayer.sdk.model.sports.EventScheduleData;
import io.streamlayer.sdk.model.sports.EventScheduleDataRelation;
import io.streamlayer.sdk.model.sports.EventStatus;
import io.streamlayer.sdk.model.sports.EventSummary;
import io.streamlayer.sdk.model.sports.EventSummaryAwayEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryHomeEventTeamCrossRef;
import io.streamlayer.sdk.model.sports.EventSummaryRelation;
import io.streamlayer.sdk.model.sports.EventSummaryResponseData;
import io.streamlayer.sdk.model.sports.EventSummaryResponseDataRelation;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.EventTime;
import io.streamlayer.sdk.model.sports.EventType;
import io.streamlayer.sdk.model.sports.TeamRecord;
import io.streamlayer.sdk.model.sports.baseball.BaseballEventScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballBoxScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventScore;
import io.streamlayer.sdk.model.sports.basketball.BasketballEventSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballPerformers;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlay;
import io.streamlayer.sdk.model.sports.basketball.BasketballPlayByPlayStatistics;
import io.streamlayer.sdk.model.sports.basketball.BasketballStandings;
import io.streamlayer.sdk.model.sports.basketball.BasketballSummary;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamRank;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStanding;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamStreak;
import io.streamlayer.sdk.model.sports.basketball.BasketballTeamSummary;
import io.streamlayer.sdk.model.sports.basketball.PlayerScores;
import io.streamlayer.sdk.model.sports.hockey.HockeyEventScore;
import io.streamlayer.sdk.repository.sports.events.SportEventsDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public final class SportEventsDao_Impl
implements SportEventsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BasketballEventSummary> __insertionAdapterOfBasketballEventSummary;
    private final Converters __converters;
    private final EntityInsertionAdapter<BasketballBoxScore> __insertionAdapterOfBasketballBoxScore;
    private final EntityInsertionAdapter<BasketballPlayByPlay> __insertionAdapterOfBasketballPlayByPlay;
    private final EntityInsertionAdapter<BasketballTeamStanding> __insertionAdapterOfBasketballTeamStanding;
    private final EntityInsertionAdapter<EventSummaryResponseData> __insertionAdapterOfEventSummaryResponseData;
    private final EntityInsertionAdapter<EventTeam> __insertionAdapterOfEventTeam;
    private final EntityInsertionAdapter<EventSummary> __insertionAdapterOfEventSummary;
    private final EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef> __insertionAdapterOfEventSummaryHomeEventTeamCrossRef;
    private final EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef> __insertionAdapterOfEventSummaryAwayEventTeamCrossRef;
    private final EntityInsertionAdapter<EventScheduleData> __insertionAdapterOfEventScheduleData;
    private final EntityInsertionAdapter<EventScheduleAttributes> __insertionAdapterOfEventScheduleAttributes;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __deletionAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __deletionAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __deletionAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __deletionAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __deletionAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __deletionAdapterOfEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballEventSummary> __updateAdapterOfBasketballEventSummary;
    private final EntityDeletionOrUpdateAdapter<BasketballBoxScore> __updateAdapterOfBasketballBoxScore;
    private final EntityDeletionOrUpdateAdapter<BasketballPlayByPlay> __updateAdapterOfBasketballPlayByPlay;
    private final EntityDeletionOrUpdateAdapter<BasketballTeamStanding> __updateAdapterOfBasketballTeamStanding;
    private final EntityDeletionOrUpdateAdapter<EventSummaryResponseData> __updateAdapterOfEventSummaryResponseData;
    private final EntityDeletionOrUpdateAdapter<EventTeam> __updateAdapterOfEventTeam;
    private final EntityDeletionOrUpdateAdapter<EventSummary> __updateAdapterOfEventSummary;
    private final SharedSQLiteStatement __preparedStmtOfDeleteBasketballStandings;
    private final SharedSQLiteStatement __preparedStmtOfDeleteEventSchedules;

    public SportEventsDao_Impl(RoomDatabase roomDatabase) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__converters = new Converters();
        sportEventsDao_Impl.__db = roomDatabase;
        sportEventsDao_Impl.__insertionAdapterOfBasketballEventSummary = new EntityInsertionAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballEventSummary` (`basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary object) {
                long l = ((BasketballEventSummary)object).getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = object2.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(((BasketballEventSummary)object).getPerformers());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object2);
                }
                object2 = ((BasketballEventSummary)object).getSummary();
                if (object2 != null) {
                    object = ((BasketballSummary)object2).getHomeTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object2 = ((BasketballSummary)object2).getAwayTeamStatistics();
                    if (object2 != null) {
                        double d = ((BasketballTeamSummary)object2).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object2).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object2).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object2).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object2).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfBasketballBoxScore = new EntityInsertionAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballBoxScore` (`basketballBoxScoreId`,`homePlayerScores`,`awayPlayerScore`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfBasketballPlayByPlay = new EntityInsertionAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballPlayByPlay` (`basketballPlayByPlayId`,`statistics`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfBasketballTeamStanding = new EntityInsertionAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `BasketballTeamStanding` (`id`,`teamName`,`teamIcon`,`colors`,`wins`,`losses`,`percentage`,`gamesBehind`,`division`,`conference`,`streakkind`,`streaklength`,`rankdivision`,`rankconference`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(12, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(11);
                    supportSQLiteStatement2.bindNull(12);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    long l3 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(13, l3);
                    l3 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(14, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(13);
                    supportSQLiteStatement3.bindNull(14);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryResponseData = new EntityInsertionAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryResponseData` (`eventSummaryResponseDataId`,`type`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventTeam = new EntityInsertionAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventTeam` (`eventTeamId`,`name`,`alias`,`logo`,`colors`,`isWinner`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummary = new EntityInsertionAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummary` (`scheduleDateString`,`scheduleDate`,`eventSummaryId`,`scheduled`,`league`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                Object object = eventSummary.scheduledDateString;
                if (object == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, (String)object);
                }
                object = object2.SportEventsDao_Impl.this.__converters.dateToString(eventSummary.scheduleDate);
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = (Long)object;
                    supportSQLiteStatement.bindLong(2, l);
                }
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(3, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventSummary.getScheduled());
                }
                if (eventSummary.getLeague() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, eventSummary.getLeague());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(6, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(7, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(8, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(9, l);
                String string2 = object2.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, string2);
                }
                Object object2 = object2.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, (String)object2);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(12, l2);
                object2 = eventSummary.getEventTime();
                if (object2 != null) {
                    if (((EventTime)object2).getClock() == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, ((EventTime)object2).getClock());
                    }
                    long l3 = ((EventTime)object2).getPeriod();
                    supportSQLiteStatement.bindLong(14, l3);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(13);
                    supportSQLiteStatement2.bindNull(14);
                }
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef = new EntityInsertionAdapter<EventSummaryHomeEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryHomeEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
                long l = eventSummaryHomeEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryHomeEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef = new EntityInsertionAdapter<EventSummaryAwayEventTeamCrossRef>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventSummaryAwayEventTeamCrossRef` (`eventSummaryId`,`eventTeamId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
                long l = eventSummaryAwayEventTeamCrossRef.getEventSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                l = eventSummaryAwayEventTeamCrossRef.getEventTeamId();
                supportSQLiteStatement.bindLong(2, l);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventScheduleData = new EntityInsertionAdapter<EventScheduleData>(roomDatabase){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `EventScheduleData` (`eventScheduleDataId`,`type`,`attributesId`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventScheduleData eventScheduleData) {
                long l = eventScheduleData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventScheduleData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = eventScheduleData.getAttributesId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        sportEventsDao_Impl.__insertionAdapterOfEventScheduleAttributes = new EntityInsertionAdapter<EventScheduleAttributes>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `EventScheduleAttributes` (`eventScheduleAttributesId`,`basketballhomeTeamRecord`,`basketballawayTeamRecord`,`baseballouts`,`baseballinning`,`baseballinningDivision`,`baseballdelayed`,`baseballreasonForDelay`,`baseballtakenBases`,`baseballhomeTeamRecord`,`baseballawayTeamRecord`,`hockeyhomeTeamRecord`,`hockeyawayTeamRecord`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventScheduleAttributes object) {
                long l = ((EventScheduleAttributes)object).getSummaryId();
                supportSQLiteStatement.bindLong(1, l);
                Object object2 = ((EventScheduleAttributes)object).getBasketballScore();
                if (object2 != null) {
                    String string2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BasketballEventScore)object2).getHomeTeamRecord());
                    if (string2 == null) {
                        supportSQLiteStatement.bindNull(2);
                    } else {
                        supportSQLiteStatement.bindString(2, string2);
                    }
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BasketballEventScore)object2).getAwayTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(3);
                    } else {
                        supportSQLiteStatement.bindString(3, (String)object2);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(2);
                    supportSQLiteStatement2.bindNull(3);
                }
                object2 = ((EventScheduleAttributes)object).getBaseballEventScore();
                if (object2 != null) {
                    long l2 = ((BaseballEventScore)object2).getOuts();
                    supportSQLiteStatement.bindLong(4, l2);
                    l2 = ((BaseballEventScore)object2).getInning();
                    supportSQLiteStatement.bindLong(5, l2);
                    if (((BaseballEventScore)object2).getInningDivision() == null) {
                        supportSQLiteStatement.bindNull(6);
                    } else {
                        supportSQLiteStatement.bindString(6, ((BaseballEventScore)object2).getInningDivision());
                    }
                    l2 = (long)((BaseballEventScore)object2).getDelayed();
                    supportSQLiteStatement.bindLong(7, l2);
                    if (((BaseballEventScore)object2).getReasonForDelay() == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, ((BaseballEventScore)object2).getReasonForDelay());
                    }
                    l2 = ((BaseballEventScore)object2).getTakenBases();
                    supportSQLiteStatement.bindLong(9, l2);
                    String string3 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BaseballEventScore)object2).getHomeTeamRecord());
                    if (string3 == null) {
                        supportSQLiteStatement.bindNull(10);
                    } else {
                        supportSQLiteStatement.bindString(10, string3);
                    }
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((BaseballEventScore)object2).getAwayTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, (String)object2);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(4);
                    supportSQLiteStatement3.bindNull(5);
                    supportSQLiteStatement3.bindNull(6);
                    supportSQLiteStatement3.bindNull(7);
                    supportSQLiteStatement3.bindNull(8);
                    supportSQLiteStatement3.bindNull(9);
                    supportSQLiteStatement3.bindNull(10);
                    supportSQLiteStatement3.bindNull(11);
                }
                object = ((EventScheduleAttributes)object).getHockeyEventScore();
                if (object != null) {
                    object2 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((HockeyEventScore)object).getHomeTeamRecord());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(12);
                    } else {
                        supportSQLiteStatement.bindString(12, (String)object2);
                    }
                    Object object3 = object3.SportEventsDao_Impl.this.__converters.teamRecordToString(((HockeyEventScore)object).getAwayTeamRecord());
                    if (object3 == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, (String)object3);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(12);
                    supportSQLiteStatement4.bindNull(13);
                }
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfBasketballEventSummary = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfBasketballBoxScore = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballBoxScore` WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfBasketballPlayByPlay = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `BasketballPlayByPlay` WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventSummaryResponseData = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummaryResponseData` WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventTeam = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventTeam` WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__deletionAdapterOfEventSummary = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "DELETE FROM `EventSummary` WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballEventSummary = new EntityDeletionOrUpdateAdapter<BasketballEventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballEventSummary` SET `basketballEventSummaryId` = ?,`performers` = ?,`homeTeamfieldGoalPercentage` = ?,`homeTeamthreePtsPercentage` = ?,`homeTeamfreeThrowPercentage` = ?,`homeTeamassists` = ?,`homeTeamrebounds` = ?,`awayTeamfieldGoalPercentage` = ?,`awayTeamthreePtsPercentage` = ?,`awayTeamfreeThrowPercentage` = ?,`awayTeamassists` = ?,`awayTeamrebounds` = ? WHERE `basketballEventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballEventSummary basketballEventSummary) {
                long l = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.basketballPerfomersToString(basketballEventSummary.getPerformers());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                object = basketballEventSummary.getSummary();
                if (object != null) {
                    BasketballTeamSummary basketballTeamSummary = ((BasketballSummary)object).getHomeTeamStatistics();
                    if (basketballTeamSummary != null) {
                        double d = basketballTeamSummary.getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(3, d);
                        d = basketballTeamSummary.getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(4, d);
                        d = basketballTeamSummary.getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(5, d);
                        long l2 = basketballTeamSummary.getAssists();
                        supportSQLiteStatement.bindLong(6, l2);
                        l2 = basketballTeamSummary.getRebounds();
                        supportSQLiteStatement.bindLong(7, l2);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                        supportSQLiteStatement2.bindNull(3);
                        supportSQLiteStatement2.bindNull(4);
                        supportSQLiteStatement2.bindNull(5);
                        supportSQLiteStatement2.bindNull(6);
                        supportSQLiteStatement2.bindNull(7);
                    }
                    object = ((BasketballSummary)object).getAwayTeamStatistics();
                    if (object != null) {
                        double d = ((BasketballTeamSummary)object).getFieldGoalPercentage();
                        supportSQLiteStatement.bindDouble(8, d);
                        d = ((BasketballTeamSummary)object).getThreePtsPercentage();
                        supportSQLiteStatement.bindDouble(9, d);
                        d = ((BasketballTeamSummary)object).getFreeThrowPercentage();
                        supportSQLiteStatement.bindDouble(10, d);
                        long l3 = ((BasketballTeamSummary)object).getAssists();
                        supportSQLiteStatement.bindLong(11, l3);
                        l3 = ((BasketballTeamSummary)object).getRebounds();
                        supportSQLiteStatement.bindLong(12, l3);
                    } else {
                        SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                        supportSQLiteStatement3.bindNull(8);
                        supportSQLiteStatement3.bindNull(9);
                        supportSQLiteStatement3.bindNull(10);
                        supportSQLiteStatement3.bindNull(11);
                        supportSQLiteStatement3.bindNull(12);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement4 = supportSQLiteStatement;
                    supportSQLiteStatement4.bindNull(3);
                    supportSQLiteStatement4.bindNull(4);
                    supportSQLiteStatement4.bindNull(5);
                    supportSQLiteStatement4.bindNull(6);
                    supportSQLiteStatement4.bindNull(7);
                    supportSQLiteStatement4.bindNull(8);
                    supportSQLiteStatement4.bindNull(9);
                    supportSQLiteStatement4.bindNull(10);
                    supportSQLiteStatement4.bindNull(11);
                    supportSQLiteStatement4.bindNull(12);
                }
                long l4 = basketballEventSummary.getId();
                supportSQLiteStatement.bindLong(13, l4);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballBoxScore = new EntityDeletionOrUpdateAdapter<BasketballBoxScore>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballBoxScore` SET `basketballBoxScoreId` = ?,`homePlayerScores` = ?,`awayPlayerScore` = ? WHERE `basketballBoxScoreId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballBoxScore basketballBoxScore) {
                long l = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(1, l);
                String string2 = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getHomePlayerScores());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, string2);
                }
                Object object = object.SportEventsDao_Impl.this.__converters.playerScoresToString(basketballBoxScore.getAwayPlayerScore());
                if (object == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, (String)object);
                }
                long l2 = basketballBoxScore.getId();
                supportSQLiteStatement.bindLong(4, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballPlayByPlay = new EntityDeletionOrUpdateAdapter<BasketballPlayByPlay>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballPlayByPlay` SET `basketballPlayByPlayId` = ?,`statistics` = ? WHERE `basketballPlayByPlayId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballPlayByPlay basketballPlayByPlay) {
                long l = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.playByPlayStatisticsToString(basketballPlayByPlay.getStatistics());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = basketballPlayByPlay.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfBasketballTeamStanding = new EntityDeletionOrUpdateAdapter<BasketballTeamStanding>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `BasketballTeamStanding` SET `id` = ?,`teamName` = ?,`teamIcon` = ?,`colors` = ?,`wins` = ?,`losses` = ?,`percentage` = ?,`gamesBehind` = ?,`division` = ?,`conference` = ?,`streakkind` = ?,`streaklength` = ?,`rankdivision` = ?,`rankconference` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, BasketballTeamStanding basketballTeamStanding) {
                long l = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (basketballTeamStanding.getTeamName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, basketballTeamStanding.getTeamName());
                }
                if (basketballTeamStanding.getTeamIcon() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, basketballTeamStanding.getTeamIcon());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(basketballTeamStanding.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, (String)object);
                }
                l = basketballTeamStanding.getWins();
                supportSQLiteStatement.bindLong(5, l);
                l = basketballTeamStanding.getLosses();
                supportSQLiteStatement.bindLong(6, l);
                double d = basketballTeamStanding.getPercentage();
                supportSQLiteStatement.bindDouble(7, d);
                long l2 = basketballTeamStanding.getGamesBehind();
                supportSQLiteStatement.bindLong(8, l2);
                if (basketballTeamStanding.getDivision() == null) {
                    supportSQLiteStatement.bindNull(9);
                } else {
                    supportSQLiteStatement.bindString(9, basketballTeamStanding.getDivision());
                }
                if (basketballTeamStanding.getConference() == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, basketballTeamStanding.getConference());
                }
                object = basketballTeamStanding.getStreak();
                if (object != null) {
                    if (((BasketballTeamStreak)object).getKind() == null) {
                        supportSQLiteStatement.bindNull(11);
                    } else {
                        supportSQLiteStatement.bindString(11, ((BasketballTeamStreak)object).getKind());
                    }
                    l2 = ((BasketballTeamStreak)object).getLength();
                    supportSQLiteStatement.bindLong(12, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(11);
                    supportSQLiteStatement2.bindNull(12);
                }
                object = basketballTeamStanding.getRank();
                if (object != null) {
                    l2 = ((BasketballTeamRank)object).getDivision();
                    supportSQLiteStatement.bindLong(13, l2);
                    l2 = ((BasketballTeamRank)object).getConference();
                    supportSQLiteStatement.bindLong(14, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement3 = supportSQLiteStatement;
                    supportSQLiteStatement3.bindNull(13);
                    supportSQLiteStatement3.bindNull(14);
                }
                long l3 = basketballTeamStanding.getId();
                supportSQLiteStatement.bindLong(15, l3);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventSummaryResponseData = new EntityDeletionOrUpdateAdapter<EventSummaryResponseData>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummaryResponseData` SET `eventSummaryResponseDataId` = ?,`type` = ? WHERE `eventSummaryResponseDataId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummaryResponseData eventSummaryResponseData) {
                long l = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(1, l);
                Object object = object.SportEventsDao_Impl.this.__converters.eventTypeToString(eventSummaryResponseData.getType());
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, (String)object);
                }
                long l2 = eventSummaryResponseData.getId();
                supportSQLiteStatement.bindLong(3, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventTeam = new EntityDeletionOrUpdateAdapter<EventTeam>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventTeam` SET `eventTeamId` = ?,`name` = ?,`alias` = ?,`logo` = ?,`colors` = ?,`isWinner` = ? WHERE `eventTeamId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventTeam eventTeam) {
                long l = eventTeam.getId();
                supportSQLiteStatement.bindLong(1, l);
                if (eventTeam.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, eventTeam.getName());
                }
                if (eventTeam.getAlias() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, eventTeam.getAlias());
                }
                if (eventTeam.getLogo() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventTeam.getLogo());
                }
                Object object = object.SportEventsDao_Impl.this.__converters.stringListToString(eventTeam.getColors());
                if (object == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, (String)object);
                }
                long l2 = (long)eventTeam.isWinner();
                supportSQLiteStatement.bindLong(6, l2);
                l2 = eventTeam.getId();
                supportSQLiteStatement.bindLong(7, l2);
            }
        };
        sportEventsDao_Impl.__updateAdapterOfEventSummary = new EntityDeletionOrUpdateAdapter<EventSummary>(roomDatabase){

            public String createQuery() {
                return "UPDATE OR ABORT `EventSummary` SET `scheduleDateString` = ?,`scheduleDate` = ?,`eventSummaryId` = ?,`scheduled` = ?,`league` = ?,`homeScore` = ?,`awayScore` = ?,`homeTeamId` = ?,`awayTeamId` = ?,`status` = ?,`periods` = ?,`periodsCount` = ?,`clock` = ?,`period` = ? WHERE `eventSummaryId` = ?";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, EventSummary eventSummary) {
                Object object = eventSummary.scheduledDateString;
                if (object == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, (String)object);
                }
                object = object2.SportEventsDao_Impl.this.__converters.dateToString(eventSummary.scheduleDate);
                if (object == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = (Long)object;
                    supportSQLiteStatement.bindLong(2, l);
                }
                long l = eventSummary.getId();
                supportSQLiteStatement.bindLong(3, l);
                if (eventSummary.getScheduled() == null) {
                    supportSQLiteStatement.bindNull(4);
                } else {
                    supportSQLiteStatement.bindString(4, eventSummary.getScheduled());
                }
                if (eventSummary.getLeague() == null) {
                    supportSQLiteStatement.bindNull(5);
                } else {
                    supportSQLiteStatement.bindString(5, eventSummary.getLeague());
                }
                l = eventSummary.getHomeScore();
                supportSQLiteStatement.bindLong(6, l);
                l = eventSummary.getAwayScore();
                supportSQLiteStatement.bindLong(7, l);
                l = eventSummary.getHomeTeamId();
                supportSQLiteStatement.bindLong(8, l);
                l = eventSummary.getAwayTeamId();
                supportSQLiteStatement.bindLong(9, l);
                String string2 = object2.SportEventsDao_Impl.this.__converters.eventStatusToString(eventSummary.getStatus());
                if (string2 == null) {
                    supportSQLiteStatement.bindNull(10);
                } else {
                    supportSQLiteStatement.bindString(10, string2);
                }
                Object object2 = object2.SportEventsDao_Impl.this.__converters.eventPeriodsToString(eventSummary.getPeriods());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(11);
                } else {
                    supportSQLiteStatement.bindString(11, (String)object2);
                }
                long l2 = eventSummary.getPeriodsCount();
                supportSQLiteStatement.bindLong(12, l2);
                object2 = eventSummary.getEventTime();
                if (object2 != null) {
                    if (((EventTime)object2).getClock() == null) {
                        supportSQLiteStatement.bindNull(13);
                    } else {
                        supportSQLiteStatement.bindString(13, ((EventTime)object2).getClock());
                    }
                    l2 = ((EventTime)object2).getPeriod();
                    supportSQLiteStatement.bindLong(14, l2);
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(13);
                    supportSQLiteStatement2.bindNull(14);
                }
                long l3 = eventSummary.getId();
                supportSQLiteStatement.bindLong(15, l3);
            }
        };
        sportEventsDao_Impl.__preparedStmtOfDeleteBasketballStandings = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM BasketballTeamStanding";
            }
        };
        sportEventsDao_Impl.__preparedStmtOfDeleteEventSchedules = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM EventScheduleData WHERE type = ?";
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n2 = 0;
            int n3 = longSparseArray.size();
            for (int j = 0; j < n3; ++j) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(j), null);
                if (++n2 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n2 = 0;
            }
            if (n2 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryHomeEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n4 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (n = 0; n < longSparseArray.size(); ++n5, ++n) {
            roomSQLiteQuery.bindLong(n5, longSparseArray.keyAt(n));
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"eventTeamId");
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"name");
            int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"alias");
            int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"logo");
            int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"colors");
            int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"isWinner");
            while (roomSQLiteQuery.moveToNext()) {
                Object object;
                long l = roomSQLiteQuery.getLong(6);
                if (!longSparseArray.containsKey(l)) continue;
                long l2 = n5 == -1 ? 0L : roomSQLiteQuery.getLong(n5);
                String string2 = n == -1 ? null : roomSQLiteQuery.getString(n);
                String string3 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
                String string4 = n7 == -1 ? null : roomSQLiteQuery.getString(n7);
                if (n8 == -1) {
                    object = null;
                } else {
                    object = roomSQLiteQuery.getString(n8);
                    object = this.__converters.stringToStringList((String)object);
                }
                boolean bl = n9 != -1 && roomSQLiteQuery.getInt(n9) != 0;
                longSparseArray.put(l, (Object)new EventTeam(l2, string2, string3, string4, (List<String>)object, bl));
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        roomSQLiteQuery.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1(LongSparseArray<EventTeam> longSparseArray) {
        int n;
        if (longSparseArray.isEmpty()) {
            return;
        }
        if (longSparseArray.size() > 999) {
            LongSparseArray longSparseArray2;
            LongSparseArray longSparseArray3 = longSparseArray2;
            longSparseArray2 = new LongSparseArray(999);
            int n2 = 0;
            int n3 = longSparseArray.size();
            for (int j = 0; j < n3; ++j) {
                LongSparseArray longSparseArray4;
                longSparseArray3.put(longSparseArray.keyAt(j), null);
                if (++n2 != 999) continue;
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray(999);
                n2 = 0;
            }
            if (n2 > 0) {
                this.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray3);
                longSparseArray.putAll(longSparseArray3);
            }
            return;
        }
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT `EventTeam`.`eventTeamId` AS `eventTeamId`,`EventTeam`.`name` AS `name`,`EventTeam`.`alias` AS `alias`,`EventTeam`.`logo` AS `logo`,`EventTeam`.`colors` AS `colors`,`EventTeam`.`isWinner` AS `isWinner`,_junction.`eventSummaryId` FROM `EventSummaryAwayEventTeamCrossRef` AS _junction INNER JOIN `EventTeam` ON (_junction.`eventTeamId` = `EventTeam`.`eventTeamId`) WHERE _junction.`eventSummaryId` IN (");
        int n4 = longSparseArray.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n4);
        stringBuilder.append(")");
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n4 + 0));
        int n5 = 1;
        for (n = 0; n < longSparseArray.size(); ++n5, ++n) {
            roomSQLiteQuery.bindLong(n5, longSparseArray.keyAt(n));
        }
        roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
        try {
            n5 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"eventTeamId");
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"name");
            int n6 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"alias");
            int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"logo");
            int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"colors");
            int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"isWinner");
            while (roomSQLiteQuery.moveToNext()) {
                Object object;
                long l = roomSQLiteQuery.getLong(6);
                if (!longSparseArray.containsKey(l)) continue;
                long l2 = n5 == -1 ? 0L : roomSQLiteQuery.getLong(n5);
                String string2 = n == -1 ? null : roomSQLiteQuery.getString(n);
                String string3 = n6 == -1 ? null : roomSQLiteQuery.getString(n6);
                String string4 = n7 == -1 ? null : roomSQLiteQuery.getString(n7);
                if (n8 == -1) {
                    object = null;
                } else {
                    object = roomSQLiteQuery.getString(n8);
                    object = this.__converters.stringToStringList((String)object);
                }
                boolean bl = n9 != -1 && roomSQLiteQuery.getInt(n9) != 0;
                longSparseArray.put(l, (Object)new EventTeam(l2, string2, string3, string4, (List<String>)object, bl));
            }
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        roomSQLiteQuery.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation(LongSparseArray<EventSummaryRelation> var1_1) {
        block22: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `scheduleDateString`,`scheduleDate`,`eventSummaryId`,`scheduled`,`league`,`homeScore`,`awayScore`,`homeTeamId`,`awayTeamId`,`status`,`periods`,`periodsCount`,`clock`,`period` FROM `EventSummary` WHERE `eventSummaryId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var3_6, ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)true, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"eventSummaryId");
            if (var3_6 != -1) break block22;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        var4_8 = CursorUtil.getColumnIndex((Cursor)v3, (String)"scheduleDateString");
        var5_10 = CursorUtil.getColumnIndex((Cursor)v3, (String)"scheduleDate");
        var6_11 = CursorUtil.getColumnIndex((Cursor)v3, (String)"eventSummaryId");
        var7_12 = CursorUtil.getColumnIndex((Cursor)v3, (String)"scheduled");
        var8_13 = CursorUtil.getColumnIndex((Cursor)v3, (String)"league");
        var9_14 = CursorUtil.getColumnIndex((Cursor)v3, (String)"homeScore");
        var10_15 = CursorUtil.getColumnIndex((Cursor)v3, (String)"awayScore");
        var11_16 = CursorUtil.getColumnIndex((Cursor)v3, (String)"homeTeamId");
        var12_17 = CursorUtil.getColumnIndex((Cursor)v3, (String)"awayTeamId");
        var13_18 = CursorUtil.getColumnIndex((Cursor)v3, (String)"status");
        var14_19 = CursorUtil.getColumnIndex((Cursor)v3, (String)"periods");
        var15_20 = CursorUtil.getColumnIndex((Cursor)v3, (String)"periodsCount");
        var16_21 = CursorUtil.getColumnIndex((Cursor)v3, (String)"clock");
        var17_22 = CursorUtil.getColumnIndex((Cursor)v3, (String)"period");
        var18_23 = v4;
        v4 = new LongSparseArray();
        var19_24 = v5;
        v5 = new LongSparseArray();
        while (var2_4.moveToNext()) {
            var18_23.put(var2_4.getLong(var6_11), null);
            var19_24.put(var2_4.getLong(var6_11), null);
        }
        v6 = this;
        v7 = var19_24;
        v8 = this;
        v9 = var18_23;
        var2_4.moveToPosition(-1);
        try {
            v8.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)v9);
            v6.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)v7);
            while (var2_4.moveToNext()) {
                v10 = var1_1;
                var20_25 = var2_4.getLong(var3_6);
            }
        }
        catch (Throwable v11) {
            var2_4.close();
            throw v11;
        }
        {
            block24: {
                block23: {
                    if (!v10.containsKey(var20_25)) continue;
                    if (!(var4_8 != -1 && var2_4.isNull(var4_8) == false || var5_10 != -1 && var2_4.isNull(var5_10) == false || var6_11 != -1 && var2_4.isNull(var6_11) == false || var7_12 != -1 && var2_4.isNull(var7_12) == false || var8_13 != -1 && var2_4.isNull(var8_13) == false || var9_14 != -1 && var2_4.isNull(var9_14) == false || var10_15 != -1 && var2_4.isNull(var10_15) == false || var11_16 != -1 && var2_4.isNull(var11_16) == false || var12_17 != -1 && var2_4.isNull(var12_17) == false || var13_18 != -1 && var2_4.isNull(var13_18) == false || var14_19 != -1 && var2_4.isNull(var14_19) == false || var15_20 != -1 && var2_4.isNull(var15_20) == false || var16_21 != -1 && var2_4.isNull(var16_21) == false) && (var17_22 == -1 || var2_4.isNull(var17_22))) ** GOTO lbl121
                    var22_28 = var6_11 == -1 ? 0L : var2_4.getLong(var6_11);
                    var24_30 = var7_12 == -1 ? null : var2_4.getString(var7_12);
                    var25_31 = var8_13 == -1 ? null : var2_4.getString(var8_13);
                    var26_32 = var9_14 == -1 ? 0 : var2_4.getInt(var9_14);
                    var27_33 = var10_15 == -1 ? 0 : var2_4.getInt(var10_15);
                    var28_34 = var11_16 == -1 ? 0L : var2_4.getLong(var11_16);
                    var30_35 = var12_17 == -1 ? 0L : var2_4.getLong(var12_17);
                    if (var13_18 == -1) {
                        var32_36 /* !! */  = null;
                    } else {
                        var32_36 /* !! */  = var2_4.getString(var13_18);
                        var32_36 /* !! */  = this.__converters.stringToEventStatus(var32_36 /* !! */ );
                    }
                    if (var14_19 == -1) {
                        var33_37 = null;
                    } else {
                        var33_37 = var2_4.getString(var14_19);
                        var33_37 = this.__converters.stringToEventPeriods((String)var33_37);
                    }
                    var34_38 = var15_20 == -1 ? 0 : var2_4.getInt(var15_20);
                    if ((var16_21 == -1 || var2_4.isNull(var16_21)) && (var17_22 == -1 || var2_4.isNull(var17_22))) ** GOTO lbl109
                    var35_39 = var16_21 == -1 ? null : var2_4.getString(var16_21);
                    var36_40 = var17_22 == -1 ? 0 : var2_4.getInt(var17_22);
                    var37_41 = v12;
                    v12 = new EventTime((String)var35_39, var36_40);
                    break block23;
lbl109:
                    // 1 sources

                    var37_41 = null;
                }
                v13 = var4_8;
                var35_39 = v14;
                v14 = new EventSummary(var22_28, var24_30, var25_31, var26_32, var27_33, var37_41, var28_34, var30_35, (EventStatus)var32_36 /* !! */ , (List<EventPeriod>)var33_37, var34_38);
                if (v13 != -1) {
                    var35_39.scheduledDateString = var2_4.getString(var4_8);
                }
                if (var5_10 != -1) {
                    var22_29 = var2_4.isNull(var5_10) != false ? null : Long.valueOf(var2_4.getLong(var5_10));
                    var35_39.scheduleDate = this.__converters.timestampToDate(var22_29);
                }
                break block24;
lbl121:
                // 1 sources

                var35_39 = null;
            }
            var20_26 = (EventTeam)var18_23.get(var2_4.getLong(var6_11));
            var21_27 = (EventTeam)var19_24.get(var2_4.getLong(var6_11));
            var1_1.put(var20_25, (Object)new EventSummaryRelation((EventSummary)var35_39, var20_26, var21_27));
            continue;
        }
        var2_4.close();
    }

    private void __fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary(LongSparseArray<BasketballEventSummary> longSparseArray) {
        int n;
        int n2;
        int n3;
        RoomSQLiteQuery roomSQLiteQuery;
        block102: {
            if (longSparseArray.isEmpty()) {
                return;
            }
            if (longSparseArray.size() > 999) {
                LongSparseArray longSparseArray2;
                LongSparseArray longSparseArray3 = longSparseArray2;
                longSparseArray2 = new LongSparseArray(999);
                int n4 = 0;
                int n5 = longSparseArray.size();
                for (int j = 0; j < n5; ++j) {
                    LongSparseArray longSparseArray4;
                    longSparseArray3.put(longSparseArray.keyAt(j), null);
                    if (++n4 != 999) continue;
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray3);
                    longSparseArray.putAll(longSparseArray3);
                    longSparseArray3 = longSparseArray4;
                    longSparseArray4 = new LongSparseArray(999);
                    n4 = 0;
                }
                if (n4 > 0) {
                    this.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray3);
                    longSparseArray.putAll(longSparseArray3);
                }
                return;
            }
            StringBuilder stringBuilder = StringUtil.newStringBuilder();
            stringBuilder.append("SELECT `basketballEventSummaryId`,`performers`,`homeTeamfieldGoalPercentage`,`homeTeamthreePtsPercentage`,`homeTeamfreeThrowPercentage`,`homeTeamassists`,`homeTeamrebounds`,`awayTeamfieldGoalPercentage`,`awayTeamthreePtsPercentage`,`awayTeamfreeThrowPercentage`,`awayTeamassists`,`awayTeamrebounds` FROM `BasketballEventSummary` WHERE `basketballEventSummaryId` IN (");
            int n6 = longSparseArray.size();
            StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n6);
            stringBuilder.append(")");
            roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)(n6 + 0));
            n3 = 1;
            for (n2 = 0; n2 < longSparseArray.size(); ++n2) {
                roomSQLiteQuery.bindLong(n3, longSparseArray.keyAt(n2));
                ++n3;
            }
            roomSQLiteQuery = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
            n3 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery, (String)"basketballEventSummaryId");
            if (n3 != -1) break block102;
            roomSQLiteQuery.close();
            return;
        }
        RoomSQLiteQuery roomSQLiteQuery2 = roomSQLiteQuery;
        RoomSQLiteQuery roomSQLiteQuery3 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery4 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery5 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery6 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery7 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery8 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery9 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery10 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery11 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery12 = roomSQLiteQuery2;
        RoomSQLiteQuery roomSQLiteQuery13 = roomSQLiteQuery2;
        n2 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery2, (String)"basketballEventSummaryId");
        int n7 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery11, (String)"performers");
        int n8 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery12, (String)"homeTeamfieldGoalPercentage");
        int n9 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery13, (String)"homeTeamthreePtsPercentage");
        int n10 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery9, (String)"homeTeamfreeThrowPercentage");
        int n11 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery10, (String)"homeTeamassists");
        int n12 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery7, (String)"homeTeamrebounds");
        int n13 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery8, (String)"awayTeamfieldGoalPercentage");
        int n14 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery5, (String)"awayTeamthreePtsPercentage");
        int n15 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery6, (String)"awayTeamfreeThrowPercentage");
        int n16 = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery3, (String)"awayTeamassists");
        try {
            n = CursorUtil.getColumnIndex((Cursor)roomSQLiteQuery4, (String)"awayTeamrebounds");
        }
        catch (Throwable throwable) {
            roomSQLiteQuery.close();
            throw throwable;
        }
        while (true) {
            BasketballSummary basketballSummary;
            Object object;
            long l;
            long l2;
            block113: {
                block106: {
                    BasketballSummary basketballSummary2;
                    BasketballTeamSummary basketballTeamSummary;
                    BasketballTeamSummary basketballTeamSummary2;
                    block112: {
                        block111: {
                            BasketballTeamSummary basketballTeamSummary3;
                            int n17;
                            int n18;
                            double d;
                            double d2;
                            double d3;
                            block110: {
                                block109: {
                                    block108: {
                                        BasketballTeamSummary basketballTeamSummary4;
                                        block107: {
                                            block105: {
                                                block104: {
                                                    block103: {
                                                        if (!roomSQLiteQuery.moveToNext()) break;
                                                        LongSparseArray<BasketballEventSummary> longSparseArray5 = longSparseArray;
                                                        l2 = roomSQLiteQuery.getLong(n3);
                                                        if (!longSparseArray5.containsKey(l2)) continue;
                                                        if (n2 != -1) break block103;
                                                        l = 0L;
                                                        break block104;
                                                    }
                                                    l = roomSQLiteQuery.getLong(n2);
                                                }
                                                if (n7 == -1) {
                                                    object = null;
                                                } else {
                                                    SportEventsDao_Impl sportEventsDao_Impl = this;
                                                    object = roomSQLiteQuery.getString(n7);
                                                    object = sportEventsDao_Impl.__converters.stringToBasketballPerformers((String)object);
                                                }
                                                if (n8 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n8)) break block105;
                                                }
                                                if (n9 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n9)) break block105;
                                                }
                                                if (n10 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n10)) break block105;
                                                }
                                                if (n11 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n11)) break block105;
                                                }
                                                if (n12 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n12)) break block105;
                                                }
                                                if (n13 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n13)) break block105;
                                                }
                                                if (n14 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n14)) break block105;
                                                }
                                                if (n15 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n15)) break block105;
                                                }
                                                if (n16 != -1) {
                                                    if (!roomSQLiteQuery.isNull(n16)) break block105;
                                                }
                                                if (n == -1) break block106;
                                                if (roomSQLiteQuery.isNull(n)) break block106;
                                            }
                                            if (n8 != -1) {
                                                if (!roomSQLiteQuery.isNull(n8)) break block107;
                                            }
                                            if (n9 != -1) {
                                                if (!roomSQLiteQuery.isNull(n9)) break block107;
                                            }
                                            if (n10 != -1) {
                                                if (!roomSQLiteQuery.isNull(n10)) break block107;
                                            }
                                            if (n11 != -1) {
                                                if (!roomSQLiteQuery.isNull(n11)) break block107;
                                            }
                                            if (n12 == -1) break block108;
                                            if (roomSQLiteQuery.isNull(n12)) break block108;
                                        }
                                        if (n8 == -1) {
                                            d3 = 0.0;
                                        } else {
                                            d3 = roomSQLiteQuery.getDouble(n8);
                                        }
                                        if (n9 == -1) {
                                            d2 = 0.0;
                                        } else {
                                            d2 = roomSQLiteQuery.getDouble(n9);
                                        }
                                        if (n10 == -1) {
                                            d = 0.0;
                                        } else {
                                            d = roomSQLiteQuery.getDouble(n10);
                                        }
                                        if (n11 == -1) {
                                            n18 = 0;
                                        } else {
                                            n18 = roomSQLiteQuery.getInt(n11);
                                        }
                                        if (n12 == -1) {
                                            n17 = 0;
                                        } else {
                                            n17 = roomSQLiteQuery.getInt(n12);
                                        }
                                        basketballTeamSummary2 = basketballTeamSummary4;
                                        basketballTeamSummary4 = new BasketballTeamSummary(d3, d2, d, n18, n17);
                                        break block109;
                                    }
                                    basketballTeamSummary2 = null;
                                }
                                if (n13 != -1) {
                                    if (!roomSQLiteQuery.isNull(n13)) break block110;
                                }
                                if (n14 != -1) {
                                    if (!roomSQLiteQuery.isNull(n14)) break block110;
                                }
                                if (n15 != -1) {
                                    if (!roomSQLiteQuery.isNull(n15)) break block110;
                                }
                                if (n16 != -1) {
                                    if (!roomSQLiteQuery.isNull(n16)) break block110;
                                }
                                if (n == -1) break block111;
                                if (roomSQLiteQuery.isNull(n)) break block111;
                            }
                            if (n13 == -1) {
                                d3 = 0.0;
                            } else {
                                d3 = roomSQLiteQuery.getDouble(n13);
                            }
                            if (n14 == -1) {
                                d2 = 0.0;
                            } else {
                                d2 = roomSQLiteQuery.getDouble(n14);
                            }
                            if (n15 == -1) {
                                d = 0.0;
                            } else {
                                d = roomSQLiteQuery.getDouble(n15);
                            }
                            if (n16 == -1) {
                                n18 = 0;
                            } else {
                                n18 = roomSQLiteQuery.getInt(n16);
                            }
                            if (n == -1) {
                                n17 = 0;
                            } else {
                                n17 = roomSQLiteQuery.getInt(n);
                            }
                            basketballTeamSummary = basketballTeamSummary3;
                            basketballTeamSummary3 = new BasketballTeamSummary(d3, d2, d, n18, n17);
                            break block112;
                        }
                        basketballTeamSummary = null;
                    }
                    basketballSummary = basketballSummary2;
                    basketballSummary2 = new BasketballSummary(basketballTeamSummary2, basketballTeamSummary);
                    break block113;
                }
                basketballSummary = null;
            }
            longSparseArray.put(l2, (Object)new BasketballEventSummary(l, basketballSummary, (List<BasketballPerformers>)object));
            continue;
            break;
        }
        roomSQLiteQuery.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation(LongSparseArray<EventScheduleAttributesRelation> var1_1) {
        block26: {
            if (var1_1.isEmpty()) {
                return;
            }
            if (var1_1.size() > 999) {
                var2_2 = v0;
                v0 = new LongSparseArray(999);
                var3_5 = 0;
                var5_9 = var1_1.size();
                for (var4_7 = 0; var4_7 < var5_9; ++var4_7) {
                    var2_2.put(var1_1.keyAt(var4_7), null);
                    if (++var3_5 != 999) continue;
                    this.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)var2_2);
                    var1_1.putAll(var2_2);
                    var2_2 = v1;
                    v1 = new LongSparseArray(999);
                    var3_5 = 0;
                }
                if (var3_5 > 0) {
                    this.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)var2_2);
                    var1_1.putAll(var2_2);
                }
                return;
            }
            v2 = StringUtil.newStringBuilder();
            v2.append("SELECT `eventScheduleAttributesId`,`basketballhomeTeamRecord`,`basketballawayTeamRecord`,`baseballouts`,`baseballinning`,`baseballinningDivision`,`baseballdelayed`,`baseballreasonForDelay`,`baseballtakenBases`,`baseballhomeTeamRecord`,`baseballawayTeamRecord`,`hockeyhomeTeamRecord`,`hockeyawayTeamRecord` FROM `EventScheduleAttributes` WHERE `eventScheduleAttributesId` IN (");
            var2_3 = var1_1.size();
            StringUtil.appendPlaceholders((StringBuilder)v2, (int)var2_3);
            v2.append(")");
            var2_4 = RoomSQLiteQuery.acquire((String)v2.toString(), (int)(var2_3 + 0));
            var3_6 = 1;
            for (var4_8 = 0; var4_8 < var1_1.size(); ++var3_6, ++var4_8) {
                var2_4.bindLong(var3_6, var1_1.keyAt(var4_8));
            }
            var2_4 = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)var2_4, (boolean)true, null);
            var3_6 = CursorUtil.getColumnIndex((Cursor)var2_4, (String)"eventScheduleAttributesId");
            if (var3_6 != -1) break block26;
            var2_4.close();
            return;
        }
        v3 = var2_4;
        var4_8 = CursorUtil.getColumnIndex((Cursor)v3, (String)"eventScheduleAttributesId");
        var5_10 = CursorUtil.getColumnIndex((Cursor)v3, (String)"basketballhomeTeamRecord");
        var6_11 = CursorUtil.getColumnIndex((Cursor)v3, (String)"basketballawayTeamRecord");
        var7_12 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballouts");
        var8_13 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballinning");
        var9_14 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballinningDivision");
        var10_15 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballdelayed");
        var11_16 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballreasonForDelay");
        var12_17 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballtakenBases");
        var13_18 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballhomeTeamRecord");
        var14_19 = CursorUtil.getColumnIndex((Cursor)v3, (String)"baseballawayTeamRecord");
        var15_20 = CursorUtil.getColumnIndex((Cursor)v3, (String)"hockeyhomeTeamRecord");
        var16_21 = CursorUtil.getColumnIndex((Cursor)v3, (String)"hockeyawayTeamRecord");
        var17_22 = v4;
        v4 = new LongSparseArray();
        while (var2_4.moveToNext()) {
            var17_22.put(var2_4.getLong(var4_8), null);
        }
        v5 = this;
        v6 = var17_22;
        var2_4.moveToPosition(-1);
        try {
            v5.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)v6);
            while (var2_4.moveToNext()) {
                v7 = var1_1;
                var18_23 = var2_4.getLong(var3_6);
            }
        }
        catch (Throwable v8) {
            var2_4.close();
            throw v8;
        }
        {
            block33: {
                block30: {
                    block29: {
                        block32: {
                            block28: {
                                block31: {
                                    block27: {
                                        if (!v7.containsKey(var18_23)) continue;
                                        if (!(var4_8 != -1 && var2_4.isNull(var4_8) == false || var5_10 != -1 && var2_4.isNull(var5_10) == false || var6_11 != -1 && var2_4.isNull(var6_11) == false || var7_12 != -1 && var2_4.isNull(var7_12) == false || var8_13 != -1 && var2_4.isNull(var8_13) == false || var9_14 != -1 && var2_4.isNull(var9_14) == false || var10_15 != -1 && var2_4.isNull(var10_15) == false || var11_16 != -1 && var2_4.isNull(var11_16) == false || var12_17 != -1 && var2_4.isNull(var12_17) == false || var13_18 != -1 && var2_4.isNull(var13_18) == false || var14_19 != -1 && var2_4.isNull(var14_19) == false || var15_20 != -1 && var2_4.isNull(var15_20) == false) && (var16_21 == -1 || var2_4.isNull(var16_21))) ** GOTO lbl141
                                        var20_25 = var4_8 == -1 ? 0L : var2_4.getLong(var4_8);
                                        if ((var5_10 == -1 || var2_4.isNull(var5_10)) && (var6_11 == -1 || var2_4.isNull(var6_11))) ** GOTO lbl93
                                        if (var5_10 == -1) {
                                            var22_26 = null;
                                        } else {
                                            var22_26 = var2_4.getString(var5_10);
                                            var22_26 = this.__converters.stringToTeamRecord((String)var22_26);
                                        }
                                        if (var6_11 == -1) {
                                            var23_30 = null;
                                            break block27;
                                        }
                                        var23_30 = var2_4.getString(var6_11);
                                        var23_30 = this.__converters.stringToTeamRecord((String)var23_30);
                                    }
                                    var24_33 = v9;
                                    v9 = new BasketballEventScore((TeamRecord)var22_26, (TeamRecord)var23_30);
                                    break block31;
lbl93:
                                    // 1 sources

                                    var24_33 = null;
                                }
                                if (!(var7_12 != -1 && var2_4.isNull(var7_12) == false || var8_13 != -1 && var2_4.isNull(var8_13) == false || var9_14 != -1 && var2_4.isNull(var9_14) == false || var10_15 != -1 && var2_4.isNull(var10_15) == false || var11_16 != -1 && var2_4.isNull(var11_16) == false || var12_17 != -1 && var2_4.isNull(var12_17) == false || var13_18 != -1 && var2_4.isNull(var13_18) == false) && (var14_19 == -1 || var2_4.isNull(var14_19))) ** GOTO lbl117
                                var22_27 = var7_12 == -1 ? 0 : var2_4.getInt(var7_12);
                                var23_31 = var8_13 == -1 ? 0 : var2_4.getInt(var8_13);
                                var25_34 = var9_14 == -1 ? null : var2_4.getString(var9_14);
                                var26_35 = var10_15 != -1 && var2_4.getInt(var10_15) != 0;
                                var27_36 = var11_16 == -1 ? null : var2_4.getString(var11_16);
                                var28_37 = var12_17 == -1 ? 0 : var2_4.getInt(var12_17);
                                if (var13_18 == -1) {
                                    var29_38 = null;
                                } else {
                                    var29_38 = var2_4.getString(var13_18);
                                    var29_38 = this.__converters.stringToTeamRecord((String)var29_38);
                                }
                                if (var14_19 == -1) {
                                    var30_39 = null;
                                    break block28;
                                }
                                var30_39 = var2_4.getString(var14_19);
                                var30_39 = this.__converters.stringToTeamRecord((String)var30_39);
                            }
                            var31_40 = v10;
                            v10 = new BaseballEventScore(var22_27, var23_31, (String)var25_34, var26_35, var27_36, var28_37, (TeamRecord)var29_38, (TeamRecord)var30_39);
                            break block32;
lbl117:
                            // 1 sources

                            var31_40 = null;
                        }
                        if ((var15_20 == -1 || var2_4.isNull(var15_20)) && (var16_21 == -1 || var2_4.isNull(var16_21))) ** GOTO lbl135
                        if (var15_20 == -1) {
                            var22_29 = null;
                        } else {
                            var22_29 = var2_4.getString(var15_20);
                            var22_29 = this.__converters.stringToTeamRecord((String)var22_29);
                        }
                        if (var16_21 == -1) {
                            var23_32 = null;
                            break block29;
                        }
                        var23_32 = var2_4.getString(var16_21);
                        var23_32 = this.__converters.stringToTeamRecord((String)var23_32);
                    }
                    var25_34 = v11;
                    v11 = new HockeyEventScore((TeamRecord)var22_29, (TeamRecord)var23_32);
                    break block30;
lbl135:
                    // 1 sources

                    var25_34 = null;
                }
                var22_26 = v12;
                v12 = new EventScheduleAttributes(var20_25, var24_33, var31_40, (HockeyEventScore)var25_34);
                break block33;
lbl141:
                // 1 sources

                var22_26 = null;
            }
            var18_24 = (EventSummaryRelation)var17_22.get(var2_4.getLong(var4_8));
            var1_1.put(var18_23, (Object)new EventScheduleAttributesRelation((EventScheduleAttributes)var22_26, var18_24));
            continue;
        }
        var2_4.close();
    }

    static /* synthetic */ void access$200(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventSummaryAsioStreamlayerSdkModelSportsEventSummaryRelation((LongSparseArray<EventSummaryRelation>)longSparseArray);
    }

    static /* synthetic */ void access$300(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipBasketballEventSummaryAsioStreamlayerSdkModelSportsBasketballBasketballEventSummary((LongSparseArray<BasketballEventSummary>)longSparseArray);
    }

    static /* synthetic */ void access$400(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam((LongSparseArray<EventTeam>)longSparseArray);
    }

    static /* synthetic */ void access$500(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventTeamAsioStreamlayerSdkModelSportsEventTeam_1((LongSparseArray<EventTeam>)longSparseArray);
    }

    static /* synthetic */ void access$600(SportEventsDao_Impl sportEventsDao_Impl, LongSparseArray longSparseArray) {
        sportEventsDao_Impl.__fetchRelationshipEventScheduleAttributesAsioStreamlayerSdkModelSportsEventScheduleAttributesRelation((LongSparseArray<EventScheduleAttributesRelation>)longSparseArray);
    }

    @Override
    public void saveBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballEventSummary.insert((Object)basketballEventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballBoxScore.insert((Object)basketballBoxScore);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballPlayByPlay.insert((Object)basketballPlayByPlay);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveBasketballTeamStandings(List<BasketballTeamStanding> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfBasketballTeamStanding.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryResponseData.insert((Object)eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventTeam.insert((Object)eventTeam);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummary.insert((Object)eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryHomeEventTeamCrossRef(EventSummaryHomeEventTeamCrossRef eventSummaryHomeEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryHomeEventTeamCrossRef.insert((Object)eventSummaryHomeEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryAwayEventTeamCrossRef(EventSummaryAwayEventTeamCrossRef eventSummaryAwayEventTeamCrossRef) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventSummaryAwayEventTeamCrossRef.insert((Object)eventSummaryAwayEventTeamCrossRef);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventSchedules(List<EventScheduleData> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventScheduleData.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void weakSaveEventScheduleAttributes(List<EventScheduleAttributes> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__insertionAdapterOfEventScheduleAttributes.insert(list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__deletionAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballSummary(BasketballEventSummary basketballEventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballEventSummary.handle((Object)basketballEventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballBoxScore(BasketballBoxScore basketballBoxScore) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballBoxScore.handle((Object)basketballBoxScore);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballPlayByPlay(BasketballPlayByPlay basketballPlayByPlay) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballPlayByPlay.handle((Object)basketballPlayByPlay);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateBasketballTeamStandings(List<BasketballTeamStanding> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfBasketballTeamStanding.handleMultiple(list);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummaryResponseData.handle((Object)eventSummaryResponseData);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventTeam(EventTeam eventTeam) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventTeam.handle((Object)eventTeam);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void updateEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        sportEventsDao_Impl.__db.beginTransaction();
        try {
            sportEventsDao_Impl.__updateAdapterOfEventSummary.handle((Object)eventSummary);
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummaryResponseData(EventSummaryResponseData eventSummaryResponseData) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummaryResponseData(sportEventsDao_Impl, eventSummaryResponseData);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSummary(EventSummary eventSummary) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSummary(sportEventsDao_Impl, eventSummary);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventSchedules(List<EventScheduleData> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventSchedules(sportEventsDao_Impl, list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveEventScheduleAttributes(List<EventScheduleAttributes> list) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        this.__db.beginTransaction();
        try {
            SportEventsDao.DefaultImpls.saveEventScheduleAttributes(sportEventsDao_Impl, list);
            sportEventsDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        sportEventsDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteBasketballStandings() {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = sportEventsDao_Impl.__preparedStmtOfDeleteBasketballStandings.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            SportEventsDao_Impl sportEventsDao_Impl2 = this;
            sportEventsDao_Impl2.__db.endTransaction();
            sportEventsDao_Impl2.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
            throw throwable;
        }
        sportEventsDao_Impl.__db.setTransactionSuccessful();
        sportEventsDao_Impl.__db.endTransaction();
        sportEventsDao_Impl.__preparedStmtOfDeleteBasketballStandings.release(supportSQLiteStatement);
    }

    @Override
    public void deleteEventSchedules(EventType object) {
        SportEventsDao_Impl sportEventsDao_Impl = this;
        sportEventsDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = sportEventsDao_Impl.__preparedStmtOfDeleteEventSchedules.acquire();
        int n = 1;
        object = sportEventsDao_Impl.__converters.eventTypeToString((EventType)((Object)object));
        if (object == null) {
            supportSQLiteStatement.bindNull(n);
        } else {
            supportSQLiteStatement.bindString(n, (String)object);
        }
        SportEventsDao_Impl sportEventsDao_Impl2 = this;
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            SportEventsDao_Impl sportEventsDao_Impl3 = this;
            sportEventsDao_Impl3.__db.endTransaction();
            sportEventsDao_Impl3.__preparedStmtOfDeleteEventSchedules.release(supportSQLiteStatement);
            throw throwable;
        }
        sportEventsDao_Impl2.__db.setTransactionSuccessful();
        sportEventsDao_Impl2.__db.endTransaction();
        sportEventsDao_Impl2.__preparedStmtOfDeleteEventSchedules.release(supportSQLiteStatement);
    }

    @Override
    public Observable<BasketballEventSummary> getBasketballSummary(long l) {
        Callable<BasketballEventSummary> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballEventSummary WHERE BasketballEventSummary.basketballEventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballEventSummary";
        Callable<BasketballEventSummary> callable2 = callable;
        callable = new Callable<BasketballEventSummary>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public BasketballEventSummary call() throws Exception {
                block58: {
                    block52: {
                        block54: {
                            block57: {
                                block56: {
                                    block55: {
                                        block53: {
                                            var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                                            try {
                                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"basketballEventSummaryId");
                                            }
                                            catch (Throwable v0) {
                                                var1_1.close();
                                                throw v0;
                                            }
                                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"performers");
                                            var4_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfieldGoalPercentage");
                                            var5_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamthreePtsPercentage");
                                            var6_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamfreeThrowPercentage");
                                            var7_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamassists");
                                            var8_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamrebounds");
                                            var9_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfieldGoalPercentage");
                                            var10_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamthreePtsPercentage");
                                            var11_21 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamfreeThrowPercentage");
                                            var12_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamassists");
                                            var13_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamrebounds");
                                            if (!var1_1.moveToFirst()) break block52;
                                            v1 = var1_1;
                                            v2 = var4_5;
                                            v3 = this;
                                            v4 = var1_1;
                                            v5 = var3_4;
                                            var2_3 = var1_1.getLong(var2_2);
                                            this = v4.getString(v5);
                                            this = SportEventsDao_Impl.access$000(v3.SportEventsDao_Impl.this).stringToBasketballPerformers((String)this);
                                            if (!v1.isNull(v2)) break block53;
                                            if (!var1_1.isNull(var5_11)) break block53;
                                            if (!var1_1.isNull(var6_13)) break block53;
                                            if (!var1_1.isNull(var7_16)) break block53;
                                            if (!var1_1.isNull(var8_17)) break block53;
                                            if (!var1_1.isNull(var9_19)) break block53;
                                            if (!var1_1.isNull(var10_20)) break block53;
                                            if (!var1_1.isNull(var11_21)) break block53;
                                            if (!var1_1.isNull(var12_22)) break block53;
                                            if (!var1_1.isNull(var13_24)) break block53;
                                            var4_6 = null;
                                            break block54;
                                        }
                                        if (!var1_1.isNull(var4_5)) break block55;
                                        if (!var1_1.isNull(var5_11)) break block55;
                                        if (!var1_1.isNull(var6_13)) break block55;
                                        if (!var1_1.isNull(var7_16)) break block55;
                                        if (!var1_1.isNull(var8_17)) break block55;
                                        var17_25 = var4_7 = null;
                                        ** GOTO lbl99
                                    }
                                    v6 = var1_1;
                                    v7 = var8_17;
                                    v8 = var1_1;
                                    v9 = var7_16;
                                    v10 = var1_1;
                                    v11 = var6_13;
                                    v12 = var1_1;
                                    v13 = var5_11;
                                    var4_8 = var1_1.getDouble(var4_5);
                                    var6_14 = v12.getDouble(v13);
                                    var14_26 = v10.getDouble(v11);
                                    var8_17 = v8.getInt(v9);
                                    var16_27 = v6.getInt(v7);
                                    var17_25 = v14;
                                    v14 = new BasketballTeamSummary(var4_8, var6_14, var14_26, var8_17, var16_27);
lbl99:
                                    // 2 sources

                                    if (!var1_1.isNull(var9_19)) break block56;
                                    if (!var1_1.isNull(var10_20)) break block56;
                                    if (!var1_1.isNull(var11_21)) break block56;
                                    if (!var1_1.isNull(var12_22)) break block56;
                                    if (!var1_1.isNull(var13_24)) break block56;
                                    var12_23 = var4_9 = null;
                                    break block57;
                                }
                                v15 = var1_1;
                                v16 = var13_24;
                                v17 = var1_1;
                                v18 = var12_22;
                                v19 = var1_1;
                                v20 = var11_21;
                                v21 = var1_1;
                                v22 = var10_20;
                                var4_10 = var1_1.getDouble(var9_19);
                                var6_15 = v21.getDouble(v22);
                                var8_18 = v19.getDouble(v20);
                                var10_20 = v17.getInt(v18);
                                var11_21 = v15.getInt(v16);
                                var12_23 = v23;
                                v23 = new BasketballTeamSummary(var4_10, var6_15, var8_18, var10_20, var11_21);
                            }
                            var4_6 = v24;
                            v24 = new BasketballSummary(var17_25, var12_23);
                        }
                        var5_12 = v25;
                        v25 = new BasketballEventSummary(var2_3, var4_6, this);
                        break block58;
                    }
                    var5_12 = null;
                }
                var1_1.close();
                return var5_12;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<BasketballBoxScore> getBasketballBoxScore(long l) {
        Callable<BasketballBoxScore> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballBoxScore WHERE BasketballBoxScore.basketballBoxScoreId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballBoxScore";
        Callable<BasketballBoxScore> callable2 = callable;
        callable = new Callable<BasketballBoxScore>(){

            @Override
            public BasketballBoxScore call() throws Exception {
                BasketballBoxScore basketballBoxScore;
                Cursor cursor;
                block13: {
                    block12: {
                        BasketballBoxScore basketballBoxScore2;
                        int n;
                        cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                        try {
                            n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballBoxScoreId");
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"homePlayerScores");
                        int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"awayPlayerScore");
                        if (!cursor.moveToFirst()) break block12;
                        28 v1 = list;
                        Cursor cursor2 = cursor;
                        int n4 = n3;
                        28 v4 = list;
                        Cursor cursor3 = cursor;
                        int n5 = n2;
                        long l = cursor.getLong(n);
                        List<PlayerScores> list = cursor3.getString(n5);
                        list = v4.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)((Object)list));
                        Object object = cursor2.getString(n4);
                        object = v1.SportEventsDao_Impl.this.__converters.stringToPlayerScores((String)object);
                        basketballBoxScore = basketballBoxScore2;
                        basketballBoxScore2 = new BasketballBoxScore(l, list, (List<PlayerScores>)object);
                        break block13;
                    }
                    basketballBoxScore = null;
                }
                cursor.close();
                return basketballBoxScore;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<BasketballPlayByPlay> getBasketballPlayByPlay(long l) {
        Callable<BasketballPlayByPlay> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballPlayByPlay WHERE BasketballPlayByPlay.basketballPlayByPlayId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballPlayByPlay";
        Callable<BasketballPlayByPlay> callable2 = callable;
        callable = new Callable<BasketballPlayByPlay>(){

            @Override
            public BasketballPlayByPlay call() throws Exception {
                BasketballPlayByPlay basketballPlayByPlay;
                Cursor cursor;
                block10: {
                    block9: {
                        BasketballPlayByPlay basketballPlayByPlay2;
                        int n;
                        cursor = DBUtil.query((RoomDatabase)list.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)list.roomSQLiteQuery, (boolean)false, null);
                        try {
                            n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"basketballPlayByPlayId");
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                        int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"statistics");
                        if (!cursor.moveToFirst()) break block9;
                        29 v1 = list;
                        Cursor cursor2 = cursor;
                        int n3 = n2;
                        long l = cursor.getLong(n);
                        List<BasketballPlayByPlayStatistics> list = cursor2.getString(n3);
                        list = v1.SportEventsDao_Impl.this.__converters.stringToPlayByPlayStatistics((String)((Object)list));
                        basketballPlayByPlay = basketballPlayByPlay2;
                        basketballPlayByPlay2 = new BasketballPlayByPlay(l, list);
                        break block10;
                    }
                    basketballPlayByPlay = null;
                }
                cursor.close();
                return basketballPlayByPlay;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<List<BasketballTeamStanding>> getBasketballTeamStandings() {
        Callable<List<BasketballTeamStanding>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM BasketballTeamStanding", (int)0);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "BasketballTeamStanding";
        Callable<List<BasketballTeamStanding>> callable2 = callable;
        callable = new Callable<List<BasketballTeamStanding>>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public List<BasketballTeamStanding> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"id");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamName");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"teamIcon");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"colors");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"wins");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"losses");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"percentage");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"gamesBehind");
                var10_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"division");
                var11_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"conference");
                var12_12 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streakkind");
                var13_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"streaklength");
                var14_14 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankdivision");
                var15_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"rankconference");
                var16_16 = v0;
                try {
                    v0 = new ArrayList<BasketballTeamStanding>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block41: {
                        block40: {
                            v2 = var1_1;
                            v3 = var12_12;
                            v4 = var1_1;
                            v5 = var11_11;
                            v6 = var1_1;
                            v7 = var10_10;
                            v8 = var1_1;
                            v9 = var9_9;
                            v10 = var1_1;
                            v11 = var8_8;
                            v12 = var1_1;
                            v13 = var7_7;
                            v14 = var1_1;
                            v15 = var6_6;
                            v16 = this;
                            v17 = var1_1;
                            v18 = var5_5;
                            v19 = var1_1;
                            v20 = var4_4;
                            v21 = var1_1;
                            v22 = var3_3;
                            var17_17 = var1_1.getLong(var2_2);
                            var19_18 = v21.getString(v22);
                            var20_19 = v19.getString(v20);
                            var21_20 = v17.getString(v18);
                            var21_20 = SportEventsDao_Impl.access$000(v16.SportEventsDao_Impl.this).stringToStringList((String)var21_20);
                            var22_21 = v14.getInt(v15);
                            var23_22 = v12.getInt(v13);
                            var24_23 = v10.getDouble(v11);
                            var26_24 = v8.getInt(v9);
                            var27_25 = v6.getString(v7);
                            var28_26 = v4.getString(v5);
                            if (!v2.isNull(v3)) break block40;
                            if (!var1_1.isNull(var13_13)) break block40;
                            var29_27 = null;
                            var31_30 = var29_27;
                            ** GOTO lbl97
                        }
                        v23 = var1_1;
                        v24 = var13_13;
                        var29_27 = var1_1.getString(var12_12);
                        var30_29 = v23.getInt(v24);
                        var31_30 = v25;
                        v25 = new BasketballTeamStreak(var29_27, var30_29);
lbl97:
                        // 2 sources

                        if (!var1_1.isNull(var14_14)) break block41;
                        if (!var1_1.isNull(var15_15)) break block41;
                        var29_27 = null;
                        var32_31 = var29_27;
                        ** GOTO lbl113
                    }
                    v26 = var1_1;
                    v27 = var15_15;
                    var29_28 = var1_1.getInt(var14_14);
                    var30_29 = v26.getInt(v27);
                    var32_31 = v28;
                    v28 = new BasketballTeamRank(var29_28, var30_29);
lbl113:
                    // 2 sources

                    var16_16.add(new BasketballTeamStanding(var17_17, var19_18, var20_19, (List<String>)var21_20, var22_21, var23_22, var24_23, var26_24, (BasketballTeamStreak)var31_30, (BasketballTeamRank)var32_31, var27_25, var28_26));
                    continue;
                }
lbl116:
                // 1 sources

                var1_1.close();
                return var16_16;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventSummaryResponseDataRelation> getEventSummaryResponseDataRelation(long l) {
        Callable<EventSummaryResponseDataRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData WHERE EventSummaryResponseData.eventSummaryResponseDataId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<EventSummaryResponseDataRelation> callable2 = callable;
        callable = new Callable<EventSummaryResponseDataRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryResponseDataRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block13: {
                        block12: {
                            catch (Throwable v1) {
                                SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                throw v1;
                            }
                            var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                            var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                            var4_6 /* !! */  = v2;
                            v2 = new LongSparseArray();
                            var5_7 = v3;
                            v3 = new LongSparseArray();
                            while (var1_1.moveToNext()) {
                                var4_6 /* !! */ .put(var1_1.getLong(var2_2), null);
                                var5_7.put(var1_1.getLong(var2_2), null);
                            }
                            v4 = var1_1;
                            v5 = this;
                            v6 = v5;
                            v7 = v5;
                            var1_1.moveToPosition(-1);
                            SportEventsDao_Impl.access$200(v6.SportEventsDao_Impl.this, var4_6 /* !! */ );
                            SportEventsDao_Impl.access$300(v7.SportEventsDao_Impl.this, var5_7);
                            if (!v4.moveToFirst()) ** GOTO lbl52
                            if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4)) break block12;
                            var3_5 /* !! */  = null;
                            var8_8 = var3_5 /* !! */ ;
                            ** GOTO lbl43
                        }
                        var6_9 = var1_1.getLong(var2_2);
                        var3_5 /* !! */  = var1_1.getString(var3_4);
                        var3_5 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var3_5 /* !! */ );
                        var8_8 = v8;
                        try {
                            v8 = new EventSummaryResponseData(var6_9, (EventType)var3_5 /* !! */ );
lbl43:
                            // 2 sources

                            var2_3 = (EventSummaryRelation)var4_6 /* !! */ .get(var1_1.getLong(var2_2));
                            var3_5 /* !! */  = (BasketballEventSummary)var5_7.get(var1_1.getLong(var2_2));
                        }
                        catch (Throwable v9) {}
                        {
                            var1_1.close();
                            throw v9;
                        }
                        var4_6 /* !! */  = v10;
                        v10 = new EventSummaryResponseDataRelation((EventSummaryResponseData)var8_8, var2_3, (BasketballEventSummary)var3_5 /* !! */ );
                        break block13;
lbl52:
                        // 1 sources

                        var4_6 /* !! */  = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_6 /* !! */ ;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<List<EventSummaryResponseDataRelation>> getEventSummaryResponseDataRelations() {
        Callable<List<EventSummaryResponseDataRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummaryResponseData", (int)0);
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "BasketballEventSummary";
        stringArray[5] = "EventSummaryResponseData";
        Callable<List<EventSummaryResponseDataRelation>> callable2 = callable;
        callable = new Callable<List<EventSummaryResponseDataRelation>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<EventSummaryResponseDataRelation> call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    catch (Throwable v1) {
                        SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                        throw v1;
                    }
                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryResponseDataId");
                    var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                    var4_4 = v2;
                    v2 = new LongSparseArray();
                    var5_5 = v3;
                    v3 = new LongSparseArray();
                    while (var1_1.moveToNext()) {
                        var4_4.put(var1_1.getLong(var2_2), null);
                        var5_5.put(var1_1.getLong(var2_2), null);
                    }
                    v4 = this;
                    v5 = v4;
                    v6 = v4;
                    var1_1.moveToPosition(-1);
                    SportEventsDao_Impl.access$200(v5.SportEventsDao_Impl.this, var4_4);
                    SportEventsDao_Impl.access$300(v6.SportEventsDao_Impl.this, var5_5);
                    var6_6 = v7;
                    try {
                        v7 = new ArrayList<EventSummaryResponseDataRelation>(var1_1.getCount());
                        while (var1_1.moveToNext()) {
                            block14: {
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_3)) break block14;
                                var7_7 = null;
                                var10_11 = var7_7;
                                ** GOTO lbl48
                            }
                            var7_8 = var1_1.getLong(var2_2);
                            var9_10 /* !! */  = var1_1.getString(var3_3);
                            var9_10 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var9_10 /* !! */ );
                        }
                    }
                    catch (Throwable v8) {}
                    {
                        var1_1.close();
                        throw v8;
                    }
                    {
                        var10_11 = v9;
                        v9 = new EventSummaryResponseData(var7_8, (EventType)var9_10 /* !! */ );
lbl48:
                        // 2 sources

                        var7_7 = (EventSummaryRelation)var4_4.get(var1_1.getLong(var2_2));
                        var8_9 = (BasketballEventSummary)var5_5.get(var1_1.getLong(var2_2));
                        var6_6.add(new EventSummaryResponseDataRelation(var10_11, (EventSummaryRelation)var7_7, var8_9));
                        continue;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var6_6;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventTeam> getEventTeam(long l) {
        Callable<EventTeam> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventTeam WHERE EventTeam.eventTeamId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventTeam";
        Callable<EventTeam> callable2 = callable;
        callable = new Callable<EventTeam>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public EventTeam call() throws Exception {
                EventTeam eventTeam;
                Cursor cursor;
                block20: {
                    block18: {
                        void var7_14;
                        EventTeam eventTeam2;
                        Object object;
                        String string4;
                        String string3;
                        long l;
                        String string2;
                        block19: {
                            int n;
                            cursor = DBUtil.query((RoomDatabase)string2.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)string2.roomSQLiteQuery, (boolean)false, null);
                            try {
                                n = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"eventTeamId");
                            }
                            catch (Throwable throwable) {
                                cursor.close();
                                throw throwable;
                            }
                            int n2 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                            int n3 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"alias");
                            int n4 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"logo");
                            int n5 = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"colors");
                            int bl = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isWinner");
                            if (!cursor.moveToFirst()) break block18;
                            Cursor cursor2 = cursor;
                            int n6 = bl;
                            33 v3 = string2;
                            Cursor cursor3 = cursor;
                            int n7 = n5;
                            Cursor cursor4 = cursor;
                            int n8 = n4;
                            Cursor cursor5 = cursor;
                            int n9 = n3;
                            Cursor cursor6 = cursor;
                            int n10 = n2;
                            l = cursor.getLong(n);
                            string2 = cursor6.getString(n10);
                            string3 = cursor5.getString(n9);
                            string4 = cursor4.getString(n8);
                            object = cursor3.getString(n7);
                            object = v3.SportEventsDao_Impl.this.__converters.stringToStringList((String)object);
                            if (cursor2.getInt(n6) != 0) {
                                boolean bl2 = true;
                                break block19;
                            }
                            boolean bl3 = false;
                        }
                        eventTeam = eventTeam2;
                        eventTeam2 = new EventTeam(l, string2, string3, string4, (List<String>)object, (boolean)var7_14);
                        break block20;
                    }
                    eventTeam = null;
                }
                cursor.close();
                return eventTeam;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<EventSummaryRelation> getEventSummaryRelation(long l) {
        Callable<EventSummaryRelation> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventSummary WHERE EventSummary.eventSummaryId = ?", (int)1);
        roomSQLiteQuery.bindLong(1, l);
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        Callable<EventSummaryRelation> callable2 = callable;
        callable = new Callable<EventSummaryRelation>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public EventSummaryRelation call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    block15: {
                        block14: {
                            block13: {
                                catch (Throwable v1) {
                                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                                    throw v1;
                                }
                                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduleDateString");
                                var3_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduleDate");
                                var4_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventSummaryId");
                                var5_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"scheduled");
                                var6_10 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"league");
                                var7_11 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeScore");
                                var8_13 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayScore");
                                var9_15 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"homeTeamId");
                                var10_16 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"awayTeamId");
                                var11_17 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"status");
                                var12_19 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periods");
                                var13_20 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"periodsCount");
                                var14_22 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"clock");
                                var15_24 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"period");
                                var16_25 = v2;
                                v2 = new LongSparseArray();
                                var17_26 = v3;
                                v3 = new LongSparseArray();
                                while (var1_1.moveToNext()) {
                                    var16_25.put(var1_1.getLong(var4_6), null);
                                    var17_26.put(var1_1.getLong(var4_6), null);
                                }
                                v4 = var1_1;
                                v5 = this;
                                v6 = v5;
                                v7 = v5;
                                var1_1.moveToPosition(-1);
                                SportEventsDao_Impl.access$400(v6.SportEventsDao_Impl.this, var16_25);
                                SportEventsDao_Impl.access$500(v7.SportEventsDao_Impl.this, var17_26);
                                if (!v4.moveToFirst()) ** GOTO lbl88
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_4) || !var1_1.isNull(var4_6) || !var1_1.isNull(var5_8) || !var1_1.isNull(var6_10) || !var1_1.isNull(var7_11) || !var1_1.isNull(var8_13) || !var1_1.isNull(var9_15) || !var1_1.isNull(var10_16) || !var1_1.isNull(var11_17) || !var1_1.isNull(var12_19) || !var1_1.isNull(var13_20) || !var1_1.isNull(var14_22) || !var1_1.isNull(var15_24)) break block13;
                                var14_23 = var2_3 = null;
                                ** GOTO lbl79
                            }
                            v8 = var10_16;
                            v9 = var9_15;
                            var5_9 = var1_1.getLong(var4_6);
                            var7_12 = var1_1.getString(var5_8);
                            var8_14 = var1_1.getString(var6_10);
                            var9_15 = var1_1.getInt(var7_11);
                            var10_16 = var1_1.getInt(var8_13);
                            var11_18 = var1_1.getLong(v9);
                            var18_27 = var1_1.getLong(v8);
                            var13_21 /* !! */  = var1_1.getString(var11_17);
                            var13_21 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventStatus(var13_21 /* !! */ );
                            var20_28 = var1_1.getString(var12_19);
                            var20_28 = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventPeriods((String)var20_28);
                            var21_29 = var1_1.getInt(var13_20);
                            if (!var1_1.isNull(var14_22) || !var1_1.isNull(var15_24)) break block14;
                            var22_30 = var14_23 = null;
                            ** GOTO lbl71
                        }
                        var14_23 = var1_1.getString(var14_22);
                        var15_24 = var1_1.getInt(var15_24);
                        var22_30 = v10;
                        v10 = new EventTime((String)var14_23, var15_24);
lbl71:
                        // 2 sources

                        v11 = var1_1;
                        v12 = var3_4;
                        var14_23 = v13;
                        try {
                            var14_23(var5_9, var7_12, var8_14, var9_15, var10_16, (EventTime)var22_30, var11_18, var18_27, (EventStatus)var13_21 /* !! */ , (List<EventPeriod>)var20_28, var21_29);
                            v13.scheduledDateString = var1_1.getString(var2_2);
                            var2_3 = v11.isNull(v12) != false ? null : Long.valueOf(var1_1.getLong(var3_4));
                            var14_23.scheduleDate = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).timestampToDate((Long)var2_3);
lbl79:
                            // 2 sources

                            var2_3 = (EventTeam)var16_25.get(var1_1.getLong(var4_6));
                            var3_5 = (EventTeam)var17_26.get(var1_1.getLong(var4_6));
                        }
                        catch (Throwable v14) {}
                        {
                            var1_1.close();
                            throw v14;
                        }
                        var4_7 = v15;
                        v15 = new EventSummaryRelation((EventSummary)var14_23, (EventTeam)var2_3, var3_5);
                        break block15;
lbl88:
                        // 1 sources

                        var4_7 = null;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var4_7;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)callable2);
    }

    @Override
    public Observable<List<EventScheduleDataRelation>> getEventSchedulesRelation(String string2, String object) {
        Callable<List<EventScheduleDataRelation>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM EventScheduleData LEFT JOIN EventScheduleAttributes ON EventScheduleData.attributesId = EventScheduleAttributes.eventScheduleAttributesId LEFT JOIN EventSummary ON EventScheduleAttributes.eventScheduleAttributesId = EventSummary.eventSummaryId WHERE EventSummary.scheduleDateString = ? AND EventSummary.league = ? ORDER BY EventScheduleData.eventScheduleDataId ASC, datetime(EventSummary.scheduleDate) ASC", (int)2);
        int n = 1;
        if (string2 == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, string2);
        }
        int n2 = 2;
        if (object == null) {
            roomSQLiteQuery.bindNull(n2);
        } else {
            roomSQLiteQuery.bindString(n2, (String)object);
        }
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "EventSummaryHomeEventTeamCrossRef";
        stringArray[1] = "EventTeam";
        stringArray[2] = "EventSummaryAwayEventTeamCrossRef";
        stringArray[3] = "EventSummary";
        stringArray[4] = "EventScheduleAttributes";
        stringArray[5] = "EventScheduleData";
        object = callable;
        callable = new Callable<List<EventScheduleDataRelation>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<EventScheduleDataRelation> call() throws Exception {
                v0 = this;
                SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this).beginTransaction();
                var1_1 = DBUtil.query((RoomDatabase)SportEventsDao_Impl.access$100(v0.SportEventsDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)true, null);
                {
                    catch (Throwable v1) {
                        SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                        throw v1;
                    }
                    var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"eventScheduleDataId");
                    var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"type");
                    var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"attributesId");
                    var5_5 = v2;
                    v2 = new LongSparseArray();
                    while (var1_1.moveToNext()) {
                        var5_5.put(var1_1.getLong(var2_2), null);
                    }
                    v3 = this;
                    var1_1.moveToPosition(-1);
                    SportEventsDao_Impl.access$600(v3.SportEventsDao_Impl.this, var5_5);
                    var6_6 = v4;
                    try {
                        v4 = new ArrayList<EventScheduleDataRelation>(var1_1.getCount());
                        while (var1_1.moveToNext()) {
                            block13: {
                                if (!var1_1.isNull(var2_2) || !var1_1.isNull(var3_3) || !var1_1.isNull(var4_4)) break block13;
                                var7_7 = null;
                                var12_11 = var7_7;
                                ** GOTO lbl43
                            }
                            var7_8 = var1_1.getLong(var2_2);
                            var9_9 /* !! */  = var1_1.getString(var3_3);
                            var9_9 /* !! */  = SportEventsDao_Impl.access$000(SportEventsDao_Impl.this).stringToEventType(var9_9 /* !! */ );
                            var10_10 = var1_1.getLong(var4_4);
                        }
                    }
                    catch (Throwable v5) {}
                    {
                        var1_1.close();
                        throw v5;
                    }
                    {
                        var12_11 = v6;
                        v6 = new EventScheduleData(var7_8, (EventType)var9_9 /* !! */ , var10_10);
lbl43:
                        // 2 sources

                        var7_7 = (EventScheduleAttributesRelation)var5_5.get(var1_1.getLong(var2_2));
                        var6_6.add(new EventScheduleDataRelation((EventScheduleData)var12_11, var7_7));
                        continue;
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).setTransactionSuccessful();
                    {
                        var1_1.close();
                    }
                    SportEventsDao_Impl.access$100(SportEventsDao_Impl.this).endTransaction();
                    return var6_6;
                }
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)true, (String[])stringArray2, (Callable)object);
    }

    @Override
    public Observable<List<String>> getScheduleDateStrings(String stringArray) {
        Callable<List<String>> callable;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT scheduleDateString FROM EventSummary WHERE league = ? ORDER BY datetime(EventSummary.scheduleDate) ASC", (int)1);
        int n = 1;
        if (stringArray == null) {
            roomSQLiteQuery.bindNull(n);
        } else {
            roomSQLiteQuery.bindString(n, (String)stringArray);
        }
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "EventSummary";
        Callable<List<String>> callable2 = callable;
        callable = new Callable<List<String>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> call() throws Exception {
                ArrayList<String> arrayList;
                36 this_ = DBUtil.query((RoomDatabase)this_.SportEventsDao_Impl.this.__db, (SupportSQLiteQuery)this_.roomSQLiteQuery, (boolean)false, null);
                ArrayList<String> arrayList2 = arrayList;
                try {
                    arrayList = new ArrayList<String>(this_.getCount());
                }
                catch (Throwable throwable) {
                    this_.close();
                    throw throwable;
                }
                while (this_.moveToNext()) {
                    arrayList2.add(this_.getString(0));
                }
                this_.close();
                return arrayList2;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray, (Callable)callable2);
    }

    @Override
    public Observable<BasketballStandings> getBasketballStandings() {
        return SportEventsDao.DefaultImpls.getBasketballStandings(this);
    }

    @Override
    public Observable<EventSummaryResponseData> getEventSummaryResponseData(long l) {
        return SportEventsDao.DefaultImpls.getEventSummaryResponseData(this, l);
    }

    @Override
    public Observable<EventSummary> getEventSummary(long l) {
        return SportEventsDao.DefaultImpls.getEventSummary(this, l);
    }

    @Override
    public Observable<List<EventScheduleData>> getEventSchedules(String string2, String string3) {
        return SportEventsDao.DefaultImpls.getEventSchedules(this, string2, string3);
    }

    @Override
    public Observable<List<Date>> getScheduleDates(String string2) {
        return SportEventsDao.DefaultImpls.getScheduleDates(this, string2);
    }
}

