/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import androidx.lifecycle.LiveData;
import androidx.paging.LivePagedListKt;
import androidx.paging.PagedList;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.notifications.InAppNotificationsService;
import io.streamlayer.common.data.retrofit.ApiInterface;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.BaseRepo;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.messaging.Access;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.model.tinodecontact.TinodeUserPublic;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.repository.messaging.MessagingRepoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J7\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00150\u00100\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000f2\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J2\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010$\u001a\u00020\u001e2\b\b\u0002\u0010%\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001eJ\u001c\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\"\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00150\u00100\u000f2\u0006\u0010(\u001a\u00020\"H\u0016J9\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00150\u00100\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010 J\"\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00150\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J*\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001c\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0/0.2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J$\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016H\u0016JB\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\b\u00102\u001a\u0004\u0018\u00010\u00162\b\u00103\u001a\u0004\u0018\u00010\u00162\b\u00104\u001a\u0004\u0018\u00010\u0016H\u0016J \u00105\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\b\u00106\u001a\u0004\u0018\u000107H\u0016J.\u00108\u001a\b\u0012\u0004\u0012\u00020\"0\u000f2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/streamlayer/sdk/repository/messaging/MessagingRepoImpl;", "Lio/streamlayer/common/mvvm/BaseRepo;", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "tinode", "Lio/streamlayer/common/data/tinode/TinodeService;", "api", "Lio/streamlayer/common/data/retrofit/ApiInterface;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "inAppNotificationsService", "Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/tinode/TinodeService;Lio/streamlayer/common/data/retrofit/ApiInterface;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/common/data/notifications/InAppNotificationsService;)V", "createChat", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/messaging/Chat;", "data", "Lio/streamlayer/sdk/model/tinodecontact/TinodeUserPublic;", "userIds", "", "", "deleteUnsentMessages", "", "chatId", "fetchMessages", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "topicId", "beforeSeqId", "", "limit", "(Ljava/lang/String;Ljava/lang/Integer;I)Lio/reactivex/Observable;", "fetchTinodeParticipants", "", "fetchTopicMessages", "sinceId", "beforeId", "getChat", "getChats", "isVoice", "getMessages", "getParticipants", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "inviteUsersToChat", "paginatedMessagesSource", "Landroidx/lifecycle/LiveData;", "Landroidx/paging/PagedList;", "sendMessage", "content", "type", "subtype", "reply", "subscribeToChat", "access", "Lio/streamlayer/sdk/model/messaging/Access;", "triggerMessageLoad", "sdk_release"})
public final class MessagingRepoImpl
extends BaseRepo
implements MessagingRepo {
    private final AppDatabase database;
    private final TinodeService tinode;
    private final SessionPrefImpl session;
    private final InAppNotificationsService inAppNotificationsService;

    public static /* synthetic */ Observable fetchTopicMessages$default(MessagingRepoImpl messagingRepoImpl, String string2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 30;
        }
        return messagingRepoImpl.fetchTopicMessages(string2, n, n2, n3);
    }

    private final Observable<Boolean> fetchTinodeParticipants(String string2) {
        Observable observable = this.tinode.getParticipants(string2).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
            }

            @NotNull
            public final Observable<Boolean> apply(@NotNull List<TinodeContact> object) {
                ArrayList<ChatParticipantCrossRef> arrayList;
                ArrayList<E> arrayList2;
                Iterator<T> iterator = object;
                Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"it");
                object = arrayList2;
                arrayList2 = new ArrayList<E>();
                Object messagingDao = iterator.iterator();
                while (messagingDao.hasNext()) {
                    T object22 = messagingDao.next();
                    if (!(((TinodeContact)object22).getChatName() != null)) continue;
                    object.add(object22);
                }
                fetchTinodeParticipants.1 v2 = this;
                MessagingRepoImpl.access$getDatabase$p(v2.this$0).tinodeContactDao().insertTinodeContacts((List<TinodeContact>)((Object)object));
                messagingDao = MessagingRepoImpl.access$getDatabase$p(v2.this$0).messagingDao();
                ArrayList<ChatParticipantCrossRef> arrayList3 = arrayList;
                arrayList = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)object), (int)10));
                object = object.iterator();
                while (object.hasNext()) {
                    TinodeContact tinodeContact = (TinodeContact)object.next();
                    arrayList3.add(new ChatParticipantCrossRef(this.$chatId, tinodeContact.getChatUserId()));
                }
                messagingDao.saveChatParticipantCrossRefs(arrayList3);
                return Observable.just((Object)true);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.getParticipants(c\u2026able.just(true)\n        }");
        return observable;
    }

    @Inject
    public MessagingRepoImpl(@NotNull AppDatabase appDatabase, @NotNull TinodeService tinodeService, @NotNull ApiInterface apiInterface, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull InAppNotificationsService inAppNotificationsService) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinode");
        Intrinsics.checkParameterIsNotNull((Object)apiInterface, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)inAppNotificationsService, (String)"inAppNotificationsService");
        super(appDatabase, apiInterface, sessionPrefImpl);
        this.database = appDatabase;
        this.tinode = tinodeService;
        this.session = sessionPrefImpl;
        this.inAppNotificationsService = inAppNotificationsService;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.database;
    }

    public static final /* synthetic */ InAppNotificationsService access$getInAppNotificationsService$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.inAppNotificationsService;
    }

    public static final /* synthetic */ TinodeService access$getTinode$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.tinode;
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(MessagingRepoImpl messagingRepoImpl) {
        return messagingRepoImpl.session;
    }

    public static final /* synthetic */ Observable access$fetchTinodeParticipants(MessagingRepoImpl messagingRepoImpl, String string2) {
        return messagingRepoImpl.fetchTinodeParticipants(string2);
    }

    @Override
    @NotNull
    public LiveData<PagedList<ChatMessage>> paginatedMessagesSource(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return LivePagedListKt.toLiveData$default(this.database.messagingDao().getChatMessagesLiveData(string2), (int)30, null, null, null, (int)14, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<ChatMessage>>> getMessages(@NotNull String string2, @Nullable Integer n, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return this.twoSideCall(new Function0<Observable<List<? extends ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessages(this.$topicId, this.$beforeSeqId, null, this.$limit);
            }
        }, new Function0<Observable<List<ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                getMessages.2 v0 = this;
                MessagingRepoImpl messagingRepoImpl = v0.this$0;
                String string2 = v0.$topicId;
                int n = 0;
                Integer n2 = v0.$beforeSeqId;
                int n3 = n2 != null ? n2 : 0;
                Observable observable = messagingRepoImpl.fetchTopicMessages(string2, n, n3, this.$limit).toList().toObservable();
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"fetchTopicMessages(topic\u2026).toList().toObservable()");
                return observable;
            }
        }, new Function1<List<? extends ChatMessage>, Unit>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
                super(1);
            }

            public final void invoke(List<ChatMessage> list) {
                MessagingDao messagingDao = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao();
                List<ChatMessage> list2 = list;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it");
                messagingDao.saveChatMessages(list2);
            }
        });
    }

    @NotNull
    public final Observable<ResourceState<List<ChatMessage>>> fetchMessages(@NotNull String string2, @Nullable Integer n, int n2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        return BaseRepo.oneSideCall$default(this, (Function0)new Function0<Observable<List<ChatMessage>>>(this, string2, n, n2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ Integer $beforeSeqId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$beforeSeqId = n;
                this.$limit = n2;
                super(0);
            }

            public final Observable<List<ChatMessage>> invoke() {
                fetchMessages.1 v0 = this;
                MessagingRepoImpl messagingRepoImpl = v0.this$0;
                String string2 = v0.$topicId;
                int n = 0;
                Integer n2 = v0.$beforeSeqId;
                int n3 = n2 != null ? n2 : 0;
                return messagingRepoImpl.fetchTopicMessages(string2, n, n3, this.$limit).toList().toObservable();
            }
        }, null, null, 6, null);
    }

    @NotNull
    public final Observable<ChatMessage> fetchTopicMessages(@NotNull String string2, int n, int n2, int n3) {
        MessagingRepoImpl messagingRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        messagingRepoImpl.inAppNotificationsService.pauseNotifications(true, string2);
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        Observable observable = Observable.mergeDelayError((ObservableSource)messagingRepoImpl.tinode.subscribeToTopic(string2, null).flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
            }

            @NotNull
            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
                MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().saveOrUpdateChatMessage(chatMessage);
                return Observable.just((Object)chatMessage);
            }
        }).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                ChatMessage chatMessage2 = chatMessage;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"it");
                return !(StringsKt.isBlank((CharSequence)chatMessage2.getText()) ^ true) && !(StringsKt.isBlank((CharSequence)chatMessage.getType()) ^ true) ? MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessage(this.$topicId, chatMessage.getSeq()).toObservable() : MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessage(this.$topicId, chatMessage.getSeq()).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ fetchTopicMessages.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"it");
                        MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).notifyChatMessage(chatMessage);
                        return Observable.just((Object)chatMessage);
                    }
                });
            }
        }), (ObservableSource)Observable.just((Object)true).delay(100L, timeUnit).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2, n, n2, n3){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            final /* synthetic */ int $sinceId;
            final /* synthetic */ int $beforeId;
            final /* synthetic */ int $limit;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
                this.$sinceId = n;
                this.$beforeId = n2;
                this.$limit = n3;
            }

            public final Observable<ChatMessage> apply(@NotNull Boolean bl) {
                Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                return MessagingRepoImpl.access$getTinode$p(this.this$0).getMessages(this.$topicId, this.$sinceId, this.$beforeId, this.$limit).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ fetchTopicMessages.3 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<ChatMessage> apply(@NotNull Boolean bl) {
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).pauseNotifications(false, this.this$0.$topicId);
                        return Observable.empty();
                    }
                });
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.mergeDelayErr\u2026\n            }\n\n        )");
        return observable;
    }

    @Override
    @NotNull
    public Observable<Boolean> triggerMessageLoad(@NotNull String string2, int n, int n2, int n3) {
        MessagingRepoImpl messagingRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        messagingRepoImpl.inAppNotificationsService.pauseNotifications(true, string2);
        Observable observable = messagingRepoImpl.tinode.getMessages(string2, n, n2, n3).doOnNext(new Consumer<Boolean>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final void accept(Boolean bl) {
                MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0).pauseNotifications(false, this.$topicId);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.getMessages(topic\u2026cations(false, topicId) }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ChatMessage> subscribeToChat(@NotNull String string2, @Nullable Access access) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Observable observable = this.tinode.subscribeToTopic(string2, access).flatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ MessagingRepoImpl this$0;
            {
                this.this$0 = messagingRepoImpl;
            }

            @NotNull
            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
                MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().saveOrUpdateChatMessage(chatMessage);
                return Observable.just((Object)chatMessage);
            }
        }).flatMap(new Function<T, ObservableSource<? extends R>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $topicId;
            {
                this.this$0 = messagingRepoImpl;
                this.$topicId = string2;
            }

            public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                ChatMessage chatMessage2 = chatMessage;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"it");
                return !(StringsKt.isBlank((CharSequence)chatMessage2.getText()) ^ true) && !(StringsKt.isBlank((CharSequence)chatMessage.getType()) ^ true) ? MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessage(this.$topicId, chatMessage.getSeq()).toObservable() : MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChatMessage(this.$topicId, chatMessage.getSeq()).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ subscribeToChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<ChatMessage> apply(@NotNull ChatMessage chatMessage) {
                        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"it");
                        MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).notifyChatMessage(chatMessage);
                        return Observable.just((Object)chatMessage);
                    }
                });
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"tinode.subscribeToTopic(\u2026)\n            }\n        }");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<Chat>>> getChats(boolean bl) {
        return this.twoSideCall(new Function0<Observable<List<? extends Chat>>>(this, bl){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ boolean $isVoice;
            {
                this.this$0 = messagingRepoImpl;
                this.$isVoice = bl;
                super(0);
            }

            public final Observable<List<Chat>> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChats(this.$isVoice);
            }
        }, new Function0<Observable<List<? extends Chat>>>(this, bl){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ boolean $isVoice;
            {
                this.this$0 = messagingRepoImpl;
                this.$isVoice = bl;
                super(0);
            }

            @NotNull
            public final Observable<List<Chat>> invoke() {
                getChats.2 this_;
                if (this_.$isVoice) {
                    this_ = Observable.empty();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)this_), (String)"Observable.empty<List<Chat>>()");
                } else {
                    this_ = MessagingRepoImpl.access$getTinode$p(this_.this$0).getChats().map((Function)getChats.1.INSTANCE).flatMap(new Function<T, ObservableSource<? extends R>>(this_){
                        final /* synthetic */ getChats.2 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final Observable<List<Chat>> apply(@NotNull List<Chat> list) {
                            ArrayList<T> arrayList;
                            List<Chat> list2 = list;
                            Intrinsics.checkParameterIsNotNull(list2, (String)"chats");
                            Object object = arrayList;
                            arrayList = new ArrayList<T>();
                            for (T object2 : list2) {
                                if (!(((Chat)object2).isVoiceChat() ^ true)) continue;
                                object.add(object2);
                            }
                            if (!MessagingRepoImpl.access$getSession$p(this.this$0.this$0).isInitialTopicUnreadMessagesSet()) {
                                MessagingRepoImpl.access$getSession$p(this.this$0.this$0).setInitialTopicUnreadMessagesSet(true);
                                for (Chat chat : object) {
                                    MessagingRepoImpl.access$getSession$p(this.this$0.this$0).setLastUnreadMessageSeq(chat.getChatId(), chat.getSeq());
                                }
                            }
                            Observable observable = Observable.fromIterable(object);
                            object = TimeUnit.MILLISECONDS;
                            Observable observable2 = observable.delay(1000L, object).flatMap(new Function<T, ObservableSource<? extends R>>(this, list){
                                final /* synthetic */ getChats.2 this$0;
                                final /* synthetic */ List $chats;
                                {
                                    this.this$0 = var1_1;
                                    this.$chats = list;
                                }

                                @NotNull
                                public final Observable<Chat> apply(@NotNull Chat chat) {
                                    Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                    return MessagingRepoImpl.access$getDatabase$p(this.this$0.this$0.this$0).messagingDao().getLastSeqId(chat.getChatId()).defaultIfEmpty((Object)0).filter(new Predicate<Integer>(chat){
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.$chat = chat;
                                        }

                                        public final boolean test(@NotNull Integer n) {
                                            Intrinsics.checkParameterIsNotNull((Object)n, (String)"it");
                                            int n2 = this.$chat.getSeq();
                                            return n != n2;
                                        }
                                    }).delay((long)this.$chats.indexOf(chat) * 100L, TimeUnit.MILLISECONDS).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, chat){
                                        final /* synthetic */ getChats.4 this$0;
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.this$0 = var1_1;
                                            this.$chat = chat;
                                        }

                                        public final Observable<Chat> apply(@NotNull Integer object) {
                                            Integer n = object;
                                            getChats.2 v1 = messagingRepoImpl;
                                            Intrinsics.checkParameterIsNotNull((Object)object, (String)"lastSeqId");
                                            MessagingRepoImpl messagingRepoImpl = v1.this$0.this$0.this$0.this$0;
                                            object = v1.$chat.getChatId();
                                            int n2 = n + 1;
                                            int n3 = 0;
                                            int n4 = n == 0 ? 30 : 0;
                                            return MessagingRepo.DefaultImpls.triggerMessageLoad$default(messagingRepoImpl, (String)object, n2, n3, n4, 4, null).flatMap((Function)getChats.1.INSTANCE);
                                        }
                                    });
                                }
                            }).flatMap((Function)getChats.5.INSTANCE);
                            object = TimeUnit.MILLISECONDS;
                            return Observable.mergeDelayError((ObservableSource)Observable.just(list), (ObservableSource)Observable.fromIterable(list).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                final /* synthetic */ getChats.2 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final Observable<Chat> apply(@NotNull Chat chat) {
                                    Ref.ObjectRef objectRef;
                                    getChats.2 v0 = this;
                                    Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                    MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)chat));
                                    Ref.ObjectRef objectRef2 = objectRef;
                                    objectRef2();
                                    objectRef.element = Chat.copy$default(chat, null, null, null, 0, 0, 0, null, null, null, null, 1023, null);
                                    return v0.this$0.this$0.this$0.subscribeToChat(chat.getChatId(), chat.getAccess()).flatMap(new Function<T, ObservableSource<? extends R>>(this, objectRef2, chat){
                                        final /* synthetic */ getChats.2 this$0;
                                        final /* synthetic */ Ref.ObjectRef $updatingChat;
                                        final /* synthetic */ Chat $chat;
                                        {
                                            this.this$0 = var1_1;
                                            this.$updatingChat = objectRef;
                                            this.$chat = chat;
                                        }

                                        public final Observable<Chat> apply(@NotNull ChatMessage chatMessage) {
                                            ChatMessage chatMessage2 = chatMessage;
                                            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"newMessage");
                                            if (chatMessage2.getSeq() > ((Chat)this.$updatingChat.element).getSeq()) {
                                                getChats.1 v1 = this;
                                                Ref.ObjectRef objectRef = v1.$updatingChat;
                                                ChatMessage chatMessage3 = chatMessage;
                                                int n = chatMessage3.getSeq();
                                                Date date2 = chatMessage3.getDate();
                                                Chat chat = Chat.copy$default(this.$chat, null, null, null, n, 0, 0, date2, null, null, null, 951, null);
                                                chat.setLastMessage(chatMessage);
                                                objectRef.element = chat;
                                                MessagingRepoImpl.access$getDatabase$p(v1.this$0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)((Chat)this.$updatingChat.element)));
                                            }
                                            return Observable.empty();
                                        }
                                    });
                                }
                            }).flatMap((Function)getChats.3.INSTANCE), (ObservableSource)observable2, (ObservableSource)Observable.just((Object)true).delay(200L, object).flatMap(new Function<T, ObservableSource<? extends R>>(this, list){
                                final /* synthetic */ getChats.2 this$0;
                                final /* synthetic */ List $chats;
                                {
                                    this.this$0 = var1_1;
                                    this.$chats = list;
                                }

                                public final Observable<List<Chat>> apply(@NotNull Boolean bl) {
                                    Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                                    return Observable.fromIterable((Iterable)this.$chats).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                        final /* synthetic */ getChats.6 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final Observable<Chat> apply(@NotNull Chat chat) {
                                            Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                                            return MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0.this$0.this$0.this$0, chat.getChatId()).flatMap((Function)getChats.1.INSTANCE);
                                        }
                                    }).flatMap((Function)getChats.2.INSTANCE);
                                }
                            })).distinctUntilChanged().flatMap(new Function<T, ObservableSource<? extends R>>(this){
                                final /* synthetic */ getChats.2 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final Observable<List<Chat>> apply(@NotNull List<Chat> list) {
                                    getChats.7 v0 = this;
                                    Intrinsics.checkParameterIsNotNull(list, (String)"it");
                                    MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().deleteChats();
                                    MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChats(list);
                                    return Observable.empty();
                                }
                            });
                        }
                    }).distinctUntilChanged();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)this_), (String)"tinode.getChats()\n      \u2026 }.distinctUntilChanged()");
                }
                return this_;
            }
        }, getChats.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Chat>> getChat(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        return this.twoSideCall(new Function0<Observable<Chat>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<Chat> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChat(this.$chatId).map(new Function<T, R>(this){
                    final /* synthetic */ getChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Chat apply(@NotNull Chat chat) {
                        Chat chat2 = chat;
                        Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"it");
                        if (chat2.isVoiceChat()) {
                            MessagingRepoImpl.access$getInAppNotificationsService$p(this.this$0.this$0).notifyCall(chat);
                        }
                        return chat;
                    }
                });
            }
        }, new Function0<Observable<Chat>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<Chat> invoke() {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                Observable observable = MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getLastSeqId(this.$chatId).delay(400L, timeUnit).defaultIfEmpty((Object)0).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Integer n) {
                        Intrinsics.checkParameterIsNotNull((Object)n, (String)"seqId");
                        Object object = object.this$0;
                        return MessagingRepoImpl.fetchTopicMessages$default(object.this$0, object.$chatId, n + 1, 0, 0, 12, null).flatMap((Function)getChat.1.INSTANCE);
                    }
                });
                timeUnit = TimeUnit.MILLISECONDS;
                Observable observable2 = Observable.mergeDelayError((ObservableSource)MessagingRepoImpl.access$getTinode$p(this.this$0).getChat(this.$chatId).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Chat chat) {
                        Ref.ObjectRef objectRef;
                        getChat.1 v0 = this;
                        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
                        MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)chat));
                        Ref.ObjectRef objectRef2 = objectRef;
                        objectRef2();
                        objectRef.element = Chat.copy$default(chat, null, null, null, 0, 0, 0, null, null, null, null, 1023, null);
                        return v0.this$0.this$0.subscribeToChat(chat.getChatId(), chat.getAccess()).flatMap(new Function<T, ObservableSource<? extends R>>(this, objectRef2, chat){
                            final /* synthetic */ getChat.1 this$0;
                            final /* synthetic */ Ref.ObjectRef $updatingChat;
                            final /* synthetic */ Chat $chat;
                            {
                                this.this$0 = var1_1;
                                this.$updatingChat = objectRef;
                                this.$chat = chat;
                            }

                            public final Observable<Chat> apply(@NotNull ChatMessage chatMessage) {
                                ChatMessage chatMessage2 = chatMessage;
                                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"newMessage");
                                if (chatMessage2.getSeq() > ((Chat)this.$updatingChat.element).getSeq()) {
                                    getChat.1 v1 = this;
                                    Ref.ObjectRef objectRef = v1.$updatingChat;
                                    ChatMessage chatMessage3 = chatMessage;
                                    int n = chatMessage3.getSeq();
                                    Date date2 = chatMessage3.getDate();
                                    Chat chat = Chat.copy$default(this.$chat, null, null, null, n, 0, 0, date2, null, null, null, 951, null);
                                    chat.setLastMessage(chatMessage);
                                    objectRef.element = chat;
                                    MessagingRepoImpl.access$getDatabase$p(v1.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)((Chat)this.$updatingChat.element)));
                                }
                                return Observable.empty();
                            }
                        });
                    }
                }), (ObservableSource)observable, (ObservableSource)Observable.just((Object)true).delay(200L, timeUnit).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ getChat.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Chat> apply(@NotNull Boolean bl) {
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        Object object = object.this$0;
                        return MessagingRepoImpl.access$fetchTinodeParticipants(object.this$0, object.$chatId).flatMap((Function)getChat.1.INSTANCE);
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"Observable.mergeDelayErr\u2026      }\n                )");
                return observable2;
            }
        }, getChat.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<TinodeContact>>> getParticipants(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        return this.twoSideCall(new Function0<Observable<List<? extends TinodeContact>>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<List<TinodeContact>> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getChat(this.$chatId).map((Function)getParticipants.1.INSTANCE);
            }
        }, new Function0<Observable<List<? extends TinodeContact>>>(this, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                super(0);
            }

            public final Observable<List<TinodeContact>> invoke() {
                Observable observable = MessagingRepoImpl.access$fetchTinodeParticipants(this.this$0, this.$chatId).flatMap((Function)getParticipants.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"fetchTinodeParticipants(\u2026<List<TinodeContact>>() }");
                return observable;
            }
        }, getParticipants.3.INSTANCE);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendMessage(@NotNull String string2, @NotNull String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"content");
        return BaseRepo.oneSideCall$default(this, (Function0)new Function0<Observable<Boolean>>(this, string2, string3, string4, string5, string6){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ String $chatId;
            final /* synthetic */ String $content;
            final /* synthetic */ String $type;
            final /* synthetic */ String $subtype;
            final /* synthetic */ String $reply;
            {
                this.this$0 = messagingRepoImpl;
                this.$chatId = string2;
                this.$content = string3;
                this.$type = string4;
                this.$subtype = string5;
                this.$reply = string6;
                super(0);
            }

            @NotNull
            public final Observable<Boolean> invoke() {
                return MessagingRepoImpl.access$getDatabase$p(this.this$0).messagingDao().getLastSeqId(this.$chatId).defaultIfEmpty((Object)0).flatMapObservable(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ sendMessage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Boolean> apply(@NotNull Integer n) {
                        LinkedHashMap<K, V> linkedHashMap;
                        ChatMessage chatMessage;
                        Date date2;
                        Integer n2 = n;
                        Intrinsics.checkParameterIsNotNull((Object)n2, (String)"it");
                        int n3 = n2 + 1;
                        sendMessage.1 v1 = this.this$0;
                        String string2 = v1.$chatId;
                        String string3 = MessagingRepoImpl.access$getSession$p(v1.this$0).getTinodeUserId();
                        if (string3 == null) {
                            string3 = "";
                        }
                        Cloneable cloneable = date2;
                        date2 = new Date();
                        sendMessage.1 v3 = this.this$0;
                        String string4 = v3.$content;
                        ChatMessageStatus chatMessageStatus = ChatMessageStatus.Sending;
                        String string5 = v3.$type;
                        if (string5 == null) {
                            string5 = "";
                        }
                        String string6 = this.this$0.$subtype;
                        if (string6 == null) {
                            string6 = "";
                        }
                        String string7 = this.this$0.$reply;
                        if (string7 == null) {
                            string7 = "";
                        }
                        sendMessage.1 v4 = this;
                        ChatMessage chatMessage2 = chatMessage;
                        chatMessage = new ChatMessage(string2, n3, string3, (Date)cloneable, string4, string5, string6, string7, chatMessageStatus);
                        MessagingRepoImpl.access$getDatabase$p(v4.this$0.this$0).messagingDao().saveChatMessage(chatMessage2);
                        TinodeService tinodeService = MessagingRepoImpl.access$getTinode$p(v4.this$0.this$0);
                        sendMessage.1 v6 = v4.this$0;
                        string2 = v6.$chatId;
                        string3 = v6.$content;
                        cloneable = linkedHashMap;
                        linkedHashMap = new LinkedHashMap<K, V>();
                        string4 = v4.this$0.$type;
                        if (string4 != null) {
                            cloneable.put("x-slr-type", string4);
                        }
                        if ((string4 = this.this$0.$subtype) != null) {
                            cloneable.put("x-slr-subtype", string4);
                        }
                        if ((string4 = this.this$0.$reply) != null) {
                            cloneable.put("x-slr-reply", string4);
                        }
                        return tinodeService.sendMessage(string2, string3, (Map<String, String>)((Object)cloneable)).flatMap(new Function<T, ObservableSource<? extends R>>(this, chatMessage2){
                            final /* synthetic */ sendMessage.1 this$0;
                            final /* synthetic */ ChatMessage $message;
                            {
                                this.this$0 = var1_1;
                                this.$message = chatMessage;
                            }

                            @NotNull
                            public final Observable<Boolean> apply(@NotNull Boolean bl) {
                                Boolean bl2 = bl;
                                Intrinsics.checkParameterIsNotNull((Object)bl2, (String)"it");
                                if (!bl2.booleanValue()) {
                                    Object object = ChatMessageStatus.Failed;
                                    MessagingRepoImpl.access$getDatabase$p(object.this$0.this$0.this$0).messagingDao().updateChatMessage(ChatMessageUpdate.copy$default(ChatMessageKt.toUpdateEntity(object.$message), null, 0, (ChatMessageStatus)((Object)object), 3, null));
                                }
                                return Observable.just((Object)bl);
                            }
                        });
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendMessage(@NotNull String string2, @NotNull String string3) {
        String string4 = string3;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)string4, (String)"content");
        return this.sendMessage(string2, string4, null, null, null);
    }

    @Override
    public void deleteUnsentMessages(@NotNull String string2) {
        MessagingRepoImpl messagingRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        messagingRepoImpl.database.messagingDao().deleteMessages(string2, ChatMessageStatus.Sending);
        messagingRepoImpl.database.messagingDao().deleteMessages(string2, ChatMessageStatus.Failed);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Chat>> createChat(@NotNull TinodeUserPublic tinodeUserPublic, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull((Object)tinodeUserPublic, (String)"data");
        Intrinsics.checkParameterIsNotNull(list, (String)"userIds");
        return BaseRepo.oneSideCall$default(this, (Function0)new Function0<Observable<Chat>>(this, tinodeUserPublic, list){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ TinodeUserPublic $data;
            final /* synthetic */ List $userIds;
            {
                this.this$0 = messagingRepoImpl;
                this.$data = tinodeUserPublic;
                this.$userIds = list;
                super(0);
            }

            public final Observable<Chat> invoke() {
                return MessagingRepoImpl.access$getTinode$p(this.this$0).createTopic(this.$data).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ createChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<Chat> apply(@NotNull Chat chat) {
                        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"newChat");
                        return Observable.fromIterable((Iterable)this.this$0.$userIds).flatMapSingle(new Function<T, SingleSource<? extends R>>(this, chat){
                            final /* synthetic */ createChat.1 this$0;
                            final /* synthetic */ Chat $newChat;
                            {
                                this.this$0 = var1_1;
                                this.$newChat = chat;
                            }

                            public final Single<Boolean> apply(@NotNull String string2) {
                                Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
                                return MessagingRepoImpl.access$getTinode$p(this.this$0.this$0.this$0).inviteUserToTopic(this.$newChat.getChatId(), string2).first((Object)false);
                            }
                        }).toList().flatMapObservable(new Function<T, ObservableSource<? extends R>>(this, chat){
                            final /* synthetic */ createChat.1 this$0;
                            final /* synthetic */ Chat $newChat;
                            {
                                this.this$0 = var1_1;
                                this.$newChat = chat;
                            }

                            @NotNull
                            public final Observable<Chat> apply(@NotNull List<Boolean> object) {
                                ArrayList<ChatParticipantCrossRef> arrayList;
                                createChat.2 v0 = this;
                                Intrinsics.checkParameterIsNotNull(object, (String)"it");
                                MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao().saveChats(CollectionsKt.listOf((Object)this.$newChat));
                                object = MessagingRepoImpl.access$getDatabase$p(v0.this$0.this$0.this$0).messagingDao();
                                Object object2 = v0.this$0.this$0.$userIds;
                                ArrayList<ChatParticipantCrossRef> arrayList2 = arrayList;
                                arrayList = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                                object2 = object2.iterator();
                                while (object2.hasNext()) {
                                    String string2 = (String)object2.next();
                                    arrayList2.add(new ChatParticipantCrossRef(this.$newChat.getChatId(), string2));
                                }
                                object.saveChatParticipantCrossRefs(arrayList2);
                                return Observable.just((Object)this.$newChat);
                            }
                        });
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> inviteUsersToChat(@NotNull String string2, @NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull(list, (String)"userIds");
        return BaseRepo.oneSideCall$default(this, (Function0)new Function0<Observable<Boolean>>(this, list, string2){
            final /* synthetic */ MessagingRepoImpl this$0;
            final /* synthetic */ List $userIds;
            final /* synthetic */ String $chatId;
            {
                this.this$0 = messagingRepoImpl;
                this.$userIds = list;
                this.$chatId = string2;
                super(0);
            }

            @NotNull
            public final Observable<Boolean> invoke() {
                return Observable.fromIterable((Iterable)this.$userIds).flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                    final /* synthetic */ inviteUsersToChat.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Single<Boolean> apply(@NotNull String string2) {
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
                        return MessagingRepoImpl.access$getTinode$p(this.this$0.this$0).inviteUserToTopic(this.this$0.$chatId, string2).first((Object)false).flatMap(new Function<T, SingleSource<? extends R>>(this, string2){
                            final /* synthetic */ inviteUsersToChat.1 this$0;
                            final /* synthetic */ String $userId;
                            {
                                this.this$0 = var1_1;
                                this.$userId = string2;
                            }

                            @NotNull
                            public final Single<Boolean> apply(@NotNull Boolean bl) {
                                Boolean bl2 = bl;
                                Intrinsics.checkParameterIsNotNull((Object)bl2, (String)"success");
                                if (bl2.booleanValue()) {
                                    MessagingDao messagingDao = MessagingRepoImpl.access$getDatabase$p(this.this$0.this$0.this$0).messagingDao();
                                    String string2 = this.this$0.this$0.$chatId;
                                    String string3 = this.$userId;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"userId");
                                    messagingDao.saveChatParticipantCrossRefs(CollectionsKt.listOf((Object)new ChatParticipantCrossRef(string2, string3)));
                                }
                                return Single.just((Object)bl);
                            }
                        });
                    }
                }).toList().flatMapObservable((Function)inviteUsersToChat.2.INSTANCE);
            }
        }, null, null, 6, null);
    }
}

