/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.contentprovider;

import android.content.Context;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.SparseArray;
import androidx.annotation.RequiresPermission;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import io.streamlayer.common.data.contentprovider.ContactsProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.contact.PhoneContact;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;)V", "fetchContacts", "", "Lio/streamlayer/sdk/model/contact/PhoneContact;", "Companion", "sdk_release"})
public final class ContactsProvider {
    private static final String[] projection;
    private static final String selection = "mimetype in (?, ?) AND has_phone_number = '1'";
    private static final String[] selectionArgs;
    private static final String sortOrder = "sort_key_alt";
    public static final Companion Companion;
    private final Context context;
    private final SessionPrefImpl session;

    @Inject
    public ContactsProvider(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.context = context;
        this.session = sessionPrefImpl;
    }

    static {
        Companion = new Companion(null);
        projection = new String[]{"mimetype", "contact_id", "display_name", "photo_uri", "starred", "account_type", "data1", "data2", "contact_last_updated_timestamp"};
        selectionArgs = new String[]{"vnd.android.cursor.item/email_v2", "vnd.android.cursor.item/phone_v2"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NotNull
    public final List<PhoneContact> fetchContacts() {
        SparseArray sparseArray;
        ArrayList<PhoneContact> arrayList;
        ArrayList<PhoneContact> arrayList2 = arrayList;
        arrayList = new ArrayList<PhoneContact>();
        Uri uri = ContactsContract.Data.CONTENT_URI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"ContactsContract.Data.CONTENT_URI");
        uri = this.context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (uri == null) {
            return CollectionsKt.emptyList();
        }
        ContactsProvider contactsProvider = this;
        Uri uri2 = uri;
        int n = uri2.getColumnIndex("mimetype");
        int n2 = uri2.getColumnIndex("contact_id");
        int n3 = uri2.getColumnIndex("display_name");
        int n4 = uri2.getColumnIndex("data1");
        int n5 = uri2.getColumnIndex("photo_uri");
        int n6 = uri2.getColumnIndex("data2");
        int n7 = uri2.getColumnIndex("account_type");
        int n8 = uri2.getColumnIndex("contact_last_updated_timestamp");
        SparseArray sparseArray2 = sparseArray;
        sparseArray = new SparseArray();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Object object = contactsProvider.session.getUser();
        if (contactsProvider.session.isLoggedIn() && object != null && StringsKt.isBlank((CharSequence)((User)object).getPhoneNumber()) ^ true) {
            PhoneNumberUtil phoneNumberUtil2 = phoneNumberUtil;
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil2.parse("+" + ((User)object).getPhoneNumber(), "");
            if (!phoneNumberUtil2.isValidNumber(phoneNumber)) throw new IllegalArgumentException("Country region could not be resolved for " + ((User)object).getPhoneNumber());
            Phonenumber.PhoneNumber phoneNumber2 = phoneNumber;
            Intrinsics.checkExpressionValueIsNotNull((Object)phoneNumber2, (String)"phone");
            object = phoneNumberUtil.getRegionCodeForCountryCode(phoneNumber2.getCountryCode());
        } else {
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            object = locale.getCountry();
        }
        while (uri.moveToNext()) {
            PhoneContact phoneContact;
            String string;
            block12: {
                Phonenumber.PhoneNumber phoneNumber;
                int n9 = uri.getInt(n2);
                String string2 = uri.getString(n5);
                String string3 = uri.getString(n3);
                String string4 = uri.getString(n7);
                uri.getInt(n6);
                string = uri.getString(n4);
                long l = uri.getLong(n8);
                phoneContact = (PhoneContact)sparseArray2.get(n9);
                if (phoneContact == null) {
                    PhoneContact phoneContact2;
                    PhoneContact phoneContact3 = phoneContact = phoneContact2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"contactName");
                    phoneContact3(n9, string3, string2, string4, l, null, null, null, 224, null);
                    sparseArray2.put(n9, (Object)phoneContact3);
                    arrayList2.add(phoneContact2);
                } else if (l > phoneContact.getLocallyUpdatedAt()) {
                    phoneContact.setLocallyUpdatedAt(l);
                }
                String string5 = uri.getString(n);
                if (Intrinsics.areEqual((Object)string5, (Object)"vnd.android.cursor.item/email_v2")) {
                    List<String> list = phoneContact.getEmails();
                    String string6 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"contactData");
                    list.add(string6);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string5, (Object)"vnd.android.cursor.item/phone_v2")) continue;
                try {
                    PhoneNumberUtil phoneNumberUtil3 = phoneNumberUtil;
                    phoneNumber = phoneNumberUtil3.parse(string, (String)object);
                    if (!phoneNumberUtil3.isValidNumber(phoneNumber)) break block12;
                }
                catch (NumberParseException numberParseException) {
                    StringBuilder stringBuilder = new StringBuilder().append((String)object);
                    String string7 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"contactData");
                    String string8 = stringBuilder.append(StringsKt.removePrefix((String)string7, (CharSequence)"0")).toString();
                    if (phoneContact.getPhoneNumbers().contains(string8)) continue;
                    phoneContact.getPhoneNumbers().add(string8);
                    continue;
                }
                String string9 = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
                if (phoneContact.getPhoneNumbers().contains(string9)) continue;
                List<String> list = phoneContact.getPhoneNumbers();
                String string10 = string9;
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"phoneE164");
                list.add(string10);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append((String)object);
            String string11 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"contactData");
            String string12 = stringBuilder.append(StringsKt.removePrefix((String)string11, (CharSequence)"0")).toString();
            if (phoneContact.getPhoneNumbers().contains(string12)) continue;
            phoneContact.getPhoneNumbers().add(string12);
        }
        uri.close();
        try {
            CollectionsKt.sortWith(arrayList2, (Comparator)fetchContacts.1.INSTANCE);
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/streamlayer/common/data/contentprovider/ContactsProvider$Companion;", "", "()V", "projection", "", "", "[Ljava/lang/String;", "selection", "selectionArgs", "sortOrder", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

