/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.retrofit;

import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.streamlayer.demo.weather.model.ForecastResponse;
import io.streamlayer.demo.weather.model.WeatherResponse;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.POST;
import retrofit2.http.Query;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001:\u0002\u000e\u000fJ\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\u0005H'J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\b\b\u0001\u0010\t\u001a\u00020\u0005H'J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\r\u001a\u00020\u0005H'\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/common/data/retrofit/ApiInterface;", "", "deleteFirebaseId", "Lio/reactivex/Single;", "registrationId", "", "getForecastForCity", "Lio/reactivex/Observable;", "Lio/streamlayer/demo/weather/model/ForecastResponse;", "city", "getWeatherForCity", "Lio/streamlayer/demo/weather/model/WeatherResponse;", "saveFirebaseId", "platform", "GeneralError", "ValidationErrors", "sdk_release"})
public interface ApiInterface {
    @GET(value="weather")
    @NotNull
    public Observable<WeatherResponse> getWeatherForCity(@Query(value="q") @NotNull String var1);

    @GET(value="forecast")
    @NotNull
    public Observable<ForecastResponse> getForecastForCity(@Query(value="q") @NotNull String var1);

    @POST(value="firebases")
    @FormUrlEncoded
    @NotNull
    public Single<Object> saveFirebaseId(@Field(value="registration_id") @NotNull String var1, @Field(value="platform") @NotNull String var2);

    @FormUrlEncoded
    @HTTP(method="DELETE", path="https://api.openweathermap.org/data/2.5/firebases/reg-delete", hasBody=true)
    @NotNull
    public Single<Object> deleteFirebaseId(@Field(value="registration_id") @NotNull String var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/streamlayer/common/data/retrofit/ApiInterface$GeneralError;", "", "()V", "errors", "", "", "getErrors", "()Ljava/util/List;", "setErrors", "(Ljava/util/List;)V", "message", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "sdk_release"})
    public static final class GeneralError {
        @Expose
        @SerializedName(value="error", alternate={"message"})
        @NotNull
        private String message = "";
        @Expose
        @SerializedName(value="errors")
        @NotNull
        private List<String> errors = CollectionsKt.emptyList();

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(@NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"<set-?>");
            this.message = string3;
        }

        @NotNull
        public final List<String> getErrors() {
            return this.errors;
        }

        public final void setErrors(@NotNull List<String> list) {
            List<String> list2 = list;
            Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
            this.errors = list2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00000\u0004R(\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00000\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/streamlayer/common/data/retrofit/ApiInterface$ValidationErrors;", "", "()V", "errors", "", "Lio/streamlayer/common/data/retrofit/ApiInterface$ValidationErrors$ValidationError;", "getErrors$sdk_release", "()Ljava/util/List;", "setErrors$sdk_release", "(Ljava/util/List;)V", "getErrors", "", "getFieldError", "fieldName", "listDelimiter", "", "getFieldErrors", "hasErrors", "", "setErrors", "", "ValidationError", "sdk_release"})
    public static final class ValidationErrors {
        @Expose
        @SerializedName(value="errors")
        @NotNull
        private List<ValidationError> errors = new ArrayList<ValidationError>();

        @NotNull
        public final List<ValidationError> getErrors$sdk_release() {
            return this.errors;
        }

        public final void setErrors$sdk_release(@NotNull List<ValidationError> list) {
            List<ValidationError> list2 = list;
            Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
            this.errors = list2;
        }

        @NotNull
        public final List<String> getFieldErrors(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"fieldName");
            List list = ((ValidationErrors)((Object)list)).errors.iterator();
            while (list.hasNext()) {
                ValidationError validationError = (ValidationError)list.next();
                if (!Intrinsics.areEqual((Object)validationError.getField$sdk_release(), (Object)string2)) continue;
                list = validationError.getMessages$sdk_release();
                list = list != null ? CollectionsKt.toList(list) : null;
                if (list == null || !(list.isEmpty() ^ true)) {
                    list = CollectionsKt.listOf((Object)validationError.getMessage$sdk_release());
                }
                return list;
            }
            return CollectionsKt.emptyList();
        }

        public final boolean hasErrors() {
            return this.errors.isEmpty() ^ true;
        }

        @NotNull
        public final String getFieldError(@NotNull String string2, @NotNull CharSequence charSequence) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"fieldName");
            Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"listDelimiter");
            List list = ((ValidationErrors)((Object)list)).errors.iterator();
            while (list.hasNext()) {
                ValidationError validationError = (ValidationError)list.next();
                if (!Intrinsics.areEqual((Object)validationError.getField$sdk_release(), (Object)string2)) continue;
                list = validationError.getMessages$sdk_release();
                if (list != null && list.isEmpty() ^ true) {
                    list = validationError.getMessages$sdk_release();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    list = TextUtils.join((CharSequence)charSequence, (Iterable)list);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"TextUtils.join(listDelim\u2026s ?: emptyList<String>())");
                } else {
                    list = validationError.getMessage$sdk_release();
                }
                return list;
            }
            return "";
        }

        @NotNull
        public final String getErrors() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            ValidationErrors validationErrors = stringBuilder2;
            stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (ValidationError validationError : validationErrors.errors) {
                List<String> list = validationError.getMessages$sdk_release();
                if (list != null && list.isEmpty() ^ true) {
                    String string2 = ", ";
                    list = validationError.getMessages$sdk_release();
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    stringBuilder2.append(TextUtils.join((CharSequence)string2, (Iterable)list)).append("\n");
                    continue;
                }
                stringBuilder2.append(validationError.getMessage$sdk_release()).append("\n");
            }
            String string3 = stringBuilder2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"stringBuilder.toString()");
            return string3;
        }

        public final void setErrors(@NotNull List<ValidationError> list) {
            List<ValidationError> list2 = list;
            Intrinsics.checkParameterIsNotNull(list2, (String)"errors");
            this.errors = list2;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/common/data/retrofit/ApiInterface$ValidationErrors$ValidationError;", "", "(Lio/streamlayer/common/data/retrofit/ApiInterface$ValidationErrors;)V", "field", "", "getField$sdk_release", "()Ljava/lang/String;", "setField$sdk_release", "(Ljava/lang/String;)V", "message", "getMessage$sdk_release", "setMessage$sdk_release", "messages", "", "getMessages$sdk_release", "()Ljava/util/List;", "setMessages$sdk_release", "(Ljava/util/List;)V", "sdk_release"})
        public final class ValidationError {
            @SerializedName(value="field")
            @NotNull
            private String field = "";
            @SerializedName(value="messages")
            @Nullable
            private List<String> messages = CollectionsKt.emptyList();
            @SerializedName(value="message")
            @NotNull
            private String message = "";

            @NotNull
            public final String getField$sdk_release() {
                return this.field;
            }

            public final void setField$sdk_release(@NotNull String string2) {
                String string3 = string2;
                Intrinsics.checkParameterIsNotNull((Object)string3, (String)"<set-?>");
                this.field = string3;
            }

            @Nullable
            public final List<String> getMessages$sdk_release() {
                return this.messages;
            }

            public final void setMessages$sdk_release(@Nullable List<String> list) {
                this.messages = list;
            }

            @NotNull
            public final String getMessage$sdk_release() {
                return this.message;
            }

            public final void setMessage$sdk_release(@NotNull String string2) {
                String string3 = string2;
                Intrinsics.checkParameterIsNotNull((Object)string3, (String)"<set-?>");
                this.message = string3;
            }
        }
    }
}

