/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.InAppNotificationsService$WhenMappings;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0010J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;)V", "generalSound", "", "lastTimestampSoundPlayed", "", "messageSound", "pausedTopicsNotifications", "", "", "settings", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "soundPool", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "tinodeUserId", "checkSoundEnabled", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "disconnect", "", "notifyCall", "voiceChat", "Lio/streamlayer/sdk/model/messaging/Chat;", "notifyChatMessage", "chatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "pauseNotifications", "pause", "chatId", "playSound", "showInAppNotification", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "showNotification", "sdk_release"})
public final class InAppNotificationsService {
    private final String tinodeUserId;
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;
    private final Context context;
    private final SessionPrefImpl session;
    private final NotificationRepo notificationsRepo;

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        if (NotificationUtil.INSTANCE.isNotificationEnabled$sdk_release(this.session, notification) && NotificationUtil.INSTANCE.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification notification) {
        if (ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)notification.getType()))) {
            this.notificationsRepo.upsertNotificationBySourceId(notification);
        } else {
            this.notificationsRepo.saveNotification(notification);
        }
        this.playSound(notification.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSoundEnabled(NotificationType notificationType) {
        int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return true;
                }
                if ((this = super.getSettings()) == null) return false;
                if (!((ClientSettings)this).getFriendsSound()) return false;
                return true;
            }
            if ((this = ((InAppNotificationsService)this).getSettings()) == null) return false;
            if (!((ClientSettings)this).getCallsSound()) return false;
            return true;
        }
        if ((this = ((InAppNotificationsService)this).getSettings()) == null) return false;
        if (!((ClientSettings)this).getMessagesSound()) return false;
        return true;
    }

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo) {
        InAppNotificationsService inAppNotificationsService = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        this.context = context;
        this.session = sessionPrefImpl;
        inAppNotificationsService.notificationsRepo = notificationRepo;
        inAppNotificationsService.tinodeUserId = inAppNotificationsService.session.getTinodeUserId();
        inAppNotificationsService.pausedTopicsNotifications = new ArrayList<String>();
        inAppNotificationsService.soundPool = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        inAppNotificationsService.generalSound = inAppNotificationsService.soundPool.load(this.context, R.raw.general_notification, 1);
        inAppNotificationsService.messageSound = inAppNotificationsService.soundPool.load(this.context, R.raw.message_notification, 1);
    }

    public final void notifyChatMessage(@NotNull ChatMessage object) {
        ChatMessage chatMessage = object;
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"chatMessage");
        if (!Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.tinodeUserId) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage2 = object;
            object = chatMessage2.getTopicId();
            Notification notification = NotificationUtilKt.toNotification(chatMessage2);
            if (!this.pausedTopicsNotifications.contains(object)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyCall(@NotNull Chat chat) {
        Notification notification;
        Object object;
        Date date;
        ArrayList<String> arrayList;
        Chat chat2 = chat;
        Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"voiceChat");
        String string2 = chat2.getChatId();
        Object object2 = MessagingExtensionsKt.participantsWithoutUser(chat, this.session.getTinodeUserId());
        chat.getLastMessage();
        Long l = null;
        Object object3 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            object3.add(((TinodeContact)object4.next()).getChatName());
        }
        object3 = CollectionsKt.joinToString$default(object3, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        object4 = this.context.getString(R.string.sl_incoming_voice_chat);
        String string3 = (object2.size() > 1 ? NotificationType.GroupCall : NotificationType.Call).name();
        Date date2 = date;
        date = new Date();
        String string4 = "topic_" + chat.getChatId();
        if (object2.size() == 1) {
            List<TinodeContact> list = object2;
            object2 = NotificationIcon.Companion;
            object = ((TinodeContact)CollectionsKt.first(list)).getPhotoData();
            String string5 = ((TinodeContact)CollectionsKt.first(list)).getChatName();
            if (string5 == null) {
                string5 = "";
            }
            object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object, string5);
        } else {
            object2 = null;
        }
        object = notification;
        notification = new Notification(l, (String)object3, (String)object4, string3, date2, string4, chat, (NotificationIcon)object2);
        if (!this.pausedTopicsNotifications.contains(string2)) {
            this.showNotification((Notification)object);
        }
    }

    public final void playSound(@NotNull NotificationType notificationType) {
        long l;
        NotificationType notificationType2 = notificationType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType2), (String)"type");
        if (this.checkSoundEnabled(notificationType2) && (l = System.currentTimeMillis()) > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()] != 1 ? this.generalSound : this.messageSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        InAppNotificationsService inAppNotificationsService;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            inAppNotificationsService = this;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
        {
            Result.constructor-impl((Object)inAppNotificationsService.pausedTopicsNotifications.remove(string2));
        }
    }
}

