/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.statistics.baseball;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.model.sports.EventTeam;
import io.streamlayer.sdk.model.sports.baseball.BaseballSummary;
import io.streamlayer.sdk.model.sports.baseball.Hitting;
import io.streamlayer.sdk.model.sports.baseball.Pitching;
import io.streamlayer.sdk.statistics.baseball.BoxScoreItem;
import io.streamlayer.sdk.statistics.baseball.DividerItem;
import io.streamlayer.sdk.statistics.baseball.PointsItem;
import io.streamlayer.sdk.statistics.baseball.TeamItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001b\u001c\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "data", "", "Lio/streamlayer/sdk/statistics/baseball/BoxScoreItem;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "team", "Lio/streamlayer/sdk/model/sports/EventTeam;", "isHomeTeam", "", "summary", "Lio/streamlayer/sdk/model/sports/baseball/BaseballSummary;", "DividerViewHolder", "PointsViewHolder", "TeamViewHolder", "sdk_originalRelease"})
public final class BaseballBoxScoreAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<? extends BoxScoreItem> data;
    private final Context context;

    public BaseballBoxScoreAdapter(@NotNull Context context) {
        BaseballBoxScoreAdapter baseballBoxScoreAdapter = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        baseballBoxScoreAdapter.context = context;
        baseballBoxScoreAdapter.data = CollectionsKt.emptyList();
    }

    public final void setData(@NotNull EventTeam iterator, boolean bl, @NotNull BaseballSummary baseballSummary) {
        ArrayList<? extends BoxScoreItem> arrayList;
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"team");
        Intrinsics.checkParameterIsNotNull((Object)baseballSummary, (String)"summary");
        ArrayList<? extends BoxScoreItem> arrayList2 = arrayList;
        new ArrayList<BoxScoreItem>().add(new TeamItem(((EventTeam)((Object)iterator)).getLogo(), ((EventTeam)((Object)iterator)).getName()));
        String string2 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026_box_score_hitting_title)");
        String string3 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_hits_per_bat);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.stri\u2026ore_hitting_hits_per_bat)");
        String string4 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_runs);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"context.getString(R.stri\u2026l_box_score_hitting_runs)");
        String string5 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_runs_batted_in);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"context.getString(R.stri\u2026e_hitting_runs_batted_in)");
        String string6 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_walks);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"context.getString(R.stri\u2026_box_score_hitting_walks)");
        String string7 = this.context.getString(R.string.sl_statistics_baseball_box_score_hitting_batting_average);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"context.getString(R.stri\u2026_hitting_batting_average)");
        arrayList2.add(new PointsItem(string2, string3, string4, string5, string6, string7, 0));
        for (Hitting hitting : bl ? baseballSummary.getHomeTeam().getHitting() : baseballSummary.getAwayTeam().getHitting()) {
            arrayList2.add(new PointsItem(hitting.getPlayerName(), hitting.getHitsPerBat(), hitting.getRuns(), hitting.getRunsBattedIn(), hitting.getWalks(), hitting.getBattingAverage(), 2));
        }
        ArrayList<? extends BoxScoreItem> arrayList3 = arrayList2;
        arrayList3.add(new DividerItem(0, 1, null));
        String string8 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"context.getString(R.stri\u2026box_score_pitching_title)");
        String string9 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_innings_pitched);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"context.getString(R.stri\u2026pitching_innings_pitched)");
        String string10 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_hits_by_pitch);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"context.getString(R.stri\u2026e_pitching_hits_by_pitch)");
        String string11 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_earned_runs);
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"context.getString(R.stri\u2026ore_pitching_earned_runs)");
        String string12 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_walks);
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"context.getString(R.stri\u2026box_score_pitching_walks)");
        String string13 = this.context.getString(R.string.sl_statistics_baseball_box_score_pitching_strikeouts);
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"context.getString(R.stri\u2026core_pitching_strikeouts)");
        arrayList3.add(new PointsItem(string8, string9, string10, string11, string12, string13, 0));
        for (Pitching pitching : bl ? baseballSummary.getHomeTeam().getPitching() : baseballSummary.getAwayTeam().getPitching()) {
            arrayList2.add(new PointsItem(pitching.getPlayerName(), pitching.getInningsPitched(), pitching.getHitsByPitch(), pitching.getEarnedRuns(), pitching.getWalks(), pitching.getStrikeouts(), 2));
        }
        this.data = arrayList2;
        this.notifyDataSetChanged();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"parent");
        switch (n) {
            default: {
                throw new RuntimeException("Unsupported viewType: " + n);
            }
            case 3: {
                DividerViewHolder dividerViewHolder;
                viewHolder = dividerViewHolder;
                dividerViewHolder = new DividerViewHolder(ExtensionsKt.inflate(viewGroup, R.layout.sl_item_statistics_baseball_box_score_divider));
                break;
            }
            case 1: {
                TeamViewHolder teamViewHolder;
                viewHolder = teamViewHolder;
                teamViewHolder = new TeamViewHolder(ExtensionsKt.inflate(viewGroup, R.layout.sl_item_statistics_baseball_box_score_team));
                break;
            }
            case 0: 
            case 2: {
                PointsViewHolder pointsViewHolder;
                viewHolder = pointsViewHolder;
                pointsViewHolder = new PointsViewHolder(ExtensionsKt.inflate(viewGroup, R.layout.sl_item_statistics_baseball_box_score_points));
            }
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getItemViewType(int n) {
        return this.data.get(n).getViewType();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"holder");
        Object object = object.data.get(n);
        if (viewHolder instanceof TeamViewHolder && object instanceof TeamItem) {
            ((TeamViewHolder)viewHolder).bind((TeamItem)object);
        } else if (viewHolder instanceof PointsViewHolder && object instanceof PointsItem) {
            ((PointsViewHolder)viewHolder).bind((PointsItem)object);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$TeamViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "bind", "", "item", "Lio/streamlayer/sdk/statistics/baseball/TeamItem;", "sdk_originalRelease"})
    public final class TeamViewHolder
    extends RecyclerView.ViewHolder {
        public TeamViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        public final void bind(@NotNull TeamItem teamItem) {
            Intrinsics.checkParameterIsNotNull((Object)teamItem, (String)"item");
            View view = this.itemView;
            ImageView imageView = (ImageView)view.findViewById(R.id.slBaseballBoxScoreTeamLogo);
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"slBaseballBoxScoreTeamLogo");
            ExtensionsKt.loadUrl$default(imageView, teamItem.getIcon(), false, null, null, 12, null);
            TextView textView = (TextView)view.findViewById(R.id.slBaseballBoxScoreTeamName);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slBaseballBoxScoreTeamName");
            textView.setText((CharSequence)teamItem.getName());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$PointsViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "bind", "", "item", "Lio/streamlayer/sdk/statistics/baseball/PointsItem;", "sdk_originalRelease"})
    public final class PointsViewHolder
    extends RecyclerView.ViewHolder {
        public PointsViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }

        public final void bind(@NotNull PointsItem pointsItem) {
            PointsItem pointsItem2 = pointsItem;
            Intrinsics.checkParameterIsNotNull((Object)pointsItem, (String)"item");
            PointsViewHolder pointsViewHolder = pointsViewHolder.itemView;
            TextView textView = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn1);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"slBaseballBoxScoreSectionColumn1");
            textView.setText((CharSequence)pointsItem.getHitting());
            TextView textView2 = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn2);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"slBaseballBoxScoreSectionColumn2");
            textView2.setText((CharSequence)pointsItem.getHitsPerBat());
            TextView textView3 = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn3);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"slBaseballBoxScoreSectionColumn3");
            textView3.setText((CharSequence)pointsItem.getRuns());
            TextView textView4 = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn4);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"slBaseballBoxScoreSectionColumn4");
            textView4.setText((CharSequence)pointsItem.getRunsBattedIn());
            TextView textView5 = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn5);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView5, (String)"slBaseballBoxScoreSectionColumn5");
            textView5.setText((CharSequence)pointsItem.getWalks());
            TextView textView6 = (TextView)pointsViewHolder.findViewById(R.id.slBaseballBoxScoreSectionColumn6);
            Intrinsics.checkExpressionValueIsNotNull((Object)textView6, (String)"slBaseballBoxScoreSectionColumn6");
            textView6.setText((CharSequence)pointsItem.getBattingAverage());
            pointsItem = pointsViewHolder.getContext();
            int n = pointsItem2.getViewType() == 0 ? R.color.white : R.color.sl_gray900;
            PointsViewHolder pointsViewHolder2 = pointsViewHolder;
            int n2 = ContextCompat.getColor((Context)pointsItem, (int)n);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn1)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn2)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn3)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn4)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn5)).setTextColor(n2);
            ((TextView)pointsViewHolder2.findViewById(R.id.slBaseballBoxScoreSectionColumn6)).setTextColor(n2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter$DividerViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/statistics/baseball/BaseballBoxScoreAdapter;Landroid/view/View;)V", "sdk_originalRelease"})
    public final class DividerViewHolder
    extends RecyclerView.ViewHolder {
        public DividerViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(view);
        }
    }
}

