/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.voice;

import com.google.gson.JsonObject;
import com.streamlayer.voice.IceRequest;
import com.streamlayer.voice.RxVoiceGrpc;
import io.grpc.Channel;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.retrofit.ApiInterface;
import io.streamlayer.common.mvvm.BaseRepo;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.calls.CallIdiom;
import io.streamlayer.sdk.model.calls.IceConfig;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.repository.voice.VoiceRepo;
import io.streamlayer.sdk.repository.voice.VoiceRepoImpl;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.IceCandidate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00100\u000fH\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00110\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0016J8\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00100\u000f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016J,\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00100\u000f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/streamlayer/sdk/repository/voice/VoiceRepoImpl;", "Lio/streamlayer/common/mvvm/BaseRepo;", "Lio/streamlayer/sdk/repository/voice/VoiceRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "api", "Lio/streamlayer/common/data/retrofit/ApiInterface;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/retrofit/ApiInterface;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;Lio/streamlayer/common/data/grpc/GrpcService;)V", "getIceServers", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "Lio/streamlayer/sdk/model/calls/IceConfig;", "getOldVoiceMessages", "Lio/reactivex/Single;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "topicId", "", "observeVoiceMessages", "userId", "sendCallIdiom", "", "chatId", "idiom", "Lio/streamlayer/sdk/model/calls/CallIdiom;", "payload", "reply", "sendIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "replyTo", "sdk_originalRelease"})
public final class VoiceRepoImpl
extends BaseRepo
implements VoiceRepo {
    private final MessagingRepo messagingRepo;
    private final GrpcService grpcService;

    @Inject
    public VoiceRepoImpl(@NotNull AppDatabase appDatabase, @NotNull ApiInterface apiInterface, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull MessagingRepo messagingRepo, @NotNull GrpcService grpcService2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)apiInterface, (String)"api");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)messagingRepo, (String)"messagingRepo");
        Intrinsics.checkParameterIsNotNull((Object)grpcService2, (String)"grpcService");
        super(appDatabase, apiInterface, sessionPrefImpl);
        this.messagingRepo = messagingRepo;
        this.grpcService = grpcService2;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendCallIdiom(@NotNull String string2, @NotNull CallIdiom callIdiom, @Nullable String string3, @Nullable String string4) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)callIdiom), (String)"idiom");
        Object object = string3 != null ? string3 : "";
        Object object2 = Charsets.UTF_8;
        if (object != null) {
            String string5;
            VoiceRepoImpl voiceRepoImpl = object3;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Object object3 = byArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = Charsets.UTF_8;
            object2 = string5;
            string5 = new String((byte[])object3, (Charset)object);
            String cfr_ignored_0 = "\u2b06\ufe0f [idiom=" + callIdiom.getKey() + "; payload=" + string3 + "; reply=" + string4 + ']';
            return voiceRepoImpl.messagingRepo.sendMessage(string2, (String)object2, "voice", callIdiom.getKey(), string4);
        }
        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendIceCandidate(@NotNull String string2, @NotNull IceCandidate iceCandidate2, @NotNull String string3) {
        JsonObject jsonObject;
        VoiceRepoImpl voiceRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)iceCandidate2, (String)"candidate");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"replyTo");
        VoiceRepoImpl voiceRepoImpl2 = this = jsonObject;
        this();
        voiceRepoImpl2.addProperty("ident", iceCandidate2.sdpMid);
        voiceRepoImpl2.addProperty("userId", string3);
        this.addProperty("desc", iceCandidate2.sdp);
        jsonObject.addProperty("index", (Number)iceCandidate2.sdpMLineIndex);
        return voiceRepoImpl.sendCallIdiom(string2, CallIdiom.ICE, this.toString(), string3);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<IceConfig>>> getIceServers() {
        VoiceRepoImpl voiceRepoImpl = voiceRepoImpl2;
        VoiceRepoImpl voiceRepoImpl2 = RxVoiceGrpc.newRxStub((Channel)voiceRepoImpl.grpcService.getManagedChannel());
        IceRequest iceRequest = IceRequest.newBuilder().build();
        return BaseRepo.oneSideCall$default(voiceRepoImpl, (Function0)new Function0<Observable<List<? extends IceConfig>>>((RxVoiceGrpc.RxVoiceStub)voiceRepoImpl2, iceRequest){
            final /* synthetic */ RxVoiceGrpc.RxVoiceStub $stub;
            final /* synthetic */ IceRequest $request;
            {
                this.$stub = rxVoiceStub;
                this.$request = iceRequest;
                super(0);
            }

            public final Observable<List<IceConfig>> invoke() {
                return this.$stub.ice(this.$request).map((Function)getIceServers.1.INSTANCE).toObservable();
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ChatMessage> observeVoiceMessages(@NotNull String string2, @Nullable String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Observable observable = this.messagingRepo.subscribeToChat(string2, null).filter(new Predicate<ChatMessage>(string3){
            final /* synthetic */ String $userId;
            {
                this.$userId = string2;
            }

            public final boolean test(@NotNull ChatMessage chatMessage) {
                ChatMessage chatMessage2 = chatMessage;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"it");
                return Intrinsics.areEqual((Object)chatMessage2.getType(), (Object)"voice") && Intrinsics.areEqual((Object)this.$userId, (Object)chatMessage.getSenderUserId()) ^ true;
            }
        }).distinctUntilChanged((BiPredicate)observeVoiceMessages.2.INSTANCE).doOnNext((Consumer)observeVoiceMessages.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"messagingRepo.subscribeT\u2026          )\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Single<List<ChatMessage>> getOldVoiceMessages(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Single single = this.messagingRepo.getMessages(string2, null, 100).filter((Predicate)getOldVoiceMessages.1.INSTANCE).map((Function)getOldVoiceMessages.2.INSTANCE).single((Object)CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"messagingRepo.getMessage\u2026     .single(emptyList())");
        return single;
    }
}

