/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.RequiresApi;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper$WhenMappings;
import io.streamlayer.sdk.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper;", "", "()V", "CHANNELS_VERSION", "", "PREFS_NAME", "VERSION", "", "getChannelDescription", "context", "Landroid/content/Context;", "channel", "Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "getChannelName", "initChannels", "", "setupChannels", "Channel", "sdk_originalRelease"})
public final class NotificationChannelsHelper {
    private static final String PREFS_NAME = "SL_NOTIF_CHANNELS";
    private static final String CHANNELS_VERSION = "channels_version";
    private static final int VERSION = 1;
    public static final NotificationChannelsHelper INSTANCE = new NotificationChannelsHelper();

    @RequiresApi(api=26)
    private final void setupChannels(Context context) {
        Object object = context.getSystemService("notification");
        if (object != null) {
            object = (NotificationManager)object;
            for (Channel channel : Channel.values()) {
                NotificationChannel notificationChannel;
                NotificationChannel notificationChannel2 = notificationChannel;
                notificationChannel2(channel.name(), (CharSequence)this.getChannelName(context, channel), 4);
                notificationChannel.setDescription(this.getChannelDescription(context, channel));
                object.createNotificationChannel(notificationChannel);
            }
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
    }

    private final String getChannelName(Context context, Channel channel) {
        if (NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$0[channel.ordinal()] == 1) {
            String string2 = context.getString(R.string.slr_streamlayer);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.slr_streamlayer)");
            return string2;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String getChannelDescription(Context context, Channel channel) {
        if (NotificationChannelsHelper$WhenMappings.$EnumSwitchMapping$1[channel.ordinal()] == 1) {
            String string2 = context.getString(R.string.slr_notif_channels_info);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026.slr_notif_channels_info)");
            return string2;
        }
        throw new NoWhenBranchMatchedException();
    }

    private NotificationChannelsHelper() {
    }

    public final void initChannels(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        SharedPreferences sharedPreferences = context2.getSharedPreferences(PREFS_NAME, 0);
        if (Build.VERSION.SDK_INT >= 26 && 1 > sharedPreferences.getInt(CHANNELS_VERSION, 0)) {
            sharedPreferences.edit().putInt(CHANNELS_VERSION, 1).apply();
            this.setupChannels(context);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lio/streamlayer/common/data/notifications/NotificationChannelsHelper$Channel;", "", "(Ljava/lang/String;I)V", "streamlayer", "sdk_originalRelease"})
    public static final class Channel
    extends Enum<Channel> {
        public static final /* enum */ Channel streamlayer;
        private static final /* synthetic */ Channel[] $VALUES;

        static {
            Channel channel;
            Channel[] channelArray = new Channel[1];
            Channel channel2 = channel;
            streamlayer = new Channel();
            channelArray[0] = channel2;
            $VALUES = channelArray;
        }

        public static Channel[] values() {
            return (Channel[])$VALUES.clone();
        }

        public static Channel valueOf(String string2) {
            return Enum.valueOf(Channel.class, string2);
        }
    }
}

