/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.twitter;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import io.reactivex.Observable;
import io.streamlayer.common.data.database.Converters;
import io.streamlayer.sdk.model.social.Tweet;
import io.streamlayer.sdk.model.social.TweetEntities;
import io.streamlayer.sdk.model.social.TweetExtendedEntities;
import io.streamlayer.sdk.model.social.TweetMetaData;
import io.streamlayer.sdk.repository.twitter.TwitterDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public final class TwitterDao_Impl
implements TwitterDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Tweet> __insertionAdapterOfTweet;
    private final Converters __converters;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllTweets;

    public TwitterDao_Impl(RoomDatabase roomDatabase) {
        TwitterDao_Impl twitterDao_Impl = this;
        this.__converters = new Converters();
        twitterDao_Impl.__db = roomDatabase;
        twitterDao_Impl.__insertionAdapterOfTweet = new EntityInsertionAdapter<Tweet>(roomDatabase){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Tweet` (`id`,`date`,`text`,`account`,`accountId`,`accountImage`,`entities`,`extendedEntities`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement supportSQLiteStatement, Tweet object) {
                if (((Tweet)object).getId() == null) {
                    supportSQLiteStatement.bindNull(1);
                } else {
                    supportSQLiteStatement.bindString(1, ((Tweet)object).getId());
                }
                Object object2 = object3.TwitterDao_Impl.this.__converters.dateToString(((Tweet)object).getDate());
                if (object2 == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    long l = (Long)object2;
                    supportSQLiteStatement.bindLong(2, l);
                }
                if (((Tweet)object).getText() == null) {
                    supportSQLiteStatement.bindNull(3);
                } else {
                    supportSQLiteStatement.bindString(3, ((Tweet)object).getText());
                }
                object = ((Tweet)object).getMetaData();
                if (object != null) {
                    if (((TweetMetaData)object).getAccount() == null) {
                        supportSQLiteStatement.bindNull(4);
                    } else {
                        supportSQLiteStatement.bindString(4, ((TweetMetaData)object).getAccount());
                    }
                    if (((TweetMetaData)object).getAccountId() == null) {
                        supportSQLiteStatement.bindNull(5);
                    } else {
                        supportSQLiteStatement.bindString(5, ((TweetMetaData)object).getAccountId());
                    }
                    if (((TweetMetaData)object).getAccountImage() == null) {
                        supportSQLiteStatement.bindNull(6);
                    } else {
                        supportSQLiteStatement.bindString(6, ((TweetMetaData)object).getAccountImage());
                    }
                    object2 = object3.TwitterDao_Impl.this.__converters.tweetEntitiesToJson(((TweetMetaData)object).getEntities());
                    if (object2 == null) {
                        supportSQLiteStatement.bindNull(7);
                    } else {
                        supportSQLiteStatement.bindString(7, (String)object2);
                    }
                    Object object3 = object3.TwitterDao_Impl.this.__converters.tweetExtendedEntitiesToJson(((TweetMetaData)object).getExtendedEntities());
                    if (object3 == null) {
                        supportSQLiteStatement.bindNull(8);
                    } else {
                        supportSQLiteStatement.bindString(8, (String)object3);
                    }
                } else {
                    SupportSQLiteStatement supportSQLiteStatement2 = supportSQLiteStatement;
                    supportSQLiteStatement2.bindNull(4);
                    supportSQLiteStatement2.bindNull(5);
                    supportSQLiteStatement2.bindNull(6);
                    supportSQLiteStatement2.bindNull(7);
                    supportSQLiteStatement2.bindNull(8);
                }
            }
        };
        twitterDao_Impl.__preparedStmtOfDeleteAllTweets = new SharedSQLiteStatement(roomDatabase){

            public String createQuery() {
                return "DELETE FROM Tweet";
            }
        };
    }

    static /* synthetic */ RoomDatabase access$100(TwitterDao_Impl twitterDao_Impl) {
        return twitterDao_Impl.__db;
    }

    @Override
    public void saveTweets(List<Tweet> list) {
        TwitterDao_Impl twitterDao_Impl = this;
        twitterDao_Impl.__db.assertNotSuspendingTransaction();
        twitterDao_Impl.__db.beginTransaction();
        try {
            twitterDao_Impl.__insertionAdapterOfTweet.insert(list);
            twitterDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        twitterDao_Impl.__db.endTransaction();
    }

    @Override
    public void saveTweet(Tweet tweet) {
        TwitterDao_Impl twitterDao_Impl = this;
        twitterDao_Impl.__db.assertNotSuspendingTransaction();
        twitterDao_Impl.__db.beginTransaction();
        try {
            twitterDao_Impl.__insertionAdapterOfTweet.insert((Object)tweet);
            twitterDao_Impl.__db.setTransactionSuccessful();
        }
        catch (Throwable throwable) {
            this.__db.endTransaction();
            throw throwable;
        }
        twitterDao_Impl.__db.endTransaction();
    }

    @Override
    public void deleteAllTweets() {
        TwitterDao_Impl twitterDao_Impl = this;
        twitterDao_Impl.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement supportSQLiteStatement = twitterDao_Impl.__preparedStmtOfDeleteAllTweets.acquire();
        this.__db.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            TwitterDao_Impl twitterDao_Impl2 = this;
            twitterDao_Impl2.__db.endTransaction();
            twitterDao_Impl2.__preparedStmtOfDeleteAllTweets.release(supportSQLiteStatement);
            throw throwable;
        }
        twitterDao_Impl.__db.setTransactionSuccessful();
        twitterDao_Impl.__db.endTransaction();
        twitterDao_Impl.__preparedStmtOfDeleteAllTweets.release(supportSQLiteStatement);
    }

    @Override
    public Observable<List<Tweet>> getTweets(List<String> list, int n, int n2) {
        Callable<List<Tweet>> callable;
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("SELECT ");
        stringBuilder.append("*");
        stringBuilder.append(" FROM Tweet WHERE lower(Tweet.account) in (");
        int n3 = list.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n3);
        stringBuilder.append(") ORDER BY Tweet.date DESC LIMIT ");
        stringBuilder.append("?");
        stringBuilder.append(" OFFSET ");
        stringBuilder.append("?");
        stringBuilder.append(" * ");
        stringBuilder.append("?");
        int n4 = n3 + 3;
        final RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)stringBuilder.toString(), (int)n4);
        int n5 = 1;
        for (String string2 : list) {
            if (string2 == null) {
                roomSQLiteQuery.bindNull(n5);
            } else {
                roomSQLiteQuery.bindString(n5, string2);
            }
            ++n5;
        }
        int n6 = n2;
        n2 = n3 + 1;
        long l = n6;
        roomSQLiteQuery.bindLong(n2, l);
        roomSQLiteQuery.bindLong(n3 + 2, (long)n);
        roomSQLiteQuery.bindLong(n4, l);
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Tweet";
        Callable<List<Tweet>> callable2 = callable;
        callable = new Callable<List<Tweet>>(){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public List<Tweet> call() throws Exception {
                var1_1 = DBUtil.query((RoomDatabase)TwitterDao_Impl.access$100(TwitterDao_Impl.this), (SupportSQLiteQuery)roomSQLiteQuery, (boolean)false, null);
                var2_2 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"id");
                var3_3 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"date");
                var4_4 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"text");
                var5_5 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"account");
                var6_6 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"accountId");
                var7_7 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"accountImage");
                var8_8 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"entities");
                var9_9 = CursorUtil.getColumnIndexOrThrow((Cursor)var1_1, (String)"extendedEntities");
                var10_10 = v0;
                try {
                    v0 = new ArrayList<Tweet>(var1_1.getCount());
                    ** while (var1_1.moveToNext())
                }
                catch (Throwable v1) {
                    var1_1.close();
                    throw v1;
                }
lbl-1000:
                // 1 sources

                {
                    block33: {
                        block32: {
                            block31: {
                                v2 = var1_1;
                                v3 = var3_3;
                                var11_11 = var1_1.getString(var2_2);
                                if (!v2.isNull(v3)) break block31;
                                var12_12 /* !! */  = null;
                                break block32;
                            }
                            var12_12 /* !! */  = var1_1.getLong(var3_3);
                        }
                        v4 = var1_1;
                        v5 = var5_5;
                        v6 = var1_1;
                        v7 = var4_4;
                        var12_12 /* !! */  = TwitterDao_Impl.access$000(TwitterDao_Impl.this).timestampToDate(var12_12 /* !! */ );
                        var13_13 = v6.getString(v7);
                        if (!v4.isNull(v5)) break block33;
                        if (!var1_1.isNull(var6_6)) break block33;
                        if (!var1_1.isNull(var7_7)) break block33;
                        if (!var1_1.isNull(var8_8)) break block33;
                        if (!var1_1.isNull(var9_9)) break block33;
                        var14_14 = null;
                        var19_19 = var14_14;
                        ** GOTO lbl86
                    }
                    v8 = this;
                    v9 = var1_1;
                    v10 = var9_9;
                    v11 = this;
                    v12 = var1_1;
                    v13 = var8_8;
                    v14 = var1_1;
                    v15 = var7_7;
                    v16 = var1_1;
                    v17 = var6_6;
                    var14_14 = var1_1.getString(var5_5);
                    var15_15 = v16.getString(v17);
                    var16_16 = v14.getString(v15);
                    var17_17 = v12.getString(v13);
                    var17_17 = TwitterDao_Impl.access$000(v11.TwitterDao_Impl.this).jsonToTweetEntities((String)var17_17);
                    var18_18 = v9.getString(v10);
                    var18_18 = TwitterDao_Impl.access$000(v8.TwitterDao_Impl.this).jsonToTweetExtendedEntities((String)var18_18);
                    var19_19 = v18;
                    v18 = new TweetMetaData(var14_14, var15_15, var16_16, (TweetEntities)var17_17, (TweetExtendedEntities)var18_18);
lbl86:
                    // 2 sources

                    var10_10.add(new Tweet(var11_11, (Date)var12_12 /* !! */ , var13_13, (TweetMetaData)var19_19));
                    continue;
                }
lbl89:
                // 1 sources

                var1_1.close();
                return var10_10;
            }

            protected void finalize() {
                roomSQLiteQuery.release();
            }
        };
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])stringArray2, (Callable)callable2);
    }
}

