/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.tooltips;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.format.DateUtils;
import io.streamlayer.common.tooltips.ViewTooltipManager$WhenMappings;
import io.streamlayer.common.tooltips.ViewTooltipType;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/streamlayer/common/tooltips/ViewTooltipManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "value", "", "lastSdkVersionCodeWhosWatchingTooltipShown", "getLastSdkVersionCodeWhosWatchingTooltipShown", "()I", "setLastSdkVersionCodeWhosWatchingTooltipShown", "(I)V", "", "lastTimePoweredByTooltipShown", "getLastTimePoweredByTooltipShown", "()J", "setLastTimePoweredByTooltipShown", "(J)V", "prefs", "Landroid/content/SharedPreferences;", "markAsShown", "", "type", "Lio/streamlayer/common/tooltips/ViewTooltipType;", "needShow", "", "Companion", "sdk_originalRelease"})
public final class ViewTooltipManager {
    private static final String KEY_LAST_TIMESTAMP_POWEREDBY_TOOLTIP_SHOWN = "time_powered_by_shown";
    private static final String KEY_LAST_SDK_VERSION_CODE_WHOS_WATCHING_TOOLTIP_SHOWN = "version_code_whos_watching_shown";
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences prefs;

    private final long getLastTimePoweredByTooltipShown() {
        return this.prefs.getLong(KEY_LAST_TIMESTAMP_POWEREDBY_TOOLTIP_SHOWN, 0L);
    }

    private final void setLastTimePoweredByTooltipShown(long l) {
        this.prefs.edit().putLong(KEY_LAST_TIMESTAMP_POWEREDBY_TOOLTIP_SHOWN, l).apply();
    }

    private final int getLastSdkVersionCodeWhosWatchingTooltipShown() {
        return this.prefs.getInt(KEY_LAST_SDK_VERSION_CODE_WHOS_WATCHING_TOOLTIP_SHOWN, 0);
    }

    private final void setLastSdkVersionCodeWhosWatchingTooltipShown(int n) {
        this.prefs.edit().putInt(KEY_LAST_SDK_VERSION_CODE_WHOS_WATCHING_TOOLTIP_SHOWN, n).apply();
    }

    @Inject
    public ViewTooltipManager(@NotNull Context context) {
        ViewTooltipManager viewTooltipManager = viewTooltipManager2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ViewTooltipManager viewTooltipManager2 = context.getSharedPreferences("io.streamlayer.sdk_tooltips", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewTooltipManager2, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        viewTooltipManager.prefs = viewTooltipManager2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean needShow(@NotNull ViewTooltipType viewTooltipType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"type");
        int n = ViewTooltipManager$WhenMappings.$EnumSwitchMapping$0[viewTooltipType.ordinal()];
        if (n != 1) {
            if (n != 2) throw new NoWhenBranchMatchedException();
            if (this.getLastSdkVersionCodeWhosWatchingTooltipShown() == 2) return false;
            return true;
        } else if (DateUtils.isToday((long)this.getLastTimePoweredByTooltipShown())) return false;
        return true;
    }

    public final void markAsShown(@NotNull ViewTooltipType viewTooltipType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewTooltipType), (String)"type");
        int n = ViewTooltipManager$WhenMappings.$EnumSwitchMapping$1[viewTooltipType.ordinal()];
        if (n != 1) {
            if (n == 2) {
                this.setLastSdkVersionCodeWhosWatchingTooltipShown(2);
            }
        } else {
            this.setLastTimePoweredByTooltipShown(System.currentTimeMillis());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/tooltips/ViewTooltipManager$Companion;", "", "()V", "KEY_LAST_SDK_VERSION_CODE_WHOS_WATCHING_TOOLTIP_SHOWN", "", "KEY_LAST_TIMESTAMP_POWEREDBY_TOOLTIP_SHOWN", "sdk_originalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

