/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.notifications;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;
import io.streamlayer.common.data.notifications.InAppNotificationsService$WhenMappings;
import io.streamlayer.common.data.notifications.NotificationUtil;
import io.streamlayer.common.data.notifications.NotificationUtilKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.MessagingExtensionsKt;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationIcon;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.model.sdksettings.ClientSettings;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.utils.RingtonePlayer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0012J\b\u0010*\u001a\u00020\u001cH\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010,\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002J\b\u00101\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/streamlayer/common/data/notifications/InAppNotificationsService;", "", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "notificationsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "(Landroid/content/Context;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/utils/RingtonePlayer;)V", "generalSound", "", "lastTimestampSoundPlayed", "", "messageSound", "pausedTopicsNotifications", "", "", "settings", "Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "getSettings", "()Lio/streamlayer/sdk/model/sdksettings/ClientSettings;", "soundPool", "Landroid/media/SoundPool;", "kotlin.jvm.PlatformType", "tinodeUserId", "disconnect", "", "isSoundEnabled", "", "type", "Lio/streamlayer/sdk/model/notifications/NotificationType;", "notifyCall", "voiceChat", "Lio/streamlayer/sdk/model/messaging/Chat;", "notifyChatMessage", "chatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "pauseNotifications", "pause", "chatId", "playCallRingtone", "playNotificationSound", "playSound", "showInAppNotification", "notification", "Lio/streamlayer/sdk/model/notifications/Notification;", "showNotification", "stopCallRingtone", "sdk_originalRelease"})
public final class InAppNotificationsService {
    private final String tinodeUserId;
    private final List<String> pausedTopicsNotifications;
    private long lastTimestampSoundPlayed;
    private final SoundPool soundPool;
    private final int generalSound;
    private final int messageSound;
    private final Context context;
    private final SessionPrefImpl session;
    private final NotificationRepo notificationsRepo;
    private final RingtonePlayer ringtonePlayer;

    private final ClientSettings getSettings() {
        return this.session.getClientSettings();
    }

    private final void showNotification(Notification notification) {
        if (NotificationUtil.INSTANCE.isNotificationEnabled$sdk_originalRelease(this.session, notification) && NotificationUtil.INSTANCE.isAppInForeground()) {
            this.showInAppNotification(notification);
        }
    }

    private final void showInAppNotification(Notification notification) {
        if (ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall, NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)notification.getType()))) {
            this.notificationsRepo.upsertNotificationBySourceId(notification);
        } else {
            this.notificationsRepo.saveNotification(notification);
        }
        this.playSound(notification.getType());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isSoundEnabled(NotificationType notificationType) {
        switch (InAppNotificationsService$WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
            case 4: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getFriendsSound()) return false;
                break;
            }
            case 2: 
            case 3: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getCallsSound()) return false;
                break;
            }
            case 1: {
                Object object = ((InAppNotificationsService)object).getSettings();
                if (object == null) return false;
                if (!((ClientSettings)object).getMessagesSound()) return false;
            }
        }
        return true;
    }

    private final void playNotificationSound(NotificationType notificationType) {
        long l = System.currentTimeMillis();
        if (l > this.lastTimestampSoundPlayed + (long)1200) {
            this.lastTimestampSoundPlayed = l;
            int n = InAppNotificationsService$WhenMappings.$EnumSwitchMapping$1[notificationType.ordinal()] != 1 ? this.generalSound : this.messageSound;
            this.soundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    private final void playCallRingtone() {
        this.ringtonePlayer.ring();
    }

    private final void stopCallRingtone() {
        this.ringtonePlayer.dismiss();
    }

    @Inject
    public InAppNotificationsService(@NotNull Context context, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo, @NotNull RingtonePlayer ringtonePlayer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notificationsRepo");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        this.context = context;
        this.session = sessionPrefImpl;
        this.notificationsRepo = notificationRepo;
        this.ringtonePlayer = ringtonePlayer;
        this.tinodeUserId = sessionPrefImpl.getTinodeUserId();
        this.pausedTopicsNotifications = new ArrayList<String>();
        context = new SoundPool.Builder().setMaxStreams(2).setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build()).build();
        this.soundPool = context;
        this.generalSound = context.load(this.context, R.raw.slr_general_notification, 1);
        this.messageSound = this.soundPool.load(this.context, R.raw.slr_message_notification, 1);
    }

    public final void notifyChatMessage(@NotNull ChatMessage object) {
        ChatMessage chatMessage = object;
        Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"chatMessage");
        if (!Intrinsics.areEqual((Object)chatMessage.getSenderUserId(), (Object)this.tinodeUserId) && !StringsKt.isBlank((CharSequence)((ChatMessage)object).getText())) {
            ChatMessage chatMessage2 = object;
            object = chatMessage2.getTopicId();
            Notification notification = NotificationUtilKt.toNotification$default(chatMessage2, null, 1, null);
            if (!this.pausedTopicsNotifications.contains(object)) {
                this.session.incrementTotalUnreadMessagesCount();
                this.showNotification(notification);
            }
            return;
        }
    }

    public final void notifyCall(@NotNull Chat chat) {
        Notification notification;
        Object object;
        Date date;
        ArrayList<String> arrayList;
        Chat chat2 = chat;
        Intrinsics.checkParameterIsNotNull((Object)chat2, (String)"voiceChat");
        String string2 = chat2.getChatId();
        Object object2 = MessagingExtensionsKt.participantsWithoutUser(chat, this.session.getTinodeUserId());
        chat.getLastMessage();
        Long l = null;
        Object object3 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        Object object4 = object2.iterator();
        while (object4.hasNext()) {
            object3.add(((TinodeContact)object4.next()).getChatName());
        }
        object3 = CollectionsKt.joinToString$default(object3, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        object4 = this.context.getString(R.string.slr_incoming_voice_chat);
        String string3 = (object2.size() > 1 ? NotificationType.GroupCall : NotificationType.Call).name();
        Date date2 = date;
        date = new Date();
        String string4 = "topic_" + chat.getChatId();
        if (object2.size() == 1) {
            List<TinodeContact> list = object2;
            object2 = NotificationIcon.Companion;
            object = ((TinodeContact)CollectionsKt.first(list)).getPhotoData();
            String string5 = ((TinodeContact)CollectionsKt.first(list)).getChatName();
            if (string5 == null) {
                string5 = "";
            }
            object2 = ((NotificationIcon.Companion)object2).buildAvatarIcon((String)object, string5);
        } else {
            object2 = null;
        }
        object = notification;
        notification = new Notification(l, (String)object3, (String)object4, string3, date2, string4, chat, (NotificationIcon)object2);
        if (!this.pausedTopicsNotifications.contains(string2)) {
            this.showNotification((Notification)object);
        }
    }

    public final void playSound(@NotNull NotificationType notificationType) {
        NotificationType notificationType2 = notificationType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationType2), (String)"type");
        if (!this.isSoundEnabled(notificationType2)) {
            return;
        }
        if (ArraysKt.contains((Object[])new NotificationType[]{NotificationType.Call, NotificationType.GroupCall}, (Object)((Object)notificationType))) {
            this.playCallRingtone();
        } else if (ArraysKt.contains((Object[])new NotificationType[]{NotificationType.MissedCall, NotificationType.MissedGroupCall}, (Object)((Object)notificationType))) {
            this.stopCallRingtone();
        } else {
            this.playNotificationSound(notificationType);
        }
    }

    public final void disconnect() {
        this.notificationsRepo.deleteAllNotifications();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void pauseNotifications(boolean bl, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        if (bl) {
            this.pausedTopicsNotifications.add(string2);
            return;
        }
        try {
            Result.constructor-impl((Object)this.pausedTopicsNotifications.remove(string2));
            return;
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return;
        }
    }
}

