/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.auth;

import android.graphics.Bitmap;
import com.streamlayer.files.UploadResponse;
import com.streamlayer.pushNotification.client.RegisterRequest;
import com.streamlayer.pushNotification.client.RxClientGrpc;
import com.streamlayer.users.LoginRequest;
import com.streamlayer.users.MeRequest;
import com.streamlayer.users.RequestPasswordRequest;
import com.streamlayer.users.RxUsersGrpc;
import com.streamlayer.users.UpdateAvatarRequest;
import com.streamlayer.users.UpdateAvatarResponse;
import com.streamlayer.users.UpdateMetadataRequest;
import com.streamlayer.users.UpdateMetadataResponse;
import io.grpc.Channel;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.tinode.TinodeService;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.repository.RxRepoExtKt;
import io.streamlayer.sdk.repository.auth.AuthRepo;
import io.streamlayer.sdk.repository.auth.AuthRepoImpl;
import io.streamlayer.sdk.repository.files.FilesRepo;
import java.io.File;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0015H\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J$\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0015H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u000e0\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00152\u0006\u0010'\u001a\u00020\u001bH\u0016J\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u000e0\u00152\u0006\u0010)\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lio/streamlayer/sdk/repository/auth/AuthRepoImpl;", "Lio/streamlayer/sdk/repository/auth/AuthRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "filesRepo", "Lio/streamlayer/sdk/repository/files/FilesRepo;", "tinodeService", "Lio/streamlayer/common/data/tinode/TinodeService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/common/data/grpc/GrpcService;Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/files/FilesRepo;Lio/streamlayer/common/data/tinode/TinodeService;)V", "unauthorizedState", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "Lio/streamlayer/sdk/model/auth/User;", "getUnauthorizedState", "()Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "unauthorizedState$delegate", "Lkotlin/Lazy;", "deleteUserImage", "Lio/reactivex/Observable;", "getCurrentUser", "getCurrentUserFromApi", "getCurrentUserFromSession", "login", "id", "", "otp", "logout", "register", "", "requestOtp", "requestPassword", "Lio/reactivex/Single;", "updateUserImage", "image", "Landroid/graphics/Bitmap;", "updateUserName", "name", "uploadFirebaseToken", "token", "sdk_originalRelease"})
public final class AuthRepoImpl
implements AuthRepo {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy unauthorizedState$delegate;
    private final AppDatabase database;
    private final GrpcService grpcService;
    private final SessionPrefImpl session;
    private final FilesRepo filesRepo;
    private final TinodeService tinodeService;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthRepoImpl.class), "unauthorizedState", "getUnauthorizedState()Lio/streamlayer/common/mvvm/basemodels/ResourceState;"))};
    }

    private final ResourceState<User> getUnauthorizedState() {
        KProperty cfr_ignored_0 = $$delegatedProperties[0];
        return (ResourceState)this.unauthorizedState$delegate.getValue();
    }

    private final Observable<Boolean> register(String string2) {
        Observable observable = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel()).register(com.streamlayer.users.RegisterRequest.newBuilder().setId(string2).build()).toObservable().map((Function)register.1.INSTANCE).onErrorResumeNext((Function)register.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"stub.register(request)\n \u2026          }\n            }");
        return observable;
    }

    private final Single<Boolean> requestPassword(String string2) {
        Single single = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel()).requestPassword(RequestPasswordRequest.newBuilder().setId(string2).build()).map((Function)requestPassword.1.INSTANCE).onErrorResumeNext((Function)requestPassword.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"stub.requestPassword(req\u2026          }\n            }");
        return single;
    }

    private final Observable<User> getCurrentUserFromSession() {
        return this.session.getUser();
    }

    private final Observable<User> getCurrentUserFromApi() {
        Observable observable = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel()).me(MeRequest.newBuilder().build()).toObservable().map((Function)getCurrentUserFromApi.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"stub.me(request).toObser\u2026ap { it.data.toDomain() }");
        return observable;
    }

    @Inject
    public AuthRepoImpl(@NotNull AppDatabase appDatabase, @NotNull GrpcService grpcService2, @NotNull SessionPrefImpl sessionPrefImpl, @NotNull FilesRepo filesRepo, @NotNull TinodeService tinodeService) {
        AuthRepoImpl authRepoImpl = this;
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)grpcService2, (String)"grpcService");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)filesRepo, (String)"filesRepo");
        Intrinsics.checkParameterIsNotNull((Object)tinodeService, (String)"tinodeService");
        this.database = appDatabase;
        this.grpcService = grpcService2;
        this.session = sessionPrefImpl;
        this.filesRepo = filesRepo;
        authRepoImpl.tinodeService = tinodeService;
        authRepoImpl.unauthorizedState$delegate = LazyKt.lazy((Function0)unauthorizedState.2.INSTANCE);
    }

    public static final /* synthetic */ Observable access$register(AuthRepoImpl authRepoImpl, String string2) {
        return authRepoImpl.register(string2);
    }

    public static final /* synthetic */ Single access$requestPassword(AuthRepoImpl authRepoImpl, String string2) {
        return authRepoImpl.requestPassword(string2);
    }

    public static final /* synthetic */ SessionPrefImpl access$getSession$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.session;
    }

    public static final /* synthetic */ FilesRepo access$getFilesRepo$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.filesRepo;
    }

    public static final /* synthetic */ Observable access$getCurrentUserFromApi(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.getCurrentUserFromApi();
    }

    public static final /* synthetic */ Observable access$getCurrentUserFromSession(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.getCurrentUserFromSession();
    }

    public static final /* synthetic */ TinodeService access$getTinodeService$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.tinodeService;
    }

    public static final /* synthetic */ AppDatabase access$getDatabase$p(AuthRepoImpl authRepoImpl) {
        return authRepoImpl.database;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> requestOtp(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Boolean>>(this, string2){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = authRepoImpl;
                this.$id = string2;
                super(0);
            }

            public final Observable<Boolean> invoke() {
                return AuthRepoImpl.access$register(this.this$0, this.$id).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ requestOtp.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<Boolean> apply(@NotNull Boolean bl) {
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        Object object = object.this$0;
                        return AuthRepoImpl.access$requestPassword(object.this$0, object.$id).toObservable();
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> login(@NotNull String string2, @NotNull String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"otp");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel());
        string2 = LoginRequest.newBuilder().setId(string2).setPassword(string3).build();
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<User>>(this, rxUsersStub, (LoginRequest)string2){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ LoginRequest $request;
            {
                this.this$0 = authRepoImpl;
                this.$stub = rxUsersStub;
                this.$request = loginRequest;
                super(0);
            }

            public final Observable<User> invoke() {
                return this.$stub.login(this.$request).toObservable().map((Function)login.1.INSTANCE).doOnNext(new Consumer<Pair<? extends String, ? extends User>>(this){
                    final /* synthetic */ login.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void accept(Pair<String, User> object) {
                        login.2 v0 = string2;
                        Pair<String, User> pair = object;
                        String string2 = (String)pair.component1();
                        object = (User)pair.component2();
                        AuthRepoImpl.access$getSession$p(v0.this$0.this$0).setLoggedIn(string2, (User)object);
                    }
                }).map((Function)login.3.INSTANCE);
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> updateUserName(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel());
        UpdateMetadataRequest updateMetadataRequest = UpdateMetadataRequest.newBuilder().setSetName(string2).build();
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<User>>(this, rxUsersStub, updateMetadataRequest, string2){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $stub;
            final /* synthetic */ UpdateMetadataRequest $request;
            final /* synthetic */ String $name;
            {
                this.this$0 = authRepoImpl;
                this.$stub = rxUsersStub;
                this.$request = updateMetadataRequest;
                this.$name = string2;
                super(0);
            }

            public final Observable<User> invoke() {
                return this.$stub.updateMetadata(this.$request).toObservable().map(new Function<T, R>(this){
                    final /* synthetic */ updateUserName.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final User apply(@NotNull UpdateMetadataResponse object) {
                        Intrinsics.checkParameterIsNotNull((Object)object, (String)"it");
                        object = AuthRepoImpl.access$getSession$p(this.this$0.this$0).getUser();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Object object2 = object;
                        object = this.this$0.$name;
                        User user = User.copy$default((User)object2, null, null, (String)object, null, 11, null);
                        AuthRepoImpl.access$getSession$p(this.this$0.this$0).setUser(user);
                        return user;
                    }
                });
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> updateUserImage(@NotNull Bitmap bitmap2) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap2, (String)"image");
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel());
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<User>>(this, bitmap2, rxUsersStub){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ Bitmap $image;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $usersStub;
            {
                this.this$0 = authRepoImpl;
                this.$image = bitmap2;
                this.$usersStub = rxUsersStub;
                super(0);
            }

            public final Observable<User> invoke() {
                return FilesRepo.DefaultImpls.createTempImage$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0), this.$image, "avatar", null, 4, null).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<String> apply(@NotNull File file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        return FilesRepo.DefaultImpls.sendMetaDataForFile$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0.this$0), file, null, 2, null).flatMap(new Function<T, ObservableSource<? extends R>>(this, file){
                            final /* synthetic */ updateUserImage.1 this$0;
                            final /* synthetic */ File $file;
                            {
                                this.this$0 = var1_1;
                                this.$file = file;
                            }

                            @NotNull
                            public final Observable<String> apply(@NotNull UploadResponse uploadResponse) {
                                Intrinsics.checkParameterIsNotNull((Object)uploadResponse, (String)"response");
                                FilesRepo filesRepo = AuthRepoImpl.access$getFilesRepo$p(this.this$0.this$0.this$0);
                                File file = this.$file;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                                return filesRepo.sendFileToCDN(file, uploadResponse);
                            }
                        });
                    }
                }).map(new Function<T, R>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final UpdateAvatarRequest apply(@NotNull String string2) {
                        updateUserImage.2 v0 = this_;
                        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"it");
                        updateUserImage.2 this_ = UpdateAvatarRequest.newBuilder();
                        Object object = AuthRepoImpl.access$getSession$p(v0.this$0.this$0).getUser();
                        object = object != null ? ((User)object).getPhoneNumber() : null;
                        return this_.setUsername((String)object).setSetAvatar(string2).build();
                    }
                }).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ updateUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Observable<User> apply(@NotNull UpdateAvatarRequest updateAvatarRequest) {
                        Intrinsics.checkParameterIsNotNull((Object)updateAvatarRequest, (String)"it");
                        return this.this$0.$usersStub.updateAvatar(updateAvatarRequest).toObservable().flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                            final /* synthetic */ updateUserImage.3 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final Single<User> apply(@NotNull UpdateAvatarResponse updateAvatarResponse) {
                                Intrinsics.checkParameterIsNotNull((Object)updateAvatarResponse, (String)"it");
                                return AuthRepoImpl.access$getCurrentUserFromApi(this.this$0.this$0.this$0).singleOrError();
                            }
                        });
                    }
                });
            }
        }, (Function1)new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(User user) {
                AuthRepoImpl.access$getSession$p(this.this$0).setUser(user);
            }
        }, null, 4, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> deleteUserImage() {
        RxUsersGrpc.RxUsersStub rxUsersStub = RxUsersGrpc.newRxStub((Channel)this.grpcService.getManagedChannel());
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<User>>(this, rxUsersStub){
            final /* synthetic */ AuthRepoImpl this$0;
            final /* synthetic */ RxUsersGrpc.RxUsersStub $usersStub;
            {
                this.this$0 = authRepoImpl;
                this.$usersStub = rxUsersStub;
                super(0);
            }

            public final Observable<User> invoke() {
                return FilesRepo.DefaultImpls.deleteTempImage$default(AuthRepoImpl.access$getFilesRepo$p(this.this$0), "avatar", null, 2, null).andThen((ObservableSource)AuthRepoImpl.access$getSession$p(this.this$0).getUser().flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
                    final /* synthetic */ deleteUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final Single<UpdateAvatarResponse> apply(@NotNull User user) {
                        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
                        return this.this$0.$usersStub.updateAvatar(UpdateAvatarRequest.newBuilder().setDelAvatar(user.getAvatar()).setUsername(user.getPhoneNumber()).build());
                    }
                })).flatMap(new Function<T, ObservableSource<? extends R>>(this){
                    final /* synthetic */ deleteUserImage.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    @NotNull
                    public final Observable<User> apply(@NotNull UpdateAvatarResponse updateAvatarResponse) {
                        Intrinsics.checkParameterIsNotNull((Object)updateAvatarResponse, (String)"it");
                        return AuthRepoImpl.access$getCurrentUserFromApi(this.this$0.this$0);
                    }
                });
            }
        }, (Function1)new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(User user) {
                AuthRepoImpl.access$getSession$p(this.this$0).setUser(user);
            }
        }, null, 4, null);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> getCurrentUser() {
        Function1<User, Unit> function1;
        Function1<User, Unit> function12 = function1;
        function1 = new Function1<User, Unit>(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
                super(1);
            }

            public final void invoke(@NotNull User user) {
                Intrinsics.checkParameterIsNotNull((Object)user, (String)"it");
                AuthRepoImpl.access$getSession$p(this.this$0).setLoggedIn(AuthRepoImpl.access$getSession$p(this.this$0).getToken(), user);
            }
        };
        return RxRepoExtKt.twoSideCall(new Function0<Observable<User>>(this){

            @NotNull
            public final Observable<User> invoke() {
                return AuthRepoImpl.access$getCurrentUserFromSession((AuthRepoImpl)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AuthRepoImpl.class);
            }

            public final String getName() {
                return "getCurrentUserFromSession";
            }

            public final String getSignature() {
                return "getCurrentUserFromSession()Lio/reactivex/Observable;";
            }
        }, new Function0<Observable<User>>(this){

            @NotNull
            public final Observable<User> invoke() {
                return AuthRepoImpl.access$getCurrentUserFromApi((AuthRepoImpl)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AuthRepoImpl.class);
            }

            public final String getName() {
                return "getCurrentUserFromApi";
            }

            public final String getSignature() {
                return "getCurrentUserFromApi()Lio/reactivex/Observable;";
            }
        }, function12);
    }

    @Override
    @NotNull
    public Observable<ResourceState<User>> logout() {
        Observable observable = Completable.fromAction((Action)new Action(this){
            final /* synthetic */ AuthRepoImpl this$0;
            {
                this.this$0 = authRepoImpl;
            }

            public final void run() {
                logout.1 v0 = this;
                AuthRepoImpl.access$getTinodeService$p(v0.this$0).disconnect();
                AuthRepoImpl.access$getDatabase$p(v0.this$0).clearAllTables();
                AuthRepoImpl.access$getSession$p(v0.this$0).logout();
            }
        }).andThen((ObservableSource)Observable.just(this.getUnauthorizedState()));
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Completable.fromAction {\u2026.just(unauthorizedState))");
        return observable;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> uploadFirebaseToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"token");
        AuthRepoImpl authRepoImpl = RxClientGrpc.newRxStub((Channel)authRepoImpl.grpcService.getManagedChannel());
        string2 = RegisterRequest.newBuilder().setDeviceToken(string2).setType("firebase").build();
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<Boolean>>((RxClientGrpc.RxClientStub)authRepoImpl, (RegisterRequest)string2){
            final /* synthetic */ RxClientGrpc.RxClientStub $stub;
            final /* synthetic */ RegisterRequest $request;
            {
                this.$stub = rxClientStub;
                this.$request = registerRequest;
                super(0);
            }

            public final Observable<Boolean> invoke() {
                return this.$stub.register(this.$request).map((Function)uploadFirebaseToken.1.INSTANCE).toObservable();
            }
        }, null, null, 6, null);
    }
}

