/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.voice;

import com.google.gson.JsonObject;
import com.streamlayer.voice.IceRequest;
import com.streamlayer.voice.RxVoiceGrpc;
import io.grpc.Channel;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.sdk.model.calls.CallIdiom;
import io.streamlayer.sdk.model.calls.IceConfig;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.repository.RxRepoExtKt;
import io.streamlayer.sdk.repository.messaging.MessagingRepo;
import io.streamlayer.sdk.repository.voice.VoiceRepo;
import io.streamlayer.sdk.repository.voice.VoiceRepoImpl;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.IceCandidate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\nH\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\f0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0016J8\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0016J,\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/streamlayer/sdk/repository/voice/VoiceRepoImpl;", "Lio/streamlayer/sdk/repository/voice/VoiceRepo;", "database", "Lio/streamlayer/common/data/database/AppDatabase;", "messagingRepo", "Lio/streamlayer/sdk/repository/messaging/MessagingRepo;", "grpcService", "Lio/streamlayer/common/data/grpc/GrpcService;", "(Lio/streamlayer/common/data/database/AppDatabase;Lio/streamlayer/sdk/repository/messaging/MessagingRepo;Lio/streamlayer/common/data/grpc/GrpcService;)V", "getIceServers", "Lio/reactivex/Observable;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "Lio/streamlayer/sdk/model/calls/IceConfig;", "getOldVoiceMessages", "Lio/reactivex/Single;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "topicId", "", "observeVoiceMessages", "userId", "sendCallIdiom", "", "chatId", "idiom", "Lio/streamlayer/sdk/model/calls/CallIdiom;", "payload", "reply", "sendIceCandidate", "candidate", "Lorg/webrtc/IceCandidate;", "replyTo", "sdk_originalRelease"})
public final class VoiceRepoImpl
implements VoiceRepo {
    private final AppDatabase database;
    private final MessagingRepo messagingRepo;
    private final GrpcService grpcService;

    @Inject
    public VoiceRepoImpl(@NotNull AppDatabase appDatabase, @NotNull MessagingRepo messagingRepo, @NotNull GrpcService grpcService2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)messagingRepo, (String)"messagingRepo");
        Intrinsics.checkParameterIsNotNull((Object)grpcService2, (String)"grpcService");
        this.database = appDatabase;
        this.messagingRepo = messagingRepo;
        this.grpcService = grpcService2;
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendCallIdiom(@NotNull String string2, @NotNull CallIdiom callIdiom, @Nullable String string3, @Nullable String string4) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)callIdiom), (String)"idiom");
        Object object = string3 != null ? string3 : "";
        Object object2 = Charsets.UTF_8;
        if (object != null) {
            String string5;
            VoiceRepoImpl voiceRepoImpl = object3;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Object object3 = byArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = Charsets.UTF_8;
            object2 = string5;
            string5 = new String((byte[])object3, (Charset)object);
            String cfr_ignored_0 = "\u2b06\ufe0f [idiom=" + callIdiom.getKey() + "; payload=" + string3 + "; reply=" + string4 + ']';
            object3 = callIdiom.getKey();
            return voiceRepoImpl.messagingRepo.sendMessage(string2, (String)object2, "voice", (String)object3, string4);
        }
        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
    }

    @Override
    @NotNull
    public Observable<ResourceState<Boolean>> sendIceCandidate(@NotNull String string2, @NotNull IceCandidate iceCandidate2, @NotNull String string3) {
        JsonObject jsonObject;
        VoiceRepoImpl voiceRepoImpl = object;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
        Intrinsics.checkParameterIsNotNull((Object)iceCandidate2, (String)"candidate");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"replyTo");
        VoiceRepoImpl voiceRepoImpl2 = object = jsonObject;
        object();
        voiceRepoImpl2.addProperty("ident", iceCandidate2.sdpMid);
        voiceRepoImpl2.addProperty("userId", string3);
        object.addProperty("desc", iceCandidate2.sdp);
        jsonObject.addProperty("index", (Number)iceCandidate2.sdpMLineIndex);
        Object object = CallIdiom.ICE;
        return voiceRepoImpl.sendCallIdiom(string2, (CallIdiom)((Object)object), jsonObject.toString(), string3);
    }

    @Override
    @NotNull
    public Observable<ResourceState<List<IceConfig>>> getIceServers() {
        VoiceRepoImpl voiceRepoImpl = RxVoiceGrpc.newRxStub((Channel)voiceRepoImpl.grpcService.getManagedChannel());
        IceRequest iceRequest = IceRequest.newBuilder().build();
        return RxRepoExtKt.oneSideCall$default((Function0)new Function0<Observable<List<? extends IceConfig>>>((RxVoiceGrpc.RxVoiceStub)voiceRepoImpl, iceRequest){
            final /* synthetic */ RxVoiceGrpc.RxVoiceStub $stub;
            final /* synthetic */ IceRequest $request;
            {
                this.$stub = rxVoiceStub;
                this.$request = iceRequest;
                super(0);
            }

            public final Observable<List<IceConfig>> invoke() {
                return this.$stub.ice(this.$request).map((Function)getIceServers.1.INSTANCE).toObservable();
            }
        }, null, null, 6, null);
    }

    @Override
    @NotNull
    public Observable<ChatMessage> observeVoiceMessages(@NotNull String string2, @Nullable String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Observable observable = this.messagingRepo.subscribeToChat(string2, null).filter(new Predicate<ChatMessage>(string3){
            final /* synthetic */ String $userId;
            {
                this.$userId = string2;
            }

            public final boolean test(@NotNull ChatMessage chatMessage) {
                ChatMessage chatMessage2 = chatMessage;
                Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"it");
                return Intrinsics.areEqual((Object)chatMessage2.getType(), (Object)"voice") && Intrinsics.areEqual((Object)this.$userId, (Object)chatMessage.getSenderUserId()) ^ true;
            }
        }).distinctUntilChanged((BiPredicate)observeVoiceMessages.2.INSTANCE).doOnNext((Consumer)observeVoiceMessages.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"messagingRepo.subscribeT\u2026          )\n            }");
        return observable;
    }

    @Override
    @NotNull
    public Single<List<ChatMessage>> getOldVoiceMessages(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
        Single single = this.database.messagingDao().getChatMessages(string2, null, null, 100).map((Function)getOldVoiceMessages.1.INSTANCE).single((Object)CollectionsKt.emptyList());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"database.messagingDao().\u2026    }.single(emptyList())");
        return single;
    }
}

