/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.notifications;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.streamlayer.sdk.model.notifications.Notification;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\ba\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH'J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH'J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH'J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH'J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\u0011H'J\b\u0010\u0012\u001a\u00020\u0003H'J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\u0014\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH'J\u0016\u0010\u0015\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH'J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0017"}, d2={"Lio/streamlayer/sdk/repository/notifications/NotificationDao;", "", "deleteAllNotifications", "", "deleteNotification", "Lio/reactivex/Completable;", "item", "Lio/streamlayer/sdk/model/notifications/Notification;", "itemId", "", "sourceUniqueId", "", "deleteNotifications", "items", "", "getNotification", "getNotifications", "Lio/reactivex/Observable;", "safeDeleteAllNotifications", "saveNotification", "saveNotifications", "updateNotifications", "upsertNotificationBySourceId", "sdk_originalRelease"})
@Dao
public interface NotificationDao {
    @Insert(onConflict=5)
    public void saveNotifications(@NotNull List<Notification> var1);

    @Insert(onConflict=5)
    public long saveNotification(@NotNull Notification var1);

    @Update
    public void updateNotifications(@NotNull List<Notification> var1);

    @Query(value="SELECT * FROM Notification ORDER BY Notification.id DESC, Notification.date DESC")
    @NotNull
    public Observable<List<Notification>> getNotifications();

    @Delete
    @NotNull
    public Completable deleteNotifications(@NotNull List<Notification> var1);

    @Query(value="DELETE FROM Notification WHERE id = :itemId")
    @NotNull
    public Completable deleteNotification(long var1);

    @Delete
    @NotNull
    public Completable deleteNotification(@NotNull Notification var1);

    public void deleteAllNotifications();

    @Query(value="DELETE FROM Notification")
    public void safeDeleteAllNotifications();

    public void upsertNotificationBySourceId(@NotNull Notification var1);

    @Query(value="DELETE FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    public void deleteNotification(@NotNull String var1);

    @Query(value="SELECT * FROM Notification WHERE sourceUniqueId = :sourceUniqueId")
    @NotNull
    public Notification getNotification(@NotNull String var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void deleteAllNotifications(NotificationDao notificationDao) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(notificationDao){
                final /* synthetic */ NotificationDao this$0;
                {
                    this.this$0 = notificationDao;
                }

                public final void run() {
                    this.this$0.safeDeleteAllNotifications();
                }
            };
            new Thread(runnable2).start();
        }

        public static void upsertNotificationBySourceId(NotificationDao notificationDao, @NotNull Notification notification) {
            Notification notification2 = notification;
            Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"item");
            if (notificationDao.saveNotification(notification2) == -1L) {
                Notification notification3 = notification;
                notification3.setId(notificationDao.getNotification(notification.getSourceUniqueId()).getId());
                notificationDao.updateNotifications(CollectionsKt.listOf((Object)notification3));
            }
        }
    }
}

