/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.main.tooltips;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.tooltips.ViewTooltipType;
import io.streamlayer.common.views.NotificationsView;
import io.streamlayer.common.views.tooltips.BubbleView;
import io.streamlayer.common.views.tooltips.BubbleViewTooltip;
import io.streamlayer.common.views.tooltips.ViewTooltipHandler;
import io.streamlayer.common.views.tooltips.ViewTooltipHandlerKt;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.ScreenUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/streamlayer/sdk/main/tooltips/NotificationsViewTooltip;", "Lio/streamlayer/common/views/tooltips/ViewTooltipHandler;", "view", "Lio/streamlayer/common/views/NotificationsView;", "(Lio/streamlayer/common/views/NotificationsView;)V", "_isTooltipVisible", "", "bubbleViewTooltip", "Lio/streamlayer/common/views/tooltips/BubbleViewTooltip;", "onTooltipCompleted", "Lkotlin/Function0;", "", "getOnTooltipCompleted", "()Lkotlin/jvm/functions/Function0;", "setOnTooltipCompleted", "(Lkotlin/jvm/functions/Function0;)V", "type", "Lio/streamlayer/common/tooltips/ViewTooltipType;", "getType", "()Lio/streamlayer/common/tooltips/ViewTooltipType;", "buildTooltipAnimation", "Lio/streamlayer/common/views/tooltips/BubbleView$Animation;", "hideTooltip", "onAnimationEnd", "isTooltipVisible", "showTooltip", "parentView", "Landroidx/constraintlayout/widget/ConstraintLayout;", "sdk_originalRelease"})
public final class NotificationsViewTooltip
implements ViewTooltipHandler {
    private BubbleViewTooltip bubbleViewTooltip;
    @NotNull
    private final ViewTooltipType type;
    @Nullable
    private Function0<Unit> onTooltipCompleted;
    private boolean _isTooltipVisible;
    private final NotificationsView view;

    private final BubbleView.Animation buildTooltipAnimation() {
        return new BubbleView.Animation(){

            public void animateEnter(@Nullable View view) {
                Object object = (BubbleView)view;
                if (object != null) {
                    object.setAlpha(0.0f);
                }
                if (object != null) {
                    object.setScaleX(0.0f);
                }
                if (object != null) {
                    object.setScaleY(0.0f);
                }
                if (object != null && (object = object.animate()) != null && (object = object.alpha(1.0f)) != null && (object = object.scaleX(1.0f)) != null && (object = object.scaleY(1.0f)) != null) {
                    OvershootInterpolator overshootInterpolator;
                    Object object2 = object;
                    object = overshootInterpolator;
                    overshootInterpolator = new OvershootInterpolator(1.2f);
                    if ((object = object2.setInterpolator((TimeInterpolator)object)) != null && (object = object.setDuration(1000L)) != null) {
                        object.start();
                    }
                }
            }

            public void animateExit(@Nullable View view, @Nullable Animator.AnimatorListener animatorListener) {
                Object object = (BubbleView)view;
                if (object != null && (object = object.animate()) != null && (object = object.alpha(0.0f)) != null && (object = object.setStartDelay(0L)) != null && (object = object.setDuration(400L)) != null && (object = object.setListener(animatorListener)) != null) {
                    object.start();
                }
            }
        };
    }

    public NotificationsViewTooltip(@NotNull NotificationsView notificationsView) {
        NotificationsViewTooltip notificationsViewTooltip = this;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notificationsView), (String)"view");
        notificationsViewTooltip.view = notificationsView;
        notificationsViewTooltip.type = ViewTooltipType.NOTIFICATION;
    }

    @Override
    @NotNull
    public ViewTooltipType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Function0<Unit> getOnTooltipCompleted() {
        return this.onTooltipCompleted;
    }

    @Override
    public void setOnTooltipCompleted(@Nullable Function0<Unit> function0) {
        this.onTooltipCompleted = function0;
    }

    @Override
    public boolean isTooltipVisible() {
        return this._isTooltipVisible;
    }

    @Override
    public void showTooltip(@NotNull ConstraintLayout object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"parentView");
        if (this.isTooltipVisible()) {
            return;
        }
        this._isTooltipVisible = true;
        Context context = this.view.getContext();
        Context context2 = this.view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"view.context");
        Resources resources = context2.getResources();
        int n = resources.getDimensionPixelSize(R.dimen.slr_notification_height);
        int n2 = resources.getDimensionPixelSize(R.dimen.slr_activity_vertical_margin);
        int n3 = resources.getDimensionPixelSize(R.dimen.slr_activity_horizontal_margin);
        int n4 = resources.getDimensionPixelSize(R.dimen.slr_menu_button_size);
        int n5 = resources.getDimensionPixelSize(R.dimen.slr_notification_landscape_width);
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Point point = ScreenUtilKt.getScreenSize(context);
        boolean bl = ScreenUtilKt.isScreenPortrait(context);
        n5 = bl ? 0 : (this.view.getLeft() != 0 ? this.view.getLeft() : point.x - n5 - n4 - n3);
        n3 = bl ? point.x : (this.view.getRight() != 0 ? this.view.getRight() : point.x - n4 - n3);
        int n6 = point.y;
        n = n6 - n2 - n;
        n2 = n6 - n2;
        BubbleViewTooltip bubbleViewTooltip = ViewTooltipHandlerKt.applyStyles(BubbleViewTooltip.Companion.on(new Rect(n5, n, n3, n2), (ViewGroup)object), context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.slr_notification_tooltip, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"LayoutInflater.from(cont\u2026tification_tooltip, null)");
        object = BubbleViewTooltip.customView$default(bubbleViewTooltip, view, 0, 0, 6, null).animation(this.buildTooltipAnimation()).position(BubbleView.Position.TOP);
        this.bubbleViewTooltip = object;
        if (object != null) {
            ((BubbleViewTooltip)object).show();
        }
    }

    @Override
    public void hideTooltip(@Nullable Function0<Unit> function0) {
        if (!((NotificationsViewTooltip)((Object)bubbleViewTooltip)).isTooltipVisible()) {
            return;
        }
        ((NotificationsViewTooltip)((Object)bubbleViewTooltip))._isTooltipVisible = false;
        BubbleViewTooltip bubbleViewTooltip = ((NotificationsViewTooltip)((Object)bubbleViewTooltip)).bubbleViewTooltip;
        if (bubbleViewTooltip != null) {
            bubbleViewTooltip.close(function0);
        }
    }
}

