/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import androidx.emoji.bundled.BundledEmojiCompatConfig;
import androidx.emoji.text.EmojiCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.streamlayer.sdkSettings.client.GetStreamResponse;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterConfig;
import io.streamlayer.common.dagger.components.DaggerStreamLayerComponent;
import io.streamlayer.common.dagger.components.StreamLayerComponent;
import io.streamlayer.common.dagger.modules.ContextModule;
import io.streamlayer.common.data.notifications.NotificationChannelsHelper;
import io.streamlayer.common.data.notifications.PushNotificationsService;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.deeplink.StreamLayerDeeplinkHandler;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J9\u0010\u0011\u001a\u00020\u0010\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u00122\u001a\u0010\u0015\u001a\u0016\u0012\b\u0012\u00060\u0017j\u0002`\u0018\u0012\u0004\u0012\u00020\u00100\u0016j\u0002`\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u001a\u0010!\u001a\u00020\u001c2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020$0#J\u0016\u0010%\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020$J\u0015\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b)J\"\u0010*\u001a\u00020\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100,J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0004J\u000e\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020$R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/streamlayer/sdk/StreamLayer;", "", "()V", "audioDuckingListener", "Lio/streamlayer/sdk/StreamLayer$AudioDuckingListener;", "component", "Lio/streamlayer/common/dagger/components/StreamLayerComponent;", "getComponent$sdk_originalRelease", "()Lio/streamlayer/common/dagger/components/StreamLayerComponent;", "setComponent$sdk_originalRelease", "(Lio/streamlayer/common/dagger/components/StreamLayerComponent;)V", "context", "Landroid/content/Context;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "assertComponent", "", "changeStreamEvent", "T", "", "event", "onInitialized", "Lkotlin/Function1;", "Lcom/streamlayer/sdkSettings/client/GetStreamResponse;", "Lio/streamlayer/sdk/SLRResponse;", "Lio/streamlayer/sdk/OnStreamCallback;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function1;)V", "handleDeepLinkIntent", "", "intent", "Landroid/content/Intent;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "handleStreamLayerPush", "data", "", "", "initializeApp", "sdkKey", "notifyVoiceActive", "active", "notifyVoiceActive$sdk_originalRelease", "setAudioDuckingListener", "requestAudioDucking", "Lkotlin/Function0;", "disableAudioDucking", "listener", "uploadDeviceFCMToken", "token", "AudioDuckingListener", "sdk_originalRelease"})
public final class StreamLayer {
    @NotNull
    public static StreamLayerComponent component;
    private static Context context;
    private static SessionPrefImpl session;
    private static AudioDuckingListener audioDuckingListener;
    public static final StreamLayer INSTANCE;

    private final void assertComponent() {
        if (component != null) {
            return;
        }
        throw new UninitializedPropertyAccessException("StreamLayer not initialized!");
    }

    private StreamLayer() {
    }

    static {
        INSTANCE = new StreamLayer();
    }

    @NotNull
    public final StreamLayerComponent getComponent$sdk_originalRelease() {
        StreamLayerComponent streamLayerComponent = component;
        if (streamLayerComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
        }
        return streamLayerComponent;
    }

    public final void setComponent$sdk_originalRelease(@NotNull StreamLayerComponent streamLayerComponent) {
        StreamLayerComponent streamLayerComponent2 = streamLayerComponent;
        Intrinsics.checkParameterIsNotNull((Object)streamLayerComponent2, (String)"<set-?>");
        component = streamLayerComponent2;
    }

    public final void initializeApp(@NotNull Context context, @NotNull String string2) {
        SessionPrefImpl sessionPrefImpl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"sdkKey");
        StreamLayerComponent streamLayerComponent = DaggerStreamLayerComponent.builder().contextModule(new ContextModule(context)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)streamLayerComponent, (String)"DaggerStreamLayerCompone\u2026xt))\n            .build()");
        component = streamLayerComponent;
        Glide.with((Context)context).setDefaultRequestOptions((RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.AUTOMATIC));
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl;
        session = new SessionPrefImpl(context);
        if (sessionPrefImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        sessionPrefImpl2.setSdkKey(string2);
        StreamLayer.context = context;
        Twitter.initialize((TwitterConfig)new TwitterConfig.Builder(context).build());
        EmojiCompat.init((EmojiCompat.Config)new BundledEmojiCompatConfig(context));
        NotificationChannelsHelper.INSTANCE.initChannels(context);
    }

    public final <T extends CharSequence> void changeStreamEvent(@NotNull T t, @NotNull Function1<? super GetStreamResponse, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(t, (String)"event");
        Intrinsics.checkParameterIsNotNull(function1, (String)"onInitialized");
        ((StreamLayer)((Object)sessionPrefImpl)).assertComponent();
        SessionPrefImpl sessionPrefImpl = session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        sessionPrefImpl.setCurrentEventId(((Object)t).toString());
    }

    public final void setAudioDuckingListener(@NotNull AudioDuckingListener audioDuckingListener) {
        AudioDuckingListener audioDuckingListener2 = audioDuckingListener;
        Intrinsics.checkParameterIsNotNull((Object)audioDuckingListener2, (String)"listener");
        StreamLayer.audioDuckingListener = audioDuckingListener2;
    }

    public final void setAudioDuckingListener(@NotNull Function0<Unit> function0, @NotNull Function0<Unit> function02) {
        AudioDuckingListener audioDuckingListener;
        StreamLayer streamLayer = audioDuckingListener2;
        Intrinsics.checkParameterIsNotNull(function0, (String)"requestAudioDucking");
        Intrinsics.checkParameterIsNotNull(function02, (String)"disableAudioDucking");
        AudioDuckingListener audioDuckingListener2 = audioDuckingListener;
        audioDuckingListener = new AudioDuckingListener(function0, function02){
            final /* synthetic */ Function0 $requestAudioDucking;
            final /* synthetic */ Function0 $disableAudioDucking;
            {
                this.$requestAudioDucking = function0;
                this.$disableAudioDucking = function02;
            }

            public void requestAudioDucking() {
                this.$requestAudioDucking.invoke();
            }

            public void disableAudioDucking() {
                this.$disableAudioDucking.invoke();
            }
        };
        streamLayer.setAudioDuckingListener(audioDuckingListener2);
    }

    public final void notifyVoiceActive$sdk_originalRelease(boolean bl) {
        Object object;
        if (bl) {
            object = audioDuckingListener;
            if (object != null) {
                object.requestAudioDucking();
            }
        } else {
            object = audioDuckingListener;
            if (object != null) {
                object.disableAudioDucking();
            }
        }
    }

    public final void uploadDeviceFCMToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"token");
        ((StreamLayer)object).assertComponent();
        Object object = session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        ((SessionPrefImpl)object).setFirebaseToken(string2);
        object = session;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        ((SessionPrefImpl)object).setFirebaseTokenChanged(true);
        object = NotificationChannelsHelper.INSTANCE;
        string2 = context;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        ((NotificationChannelsHelper)object).initChannels((Context)string2);
    }

    public final boolean handleStreamLayerPush(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"data");
        ((StreamLayer)((Object)streamLayerComponent)).assertComponent();
        if (PushNotificationsService.Companion.isStreamLayerPush(map2)) {
            StreamLayerComponent streamLayerComponent = component;
            if (streamLayerComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            }
            streamLayerComponent.getPushNotificationsService().handlePushMessage(map2);
            return true;
        }
        return false;
    }

    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity appCompatActivity) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
        return StreamLayerDeeplinkHandler.INSTANCE.handleDeepLinkIntent(intent, appCompatActivity);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lio/streamlayer/sdk/StreamLayer$AudioDuckingListener;", "", "disableAudioDucking", "", "requestAudioDucking", "sdk_originalRelease"})
    public static interface AudioDuckingListener {
        public void requestAudioDucking();

        public void disableAudioDucking();
    }
}

