/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.voximplant;

import com.voximplant.sdk.client.AuthParams;
import com.voximplant.sdk.client.ClientState;
import com.voximplant.sdk.client.IClient;
import com.voximplant.sdk.client.IClientLoginListener;
import com.voximplant.sdk.client.IClientSessionListener;
import com.voximplant.sdk.client.LoginError;
import io.streamlayer.common.client.VoiceClientWrapper;
import io.streamlayer.common.data.voximplant.VoximplantClientManagerKt;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.session.VoiceCallAuthDetails;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\u0012\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lio/streamlayer/common/data/voximplant/VoximplantClientManager;", "Lcom/voximplant/sdk/client/IClientSessionListener;", "Lcom/voximplant/sdk/client/IClientLoginListener;", "clientWrapper", "Lio/streamlayer/common/client/VoiceClientWrapper;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "(Lio/streamlayer/common/client/VoiceClientWrapper;Lio/streamlayer/common/session/SessionPrefImpl;)V", "client", "Lcom/voximplant/sdk/client/IClient;", "mPassword", "", "mServers", "Ljava/util/ArrayList;", "mUsername", "state", "Lcom/voximplant/sdk/client/ClientState;", "getState", "()Lcom/voximplant/sdk/client/ClientState;", "buildUsername", "tinodeId", "isTokenExpired", "", "lifeTime", "", "login", "", "password", "loginTokensExist", "loginWithToken", "logout", "onConnectionClosed", "onConnectionEstablished", "onConnectionFailed", "p0", "onLoginFailed", "reason", "Lcom/voximplant/sdk/client/LoginError;", "onLoginSuccessful", "displayName", "authParams", "Lcom/voximplant/sdk/client/AuthParams;", "onOneTimeKeyGenerated", "key", "onRefreshTokenFailed", "onRefreshTokenSuccess", "saveAuthDetailsToSharedPreferences", "sdk_originalVoximplantRelease"})
public final class VoximplantClientManager
implements IClientSessionListener,
IClientLoginListener {
    private final IClient client;
    private String mUsername;
    private String mPassword;
    private final ArrayList<String> mServers;
    private final VoiceClientWrapper clientWrapper;
    private final SessionPrefImpl session;

    private final void loginWithToken() {
        if (((VoximplantClientManager)object).client.getClientState() == ClientState.DISCONNECTED) {
            IClient iClient = ((VoximplantClientManager)object).client;
            boolean bl = false;
            try {
                iClient.connect(bl, ((VoximplantClientManager)object).mServers);
            }
            catch (IllegalStateException illegalStateException) {
                String cfr_ignored_0 = "loginWithToken: exception on connect: " + illegalStateException;
            }
        }
        if (((VoximplantClientManager)object).client.getClientState() == ClientState.CONNECTED && ((VoximplantClientManager)object).loginTokensExist()) {
            Object object;
            VoximplantClientManager voximplantClientManager = object;
            voximplantClientManager.mUsername = voximplantClientManager.session.getTinodeUserId();
            VoiceCallAuthDetails voiceCallAuthDetails = voximplantClientManager.session.getVoiceCallAuthDetails();
            if (!voximplantClientManager.isTokenExpired(voiceCallAuthDetails.getAccessExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.loginWithAccessToken((String)object, voiceCallAuthDetails.getAccessToken());
            } else if (!((VoximplantClientManager)object).isTokenExpired(voiceCallAuthDetails.getRefreshExpired())) {
                object = ((VoximplantClientManager)object).mUsername;
                ((VoximplantClientManager)object).client.refreshToken((String)object, voiceCallAuthDetails.getRefreshToken());
            }
        }
    }

    private final void saveAuthDetailsToSharedPreferences(AuthParams authParams) {
        this.session.setVoiceCallAuthDetails(VoximplantClientManagerKt.toDomain(authParams));
    }

    private final boolean isTokenExpired(long l) {
        return System.currentTimeMillis() - this.session.getVoiceCallAuthDetails().getRefreshExpired() > l * (long)1000;
    }

    private final boolean loginTokensExist() {
        VoiceCallAuthDetails voiceCallAuthDetails = ((VoximplantClientManager)((Object)voiceCallAuthDetails)).session.getVoiceCallAuthDetails();
        return voiceCallAuthDetails.getAccessToken() != null && voiceCallAuthDetails.getRefreshToken() != null;
    }

    private final String buildUsername(String string2) {
        return string2 + "@" + "demo-app.streamlayer.n2.voximplant.com";
    }

    @Inject
    public VoximplantClientManager(@NotNull VoiceClientWrapper voiceClientWrapper, @NotNull SessionPrefImpl sessionPrefImpl) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)voiceClientWrapper, (String)"clientWrapper");
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        this.clientWrapper = voiceClientWrapper;
        this.session = sessionPrefImpl;
        voximplantClientManager.client = voiceClientWrapper.getVoximplantClient();
        voximplantClientManager.mServers = new ArrayList();
        voximplantClientManager.client.setClientLoginListener((IClientLoginListener)this);
        voximplantClientManager.client.setClientSessionListener((IClientSessionListener)this);
    }

    public final void login(@NotNull String string2, @NotNull String string3) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tinodeId");
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"password");
        this.mUsername = string2 = this.buildUsername(string2);
        this.mPassword = string3;
        if (this.client.getClientState() == ClientState.DISCONNECTED) {
            IClient iClient = this.client;
            boolean bl = false;
            try {
                iClient.connect(bl, this.mServers);
            }
            catch (IllegalStateException illegalStateException) {
                String cfr_ignored_0 = "login: exception on connect: " + illegalStateException;
            }
        }
        if (this.client.getClientState() == ClientState.CONNECTED) {
            this.client.login(string2, string3);
        }
    }

    public final void logout() {
        if (this.client.getClientState() == ClientState.LOGGED_IN) {
            this.client.disconnect();
        }
    }

    @NotNull
    public final ClientState getState() {
        ClientState clientState = this.client.getClientState();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientState, (String)"client.clientState");
        return clientState;
    }

    public void onConnectionEstablished() {
        String string2;
        String string3 = this.mUsername;
        if (string3 != null && (string2 = this.mPassword) != null) {
            this.client.login(string3, string2);
        } else {
            this.loginWithToken();
        }
    }

    public void onConnectionFailed(@Nullable String string2) {
    }

    public void onConnectionClosed() {
        this.mPassword = null;
    }

    public void onLoginSuccessful(@NotNull String string2, @NotNull AuthParams authParams) {
        AuthParams authParams2 = authParams;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)authParams2, (String)"authParams");
        String cfr_ignored_0 = "Login success: " + string2;
        this.saveAuthDetailsToSharedPreferences(authParams2);
    }

    public void onLoginFailed(@NotNull LoginError loginError) {
        Intrinsics.checkParameterIsNotNull((Object)loginError, (String)"reason");
        String cfr_ignored_0 = "Login failed: " + loginError;
    }

    public void onOneTimeKeyGenerated(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"key");
    }

    public void onRefreshTokenFailed(@NotNull LoginError loginError) {
        Intrinsics.checkParameterIsNotNull((Object)loginError, (String)"reason");
    }

    public void onRefreshTokenSuccess(@NotNull AuthParams authParams) {
        VoximplantClientManager voximplantClientManager = this;
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        voximplantClientManager.saveAuthDetailsToSharedPreferences(authParams);
        voximplantClientManager.loginWithToken();
    }
}

