/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.deeplink;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import io.streamlayer.sdk.main.StreamLayerFragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/streamlayer/sdk/deeplink/StreamLayerDeeplinkHandler;", "", "()V", "DEEP_LINK_NAV_GRAPH_DATA", "", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "destinationUri", "Landroid/net/Uri;", "buildDeepLinkIntent$sdk_originalVoximplantRelease", "findHostFragment", "Lio/streamlayer/sdk/main/StreamLayerFragment;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getDeepLinkUri", "intent", "handleDeepLinkIntent", "", "sdk_originalVoximplantRelease"})
public final class StreamLayerDeeplinkHandler {
    @NotNull
    public static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    public static final StreamLayerDeeplinkHandler INSTANCE = new StreamLayerDeeplinkHandler();

    private final StreamLayerFragment findHostFragment(AppCompatActivity appCompatActivity) {
        return (StreamLayerFragment)appCompatActivity.getSupportFragmentManager().findFragmentByTag("StreamLayerFragment");
    }

    private final Uri getDeepLinkUri(Intent intent) {
        return (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
    }

    private StreamLayerDeeplinkHandler() {
    }

    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity object) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"activity");
        Uri uri = intent.getData();
        if (Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer")) {
            if ((object = this.findHostFragment((AppCompatActivity)object)) != null) {
                StreamLayerFragment.triggerDeepLink$default((StreamLayerFragment)((Object)object), this.getDeepLinkUri(intent), false, 2, null);
                return true;
            }
            throw new IllegalStateException("StreamLayerFragment not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
        }
        return false;
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalVoximplantRelease(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        return intent;
    }
}

