/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.messaging.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.format.DateUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.pagination.GenericPagedListAdapter;
import io.streamlayer.sdk.R;
import io.streamlayer.sdk.messaging.chat.MessagingAdapter$MessageViewHolder$WhenMappings;
import io.streamlayer.sdk.messaging.chat.MessagingAdapterKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatType;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.profile.ProfileExtensionsKt;
import io.streamlayer.utils.AvatarUtil;
import io.streamlayer.utils.DateUtil;
import io.streamlayer.utils.EmojiUtil;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000eH\u0014R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "userId", "", "(Ljava/lang/String;)V", "value", "Lio/streamlayer/sdk/model/messaging/ChatType;", "mode", "getMode", "()Lio/streamlayer/sdk/model/messaging/ChatType;", "setMode", "(Lio/streamlayer/sdk/model/messaging/ChatType;)V", "getItemViewType", "", "position", "getLayoutId", "viewType", "getViewHolder", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "view", "Landroid/view/View;", "MessageReceiverViewHolder", "MessageSenderViewHolder", "MessageViewHolder", "sdk_originalVoximplantRelease"})
public final class MessagingAdapter
extends GenericPagedListAdapter<ChatMessage> {
    @NotNull
    private ChatType mode;
    private final String userId;

    public MessagingAdapter(@NotNull String string2) {
        MessagingAdapter messagingAdapter = this;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"userId");
        super(MessagingAdapterKt.access$getDiffItemCallback$p());
        messagingAdapter.userId = string2;
        messagingAdapter.mode = ChatType.P2P;
    }

    public static final /* synthetic */ ChatMessage access$getItem(MessagingAdapter messagingAdapter, int n) {
        return (ChatMessage)messagingAdapter.getItem(n);
    }

    @NotNull
    public final ChatType getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull ChatType chatType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)chatType), (String)"value");
        if (this.mode != chatType) {
            this.mode = chatType;
            this.notifyDataSetChanged();
        }
    }

    @Override
    protected int getLayoutId(int n) {
        return n != 0 ? (n != 1 ? (n != 2 ? 0 : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_receiver) : R.layout.slr_item_chat_sender;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected GenericPagedListAdapter.GenericViewHolder<ChatMessage> getViewHolder(@NotNull View view, int n) {
        void var2_6;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (n != 0) {
            if (n != 1) {
                MessageReceiverViewHolder messageReceiverViewHolder;
                if (n != 2) throw new RuntimeException("Unsupported item view type: " + n);
                ((ConstraintLayout)view.findViewById(R.id.chatMessageContainer)).setBackgroundResource(R.drawable.slr_shape_chat_bubble_contact);
                MessageReceiverViewHolder messageReceiverViewHolder2 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(view, true);
                return var2_6;
            } else {
                MessageReceiverViewHolder messageReceiverViewHolder;
                ((ConstraintLayout)view.findViewById(R.id.chatMessageContainer)).setBackgroundResource(R.drawable.slr_shape_chat_bubble_contact_p2p);
                MessageReceiverViewHolder messageReceiverViewHolder3 = messageReceiverViewHolder;
                messageReceiverViewHolder = new MessageReceiverViewHolder(view, false);
            }
            return var2_6;
        } else {
            MessageSenderViewHolder messageSenderViewHolder;
            MessageSenderViewHolder messageSenderViewHolder2 = messageSenderViewHolder;
            messageSenderViewHolder = new MessageSenderViewHolder(view);
        }
        return var2_6;
    }

    public int getItemViewType(int n) {
        block2: {
            block6: {
                int n2;
                block4: {
                    block5: {
                        block3: {
                            ChatMessage chatMessage = (ChatMessage)this.getItem(n);
                            if (chatMessage == null) break block2;
                            ChatMessage chatMessage2 = chatMessage;
                            Intrinsics.checkExpressionValueIsNotNull((Object)chatMessage2, (String)"getItem(position) ?: ret\u2026getItemViewType(position)");
                            boolean bl = Intrinsics.areEqual((Object)chatMessage2.getSenderUserId(), (Object)this.userId);
                            n = bl ? 1 : 0;
                            if (!bl) break block3;
                            n2 = 0;
                            break block4;
                        }
                        if (n != 0 || this.mode != ChatType.Group) break block5;
                        n2 = 2;
                        break block4;
                    }
                    if (n != 0 || this.mode != ChatType.P2P) break block6;
                    n2 = 1;
                }
                return n2;
            }
            throw new RuntimeException("Unsupported state. isCurrentUser: " + (n != 0) + "; mode: " + (Object)((Object)this.mode));
        }
        return super.getItemViewType(n);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0004J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0004R\u001b\u0010\u0006\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/common/mvvm/pagination/GenericPagedListAdapter$GenericViewHolder;", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;)V", "chatMessageContainer", "getChatMessageContainer", "()Landroid/view/View;", "chatMessageContainer$delegate", "Lkotlin/Lazy;", "chatMessageContent", "Landroid/widget/TextView;", "getChatMessageContent", "()Landroid/widget/TextView;", "chatMessageContent$delegate", "chatTimestamp", "getChatTimestamp", "chatTimestamp$delegate", "defaultBackground", "Landroid/graphics/drawable/Drawable;", "bind", "", "message", "getNextMessage", "getPreviousMessage", "sdk_originalVoximplantRelease"})
    public abstract class MessageViewHolder
    extends GenericPagedListAdapter.GenericViewHolder<ChatMessage> {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Lazy chatTimestamp$delegate;
        private final Lazy chatMessageContent$delegate;
        private final Lazy chatMessageContainer$delegate;
        private final Drawable defaultBackground;
        final /* synthetic */ MessagingAdapter this$0;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatTimestamp", "getChatTimestamp()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContent", "getChatMessageContent()Landroid/widget/TextView;")), Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MessageViewHolder.class), "chatMessageContainer", "getChatMessageContainer()Landroid/view/View;"))};
        }

        private final TextView getChatTimestamp() {
            KProperty cfr_ignored_0 = $$delegatedProperties[0];
            return (TextView)this.chatTimestamp$delegate.getValue();
        }

        private final TextView getChatMessageContent() {
            KProperty cfr_ignored_0 = $$delegatedProperties[1];
            return (TextView)this.chatMessageContent$delegate.getValue();
        }

        private final View getChatMessageContainer() {
            KProperty cfr_ignored_0 = $$delegatedProperties[2];
            return (View)this.chatMessageContainer$delegate.getValue();
        }

        public MessageViewHolder(@NotNull MessagingAdapter messagingAdapter, View view) {
            MessageViewHolder messageViewHolder = this;
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            this.this$0 = messagingAdapter;
            super(view);
            messageViewHolder.chatTimestamp$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatTimestamp);
                }
            });
            messageViewHolder.chatMessageContent$delegate = LazyKt.lazy((Function0)new Function0<TextView>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final TextView invoke() {
                    return (TextView)this.$itemView.findViewById(R.id.chatMessageContent);
                }
            });
            messageViewHolder.chatMessageContainer$delegate = LazyKt.lazy((Function0)new Function0<View>(view){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = view;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.chatMessageContainer);
                }
            });
            Drawable drawable2 = messageViewHolder.getChatMessageContainer().getBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"chatMessageContainer.background");
            messageViewHolder.defaultBackground = drawable2;
        }

        @Nullable
        protected final ChatMessage getPreviousMessage() {
            Object object;
            MessagingAdapter messagingAdapter = object.this$0;
            int n = object.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n + 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Nullable
        protected final ChatMessage getNextMessage() {
            Object object;
            MessagingAdapter messagingAdapter = object.this$0;
            int n = object.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n - 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            return (ChatMessage)object;
        }

        @Override
        public void bind(@NotNull ChatMessage chatMessage) {
            Object object;
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"message");
            if (chatMessage2.getDate() != null) {
                TextView textView = this.getChatTimestamp();
                View view = this.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                textView.setText(DateUtils.getRelativeDateTimeString((Context)view.getContext(), (long)chatMessage.getDate().getTime(), (long)86400000L, (long)86400000L, (int)0));
            }
            MessagingAdapter messagingAdapter = this.this$0;
            int n = this.getLayoutPosition();
            try {
                object = Result.constructor-impl((Object)MessagingAdapter.access$getItem(messagingAdapter, n + 1));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                object = null;
            }
            object = (ChatMessage)object;
            boolean bl = chatMessage.getDate() != null && ((object != null ? ((ChatMessage)object).getDate() : null) == null || !DateUtil.INSTANCE.isSameDay((Date)(object = ((ChatMessage)object).getDate()), chatMessage.getDate()));
            MessageViewHolder messageViewHolder = this;
            ExtensionsKt.visibleIf((View)messageViewHolder.getChatTimestamp(), bl);
            View view = messageViewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            float f = MessagingAdapter$MessageViewHolder$WhenMappings.$EnumSwitchMapping$0[chatMessage.getStatus().ordinal()] != 1 ? 1.0f : 0.7f;
            view.setAlpha(f);
            if (EmojiUtil.INSTANCE.isEmojiOnly(chatMessage.getText())) {
                int n2 = EmojiUtil.INSTANCE.getEmojiCount(chatMessage.getText());
                f = n2 == 1 ? 60.0f : (n2 <= 3 ? 30.0f : 14.0f);
                MessageViewHolder messageViewHolder2 = this;
                messageViewHolder2.getChatMessageContent().setTextSize(1, f);
                View view2 = messageViewHolder2.getChatMessageContainer();
                Drawable drawable2 = n2 <= 3 ? null : this.defaultBackground;
                view2.setBackground(drawable2);
                int n3 = n2 <= 3 ? 0 : ExtensionsKt.getDp(16.0f);
                if (n2 <= 3) {
                    View view3 = this.getChatMessageContainer();
                    n2 = view3.getPaddingTop();
                    int n4 = view3.getPaddingBottom();
                    view3.setPadding(n3, n2, n3, n4);
                }
            } else {
                MessageViewHolder messageViewHolder3 = this;
                messageViewHolder3.getChatMessageContainer().setBackground(this.defaultBackground);
                View view4 = messageViewHolder3.getChatMessageContainer();
                int n5 = ExtensionsKt.getDp(16.0f);
                int n6 = view4.getPaddingTop();
                int n7 = ExtensionsKt.getDp(16.0f);
                int n8 = view4.getPaddingBottom();
                view4.setPadding(n5, n6, n7, n8);
                messageViewHolder3.getChatMessageContent().setTextSize(2, 14.0f);
            }
            this.getChatMessageContent().setText((CharSequence)chatMessage.getText());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageSenderViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "itemView", "Landroid/view/View;", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;)V", "sdk_originalVoximplantRelease"})
    public final class MessageSenderViewHolder
    extends MessageViewHolder {
        public MessageSenderViewHolder(View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(MessagingAdapter.this, view);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageReceiverViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter$MessageViewHolder;", "Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;", "itemView", "Landroid/view/View;", "isGroup", "", "(Lio/streamlayer/sdk/messaging/chat/MessagingAdapter;Landroid/view/View;Z)V", "bind", "", "message", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "sdk_originalVoximplantRelease"})
    public final class MessageReceiverViewHolder
    extends MessageViewHolder {
        private final boolean isGroup;

        public MessageReceiverViewHolder(View view, boolean bl) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"itemView");
            super(MessagingAdapter.this, view);
            this.isGroup = bl;
        }

        @Override
        public void bind(@NotNull ChatMessage object) {
            MessageReceiverViewHolder messageReceiverViewHolder = this;
            ChatMessage chatMessage = object;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage, (String)"message");
            super.bind(chatMessage);
            TinodeContact tinodeContact = ((ChatMessage)object).getSender();
            View view = messageReceiverViewHolder.itemView;
            if (messageReceiverViewHolder.isGroup && tinodeContact != null) {
                Object object2 = this.getPreviousMessage();
                object2 = object2 != null ? ((ChatMessage)object2).getSenderUserId() : null;
                boolean bl = Intrinsics.areEqual((Object)object2, (Object)((ChatMessage)object).getSenderUserId());
                object2 = this.getNextMessage();
                if (!Intrinsics.areEqual((Object)(object2 != null ? ((ChatMessage)object2).getSenderUserId() : null), (Object)((ChatMessage)object).getSenderUserId())) {
                    View view2 = view;
                    ImageView imageView = (ImageView)view2.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ProfileExtensionsKt.loadContactAvatar$default(imageView, tinodeContact, null, 2, null);
                    ImageView imageView2 = (ImageView)view2.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"chatMessageAuthorAvatar");
                    ExtensionsKt.visible((View)imageView2);
                } else {
                    ImageView imageView = (ImageView)view.findViewById(R.id.chatMessageAuthorAvatar);
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                    ExtensionsKt.invisible((View)imageView);
                }
                if (!bl) {
                    View view3 = view;
                    TextView textView = (TextView)view3.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                    textView.setText((CharSequence)tinodeContact.getChatName());
                    TextView textView2 = (TextView)view3.findViewById(R.id.chatMessageAuthorName);
                    object = tinodeContact.getChatName();
                    int n = object != null ? AvatarUtil.INSTANCE.getColor((String)object) : -1;
                    textView2.setTextColor(n);
                    TextView textView3 = (TextView)view.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"chatMessageAuthorName");
                    ExtensionsKt.visible((View)textView3);
                } else {
                    TextView textView = (TextView)view.findViewById(R.id.chatMessageAuthorName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                    ExtensionsKt.gone((View)textView);
                }
            } else {
                View view4 = view;
                ImageView imageView = (ImageView)view4.findViewById(R.id.chatMessageAuthorAvatar);
                Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"chatMessageAuthorAvatar");
                ExtensionsKt.gone((View)imageView);
                TextView textView = (TextView)view4.findViewById(R.id.chatMessageAuthorName);
                Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"chatMessageAuthorName");
                ExtensionsKt.gone((View)textView);
            }
        }
    }
}

